package JavaAgent.agent;

import JavaAgent.resource.*;

import java.util.Hashtable;
import java.util.Vector;
import java.util.Enumeration;


/**
 * Subclass of MessageHandler which handles all message transmissions for an
 * ANS.<p>
 *
 * <hr>
 * Copyright (c) 1995, H. Robert Frost, Stanford University.
 * All rights reserved.<p>
 * Copyright (c) 1996, H. Robert Frost, Enterprise Integration Technologies,
 * Inc. All rights reserved.<p>
 *
 * RESTRICTED RIGHTS LEGEND: Use, duplication or disclosure by the 
 * Government is subject to restrictions as set forth in 
 * subparagraph(c)(1)(ii) of the Rights in Technical Data and Computer
 * Software clause at DFARS 252.227-7013 and in similar clauses in the
 * FAR and NASA FAR supplement.<p>
 * 
 * This software is bound by the terms and conditions listed in the
 * attached <a href="../LICENSE">LICENSE file</A>.
 * <hr>
 * @author <A HREF="http://cdr.stanford.edu/html/people/frost-bio.html"> Rob Frost</A>
 * @version 0.3 5/21/96 for Java(tm) Language Version 1.0.2
 */

public class ANSMessageHandler extends MessageHandler {

  /**
   * Creates a new ANSMessageHandler.
   * @param parent ANS which this handler represents.
   */

  public ANSMessageHandler(ANS parent){
   super(parent);
  } 

  /**
   * Send Remove-address messages to all of the agents in the address buffer.
   * @param name Agent name whose address should be removed.
   * @param aa The AgentAddress to remove.
   */

  public void SendRemovalMessage(String name, AgentAddress aa){
    Enumeration agents = parent.getResource("address").getElements();
    String message = "(evaluate :ontology agent :language KQML " +
      ":sender ANS :content (invalidate-resource :type address :name " + name +
	" :value " + aa.getValue() + "))";
   
    /* is the ANS trying to terminate?, if it has its own address then it
       is not trying to terminate */
    boolean no_terminate = parent.getResource("address").hasElement("ANS");

    if(agents.hasMoreElements()){
      while(agents.hasMoreElements()){
	KQMLmessage kmessage = new KQMLmessage(message);
	String agent_name = (String)agents.nextElement();
	if(!agent_name.equals("ANS")){
	  kmessage.addFieldValuePair("receiver",agent_name);	  
	  /* the last message */
	  if(!agents.hasMoreElements() && !no_terminate){
	    last_message = kmessage;
	  }
	  sendMessage(kmessage);        
	}
      }
    } else { /* ANS didn't send out any messages */
      if(!no_terminate){ /* just kill context */
	terminate();
      }
    }
      
  }

 /**
   * Called when the executable class which contains the ANS terminates.
   * The ANS then sends a message to all of the agents in its address buffer
   * that it is shuting down.
   */

  public void initiateTermination(){
    if(comm != null){
      comm.disconnect();
      if(parent.getResource("address").hasElement("ANS")){
	try{
	  AgentAddress aa = 
	    (AgentAddress)(parent.getResource("address")).getElement(parent.getName(),Resource.NO_RETRIEVAL);
	  parent.getResource("address").removeElement("ANS");
	  SendRemovalMessage(parent.getName(), aa);
	} catch (ResourceException e){
	  terminate();
	}
      } else {
	terminate();
      }
    }
  }
 
}



