package JavaAgent.agent;

import JavaAgent.resource.*;
import JavaAgent.context.ContextInterface;

import java.util.Hashtable;
import java.util.Vector;
import java.util.Enumeration;
import java.io.*;
import java.net.URL;
import java.awt.Panel;

/**
 * ANS (Agent Name Server). This subclass of Agent functions as a central 
 * repository of addresses for a group of agents. Allows agents who have no 
 * prior knowledge of each other to communicate. Details of the messages sent
 * between the ANS  and other agents are detailed in the documentation for 
 * class AgentInterpreter.<P>
 *
 * <hr>
 * Copyright (c) 1995, H. Robert Frost, Stanford University.
 * All rights reserved.<p>
 * Copyright (c) 1996, H. Robert Frost, Enterprise Integration Technologies,
 * Inc. All rights reserved.<p>
 *
 * RESTRICTED RIGHTS LEGEND: Use, duplication or disclosure by the 
 * Government is subject to restrictions as set forth in 
 * subparagraph(c)(1)(ii) of the Rights in Technical Data and Computer
 * Software clause at DFARS 252.227-7013 and in similar clauses in the
 * FAR and NASA FAR supplement.<p>
 * 
 * This software is bound by the terms and conditions listed in the
 * attached <a href="../LICENSE">LICENSE file</A>.
 * <hr>
 * @author <A HREF="http://cdr.stanford.edu/html/people/frost-bio.html"> Rob Frost</A>
 * @version 0.3 5/21/96 for Java(tm) Language Version 1.0.2
 */

public class ANS extends Agent {

  /**
   * Contructs an ANS with an output, name, init file, shared classes URL
   * and working directory.
   *
   * @param n String identifier for the Agent.
   * @param init_url URL for the initialization file.
   * @param shared_url URL for shared classes.
   * @param shared_dir Directory for local access to shared classes.
   * @param working_dir Directory for local files, will be null if the 
   * Agent is unable to write to the local file system.
   */

  public ANS(ContextInterface context,String n, URL init_url, URL shared_url,
	     File shared_dir,File working_dir) {
    super(context, n, init_url, shared_url, shared_dir, working_dir);
  }

  /**
   * Creates the ResourceManager, MessageHandler and reads in the init_file.
   */
  
  public void init(){
    if(working_dir != null){
      io_enabled = true;
    }
    resources = new ANSResourceManager(this);
    handler = new ANSMessageHandler(this);
    loadInitFile(init_url);
  }
  
  /**
   * Send Remove-address messages to all of the agents in the address buffer.
   * @param name Agent name whose address should be removed.
   * @param aa The AgentAddress to remove.
   */

  public void SendRemovalMessage(String name, AgentAddress aa){
   ((ANSMessageHandler)handler).SendRemovalMessage(name,aa);
  }

}







