package ImageSelector;

import java.lang.*;

/**
 * Copyright (c) 1996, Tim DeBruine, Enterprise Integration Technologies,
 * Inc. All rights reserved.<p>
 *
 * RESTRICTED RIGHTS LEGEND: Use, duplication or disclosure by the 
 * Government is subject to restrictions as set forth in 
 * subparagraph(c)(1)(ii) of the Rights in Technical Data and Computer
 * Software clause at DFARS 252.227-7013 and in similar clauses in the
 * FAR and NASA FAR supplement.<p>
 * 
 * This software is bound by the terms and conditions listed in the
 * attached <a href="../LICENSE">LICENSE file</A>.
 * @author Tim DeBruine
 * @version 1.0
 */

/** Sets up a continuously running timer in a new thread.
*/
class timer implements Runnable {
	static int count;
	static int running=0;
	static Thread thr=null;
	static final int interval=20;		// the interval between timer ticks in ms
	
/** Starts the timer thread
*/
	static void go() {
		timer t=new timer();
		thr=new Thread(t);		
		thr.start();
	}

/** Stops the timer thread.	
*/
	public static void die() {
		if (thr!=null) thr.stop();	
	}
	
	timer() {
		count=0;
	}

	public void run() 
	{
		for (;;) {
			try {
				Thread.sleep(interval);
			} catch (InterruptedException e) {}
			count++;
		}
	}
/** This method is used to get the current reading of the timer.  It is
* possible to only use this method when using a timer, because a call to
* this method when the timer is not running will start it.
*@value the reading of the timer
*/
	static public int getTime() {
		if (running==0) {
			go();
			running=1;
		}
		return count;
	}
}

