package ImageSelector;

import java.awt.*;

/** 
 * This class consists of static methods to draw graphic primitives
 * not available in the standard Java packages.<p>
 *
 * Copyright (c) 1996, Tim DeBruine, Enterprise Integration Technologies,
 * Inc. All rights reserved.<p>
 *
 * RESTRICTED RIGHTS LEGEND: Use, duplication or disclosure by the 
 * Government is subject to restrictions as set forth in 
 * subparagraph(c)(1)(ii) of the Rights in Technical Data and Computer
 * Software clause at DFARS 252.227-7013 and in similar clauses in the
 * FAR and NASA FAR supplement.<p>
 * 
 * This software is bound by the terms and conditions listed in the
 * attached <a href="../LICENSE">LICENSE file</A>.
 * @author Tim DeBruine
 * @version 1.0
 */

public class graphics1 {

/** draws a rectangle with an indented, 3d appearance
@param g a Graphics object on which to draw
@param x the x coordinate of the upper-left-hand corner
@param y the y coordinate of the upper-left-hand corner
@param width the width in pixels of the rectangle
@param height the height in pixels of the rectangle
*/
	static public void drawIndented3DRect(Graphics g,int x,
		int y,int width,int height) {
		Color c=g.getColor();
		g.setColor(Color.gray);
		g.drawLine(x,y,x+width-1,y);
		g.drawLine(x,y,x,y+height);
		g.setColor(Color.black);
		g.drawLine(x+1,y+1,x+width-2,y+1);
		g.drawLine(x+1,y+1,x+1,y+height-1);
		g.setColor(Color.white);
		g.drawLine(x+1,y+height,x+width,y+height);
		g.drawLine(x+2,y+height-1,x+width,y+height-1);
		g.drawLine(x+width-1,y+1,x+width-1,y+height);
		g.drawLine(x+width,y,x+width,y+height);
		g.setColor(c);
	}

/* this constructor does nothing, as this class has only
* static methods and no variables
*/	
	graphics1() {
	}
		
}

