package ImageSelector;

import java.awt.*;
import java.util.*;
import java.io.*;

/** This class presents the user with a scrollable area in which gif thumbnails
* are displayed.  The user can select one of the images.  Optionally, when the user
* selects an item by single-clicking on it or activates and item by double-clicking
* on it, a PictureSelector object can notify another awt component.<p>
*
 * Copyright (c) 1996, Tim DeBruine, Enterprise Integration Technologies,
 * Inc. All rights reserved.<p>
 *
 * RESTRICTED RIGHTS LEGEND: Use, duplication or disclosure by the 
 * Government is subject to restrictions as set forth in 
 * subparagraph(c)(1)(ii) of the Rights in Technical Data and Computer
 * Software clause at DFARS 252.227-7013 and in similar clauses in the
 * FAR and NASA FAR supplement.<p>
 * 
 * This software is bound by the terms and conditions listed in the
 * attached <a href="../LICENSE">LICENSE file</A>.
 *
*@author Tim DeBruine
*@version 1.0
*/

public class PictureSelector extends Panel {
  String title;
  MyCanvas pixArea;
  Scrollbar scrollBar;
  int selWidth,selHeight;
  Vector imageList;
  /** the component to which notification of user actions will be forwarded */
  public Component toNotify=null;
  /** the notification event to be posted to the component specified in toNotify */
  public Event notification=null;
  
  final int bottomInset=20;
  
  /** constructor
   *@param t title of the selector, to appear above the selection area
   *@param sw the width of the selector
   *@param sh the height of the selector
   */
  
  public PictureSelector(String t,int sw,int sh) {
    
		// create layout manager
		setLayout(new BorderLayout());

		// create the pieces we need
		pixArea=new MyCanvas(t,sw,sh-bottomInset,this);
		scrollBar=new Scrollbar(Scrollbar.HORIZONTAL);
		scrollBar.setLineIncrement(1);
		scrollBar.setValues(0,1,0,99);

		// add the pieces to the panel
		add("North",pixArea);
		add("South",scrollBar);
		
		// remember w and h of selection area
		selWidth=sw;
		selHeight=sh;
		
		// create the list of images
		imageList=new Vector();
		pixArea.imageList=imageList;
		
	}
	
/** used to change the title of the PictureSelector
*@param t the title
*/
	public void setTitle(String t) {
		title=t;
		pixArea.title=t;
	}
	
	public Dimension minimumSize() {
		return new Dimension(selWidth,selHeight);
	}

	public Dimension preferredSize() {
		return minimumSize();
	}
/** adds a new image to the selector
*@param the image to be added 
*/	
	public void addPicture(Image im) 
	{
		imageList.addElement(im);
	}
/** removes an image from the selector
*@param n the index of the image to be removed	
*/
	public void removePicture(int n) {
		imageList.removeElementAt(n);
	}
	
	public boolean handleEvent(Event evt) {
		if (evt.target instanceof Scrollbar) {
			pixArea.scrollPos=scrollBar.getValue();
			
			// do a repaint here
			pixArea.forceRepaint();
		}

		return super.handleEvent(evt);
		
	}
	
	// callback methods for MyCanvas object to notify us
	void changedSelection(int sel) {

		// if notification is enabled, tell the Component that is to be notified
		// that we just changed selections
		if (toNotify!=null) {
			notification.x=sel;
			notification.y=0;
			toNotify.postEvent(notification);
		}
	}
	
	void doubleClicked(int sel) {
		if (toNotify!=null) {
			notification.x=sel;
			notification.y=1;
			toNotify.postEvent(notification);
		}
	}
	
/** forces the image area to repaint itself */
	public void forceRepaint() {
		pixArea.forceRepaint();
	}
}



