package ImageSelector;

import java.awt.*;
import java.net.*; 
import java.io.*;
import java.util.*;

/** 
 * This class links two other widgets -- a TextDisplayCanvas and a PictureSelector.
 * When the user clicks on an image in the PictureSelector, the TextDisplayCanvas
 * displays text describing the item associated with the image.  Optionally, when the user
 * double clicks on an image, an event can be posted to a component indicating which
 * image the user just selected.<p>
*
 * Copyright (c) 1996, Tim DeBruine, Enterprise Integration Technologies,
 * Inc. All rights reserved.<p>
 *
 * RESTRICTED RIGHTS LEGEND: Use, duplication or disclosure by the 
 * Government is subject to restrictions as set forth in 
 * subparagraph(c)(1)(ii) of the Rights in Technical Data and Computer
 * Software clause at DFARS 252.227-7013 and in similar clauses in the
 * FAR and NASA FAR supplement.<p>
 * 
 * This software is bound by the terms and conditions listed in the
 * attached <a href="../LICENSE">LICENSE file</A>.
 *
 * @author Tim DeBruine
 * @version 1.0
 */

public class PictureBrowser extends Panel {
  PictureSelector sel;
  TextDisplayCanvas text;
  Vector descrs;
      
  public int selected_index = -1;
  
  /** 
   * The component to be notified when the user makes a selection 
   */
  public Component toNotify = null;
  
  /** 
   * the notification event to be sent to the component when the user makes a selection 
   */
  public Event notification;
	
  final int SELECTION_NOTIFY_TYPE=1000;
	
  /** constructor
   *@param tdc the TextDisplayCanvas
   *@param ps the PictureSelector
   */
     public PictureBrowser(TextDisplayCanvas tdc,PictureSelector ps) 
       throws IOException
	 {
	    // save the two pieces
	      text=tdc;
		sel=ps;
		
		// initialize text to ""
		tdc.setText("");
		
		descrs=new Vector();
		
		// set up the event forwarding
		ps.toNotify=this;
		ps.notification=new Event(ps,SELECTION_NOTIFY_TYPE,null);
		
	}
	
/** used to add image/description pairs
*@param im the image to be added
*@txt a description to associate with the image being added
*/
	public void addItem(Image im,String txt) {
		sel.addPicture(im);
		descrs.addElement(txt);
	}
	
/** deletes an image/description pair
@param n the index of the image/description pair to be deleted
*/	
	public void deleteItem(int n) {
		descrs.removeElementAt(n);
		sel.removePicture(n);
		text.setText("");
		text.forceRepaint();
	}
	
  public boolean handleEvent(Event evt) {
    if (evt.id==SELECTION_NOTIFY_TYPE && evt.target instanceof PictureSelector) {
      if (evt.y==0) {
	selected_index = evt.x;
	text.setText((String)descrs.elementAt(evt.x));
				text.forceRepaint();
				return true;
			}
			
			if (evt.y==1) {
				// forward double click to DesignWindow
				notification.x=evt.x;
				notification.y=1;
				toNotify.postEvent(notification);				
				return true;
			}
		}
		return super.handleEvent(evt);
		
		
	}	
}
