package ImageSelector;

import java.awt.*;
import java.util.*;

/** 
 *This class is used by the PictureSelector class to create a scrollable
 * area in which gif thumbnail images are displayed and selectable by the
 * user.
 *
 * Copyright (c) 1996, Tim DeBruine, Enterprise Integration Technologies,
 * Inc. All rights reserved.<p>
 *
 * RESTRICTED RIGHTS LEGEND: Use, duplication or disclosure by the 
 * Government is subject to restrictions as set forth in 
 * subparagraph(c)(1)(ii) of the Rights in Technical Data and Computer
 * Software clause at DFARS 252.227-7013 and in similar clauses in the
 * FAR and NASA FAR supplement.<p>
 * 
 * This software is bound by the terms and conditions listed in the
 * attached <a href="../LICENSE">LICENSE file</A>.
 * @author Tim DeBruine
 * @version 1.0
 */

class MyCanvas extends Canvas {

	String title;
	int selection;
	int prefWidth,prefHeight;
	Vector imageList;
	int viewx;
	int scrollPos;
	PictureSelector papa;
	int time_old;
	int time_new;
	
	final int leftInset=5;
	final int rightInset=5;
	final int topInset=5;
	final int bottomInset=5;
	final int widthPerImage=60;
	final int doubleClickThreshold=10;	// 200 ms

/** constructor -- although public, it is unlikely that this class will be
* very useful if instantiated by itself (without a PictureSelector
@param t the title to appear above the picture selection area
@param w the width of the picture selection area
@param h the height of the picture selection area plus the height of the title
@param ps the PictureSelector object which created this MyCanvas object--needed for communication
*/	
	public MyCanvas(String t,int w,int h,PictureSelector ps) {
		prefWidth=w;
		prefHeight=h;
		title=t;
		viewx=0;
		scrollPos=0;
		papa=ps;
		selection=-1;
		
		time_new=timer.getTime();
	}

	public void paint(Graphics g) {
		FontMetrics fm;
		int drawx,drawy;
		int i;
		int width,height;

		// figure out where to draw based on scrollbar pos
		viewx=(imageList.size()-1)*widthPerImage*scrollPos/99;
		
		// get font metrics to draw to
		fm=g.getFontMetrics();	

		// display the title
		g.drawString(title,0,fm.getHeight());
	
		// display the box
		Color ctemp=g.getColor();
		g.setColor(Color.gray);
		g.fillRect(leftInset,fm.getHeight()+topInset,prefWidth-leftInset-rightInset,
			prefHeight-fm.getHeight()-topInset-bottomInset);
		g.setColor(ctemp);

		graphics1.drawIndented3DRect(g,leftInset,fm.getHeight()+topInset,
			prefWidth-leftInset-rightInset,prefHeight-fm.getHeight()-topInset-bottomInset);
		

		// display the data by iterating through the imageList

		width=prefWidth-leftInset-rightInset-3;
		height=prefHeight-fm.getHeight()-topInset-bottomInset-4;
		
		drawx=leftInset+3-viewx;
		drawy=fm.getHeight()+topInset+3;
		
		g.clipRect(leftInset+2,topInset+fm.getHeight()+3,width,height);
		
		for (i=0; i<imageList.size(); i++) {
			// draw image at leftInset+3-viewx,topInset+fm.getHeight()+3
			
			g.drawImage((Image)imageList.elementAt(i),drawx,drawy,this);
			
			if (selection==i) {
				Color c=g.getColor();
				g.setColor(Color.red);
				g.drawRect(drawx,drawy,48,48);
				g.setColor(c);
			}
			drawx+=widthPerImage;
		}
	}	

	public Dimension minimumSize() {
		return new Dimension(prefWidth,prefHeight);
	}
	
	public Dimension preferredSize() {
		return minimumSize();
	}	
	
/** forces the pictures and title to be repainted */
	void forceRepaint() {
		paint(this.getGraphics());
	}

	public boolean handleEvent(Event evt) {
		int a;
		int clicks;
		
		if ((evt.target instanceof MyCanvas) && (evt.id==Event.MOUSE_DOWN)) {
			// figure out which icon the user just selected
			a=decodeSelection(evt.x,evt.y);
			
			if (a!=-1) {
				
				// figure out the number of clicks
				time_old=time_new;
				time_new=timer.getTime();
				clicks=1;
				if ((time_new-time_old)<doubleClickThreshold) clicks=2;
					
				if (clicks==1) {
					selection=a;
	
					// do a repaint here
					forceRepaint();
				
					// tell PictureSelector that we just changed selection
					papa.changedSelection(selection);
				}
				else {
					papa.doubleClicked(selection);
				}
				return true;
			}
		}
		return super.handleEvent(evt);
	}
	
	
	int decodeSelection(int x,int y) {
		Graphics g;
		FontMetrics fm;
		int truex;
		int rv=-1;
		
		g=getGraphics();
		fm=g.getFontMetrics();

		// is it in the correct y range?
		if (y>(topInset+fm.getHeight()) && y<(prefHeight-topInset-bottomInset+
			fm.getHeight())) {
			
			// translate to the x of the full line of selections
			truex=viewx+x;
			
			// figure out which selection it is
			rv=truex/widthPerImage;
			if (rv>=imageList.size()) rv=imageList.size()-1;
			
		}
		return rv;
	}
}

