package FDATI;

import java.awt.*;
import SModeling.*;

/**
 * Panel which displays system messages.<p>
 *
 * <hr>
 * Copyright (c) 1995, H. Robert Frost, Stanford University.
 * All rights reserved.<p>
 * Copyright (c) 1996, H. Robert Frost, Enterprise Integration Technologies,
 * Inc. All rights reserved.<p>
 *
 * RESTRICTED RIGHTS LEGEND: Use, duplication or disclosure by the 
 * Government is subject to restrictions as set forth in 
 * subparagraph(c)(1)(ii) of the Rights in Technical Data and Computer
 * Software clause at DFARS 252.227-7013 and in similar clauses in the
 * FAR and NASA FAR supplement.<p>
 * 
 * This software is bound by the terms and conditions listed in the
 * attached <a href="../LICENSE">LICENSE file</A>.
 * <hr>
 * @author <A HREF="http://cdr.stanford.edu/html/people/frost-bio.html"> Rob Frost</A>
 * @version 0.3 5/21/96 for Java(tm) Language Version 1.0.2
 */

public class SystemMessagePanel extends Panel{
  
  TextArea SystemMessages = new TextArea(40,20);
  Button Cancel = new Button("Quit");
  
  Color bg_color;
  Color button_color;

  FDATI parent;
  
  /**
   * Constructor for SystemMessagePanel.
   * @param parent FDATI
   */

  public SystemMessagePanel( FDATI parent, Color bg, Color button){
    
    super();
    this.parent = parent;
    bg_color  = bg;
    button_color = button;

    setLayout(new BorderLayout());  
    setBackground(bg_color);
    add("Center",SystemMessages);
    add("South", Cancel);

    Cancel.setBackground(button_color);
  }
    
  public boolean action(Event evt, Object arg) {
    
    if("Quit".equals(arg)){
      Frame f = (Frame)getParent();
      parent.killMessagePanel();
      f.dispose();
    }
   
    return true;
  }

  public void addSystemMessage(String message){
    SystemMessages.setText(message);

  } 
}




















