package FDATI;

import java.awt.*;
import java.util.*;

/**
 * Panel for displaying analysis results. This panel contains a TextArea for
 * for analysis results and a button for disposing of its parent frame.<p>
 *
 * <hr>
 * Copyright (c) 1995, H. Robert Frost, Stanford University.
 * All rights reserved.<p>
 * Copyright (c) 1996, H. Robert Frost, Enterprise Integration Technologies,
 * Inc. All rights reserved.<p>
 *
 * RESTRICTED RIGHTS LEGEND: Use, duplication or disclosure by the 
 * Government is subject to restrictions as set forth in 
 * subparagraph(c)(1)(ii) of the Rights in Technical Data and Computer
 * Software clause at DFARS 252.227-7013 and in similar clauses in the
 * FAR and NASA FAR supplement.<p>
 * 
 * This software is bound by the terms and conditions listed in the
 * attached <a href="../LICENSE">LICENSE file</A>.
 * <hr>
 * @author <A HREF="http://cdr.stanford.edu/html/people/frost-bio.html"> Rob Frost</A>
 * @version 0.3 5/21/96 for Java(tm) Language Version 1.0.2
 */

public class ResultPanel extends Panel{
  
  Label stability;
  
  Button OK = new Button("OK");
  
  /**
   * Creates a new ResultPanel for displaying the passed result String.
   * @param results String containing analysis results.
   */

  public ResultPanel(String name, boolean stable, int minimum,
		     Vector redundant){
    
    super();    
    setLayout(new GridLayout(4,1));  
    add(new Label("The " + name + " plan was " + (stable?"":"not ") + 
		  "stable."));
    add(new Label("Theoretical minimum: " + minimum));
    Enumeration e = redundant.elements();
    String redundant_str = "";
    while(e.hasMoreElements()){
      redundant_str = redundant_str + ((Integer)e.nextElement()).toString() + 
	" ";
    }
    add(new Label("Redundant fixels: " + redundant_str));
    add(OK);
  }
    
  public boolean action(Event evt, Object arg) {
    
    if("OK".equals(arg)) {
      Frame f = (Frame)getParent();
      f.dispose();
    }
   
    return true;
  }

}





















