package FDATI;

import RemoteService.context.*;
import JavaAgent.context.SocketParams;
import java.io.File;
import java.net.URL;
import java.util.Hashtable;

/**
 * Subclass of SocketParams which holds runtime parameters for a 
 * FDATContext.<p>
 *
 * <hr>
 * Copyright (c) 1995, H. Robert Frost, Stanford University.
 * All rights reserved.<p>
 * Copyright (c) 1996, H. Robert Frost, Enterprise Integration Technologies,
 * Inc. All rights reserved.<p>
 *
 * RESTRICTED RIGHTS LEGEND: Use, duplication or disclosure by the 
 * Government is subject to restrictions as set forth in 
 * subparagraph(c)(1)(ii) of the Rights in Technical Data and Computer
 * Software clause at DFARS 252.227-7013 and in similar clauses in the
 * FAR and NASA FAR supplement.<p>
 * 
 * This software is bound by the terms and conditions listed in the
 * attached <a href="../LICENSE">LICENSE file</A>.
 * <hr>
 * @author <A HREF="http://cdr.stanford.edu/html/people/frost-bio.html"> Rob Frost</A>
 * @version 0.3 5/21/96 for Java(tm) Language Version 1.0.2
 */


public class FDATParams extends SocketParams{

  /**
   * Address for analysis submission
   */
  public String submission_address;

  /**
   * Constructor for use with applets 
   */
  public FDATParams(){}
  
  /**
   * Constructor the FDATParams object. Takes a Hashtable containing 
   * parameter values as input.
   */
  
  public FDATParams(Hashtable args){
    super(args);
    if(args.containsKey("-address")){
      submission_address = (String)args.get("-address");
    } 
  }

}
