package FDATI;

import RemoteService.resource.*;
import RemoteService.agent.*;

import JavaAgent.agent.*;
import JavaAgent.context.*;
import JavaAgent.resource.*;

import java.util.*;
import java.io.*;
import java.net.URL;
import java.awt.Panel;

/**
 * Subclass of ServiceAgent which represents the FDAT Service.<p>
 *	
 * <hr>
 * Copyright (c) 1995, H. Robert Frost, Stanford University.
 * All rights reserved.<p>
 * Copyright (c) 1996, H. Robert Frost, Enterprise Integration Technologies,
 * Inc. All rights reserved.<p>
 *
 * RESTRICTED RIGHTS LEGEND: Use, duplication or disclosure by the 
 * Government is subject to restrictions as set forth in 
 * subparagraph(c)(1)(ii) of the Rights in Technical Data and Computer
 * Software clause at DFARS 252.227-7013 and in similar clauses in the
 * FAR and NASA FAR supplement.<p>
 * 
 * This software is bound by the terms and conditions listed in the
 * attached <a href="../LICENSE">LICENSE file</A>.
 * <hr>
 * @author <A HREF="http://cdr.stanford.edu/html/people/frost-bio.html"> Rob Frost</A>
 * @version 0.3 5/21/96 for Java(tm) Language Version 1.0.2
 */

public class FDATAgent extends ServiceAgent{
  
  
  private String submission_address;
  
  /** 
   * Stores pairs of fixture plan names and the names of agents who 
   * submitted the plans.
   */
  private Hashtable requests = new Hashtable();

  /**
   * Contructs a FDATAgent.
   *
   * @param n String identifier for the Agent.
   * @param init_url URL for the initialization file.
   * @param shared_url URL for shared classes.
   * @param shared_dir Directory for local access to shared classes.
   * @param working_dir Directory for local files, will be null if the 
   * Agent is unable to write to the local file system.
   * @param submission_address Address for analysis submissions.
   */

  public FDATAgent(ContextInterface context,String n, URL init_url, 
		     URL shared_url, File shared_dir,File working_dir,
		   String submission_address) {
    super(context, n, init_url, shared_url, shared_dir, working_dir);
    this.submission_address = submission_address;
  }

  /**
   * Creates the FDATResourceManager, MessageHandler and reads in the
   * init_file.
   */
  
  public void init(){
    if(working_dir != null){
      io_enabled = true;
    }
    resources = new FDATResourceManager(this);
    handler = new ServiceMessageHandler(this);
    loadInitFile(init_url);
  }

  /**
   * Called by a Resource object when the number of elements has changed.
   * @param type Type of the Resource.
   */

  public void resourceChanged(Resource r){
    String class_name = r.getClass().getName();
    String type = null;
    if(class_name.equals("FDATI.Models")){
      type = "model";
      context.resourceChanged(type);
    } else {
      super.resourceChanged(r);
    }
  }

  /**
   * Submits the fixels for remote analysis.
   * @param client Agent which submitted the analysis request.
   * @param name Name of the fixturing plan.
   * @param fixels String containing fixel information.
   */

  protected void submitFixels(String client,
			      String plan_name,String fixels){
    StringTokenizer st = 
      new StringTokenizer(fixels.substring(1,fixels.lastIndexOf(")")));
    String dim = st.nextToken();
    String dir = st.nextToken();
    if(dir.equals("Form")){
      dir = dir + " " + st.nextToken();
    }
    String dir_i = "0";
    String dir_j = "0";
    String dir_k = "-1";
    if(dir.equals("directional")){
      dir_i = st.nextToken();
      dir_j = st.nextToken();
      dir_k = st.nextToken();
    }
    requests.put(plan_name,client);
    String post_params = getPostParams(dim,dir,dir_i,dir_j,dir_k,st);
    AnalysisSubmission as = 
      new AnalysisSubmission(this, plan_name,post_params,
			     submission_address);
    as.start();
  }

  protected void analysisResults(String plan_name, String results){
    String msg_str = "(evaluate :sender " + getName() + " :receiver " +
     (String)requests.get(plan_name) + " :language KQML :ontology FDAT)";
    KQMLmessage reply = new KQMLmessage(msg_str);
    KQMLmessage content = new KQMLmessage("(analysis-results)");
    content.addFieldValuePair("results","(" +results + ")");
    content.addFieldValuePair("name",plan_name);
    reply.addFieldValuePair("content",content.getSendString());
    sendMessage(reply);
  }

  private String getPostParams(String dim, String dir, String dir_i,
			       String dir_j, String dir_k,
			       StringTokenizer st){
    String answer = "";
    int num_added = 0;
    
    while(st.hasMoreTokens()){
      
      if( num_added < 10) {
	num_added++;
	answer = makepostparams(answer, "x-coord"+num_added,
				st.nextToken());
	answer = makepostparams(answer, "y-coord"+num_added,
				st.nextToken());
	answer = makepostparams(answer, "z-coord"+num_added,
				st.nextToken());
	answer = makepostparams(answer, "i-coord"+num_added,
				st.nextToken());
	answer = makepostparams(answer, "j-coord"+num_added,
				st.nextToken());
	answer = makepostparams(answer, "k-coord"+num_added,
				st.nextToken());
	answer = makepostparams(answer, "check"+num_added, "CHECKED");
      }
    }
    
    for(int i = num_added + 1; i <= 10; i ++) {
      num_added++;
      answer = makepostparams(answer, "x-coord"+num_added,
			      "0");
      answer = makepostparams(answer, "y-coord"+num_added,
			      "0");
      answer = makepostparams(answer, "z-coord"+num_added,
			      "0");
      answer = makepostparams(answer, "i-coord"+num_added,
			      "0");
      answer = makepostparams(answer, "j-coord"+num_added,
			      "0");
      answer = makepostparams(answer, "k-coord"+num_added,
			      "0");
    }
    
    answer = makepostparams(answer,"dimension",dim);    
    if(dir.equals("Form Closure")){
      dir = "form-closure";
    }
    answer = makepostparams(answer,"type",dir);    
    if(dir.equals("directional")) {
      answer = makepostparams(answer,"g-dir1", dir_i);
      answer = makepostparams(answer,"g-dir2", dir_j);
      answer = makepostparams(answer,"g-dir3", dir_k);
    } else {
      answer = makepostparams(answer,"g-dir1","0");
      answer = makepostparams(answer,"g-dir2","1");
      answer = makepostparams(answer,"g-dir3","0");
    }
    
    return answer;
  }
  
  /**
   * Makes a string of name value pairs in the format accepted by
   * POST method cgi-bin scripts/
   */

  static String makepostparams(String params, String name, String value) {
    
    params = params.concat(name + "=" + value + "&");
    return params;
  }

}







