package FDATI;

import java.awt.*;
import SModeling.*;

/**
 * Panel which allows the user to specify display options for the model.
 * Includes: light direction, edges/render/edges&render, back face culling
 * for edges.<p> 
 *
 * <hr>
 * Copyright (c) 1995, H. Robert Frost, Stanford University.
 * All rights reserved.<p>
 * Copyright (c) 1996, H. Robert Frost, Enterprise Integration Technologies,
 * Inc. All rights reserved.<p>
 *
 * RESTRICTED RIGHTS LEGEND: Use, duplication or disclosure by the 
 * Government is subject to restrictions as set forth in 
 * subparagraph(c)(1)(ii) of the Rights in Technical Data and Computer
 * Software clause at DFARS 252.227-7013 and in similar clauses in the
 * FAR and NASA FAR supplement.<p>
 * 
 * This software is bound by the terms and conditions listed in the
 * attached <a href="../LICENSE">LICENSE file</A>.
 * <hr>
 * @author <A HREF="http://cdr.stanford.edu/html/people/frost-bio.html"> Rob Frost</A>
 * @version 0.3 5/21/96 for Java(tm) Language Version 1.0.2
 */

public class DisplayPanel extends Panel{
  
  Panel DisplayTypePanel = new Panel();
  Panel LightPanel = new Panel();
  Panel ButtonPanel = new Panel();
  
  Label DisplayTypeLabel = new Label("Display type:");
  CheckboxGroup DisplayType = new CheckboxGroup();
  Checkbox EdgeOnly = new Checkbox("Edge Only", DisplayType, false); 
  Checkbox RenderOnly = new Checkbox("Render Only",  DisplayType, true); 
  Checkbox EdgeRender = new Checkbox("Edge & Render",  DisplayType, false); 

  Label LightLabel = new Label("Light direction:");
  CheckboxGroup Light = new CheckboxGroup();
  Checkbox North = new Checkbox("north", Light, true); 
  Checkbox South = new Checkbox("south", Light, false); 
  Checkbox East = new Checkbox("east", Light, false); 
  Checkbox West = new Checkbox("west", Light, false); 

  Button Cancel = new Button("Quit");
  Button Apply = new Button("Apply");
  
  Color bg_color;
  Color button_color;

  ModelPanel parent;
  
  /**
   * Constructor for Display Panel.
   * @param mp The ModelPanel from which this DisplayPanel was created
   */

  public DisplayPanel( ModelPanel mp, Color bg, Color button){
    
    super();
    parent = mp;
    bg_color  = bg;
    button_color = button;

    setLayout(new BorderLayout());  
    setBackground(bg_color);

    Apply.setBackground(button_color);
    Cancel.setBackground(button_color);

    DisplayTypePanel.setLayout(new FlowLayout());
    DisplayTypePanel.add(DisplayTypeLabel);
    DisplayTypePanel.add(EdgeOnly);
    DisplayTypePanel.add(RenderOnly);
    DisplayTypePanel.add(EdgeRender);
    
    LightPanel.setLayout(new FlowLayout());
    LightPanel.add(LightLabel);
    LightPanel.add(North);
    LightPanel.add(South);
    LightPanel.add(East);
    LightPanel.add(West);

    ButtonPanel.setLayout(new FlowLayout());
    ButtonPanel.add(Apply);
    ButtonPanel.add(Cancel);

    add("North", DisplayTypePanel);
    add("Center", LightPanel);
    add("South", ButtonPanel);
    
  }
    
  public boolean action(Event evt, Object arg) {
    
    if("Apply".equals(arg)) {
      ApplyAction();
    } else if("Quit".equals(arg)){
      Frame f = (Frame)getParent();
      parent.removeFrame(f);
      f.dispose();
    }
   
    return true;
  }
  

  void ApplyAction(){
    boolean edge = EdgeOnly.getState() || EdgeRender.getState();
    boolean render = RenderOnly.getState() || EdgeRender.getState();
    parent.setDisplayOptions(edge,render,Light.getCurrent().getLabel());  
  }
}





















