package FDATI;

import java.net.*;
import java.io.*;
import java.applet.*;

/**
 * Class which handles the POST method forms submission of the specified 
 * fixture points to the Fixture Design and Analysis Tool at CMU. This class
 * takes the ampersand delimited string of name/value pairs as input and 
 * calls its parent's  analysisResults() method to report the result String.
 * Submission is done by a separate thread of action.<p>
 *
 * <hr>
 * Copyright (c) 1995, H. Robert Frost, Stanford University.
 * All rights reserved.<p>
 * Copyright (c) 1996, H. Robert Frost, Enterprise Integration Technologies,
 * Inc. All rights reserved.<p>
 *
 * RESTRICTED RIGHTS LEGEND: Use, duplication or disclosure by the 
 * Government is subject to restrictions as set forth in 
 * subparagraph(c)(1)(ii) of the Rights in Technical Data and Computer
 * Software clause at DFARS 252.227-7013 and in similar clauses in the
 * FAR and NASA FAR supplement.<p>
 * 
 * This software is bound by the terms and conditions listed in the
 * attached <a href="../LICENSE">LICENSE file</A>.
 * <hr>
 * @author <A HREF="http://cdr.stanford.edu/html/people/frost-bio.html"> Rob Frost</A>
 * @version 0.3 5/21/96 for Java(tm) Language Version 1.0.2
 */

public class AnalysisSubmission extends Thread{

  String analysis_address = null;
  FDATAgent parent;
  String PostParameters;
  String plan_name;
  static final int TIMEOUT = 5000;

  /**
   * Constructs an AnalysisSubmission object for the specified ModelPanel
   * parent, with the specified POST parameters for submission to the 
   * URL represented by the address string.
   * @param parent FDATAgent
   * @param plan_name Name of the fixturing plan
   * @param postparams Ampersand delimited list of name/value pairs to 
   * submit.
   * @param address String representing the cgi-bin script to which the 
   * parameters are sent for analysis.
   */

  public AnalysisSubmission(FDATAgent parent, String plan_name,
			    String postparams, String address){
    super("Submission Thread");
    analysis_address = address;
    this.parent = parent;
    this.plan_name =plan_name;
    PostParameters = postparams;
  }

  /**
   * Called to begin submission.
   */

  public void run(){

    //socketMethod(analysis_address,parent,PostParameters);
    urlMethod(analysis_address,PostParameters);

  }

  void urlMethod(String analysis_address, String PostParameters){
    Socket client = null;
    
    try{
      String sURL = analysis_address + "?" + PostParameters;
      parent.addSystemMessage("Submission url: " + sURL);
      URL Url = new URL(sURL);
      DataInputStream input =
	new DataInputStream(Url.openStream());
      TimerThread tt = new TimerThread(this,TIMEOUT, parent);
      tt.start();
      while(input.available() == 0){}
      String result = input.readLine() + "\n";;
      while(input.available() > 0){
	result = result.concat(input.readLine()+ "\n");
      }
      tt.stop();
      tt = null;
      parent.analysisResults(plan_name,result);
      input.close();
    } catch(Exception e){
      parent.addSystemMessage("Problem with submission.", e);
    }
  }

}

class TimerThread extends Thread{

  Thread parent;
  int timeout;
  FDATAgent agent;

  /**
   * Thread which stops the parent thread after the specified amount of time.
   * @param parent Parent thread.
   * @param timeout The timeout value.
   * @param agent FDATAgent which is performing the submission.
   */

  public TimerThread(Thread parent, int timeout, FDATAgent agent){
    super("Timer Thread");
    this.parent = parent;
    this.timeout = timeout;
    this.agent = agent;
  }

  /**
   * Called to begin timing.
   */

  public void run(){
    try{
      sleep(timeout);
      parent.stop();
      parent = null;
      agent.analysisResults("plan","Error: submission timed-out");
    } catch (InterruptedException e){}
  }

}









