package FDATI;

import java.awt.*;
import SModeling.*;

/**
 * Panel which allows the user to specify specific analysis options for the
 * models. User picks either 3D or planar, either form closure or directional 
 * and if directional is selected then supplies a directional vector.<p> 
 *
 * <hr>
 * Copyright (c) 1995, H. Robert Frost, Stanford University.
 * All rights reserved.<p>
 * Copyright (c) 1996, H. Robert Frost, Enterprise Integration Technologies,
 * Inc. All rights reserved.<p>
 *
 * RESTRICTED RIGHTS LEGEND: Use, duplication or disclosure by the 
 * Government is subject to restrictions as set forth in 
 * subparagraph(c)(1)(ii) of the Rights in Technical Data and Computer
 * Software clause at DFARS 252.227-7013 and in similar clauses in the
 * FAR and NASA FAR supplement.<p>
 * 
 * This software is bound by the terms and conditions listed in the
 * attached <a href="../LICENSE">LICENSE file</A>.
 * <hr>
 * @author <A HREF="http://cdr.stanford.edu/html/people/frost-bio.html"> Rob Frost</A>
 * @version 0.3 5/21/96 for Java(tm) Language Version 1.0.2
 */

public class AnalysisPanel extends Panel{
  
  Panel DimensionPanel = new Panel();
  Panel DirectionPanel = new Panel();
  Panel ButtonPanel = new Panel();
  
  Choice Dimensionality = new Choice();
  Choice Directionality = new Choice();
 
  Label DirectionLabel = new Label("Direction Vector");
  Label iLabel = new Label("i: ");
  Label jLabel = new Label("j: ");
  Label kLabel = new Label("k: ");
  TextField iValue = new TextField("0",5);
  TextField jValue = new TextField("0",5);
  TextField kValue = new TextField("-1",5);

  Button Cancel = new Button("Quit");
  Button Apply = new Button("Apply");

  Color bg_color;
  Color button_color;  

  ModelPanel parent;
  
  /**
   * Constructor for Analysis Panel.
   * @param mp The ModelPanel from which this AnalysisPanel was created
   */

  public AnalysisPanel( ModelPanel mp, Color bg, Color button){
    
    super();
    parent = mp;
    
    bg_color = bg;
    button_color = button;

    setLayout(new BorderLayout());  
    setBackground(bg_color);

    Apply.setBackground(button_color);
    Cancel.setBackground(button_color);
    Dimensionality.setBackground(button_color);
    Directionality.setBackground(button_color);
    //iValue.setBackground(button_color);
    //jValue.setBackground(button_color);
    //kValue.setBackground(button_color);

    DimensionPanel.setLayout(new FlowLayout());
    DimensionPanel.add(Dimensionality);
    DimensionPanel.add(Directionality);
    Dimensionality.addItem("3D");
    Dimensionality.addItem("Planar");
    Directionality.addItem("Form Closure");
    Directionality.addItem("Directional");
    
    DirectionPanel.setLayout(new FlowLayout());
    DirectionPanel.add(iLabel);
    DirectionPanel.add(iValue);
    DirectionPanel.add(jLabel);
    DirectionPanel.add(jValue);
    DirectionPanel.add(kLabel);
    DirectionPanel.add(kValue);

    ButtonPanel.setLayout(new FlowLayout());
    ButtonPanel.add(Apply);
    ButtonPanel.add(Cancel);


    add("North", DimensionPanel);
    add("Center", DirectionPanel);
    add("South", ButtonPanel);
    
  }
    
  public boolean action(Event evt, Object arg) {
    
    if("Apply".equals(arg)) {
      ApplyAction();
    } else if("Quit".equals(arg)){
      Frame f = (Frame)getParent();
      parent.removeFrame(f);
      f.dispose();
    }
   
    return true;
  }
  

  void ApplyAction(){
    parent.setDim(Dimensionality.getSelectedItem());
    if(Directionality.getSelectedItem().equals("Directional")){
      Float i = Float.valueOf(iValue.getText()); 
      Float j = Float.valueOf(jValue.getText()); 
      Float k = Float.valueOf(kValue.getText()); 
      hpoint direction = new hpoint(i.floatValue(), j.floatValue(),
				    k.floatValue(), 1);
      parent.setDirVec(direction);
    }
    parent.setDir(Directionality.getSelectedItem());
  }
}





















