;;; loader.clp
;;; Loads Hardy2HTML conversion utility
;;; Julian Smart
;;; 
;;; Created     3/12/94
;;; Modified    25/3/96
;;;
;;;
;;; Generates:
;;;  * a set of HTML files, one HTML file per card.
;;;  * BMP files are generated for each diagram and converted to GIFs at the end
;;;    of translation using a DOS program
;;; Limitations:
;;;  * only works for the Windows Hardy version since the X version cannot 
;;;    generate
;;;    colour bitmaps
;;;  * each HTML link points to a file, not an item within a file
;;;  * if an item contains a link to more than one card, second and subsequent
;;;    links are ignored
;;;
;;; See also: standard/help.htm

(unwatch all)

;;; Globals
(load "c:\\hardy\\html\\globals.clp")

;;; HtmlWriter class declaration
(load "c:\\hardy\\html\\htmlgen.clp")

;;; Generates an image map for a diagram
(load "c:\\hardy\\html\\genmap.clp")

;;; Dialog box for entering pathname, etc.
(load "c:\\hardy\\html\\dialog.clp")

;; Diagram card conversion
(load "c:\\hardy\\html\\diagram.clp")

;; Hypertext card conversion
(load "c:\\hardy\\html\\hypertxt.clp")

;; Text card conversion
(load "c:\\hardy\\html\\text.clp")

;; Main conversion routines
(load "c:\\hardy\\html\\convert.clp")

;; Install a menu callback
(register-event-handler CustomMenu Toplevel trans-custom-menu)

;; Construct an HtmlWriter instance
(bind ?*html-writer* (make-instance html-writer of HtmlWriter))

