;;; genmap.clp
;;; Generate image map from a diagram. Each node image translates to a hotspot
;;; whose top half points to an expansion, and whose bottom half points to
;;; a file giving more detailed info about the node.

;;; Write out the node details to separate ?exp-filename HTML page
(defmessage-handler MAIN::HtmlWriter generate-image-details (?card ?node-image-id ?exp-filename)
  (bind ?node-object (diagram-image-get-object ?card ?node-image-id))

  (open (str-cat ?self:output-path "/" ?exp-filename) expansion "w")
  
  (bind ?title (str-cat (diagram-object-get-string-attribute ?card ?node-object ?self:name-attribute)))
  
  (printout expansion "<HTML>" crlf)
  (printout expansion "<HEAD>" crlf)
  (printout expansion "<TITLE>" ?title "</TITLE>" crlf)
  (printout expansion "</HEAD>" crlf crlf)
  (send ?self output-body-tag expansion "bg-3.gif")

;  (printout expansion "<CENTER>" crlf)
;  (printout expansion "<H2>" ?title "</H2>" crlf "<HR>")
;  (printout expansion "</CENTER>" crlf)

  (printout expansion "<CENTER>" crlf)
  (printout expansion "<TABLE BORDER=1 CELLPADDING=2 CELLSPACING=2>" crlf)
  (printout expansion "<TR><TD COLSPAN=2 ALIGN=CENTER><FONT SIZE=5>"
    (diagram-object-get-string-attribute ?card ?node-object ?self:name-attribute) "</FONT></TD></TR>" crlf)

  (bind ?attribute (diagram-object-get-first-attribute ?card ?node-object))
  (while (neq ?attribute "")
   (if  (neq ?attribute ?self:name-attribute) 
     then
      (printout expansion "<TR>" crlf "<TD WIDTH=200><B>" (send ?self convert-to-html ?attribute) "</B></TD>" crlf)
      (printout expansion "<TD>" (send ?self convert-to-html (diagram-object-get-string-attribute ?card ?node-object ?attribute))
        "</TD>" crlf)
     (printout expansion "</TR>" crlf)
   )
   (bind ?attribute (diagram-object-get-next-attribute))
  )

  (printout expansion "</TABLE>" crlf)
  (printout expansion "</CENTER>" crlf)
  (printout expansion "</BODY></HTML>" crlf)
  
;  (send ?self output-card-footer expansion ?card)

  (close expansion)
)

;;; Generate an image map for the diagram, plus a page for each node's details
(defmessage-handler MAIN::HtmlWriter generate-diagram-map (?output ?card ?gif-filename ?is-frame)

  ;;; First, output the inline image reference.
  (bind ?image-map-name (str-cat "diagrammap" ?card))
  
  (printout ?output "<CENTER>" crlf)
  (printout ?output "<IMG SRC=\"" ?gif-filename "\" BORDER=1 USEMAP=\"#" ?image-map-name "\" ISMAP ALT=\"image map\">" crlf crlf)
  (printout ?output "</CENTER>" crlf)
  
  (printout ?output "<MAP NAME=\"" ?image-map-name "\">" crlf)
  
  ;;; Need to multiple coordinates by the current card scale
  (bind ?scale (diagram-card-get-scale ?card))
  
  ;;; Do nodes
  (bind ?node-image-id (diagram-card-get-first-node-image ?card))
  (while (neq ?node-image-id -1)
  
   (bind ?width (diagram-image-get-width ?card ?node-image-id))
   (bind ?height (diagram-image-get-height ?card ?node-image-id))
   (bind ?x (diagram-image-get-x ?card ?node-image-id))
   (bind ?y (diagram-image-get-y ?card ?node-image-id))
   
   ;;; x and y represent the centre of the image.
   ;;; Find top and bottom half of image.
   ;;; HTML requires each region to be of the form:
   ;;;
   ;;; x1, y1 ----------
   ;;; |                |
   ;;; |                |
   ;;; |                |
   ;;; |                |
   ;;; |                |
   ;;; -----------x2, y2
   ;;;
   ;;; We want 2 of these:
   ;;; xt1, yt1---------
   ;;; |                |
   ;;; |    T O P       |
   ;;; |                |
   ;;; |--------xt2, yt2
   ;;; xb1, yb1         |
   ;;; |                |
   ;;; |  B O T T O M   |
   ;;; |                |
   ;;; ---------xb2, yb2
   
   (bind ?top-x1 (integer (* ?scale (- ?x (/ ?width 2)))))
   (bind ?top-y1 (integer (* ?scale (- ?y (/ ?height 2)))))
   (bind ?top-x2 (integer (* ?scale (+ ?x (/ ?width 2)))))
   (bind ?top-y2 (integer (* ?scale ?y)))

   (bind ?bottom-x1 (integer ?top-x1))
   (bind ?bottom-y1 (integer (* ?scale ?y)))
   (bind ?bottom-x2 (integer ?top-x2))
   (bind ?bottom-y2 (integer (* ?scale (+ ?y (/ ?height 2)))))

   ;;; The top part of the node image links to the expansion page if there is one,
   ;;; or a default file "noexp.html" otherwise.
   (bind ?exp-card (diagram-image-get-first-expansion ?card ?node-image-id))
   
   ;;; See if there's some other linked card.
   (if (eq ?exp-card -1) then
     (bind ?exp-card (send ?self find-linked-card ?card ?node-image-id))
   )
   
   (bind ?exp-filename "")
   (bind ?exp-target "infowindow")

   (if (eq ?exp-card -1) then
     (bind ?exp-filename "noexp.html")
     (bind ?exp-target "infowindow")
    else
     ;;; If we're generating an image map for a frame-enabled diagram,
     ;;; point to the -frame version of a child card.
     (if (eq TRUE ?is-frame) then
       (bind ?exp-filename (str-cat "card-" ?exp-card "-frame.html"))
     else
       (bind ?exp-filename (send ?self find-card-file ?exp-card)))
     (bind ?exp-target "topwindow")
   )

   ;;; Construct node attributes filename out of node-details-<CARD ID>-<NODE IMAGE ID>.html
   (bind ?attributes-filename (str-cat "node-details-" ?card "-" ?node-image-id ".html"))
    
   ;;; Write out the node details to separate ?attributes-filename HTML page
   (send ?self generate-image-details ?card ?node-image-id ?attributes-filename)

   (printout ?output "<AREA COORDS=\"" ?top-x1 "," ?top-y1 "," ?top-x2 "," ?top-y2 "\" HREF=\"" ?exp-filename "\" TARGET=" ?exp-target ">" crlf)
   (printout ?output "<AREA COORDS=\"" ?bottom-x1 "," ?bottom-y1 "," ?bottom-x2 "," ?bottom-y2 "\" HREF=\"" ?attributes-filename "\" TARGET=infowindow>" crlf)
   
   ;;; Next image...
   (bind ?node-image-id (diagram-card-get-next-node-image))
  )
  (printout ?output "</MAP>" crlf "<P>" crlf crlf)
)

;;; Return a card linked to this node image, or -1
(defmessage-handler MAIN::HtmlWriter find-linked-card (?card ?node-image)
  (bind ?item (diagram-image-get-item ?card ?node-image))
  (if (eq ?item -1) then (return -1))
  (bind ?link (item-get-first-link ?card ?item))
  (if (eq ?link -1) then (return -1))
  (bind ?to-card (link-get-card-to ?link))
  (return ?to-card)
)
