;;; dialog.clp
;;; Dialog for editing translator variables

;;; Respond to Ok button
(deffunction trans-dialog-ok (?but)
 (send ?*html-writer* put-output-path (text-get-value (send ?*html-writer* get-path-item)))
 (send ?*html-writer* put-standard-path (text-get-value (send ?*html-writer* get-standard-item)))
 (send ?*html-writer* put-title (text-get-value (send ?*html-writer* get-title-item)))
 (send ?*html-writer* put-author (text-get-value (send ?*html-writer* get-author-item)))
 (send ?*html-writer* put-name-attribute (text-get-value (send ?*html-writer* get-name-item)))
; (send ?*html-writer* put-diagram-scale (string-to-long (text-get-value (send ?*html-writer* get-scale-item*))))
 (window-show (send ?*html-writer* get-preferences-dialog) 0)
 (window-delete (send ?*html-writer* get-preferences-dialog))
)

;;; Respond to Cancel button
(deffunction trans-dialog-cancel (?but)
 (send ?*html-writer* put-dialog-cancel TRUE)
 (window-show (send ?*html-writer* get-preferences-dialog) 0)
 (window-delete (send ?*html-writer* get-preferences-dialog))
)

;;; Show the dialog
(defmessage-handler MAIN::HtmlWriter show-preferences-dialog ()
 (bind ?self:dialog-cancel FALSE)
 (bind ?pref-dialog (dialog-box-create 0 "HTML Translation Preferences" 1 0 0 500 500))
 (bind ?self:preferences-dialog ?pref-dialog)
 (panel-set-label-position ?pref-dialog wxVERTICAL)

 (bind ?self:path-item
    (text-create ?pref-dialog "" "Destination directory" ?self:output-path -1 -1 250))
 (panel-new-line ?pref-dialog)

 (bind ?self:standard-item
    (text-create ?pref-dialog "" "Standard document directory" ?self:standard-path -1 -1 250))
 (panel-new-line ?pref-dialog)

 (bind ?self:title-item
    (text-create ?pref-dialog "" "Title" ?self:title -1 -1 250))
 (panel-new-line ?pref-dialog)

 (bind ?self:author-item
    (text-create ?pref-dialog "" "Author(s)" ?self:author -1 -1 250))
 (panel-new-line ?pref-dialog)

 (bind ?self:name-item
    (text-create ?pref-dialog "" "Object identifier attribute" ?self:name-attribute -1 -1 250))
 (panel-new-line ?pref-dialog)

; (bind ?self:scale-item
;    (text-create ?pref-dialog "" "Diagram output width (in pixels)" (str-cat ?self:diagram-scale) -1 -1 250))
; (panel-new-line ?pref-dialog)

 (bind ?ok-item (button-create ?pref-dialog trans-dialog-ok "OK"))
 (bind ?cancel-item (button-create ?pref-dialog trans-dialog-cancel "Cancel"))
 (panel-item-set-default ?ok-item)

 (window-fit ?pref-dialog)
 (window-centre ?pref-dialog wxBOTH)
 (window-show ?pref-dialog 1)
 
 (if (eq ?self:dialog-cancel TRUE) then
   (return FALSE) else
   (return TRUE))
)

;;; Modeless dialog for informing user what's going on. Only shows
;;; under Windows, since X's synchronous nature means that nothing
;;; shows up until processing has ended.

(defmessage-handler MAIN::HtmlWriter show-processing-dialog ()
 (if (neq (get-platform ) "Windows 3.1") then (return))

 (bind ?self:processing-dialog (dialog-box-create 0 "HTML Conversion" 0 10 10 400 80))
 (message-create ?self:processing-dialog "Converting to HTML...")
 (panel-new-line ?self:processing-dialog)
 (bind ?self:processing-message (message-create ?self:processing-dialog ""))
 (window-show ?self:processing-dialog 1)
 (yield)
)

(defmessage-handler MAIN::HtmlWriter hide-processing-dialog ()
 (if (neq (get-platform ) "Windows 3.1") then (return))

 (window-show ?self:processing-dialog 1)
 (window-delete ?self:processing-dialog)
)

(defmessage-handler MAIN::HtmlWriter tell-processing (?msg)
 (if (neq (get-platform) "Windows 3.1") then (return))

 (panel-item-set-label ?self:processing-message ?msg)
 (yield)
)

