/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class Splash
extends Window {
    private Image splashImage;
    private int imgWidth;
    private int imgHeight;
    private String imgName;
    private static final int BORDERSIZE = 5;
    private static final Color BORDERCOLOR = Color.blue;
    Toolkit tk;

    public Splash(Frame frame, String string) {
        super(frame);
        this.imgName = string;
        this.tk = Toolkit.getDefaultToolkit();
        this.splashImage = this.loadSplashImage();
        this.showSplashScreen();
        frame.addWindowListener(new WindowListener());
    }

    public Image loadSplashImage() {
        MediaTracker mediaTracker = new MediaTracker(this);
        Image image = this.tk.getImage(this.imgName);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.imgWidth = image.getWidth(this);
        this.imgHeight = image.getHeight(this);
        return image;
    }

    public void paint(Graphics graphics) {
        graphics.drawImage(this.splashImage, 5, 5, this.imgWidth, this.imgHeight, this);
    }

    public void showSplashScreen() {
        Dimension dimension = this.tk.getScreenSize();
        ((Component)this).setBackground(BORDERCOLOR);
        int n = this.imgWidth + 10;
        int n2 = this.imgHeight + 10;
        int n3 = (dimension.width - n) / 2;
        int n4 = (dimension.height - n2) / 2;
        ((Component)this).setBounds(n3, n4, n, n2);
        ((Component)this).setVisible(true);
    }

    class WindowListener
    extends WindowAdapter {
        WindowListener() {
        }

        public void windowActivated(WindowEvent windowEvent) {
            ((Component)Splash.this).setVisible(false);
            Splash.this.dispose();
        }
    }
}

