/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JTree;

public class FtpModule {
    private static final int POSITIVE_PRELIMINARY_REPLY = 1;
    private static final int POSITIVE_COMPLETION_REPLY = 2;
    private static final int POSITIVE_INTERMEDIATE_REPLY = 3;
    private static final int TRANSIENT_NEGATIVE_REPLY = 4;
    private static final int PERMANENT_NEGATIVE_REPLY = 5;
    Vector cpo_plan;
    Vector cpo_process;
    Vector cpo_activity_spec;
    Vector cpo_action;
    Vector cpo_start;
    Vector cpo_finish;
    Vector cpo_begin;
    Vector cpo_end;
    Vector cpo_timepoint;
    Vector cpo_ordering_c;
    Vector cpo_input_c;
    Vector cpo_output_c;
    Vector cpo_resource_c;
    Vector cpo_include_c;
    Vector cpo_annot_c;
    Vector cpo_unit;
    Vector cpo_var;
    private boolean tfExport = false;
    private static final int IDLE = 1;
    private static final int CONNECTED = 2;
    private Integer m_port = null;
    private int State = 1;
    private OutputStream m_outdataport = null;
    private Socket controlSocket = null;
    private DataInputStream controlInputStream = null;
    private PrintStream controlOutputStream = null;
    private ByteArrayOutputStream tfOutputStream = null;
    public CpeProcessPanel m_frame = null;
    public JTree tree = null;
    private int m_frameCount = 0;

    public FtpModule(CpeProcessPanel cpeProcessPanel) {
        this.m_frame = cpeProcessPanel;
    }

    public String calcPortCmdParameter(ServerSocket serverSocket) {
        InetAddress inetAddress;
        int n = serverSocket.getLocalPort();
        try {
            inetAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            return "";
        }
        byte[] byArray = inetAddress.getAddress();
        short[] sArray = new short[4];
        int n2 = 0;
        while (n2 <= 3) {
            sArray[n2] = byArray[n2];
            if (sArray[n2] < 0) {
                int n3 = n2;
                sArray[n3] = (short)(sArray[n3] + 256);
            }
            ++n2;
        }
        String string = new String(String.valueOf(sArray[0]) + "," + sArray[1] + "," + sArray[2] + "," + sArray[3] + "," + ((n & 0xFF00) >> 8) + "," + (n & 0xFF));
        return string;
    }

    public boolean chdir(String string) {
        if (this.State == 2) {
            String string2 = new String("CWD " + string + "\r");
            this.printText(string2);
            this.controlOutputStream.println(string2);
            int n = this.checkResponse();
            if (n == 2) {
                return true;
            }
        }
        return false;
    }

    public int checkResponse() {
        String string;
        try {
            do {
                string = this.controlInputStream.readLine();
                this.printText(string);
            } while (!Character.isDigit(string.charAt(0)) || !Character.isDigit(string.charAt(1)) || !Character.isDigit(string.charAt(2)) || string.charAt(3) != ' ');
        }
        catch (IOException iOException) {
            this.printText("ERR Error getting response from controlport!");
            return 0;
        }
        return Integer.parseInt(string.substring(0, 1));
    }

    public int checkResponsePasv() {
        String string;
        Integer n = null;
        Integer n2 = null;
        int n3 = 0;
        try {
            do {
                string = this.controlInputStream.readLine();
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",()");
                int n4 = 0;
                StringTokenizer stringTokenizer2 = stringTokenizer;
                while (stringTokenizer2.hasMoreElements()) {
                    String string2 = (String)stringTokenizer2.nextElement();
                    if (n4 == 5) {
                        n = new Integer(string2);
                    } else if (n4 == 6) {
                        n2 = new Integer(string2);
                        n3 = n * 256 + n2;
                    }
                    ++n4;
                }
                this.m_port = new Integer(n3);
                this.printText("Pasv port: " + this.m_port);
                this.printText(string);
            } while (!Character.isDigit(string.charAt(0)) || !Character.isDigit(string.charAt(1)) || !Character.isDigit(string.charAt(2)) || string.charAt(3) != ' ');
        }
        catch (IOException iOException) {
            this.printText("ERR Error getting response from controlport!");
            return 0;
        }
        return Integer.parseInt(string.substring(0, 1));
    }

    public boolean connect(String string) {
        if (this.State == 2) {
            this.disconnect();
        }
        try {
            this.controlSocket = new Socket(string, 21);
            this.controlInputStream = new DataInputStream(this.controlSocket.getInputStream());
            this.controlOutputStream = new PrintStream(this.controlSocket.getOutputStream());
            this.State = 2;
        }
        catch (UnknownHostException unknownHostException) {
            this.printText("ERR Don't know about host: " + string);
            return false;
        }
        catch (IOException iOException) {
            this.printText("ERR Couldn't get I/O for the connection to: " + string);
            return false;
        }
        this.checkResponse();
        return true;
    }

    public void delete(String string) {
        if (this.State == 2) {
            String string2 = new String("DELE " + string + "\r");
            this.printText(string2);
            this.controlOutputStream.println(string2);
            int n = this.checkResponse();
        }
    }

    public boolean disconnect() {
        if (this.controlSocket != null && this.controlOutputStream != null && this.controlInputStream != null) {
            try {
                String string = new String("QUIT\r");
                this.printText(string);
                this.controlOutputStream.println(string);
                int n = this.checkResponse();
                this.controlOutputStream.close();
                this.controlInputStream.close();
                this.controlSocket.close();
                this.State = 1;
            }
            catch (IOException iOException) {
                this.printText("ERR I/O failed while closing connection!");
                return false;
            }
        }
        return true;
    }

    public String getCurrentDir() {
        String string = "";
        if (this.State == 2) {
            String string2;
            this.printText("PWD");
            this.controlOutputStream.println("PWD\r");
            try {
                do {
                    string2 = this.controlInputStream.readLine();
                    this.printText(string2);
                } while (!Character.isDigit(string2.charAt(0)) || !Character.isDigit(string2.charAt(1)) || !Character.isDigit(string2.charAt(2)) || string2.charAt(3) != ' ');
            }
            catch (IOException iOException) {
                this.printText("ERR Error getting reply from controlport!");
                return "";
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            int n = 0;
            while (stringTokenizer.hasMoreTokens() && string.equals("")) {
                String string3 = stringTokenizer.nextToken();
                if (++n != 2) continue;
                string = new String(string3.substring(1, string3.length() - 1));
                break;
            }
        }
        return string;
    }

    public boolean getFile(char c, String string) {
        Socket socket = null;
        DataInputStream dataInputStream = null;
        this.setType("BINARY");
        String string2 = "PASV\r";
        this.printText(string2);
        this.controlOutputStream.println(string2);
        int n = this.checkResponsePasv();
        try {
            socket = new Socket(Cpe.sharedInstance().hostName, (int)this.m_port);
            dataInputStream = new DataInputStream(socket.getInputStream());
        }
        catch (UnknownHostException unknownHostException) {
            this.printText("ERR Don't know about host: " + Cpe.sharedInstance().hostName);
            return false;
        }
        catch (IOException iOException) {
            this.printText("ERR Couldn't get I/O for the connection to: " + Cpe.sharedInstance().hostName);
            return false;
        }
        string2 = "RETR " + string + "\r";
        this.printText(string2);
        this.controlOutputStream.println(string2);
        n = this.checkResponse();
        if (n == 1) {
            Cpe.sharedInstance().displayMessage("Reading specification from file " + string + " ...");
            try {
                this.m_frame.process.newProcess();
                this.m_frameCount = 0;
                this.parseAndLoad(c, dataInputStream);
                n = this.checkResponse();
                dataInputStream.close();
                socket.close();
            }
            catch (IOException iOException) {
                this.printText("ERR " + iOException.toString());
                Cpe.sharedInstance().displayMessage("ERR " + iOException.toString());
                return false;
            }
            Cpe.sharedInstance().displayMessage("Read completed!");
            return n == 2;
        }
        this.printText("ERR while trying to get file.");
        Cpe.sharedInstance().displayMessage("Err while trying to get the file.");
        return false;
    }

    public boolean getFileLocal(char c, String string, InputStream inputStream) {
        Cpe.sharedInstance().displayMessage("Reading specification from file " + string + " ...");
        try {
            this.m_frame.process.newProcess();
            this.m_frameCount = 0;
            this.parseAndLoad(c, new DataInputStream(inputStream));
        }
        catch (Exception exception) {
            this.printText("ERR " + exception.toString());
            Cpe.sharedInstance().displayMessage("ERR " + exception.toString());
            return false;
        }
        Cpe.sharedInstance().displayMessage("Read completed!");
        return true;
    }

    public boolean login(String string, String string2) {
        if (this.State == 2) {
            String string3 = new String("USER " + string + "\r");
            this.printText(string3);
            this.controlOutputStream.println(string3);
            int n = this.checkResponse();
            if (n == 3) {
                string3 = new String("PASS " + string2 + "\r");
                this.printText("PASS xxxxxx");
                this.controlOutputStream.println(string3);
                n = this.checkResponse();
                if (n == 2) {
                    return true;
                }
            }
        }
        return false;
    }

    public void mkdir(String string) {
        if (this.State == 2) {
            String string2 = new String("MKD " + string + "\r");
            this.printText(string2);
            this.controlOutputStream.println(string2);
            this.checkResponse();
        }
    }

    private void parseAndLoad(char c, DataInputStream dataInputStream) {
        Cpe cpe = Cpe.sharedInstance();
        if (c == 'I') {
            opo cfr_ignored_0 = cpe.opoParse;
            opo.spec.reset();
            opo cfr_ignored_1 = cpe.opoParse;
            opo.ReInit(dataInputStream);
            try {
                Cpe cpe2 = cpe;
                cpe2.opoParse.CompilationUnit();
            }
            catch (ParseException parseException) {
                cpe.displayMessage("Error! " + parseException.getMessage());
            }
            catch (TokenMgrError tokenMgrError) {
                cpe.displayMessage("Error! " + tokenMgrError.getMessage());
            }
            catch (Exception exception) {
                cpe.displayMessage("Error! " + exception.getMessage());
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream printStream = new PrintStream(byteArrayOutputStream);
            opo cfr_ignored_2 = cpe.opoParse;
            opo.spec.writeOut(printStream);
            printStream.flush();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            cpl cfr_ignored_3 = cpe.cplParse;
            cpl.spec.reset();
            cpl cfr_ignored_4 = cpe.cplParse;
            cpl.ReInit(byteArrayInputStream);
            try {
                Cpe cpe3 = cpe;
                cpe3.cplParse.CompilationUnit();
            }
            catch (ParseException parseException) {
                cpe.displayMessage("Error! " + parseException.getMessage());
            }
            catch (TokenMgrError tokenMgrError) {
                cpe.displayMessage("Error! " + tokenMgrError.getMessage());
            }
            catch (Exception exception) {
                cpe.displayMessage("Error! " + exception.getMessage());
            }
            cpl cfr_ignored_5 = cpe.cplParse;
            cpl.spec.importer(this.m_frame);
        } else {
            cpl cfr_ignored_6 = cpe.cplParse;
            cpl.spec.reset();
            cpl cfr_ignored_7 = cpe.cplParse;
            cpl.ReInit(dataInputStream);
            try {
                Cpe cpe4 = cpe;
                cpe4.cplParse.CompilationUnit();
            }
            catch (ParseException parseException) {
                cpe.displayMessage("Error! " + parseException.getMessage());
            }
            catch (TokenMgrError tokenMgrError) {
                cpe.displayMessage("Error! " + tokenMgrError.getMessage());
            }
            catch (Exception exception) {
                cpe.displayMessage("Error! " + exception.getMessage());
            }
            cpl cfr_ignored_8 = cpe.cplParse;
            cpl.spec.importer(this.m_frame);
        }
    }

    private void printText(String string) {
        if (Cpe.sharedInstance().debugFlag) {
            System.out.println(string);
        }
    }

    public void rename(String string, String string2) {
        if (this.State == 2) {
            String string3 = new String("RNFR " + string + "\r");
            this.printText(string3);
            this.controlOutputStream.println(string3);
            int n = this.checkResponse();
            if (n != 3) {
                this.controlOutputStream.println("ABOR\r");
                this.checkResponse();
            } else {
                string3 = new String("RNTO " + string2 + "\r");
                this.printText(string3);
                this.controlOutputStream.println(string3);
                this.checkResponse();
            }
        }
    }

    public String replaceKey(String string, String string2, String string3) {
        String string4 = "";
        long l = 2113929255L;
        long l2 = 32L;
        long l3 = 5L;
        int n = 0;
        char[] cArray = string.toCharArray();
        char[] cArray2 = string2.toCharArray();
        int n2 = cArray2.length;
        int n3 = cArray.length;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 1L;
        int n4 = 0;
        while (n4 < n2 - 1) {
            l6 = (l6 << (int)l3) % l;
            ++n4;
        }
        n4 = 0;
        while (n4 < n2) {
            l4 = ((l4 << (int)l3) + (long)cArray2[n4]) % l;
            l5 = ((l5 << (int)l3) + (long)cArray[n4]) % l;
            ++n4;
        }
        n4 = 0;
        while (l4 != l5 && n4 < n3 - n2) {
            l5 = (l5 + (l << (int)l3) - (long)cArray[n4] * l6) % l;
            l5 = ((l5 << (int)l3) + (long)cArray[n4 + n2]) % l;
            ++n4;
        }
        if (n4 >= n3 - n2) {
            n = -1;
            return string;
        }
        n = n4;
        string4 = String.valueOf(string.substring(0, n4)) + string3 + string.substring(n4 + n2);
        return string4;
    }

    public void rmdir(String string) {
        if (this.State == 2) {
            String string2 = new String("RMD " + string + "\r");
            this.printText(string2);
            this.controlOutputStream.println(string2);
            this.checkResponse();
        }
    }

    public boolean sendFile(char c, boolean bl, String string) {
        DataOutputStream dataOutputStream;
        ServerSocket serverSocket = null;
        Socket socket = null;
        if (this.State != 2) {
            this.printText("ERR Not connected, unable to send file!");
            return false;
        }
        this.setType("BINARY");
        String string2 = "PASV\r";
        this.printText(string2);
        this.controlOutputStream.println(string2);
        int n = this.checkResponsePasv();
        try {
            socket = new Socket(Cpe.sharedInstance().hostName, (int)this.m_port);
            dataOutputStream = new DataOutputStream(socket.getOutputStream());
        }
        catch (UnknownHostException unknownHostException) {
            this.printText("ERR Don't know about host: " + Cpe.sharedInstance().hostName);
            return false;
        }
        catch (IOException iOException) {
            this.printText("ERR Couldn't get I/O for the connection to: " + Cpe.sharedInstance().hostName);
            return false;
        }
        string2 = bl ? "STOR " + string + "\r" : "STOU " + string + "\r";
        this.controlOutputStream.println(string2);
        this.printText(string2);
        n = this.checkResponse();
        if (n == 1) {
            try {
                this.m_outdataport = dataOutputStream;
                this.writeProcessToFile(string);
                this.m_outdataport = null;
                ((OutputStream)dataOutputStream).close();
                socket.close();
                n = this.checkResponse();
            }
            catch (IOException iOException) {
                this.printText("ERR " + iOException.toString());
                return false;
            }
            return n == 2;
        }
        this.printText("ERR while trying to send file.");
        try {
            serverSocket.close();
        }
        catch (IOException iOException) {
            this.printText("ERR closing server socket.");
            return false;
        }
        return false;
    }

    public boolean sendFileLocal(char c, String string, OutputStream outputStream) {
        try {
            this.m_outdataport = outputStream;
            this.writeProcessToFile(string);
            this.m_outdataport = null;
        }
        catch (Exception exception) {
            this.printText("ERR " + exception.toString());
            return false;
        }
        return true;
    }

    public void setPort(ServerSocket serverSocket) {
        if (this.State == 2) {
            String string = new String("PORT " + this.calcPortCmdParameter(serverSocket) + "\r");
            this.printText(string);
            this.controlOutputStream.println(string);
            int n = this.checkResponse();
        }
    }

    public void setType(String string) {
        if (this.State == 2) {
            if (string.equals("ASCII")) {
                this.controlOutputStream.println("TYPE A\r");
                this.printText("TYPE A");
                this.checkResponse();
            } else {
                this.controlOutputStream.println("TYPE I\r");
                this.printText("TYPE I");
                this.checkResponse();
            }
        }
    }

    public void write2Relation(String string, String string2, String string3) {
        this.writeRemoteFile(String.valueOf(string) + "(" + string2 + "," + string3 + ")");
    }

    public void write3Relation(String string, String string2, String string3, int n) {
        this.writeRemoteFile(String.valueOf(string) + "(" + string2 + "," + string3 + "," + new Integer(n).toString() + ")");
    }

    public void writeConditions(CpeProcess cpeProcess) {
        String string = "";
        int n = 0;
        Enumeration enumeration = cpeProcess.preconditions.elements();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            this.cpo_input_c.addElement(String.valueOf(cpeProcess.key) + "inp" + n);
            Enumeration enumeration2 = cpeProcess.m_nodes.elements();
            while (enumeration2.hasMoreElements()) {
                CpeNode cpeNode = (CpeNode)enumeration2.nextElement();
                string = this.replaceKey(string, cpeNode.m_key, cpeNode.tempSaveKey);
            }
            this.writeFunctionStr("constraint.expression", String.valueOf(cpeProcess.key) + "inp" + n, string);
            this.write2Relation("member", String.valueOf(cpeProcess.key) + "inp" + n, String.valueOf(cpeProcess.key) + "as");
            ++n;
        }
    }

    public void writeEffects(CpeProcess cpeProcess) {
        String string = "";
        int n = 0;
        Enumeration enumeration = cpeProcess.effects.elements();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            this.cpo_output_c.addElement(String.valueOf(cpeProcess.key) + "out" + n);
            this.writeFunctionStr("constraint.expression", String.valueOf(cpeProcess.key) + "out" + n, string);
            this.write2Relation("member", String.valueOf(cpeProcess.key) + "out" + n, String.valueOf(cpeProcess.key) + "as");
            ++n;
        }
    }

    public void writeFunction(String string, String string2, String string3) {
        this.writeRemoteFile(String.valueOf(string) + "(" + string2 + ")=" + string3);
    }

    public void writeFunctionStr(String string, String string2, String string3) {
        this.writeRemoteFile(String.valueOf(string) + "(" + string2 + ")=\"" + string3 + "\"");
    }

    private void writeOutProcess(CpeProcess cpeProcess) {
        Object object;
        CpeNode cpeNode = null;
        CpeEdge cpeEdge = null;
        this.writeVariables(cpeProcess);
        int n = 0;
        Enumeration enumeration = cpeProcess.m_nodes.elements();
        while (enumeration.hasMoreElements()) {
            cpeNode = (CpeNode)enumeration.nextElement();
            cpeNode.tempSaveKey = String.valueOf(cpeProcess.key) + "n" + n;
            if (cpeNode.hasExpansion) {
                this.writeFunction("process.expands", cpeNode.expansion, cpeNode.tempSaveKey);
                object = cpeProcess.m_panel.mainPanel.locatePanel((String)cpeNode.expansion).process;
                this.writeProcessEntries((CpeProcess)object);
            }
            this.writeFunction("include-node", String.valueOf(cpeProcess.key) + "c" + n, cpeNode.tempSaveKey);
            this.cpo_include_c.addElement(String.valueOf(cpeProcess.key) + "c" + n);
            this.write2Relation("member", String.valueOf(cpeProcess.key) + "c" + n, String.valueOf(cpeProcess.key) + "as");
            this.writeFunctionStr("node.label", cpeNode.tempSaveKey, cpeNode.m_lbl.replace('\n', '~'));
            this.writeFunction("node.xpos", cpeNode.tempSaveKey, String.valueOf(cpeNode.m_x));
            this.writeFunction("node.ypos", cpeNode.tempSaveKey, String.valueOf(cpeNode.m_y));
            if (n == 0) {
                this.writeFunction("finish.timepoint", cpeNode.tempSaveKey, String.valueOf(cpeNode.tempSaveKey) + "bt");
                this.cpo_timepoint.addElement(String.valueOf(cpeNode.tempSaveKey) + "bt");
                if (cpeProcess.startFinishFlag) {
                    this.cpo_finish.addElement(cpeNode.tempSaveKey);
                } else {
                    this.cpo_end.addElement(cpeNode.tempSaveKey);
                }
            } else if (n == 1) {
                this.writeFunction("start.timepoint", cpeNode.tempSaveKey, String.valueOf(cpeNode.tempSaveKey) + "et");
                this.cpo_timepoint.addElement(String.valueOf(cpeNode.tempSaveKey) + "et");
                if (cpeProcess.startFinishFlag) {
                    this.cpo_start.addElement(cpeNode.tempSaveKey);
                } else {
                    this.cpo_begin.addElement(cpeNode.tempSaveKey);
                }
            } else {
                this.cpo_action.addElement(cpeNode.tempSaveKey);
                this.writeFunctionStr("activity.pattern", String.valueOf(cpeProcess.key) + "n" + n, cpeNode.pattern);
                this.writeFunction("activity.begin-timepoint", cpeNode.tempSaveKey, String.valueOf(cpeNode.tempSaveKey) + "bt");
                this.cpo_timepoint.addElement(String.valueOf(cpeNode.tempSaveKey) + "bt");
                this.writeFunction("activity.end-timepoint", cpeNode.tempSaveKey, String.valueOf(cpeNode.tempSaveKey) + "et");
                this.cpo_timepoint.addElement(String.valueOf(cpeNode.tempSaveKey) + "et");
            }
            ++n;
        }
        object = cpeProcess.m_edges.elements();
        while (object.hasMoreElements()) {
            cpeEdge = (CpeEdge)object.nextElement();
            this.cpo_ordering_c.addElement(String.valueOf(cpeProcess.key) + "c" + n);
            if ("CpeEqEdge".equals(cpeEdge.getClass().getName())) {
                this.writeFunctionStr("constraint.expression", String.valueOf(cpeProcess.key) + "c" + n, "equal(" + cpeEdge.m_from.tempSaveKey + (cpeEdge.fromPosition ? "bt" : "et") + "," + cpeEdge.m_to.tempSaveKey + (cpeEdge.toPosition ? "bt" : "et") + ")");
            } else {
                this.writeFunctionStr("constraint.expression", String.valueOf(cpeProcess.key) + "c" + n, "before(" + cpeEdge.m_from.tempSaveKey + (cpeEdge.fromPosition ? "bt" : "et") + "," + cpeEdge.m_to.tempSaveKey + (cpeEdge.toPosition ? "bt" : "et") + ")");
            }
            this.write2Relation("member", String.valueOf(cpeProcess.key) + "c" + n, String.valueOf(cpeProcess.key) + "as");
            ++n;
        }
        this.writeConditions(cpeProcess);
        this.writeEffects(cpeProcess);
        this.writeResources(cpeProcess);
        n = 0;
        CpeText cpeText = null;
        Enumeration enumeration2 = cpeProcess.m_text.elements();
        while (enumeration2.hasMoreElements()) {
            this.cpo_annot_c.addElement(String.valueOf(cpeProcess.key) + "ann" + n);
            cpeText = (CpeText)enumeration2.nextElement();
            this.write2Relation("member", String.valueOf(cpeProcess.key) + "ann" + n, String.valueOf(cpeProcess.key) + "as");
            this.writeFunction("annotation.xpos", String.valueOf(cpeProcess.key) + "ann" + n, String.valueOf(cpeText.m_x));
            this.writeFunction("annotation.ypos", String.valueOf(cpeProcess.key) + "ann" + n, String.valueOf(cpeText.m_y));
            this.writeFunctionStr("constraint.expression", String.valueOf(cpeProcess.key) + "ann" + n, cpeText.m_lbl.replace('\n', '~'));
            ++n;
        }
    }

    private void writeProcessEntries(CpeProcess cpeProcess) {
        this.writeFunctionStr("process.label", cpeProcess.key, cpeProcess.label);
        if (cpeProcess != null) {
            if (cpeProcess.taskProcess) {
                this.cpo_plan.addElement(cpeProcess.key);
            } else {
                this.cpo_process.addElement(cpeProcess.key);
            }
            this.cpo_activity_spec.addElement(String.valueOf(cpeProcess.key) + "as");
            this.writeFunctionStr("process.expands", cpeProcess.key, cpeProcess.expands);
            this.write2Relation("process.activity-spec", cpeProcess.key, String.valueOf(cpeProcess.key) + "as");
            this.writeFunction("process.is-executable", cpeProcess.key, cpeProcess.execProcess ? "true" : "false");
            this.writeFunction("process.start-timepoint", cpeProcess.key, String.valueOf(cpeProcess.key) + "st");
            this.cpo_timepoint.addElement(String.valueOf(cpeProcess.key) + "st");
            this.writeFunction("process.finish-timepoint", cpeProcess.key, String.valueOf(cpeProcess.key) + "ft");
            this.cpo_timepoint.addElement(String.valueOf(cpeProcess.key) + "ft");
            this.writeOutProcess(cpeProcess);
        }
    }

    private void writeProcessToFile(String string) {
        Cpe.sharedInstance().displayMessage("Writing specification to file " + string + " ...");
        Cpe.sharedInstance().setWait();
        this.cpo_plan = new Vector();
        this.cpo_process = new Vector();
        this.cpo_activity_spec = new Vector();
        this.cpo_action = new Vector();
        this.cpo_start = new Vector();
        this.cpo_finish = new Vector();
        this.cpo_begin = new Vector();
        this.cpo_end = new Vector();
        this.cpo_timepoint = new Vector();
        this.cpo_ordering_c = new Vector();
        this.cpo_input_c = new Vector();
        this.cpo_output_c = new Vector();
        this.cpo_resource_c = new Vector();
        this.cpo_include_c = new Vector();
        this.cpo_annot_c = new Vector();
        this.cpo_unit = new Vector();
        this.cpo_var = new Vector();
        this.writeRemoteFile("//Common Process Editor, version 1.0, DAI, 1998");
        this.writeRemoteFile("//Date: " + new Date());
        this.writeRemoteFile("//File: " + string);
        this.writeRemoteFile("//java.version: " + System.getProperty("java.version"));
        this.writeRemoteFile("//java.vendor: " + System.getProperty("java.vendor"));
        this.writeRemoteFile("//java.class.version: " + System.getProperty("java.class.version"));
        this.writeRemoteFile("//os.name: " + System.getProperty("os.name"));
        this.writeRemoteFile("//os.arch: " + System.getProperty("os.arch"));
        this.writeRemoteFile("//os.version: " + System.getProperty("os.version"));
        this.writeRemoteFile("//------------");
        this.m_frame.process.taskProcess = true;
        this.writeProcessEntries(this.m_frame.process);
        this.writeSortInfo();
        this.writeRemoteFile("//------------");
        this.writeRemoteFile("//End");
        this.cpo_plan = null;
        this.cpo_process = null;
        this.cpo_activity_spec = null;
        this.cpo_action = null;
        this.cpo_start = null;
        this.cpo_finish = null;
        this.cpo_begin = null;
        this.cpo_end = null;
        this.cpo_timepoint = null;
        this.cpo_ordering_c = null;
        this.cpo_input_c = null;
        this.cpo_output_c = null;
        this.cpo_resource_c = null;
        this.cpo_include_c = null;
        this.cpo_annot_c = null;
        this.cpo_unit = null;
        this.cpo_var = null;
        Cpe.sharedInstance().displayMessage("Save completed!");
        Cpe.sharedInstance().setNormal();
    }

    public void writeRemoteFile(String string) {
        byte[] byArray = new byte[1024];
        string = String.valueOf(string) + '\n';
        int n = string.length();
        byArray = string.getBytes();
        try {
            if (this.tfExport) {
                this.tfOutputStream.write(byArray, 0, n);
            } else {
                this.m_outdataport.write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            this.printText("ERR with writeRemoteFile");
        }
    }

    public void writeResources(CpeProcess cpeProcess) {
        String string = "";
        int n = 0;
        Enumeration enumeration = cpeProcess.resources.elements();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            this.cpo_resource_c.addElement(String.valueOf(cpeProcess.key) + "res" + n);
            this.writeFunctionStr("constraint.expression", String.valueOf(cpeProcess.key) + "res" + n, string);
            this.write2Relation("member", String.valueOf(cpeProcess.key) + "res" + n, String.valueOf(cpeProcess.key) + "as");
            ++n;
        }
    }

    private void writeSortInfo() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        Object object9;
        Object object10;
        Object object11;
        Object object12;
        Object object13;
        Object object14;
        Object object15;
        Object object16;
        int n = 0;
        Object object17 = "";
        n = 0;
        object17 = "";
        Enumeration enumeration = this.cpo_plan.elements();
        while (enumeration.hasMoreElements()) {
            object16 = (String)enumeration.nextElement();
            object17 = n == 0 ? object16 : String.valueOf(object17) + "," + (String)object16;
            ++n;
        }
        this.writeRemoteFile("SORT cpo-plan={" + (String)object17 + "}");
        n = 0;
        object17 = "";
        object16 = this.cpo_process.elements();
        while (object16.hasMoreElements()) {
            object15 = (String)object16.nextElement();
            object17 = n == 0 ? object15 : String.valueOf(object17) + "," + (String)object15;
            ++n;
        }
        this.writeRemoteFile("SORT cpo-process={" + (String)object17 + "}");
        n = 0;
        object17 = "";
        object15 = this.cpo_activity_spec.elements();
        while (object15.hasMoreElements()) {
            object14 = (String)object15.nextElement();
            object17 = n == 0 ? object14 : String.valueOf(object17) + "," + (String)object14;
            ++n;
        }
        this.writeRemoteFile("SORT cpo-activity-specification={" + (String)object17 + "}");
        n = 0;
        object17 = "";
        object14 = this.cpo_action.elements();
        while (object14.hasMoreElements()) {
            object13 = (String)object14.nextElement();
            object17 = n == 0 ? object13 : String.valueOf(object17) + "," + (String)object13;
            ++n;
        }
        this.writeRemoteFile("SORT cpo-action={" + (String)object17 + "}");
        n = 0;
        object17 = "";
        object13 = this.cpo_start.elements();
        while (object13.hasMoreElements()) {
            object12 = (String)object13.nextElement();
            object17 = n == 0 ? object12 : String.valueOf(object17) + "," + (String)object12;
            ++n;
        }
        this.writeRemoteFile("SORT cpo-start={" + (String)object17 + "}");
        n = 0;
        object17 = "";
        object12 = this.cpo_finish.elements();
        while (object12.hasMoreElements()) {
            object11 = (String)object12.nextElement();
            object17 = n == 0 ? object11 : String.valueOf(object17) + "," + (String)object11;
            ++n;
        }
        this.writeRemoteFile("SORT cpo-finish={" + (String)object17 + "}");
        n = 0;
        object17 = "";
        object11 = this.cpo_begin.elements();
        while (object11.hasMoreElements()) {
            object10 = (String)object11.nextElement();
            object17 = n == 0 ? object10 : String.valueOf(object17) + "," + (String)object10;
            ++n;
        }
        this.writeRemoteFile("SORT cpo-begin={" + (String)object17 + "}");
        n = 0;
        object17 = "";
        object10 = this.cpo_end.elements();
        while (object10.hasMoreElements()) {
            object9 = (String)object10.nextElement();
            object17 = n == 0 ? object9 : String.valueOf(object17) + "," + (String)object9;
            ++n;
        }
        this.writeRemoteFile("SORT cpo-end={" + (String)object17 + "}");
        n = 0;
        object17 = "";
        object9 = this.cpo_timepoint.elements();
        while (object9.hasMoreElements()) {
            object8 = (String)object9.nextElement();
            object17 = n == 0 ? object8 : String.valueOf(object17) + "," + (String)object8;
            ++n;
        }
        this.writeRemoteFile("SORT cpo-timepoint={" + (String)object17 + "}");
        n = 0;
        object17 = "";
        object8 = this.cpo_ordering_c.elements();
        while (object8.hasMoreElements()) {
            object7 = (String)object8.nextElement();
            object17 = n == 0 ? object7 : String.valueOf(object17) + "," + (String)object7;
            ++n;
        }
        this.writeRemoteFile("SORT cpo-ordering-constraint={" + (String)object17 + "}");
        n = 0;
        object17 = "";
        object7 = this.cpo_input_c.elements();
        while (object7.hasMoreElements()) {
            object6 = (String)object7.nextElement();
            object17 = n == 0 ? object6 : String.valueOf(object17) + "," + (String)object6;
            ++n;
        }
        this.writeRemoteFile("SORT cpo-input-constraint={" + (String)object17 + "}");
        n = 0;
        object17 = "";
        object6 = this.cpo_output_c.elements();
        while (object6.hasMoreElements()) {
            object5 = (String)object6.nextElement();
            object17 = n == 0 ? object5 : String.valueOf(object17) + "," + (String)object5;
            ++n;
        }
        this.writeRemoteFile("SORT cpo-output-constraint={" + (String)object17 + "}");
        n = 0;
        object17 = "";
        object5 = this.cpo_resource_c.elements();
        while (object5.hasMoreElements()) {
            object4 = (String)object5.nextElement();
            object17 = n == 0 ? object4 : String.valueOf(object17) + "," + (String)object4;
            ++n;
        }
        this.writeRemoteFile("SORT cpo-resource-constraint={" + (String)object17 + "}");
        n = 0;
        object17 = "";
        object4 = this.cpo_unit.elements();
        while (object4.hasMoreElements()) {
            object3 = (String)object4.nextElement();
            object17 = n == 0 ? object3 : String.valueOf(object17) + "," + (String)object3;
            ++n;
        }
        this.writeRemoteFile("SORT cpo-resource-unit={" + (String)object17 + "}");
        n = 0;
        object17 = "";
        object3 = this.cpo_var.elements();
        while (object3.hasMoreElements()) {
            object2 = (String)object3.nextElement();
            object17 = n == 0 ? object2 : String.valueOf(object17) + "," + (String)object2;
            ++n;
        }
        this.writeRemoteFile("SORT cpo-entity-variable={" + (String)object17 + "}");
        n = 0;
        object17 = "";
        object2 = this.cpo_include_c.elements();
        while (object2.hasMoreElements()) {
            object = (String)object2.nextElement();
            object17 = n == 0 ? object : String.valueOf(object17) + "," + (String)object;
            ++n;
        }
        this.writeRemoteFile("SORT cpo-include-constraint={" + (String)object17 + "}");
        n = 0;
        object17 = "";
        object = this.cpo_annot_c.elements();
        while (object.hasMoreElements()) {
            String string = (String)object.nextElement();
            object17 = n == 0 ? string : String.valueOf(object17) + "," + string;
            ++n;
        }
        this.writeRemoteFile("SORT cpo-annotation-constraint={" + (String)object17 + "}");
    }

    public void writeVariables(CpeProcess cpeProcess) {
        String string = "";
        int n = 1;
        Enumeration enumeration = cpeProcess.variables.elements();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            this.cpo_var.addElement(String.valueOf(cpeProcess.key) + "var" + n);
            this.writeFunctionStr("var.label", String.valueOf(cpeProcess.key) + "var" + n, string);
            this.write3Relation("process.variable", cpeProcess.key, String.valueOf(cpeProcess.key) + "var" + n, n);
            ++n;
        }
    }
}

