/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;

public class CpeProcessPanel
extends JPanel
implements MouseMotionListener,
MouseListener,
ActionListener {
    public CpeMainPanel mainPanel;
    public JInternalFrame frame;
    public CpeNode m_hitNode = null;
    public CpeTextPropertyDialog textDlg = null;
    public String m_userName = null;
    public String m_password = null;
    public String m_slot = null;
    public CpeProcess process;
    public final int WIDTH = 800;
    public final int HEIGHT = 800;

    CpeProcessPanel(CpeMainPanel cpeMainPanel, boolean bl) {
        super.addMouseMotionListener(this);
        super.addMouseListener(this);
        this.mainPanel = cpeMainPanel;
        this.setOpaque(false);
        this.process = new CpeProcess(this, bl);
        this.process.newProcess();
        if (bl) {
            Cpe.sharedInstance().addProcess(this);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("newact")) {
            this.process.addActivity();
        } else if (string.equals("newref")) {
            this.process.addRef();
        } else if (string.equals("newdummy")) {
            this.process.addDummy();
        } else if (string.equals("delsel")) {
            this.process.removeSelected();
        } else if (string.equals("delnode")) {
            this.process.removeNode(this.m_hitNode);
        } else if (string.equals("addlink")) {
            this.process.addLink(this.m_hitNode, false);
        } else if (string.equals("addeqlink")) {
            this.process.addEqLink(this.m_hitNode, false);
        } else if (string.equals("addexp")) {
            this.process.addExpansion(this.m_hitNode);
        } else if (string.equals("delexp")) {
            this.process.delExpansion(this.m_hitNode);
        } else if (string.equals("showexp")) {
            this.process.showExpansion(this.m_hitNode);
        } else if (string.equals("nration")) {
            this.process.editRationale(this.m_hitNode);
        } else if (string.equals("pration")) {
            this.process.editRationale();
        } else if (string.equals("addtext")) {
            this.addText();
        } else if (string.equals("procprop")) {
            this.process.showProcessPropertyDialog();
        } else if (string.equals("nodeprop")) {
            this.process.showNodePropertyDialog();
        }
    }

    public void addText() {
        if (this.textDlg == null) {
            this.textDlg = new CpeTextPropertyDialog(this, "Add text");
        }
        ((Component)this.textDlg).setLocation(Cpe.sharedInstance().getCenteringPoint(this.textDlg));
        this.textDlg.show();
    }

    public Dimension getPreferredSize() {
        return new Dimension(800, 800);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        mouseEvent.getClickCount();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.process.mouseDrag(mouseEvent);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.process.mouseMove(mouseEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.process.mouseDown(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.process.mouseUp(mouseEvent);
    }

    public synchronized void paintComponent(Graphics graphics) {
        this.process.update(graphics);
    }

    public void toolbarActionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("newactivity")) {
            this.process.popupPoint = new Point(20, 20);
            this.process.addActivity();
        } else if (string.equals("newdummy")) {
            this.process.popupPoint = new Point(20, 20);
            this.process.addDummy();
        } else if (string.equals("newref")) {
            this.process.popupPoint = new Point(20, 20);
            this.process.addRef();
        } else if (string.equals("newtext")) {
            this.process.popupPoint = new Point(20, 20);
            this.addText();
        } else if (string.equals("newbefore")) {
            this.process.requestLink();
        } else if (string.equals("cut")) {
            this.process.removeSelected();
        } else if (string.equals("copy")) {
            this.process.copySelected();
        } else if (string.equals("paste")) {
            this.process.pasteSelected();
        } else if (string.equals("aligntop")) {
            this.process.alignTop();
        } else if (string.equals("alignbottom")) {
            this.process.alignBottom();
        } else if (string.equals("alignleft")) {
            this.process.alignLeft();
        } else if (string.equals("alignright")) {
            this.process.alignRight();
        } else if (string.equals("aligncenter")) {
            this.process.alignCenter();
        } else if (string.equals("expand")) {
            this.process.requestExpansion();
        } else if (string.equals("up")) {
            this.process.requestUp();
        } else if (string.equals("newequal")) {
            this.process.requestNewEqual();
        } else if (string.equals("properties")) {
            this.process.requestProperties();
        }
        this.repaint();
    }
}

