/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;

class CpeProcess {
    Vector m_nodes;
    Vector m_edges;
    Vector m_text;
    Vector preconditions;
    Vector effects;
    Vector requirements;
    Vector preferences;
    Vector variables;
    Vector resources;
    Vector others;
    Vector issues;
    String key = "";
    String label = "";
    String expands = "";
    boolean topLevelFlag = false;
    boolean startFinishFlag = true;
    boolean taskProcess = false;
    boolean execProcess = false;
    CpeProcessPanel m_panel = null;
    CpeNodePropertyDialog m_sheet = null;
    CpeProcPropertyDialog processSheet = null;
    JPopupMenu popup = null;
    static final String FINISH_STRING = "Finish";
    static final String START_STRING = "Start";
    static final String BEGIN_STRING = "Begin";
    static final String END_STRING = "End";
    final Color m_edgeColor = Color.black;
    final Color m_linkColor = Color.red;
    Dimension m_dimension;
    Rectangle m_selectingRect;
    long m_nodeCounter = 1L;
    boolean hasRationale = false;
    boolean m_linkDrawing = false;
    boolean m_linkEq = false;
    boolean m_linkBegin = false;
    CpeNode m_hitNode = null;
    int m_hitx = 0;
    int m_hity = 0;
    boolean m_selecting = false;
    int m_linkToX = 0;
    int m_linkToY = 0;
    Point popupPoint = new Point();
    String rationale = "";

    CpeProcess(CpeProcessPanel cpeProcessPanel, boolean bl) {
        this.m_panel = cpeProcessPanel;
        this.m_nodes = new Vector();
        this.m_edges = new Vector();
        this.m_text = new Vector();
        this.preconditions = new Vector();
        this.effects = new Vector();
        this.requirements = new Vector();
        this.preferences = new Vector();
        this.variables = new Vector();
        this.resources = new Vector();
        this.others = new Vector();
        this.issues = new Vector();
        this.topLevelFlag = bl;
    }

    public void addActivity() {
        String string = new String("act");
        string = string.concat(Long.toString(this.m_nodeCounter++));
        String string2 = null;
        String string3 = null;
        if (this.startFinishFlag) {
            string2 = START_STRING;
            string3 = FINISH_STRING;
        } else {
            string2 = BEGIN_STRING;
            string3 = END_STRING;
        }
        if (this.m_nodes.size() < 3 && this.locateNode(string2) != null && this.locateNode(string3) != null) {
            this.removeEdge(string2, false, string3, true);
            Point point = new Point();
            point = this.getMiddlePoint(this.locateNode(string2), this.locateNode(string3));
            this.addNode(new CpeNode(string, point.x, point.y));
            this.addEdge(string2, false, string, true);
            this.addEdge(string, false, string3, true);
        } else {
            this.addNode(new CpeNode(string, this.popupPoint.x, this.popupPoint.y));
        }
    }

    public void addDummy() {
        String string = new String("Dummy");
        string = string.concat(Long.toString(this.m_nodeCounter));
        this.addNode(new CpeSpecialNode(string, this.popupPoint.x, this.popupPoint.y));
        ++this.m_nodeCounter;
    }

    void addEdge(CpeEdge cpeEdge) {
        this.addEdge(cpeEdge.m_from.m_key, cpeEdge.fromPosition, cpeEdge.m_to.m_key, cpeEdge.toPosition);
    }

    void addEdge(CpeEqEdge cpeEqEdge) {
        this.addEqEdge(cpeEqEdge.m_from.m_key, cpeEqEdge.fromPosition, cpeEqEdge.m_to.m_key, cpeEqEdge.toPosition);
    }

    void addEdge(String string, boolean bl, String string2, boolean bl2) {
        CpeNode cpeNode = this.locateNode(string);
        CpeNode cpeNode2 = this.locateNode(string2);
        this.m_edges.addElement(new CpeEdge(cpeNode, bl, cpeNode2, bl2));
    }

    void addEqEdge(String string, boolean bl, String string2, boolean bl2) {
        CpeNode cpeNode = this.locateNode(string);
        CpeNode cpeNode2 = this.locateNode(string2);
        this.m_edges.addElement(new CpeEqEdge(cpeNode, bl, cpeNode2, bl2));
    }

    public void addEqLink(CpeNode cpeNode, boolean bl) {
        this.m_linkDrawing = true;
        this.m_linkBegin = cpeNode.m_key.equals(START_STRING) ? false : (cpeNode.m_key.equals(FINISH_STRING) ? true : (bl ? false : cpeNode.isBegin(this.popupPoint)));
        this.m_linkEq = true;
        this.m_linkToX = cpeNode.m_x;
        this.m_linkToY = cpeNode.m_y;
    }

    public void addExpansion(CpeNode cpeNode) {
        if (cpeNode.hasExpansion) {
            JOptionPane.showMessageDialog(Cpe.sharedInstance().getFrame(), "You must first remove the existing expansion.", "CPE Message", 2);
        } else {
            cpeNode.hasExpansion = true;
            cpeNode.expansion = this.m_panel.mainPanel.createExpansion(this.m_panel.process.key);
            this.m_panel.repaint();
        }
    }

    public void addLink(CpeNode cpeNode, boolean bl) {
        this.m_linkDrawing = true;
        this.m_linkBegin = cpeNode.m_key.equals(START_STRING) ? false : (cpeNode.m_key.equals(FINISH_STRING) ? true : (bl ? false : cpeNode.isBegin(this.popupPoint)));
        this.m_linkEq = false;
        this.m_linkToX = cpeNode.m_x;
        this.m_linkToY = cpeNode.m_y;
    }

    void addNewNode(CpeNode cpeNode) {
        CpeNode cpeNode2 = new CpeNode(cpeNode.m_key, cpeNode.m_x, cpeNode.m_y);
        cpeNode2.setStatus(cpeNode.m_status);
        cpeNode2.m_lbl = cpeNode.m_lbl;
        cpeNode2.expansion = cpeNode.expansion;
        cpeNode2.hasExpansion = cpeNode.hasExpansion;
        this.addNode(cpeNode2);
    }

    void addNewNode(CpeSpecialNode cpeSpecialNode) {
        CpeSpecialNode cpeSpecialNode2 = new CpeSpecialNode(cpeSpecialNode.m_key, cpeSpecialNode.m_x, cpeSpecialNode.m_y);
        cpeSpecialNode2.setStatus(cpeSpecialNode.m_status);
        cpeSpecialNode2.m_lbl = cpeSpecialNode.m_lbl;
        this.addNode(cpeSpecialNode2);
    }

    void addNode(CpeNode cpeNode) {
        this.m_nodes.addElement(cpeNode);
    }

    public void addRef() {
        String string = new String("Process: \nAction:");
        string = string.concat(Long.toString(this.m_nodeCounter));
        this.addNode(new CpeNodeRef(string, this.popupPoint.x, this.popupPoint.y));
        ++this.m_nodeCounter;
    }

    public void addText(String string) {
        this.m_text.addElement(new CpeText(string, this.popupPoint.x, this.popupPoint.y));
    }

    public void alignBottom() {
        CpeNode cpeNode;
        Vector<CpeNode> vector = new Vector<CpeNode>();
        int n = 0;
        Enumeration enumeration = this.m_nodes.elements();
        while (enumeration.hasMoreElements()) {
            cpeNode = (CpeNode)enumeration.nextElement();
            if (!cpeNode.m_selected) continue;
            vector.addElement(cpeNode);
            if (cpeNode.m_y <= n) continue;
            n = cpeNode.m_y;
        }
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            cpeNode = (CpeNode)enumeration2.nextElement();
            cpeNode.m_y = n;
        }
        vector = null;
    }

    public void alignCenter() {
        CpeNode cpeNode;
        Vector<CpeNode> vector = new Vector<CpeNode>();
        int n = 0;
        int n2 = 0;
        Enumeration enumeration = this.m_nodes.elements();
        while (enumeration.hasMoreElements()) {
            cpeNode = (CpeNode)enumeration.nextElement();
            if (!cpeNode.m_selected) continue;
            vector.addElement(cpeNode);
            n += cpeNode.m_x;
            ++n2;
        }
        if (n2 != 0) {
            n /= n2;
        }
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            cpeNode = (CpeNode)enumeration2.nextElement();
            cpeNode.m_x = n;
        }
    }

    public void alignLeft() {
        CpeNode cpeNode;
        Vector<CpeNode> vector = new Vector<CpeNode>();
        int n = Integer.MAX_VALUE;
        Enumeration enumeration = this.m_nodes.elements();
        while (enumeration.hasMoreElements()) {
            cpeNode = (CpeNode)enumeration.nextElement();
            if (!cpeNode.m_selected) continue;
            vector.addElement(cpeNode);
            if (cpeNode.m_rect.x >= n) continue;
            n = cpeNode.m_rect.x;
        }
        FontMetrics fontMetrics = ((Component)this.m_panel).getFontMetrics(this.m_panel.getFont());
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            cpeNode = (CpeNode)enumeration2.nextElement();
            cpeNode.setLeftPosition(n, fontMetrics);
        }
        vector = null;
    }

    public void alignRight() {
        CpeNode cpeNode;
        Vector<CpeNode> vector = new Vector<CpeNode>();
        int n = 0;
        Enumeration enumeration = this.m_nodes.elements();
        while (enumeration.hasMoreElements()) {
            cpeNode = (CpeNode)enumeration.nextElement();
            if (!cpeNode.m_selected) continue;
            vector.addElement(cpeNode);
            if (cpeNode.m_rect.x + cpeNode.m_rect.width <= n) continue;
            n = cpeNode.m_rect.x + cpeNode.m_rect.width;
        }
        FontMetrics fontMetrics = ((Component)this.m_panel).getFontMetrics(this.m_panel.getFont());
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            cpeNode = (CpeNode)enumeration2.nextElement();
            cpeNode.setRightPosition(n, fontMetrics);
        }
        vector = null;
    }

    public void alignTop() {
        CpeNode cpeNode;
        Vector<CpeNode> vector = new Vector<CpeNode>();
        int n = Integer.MAX_VALUE;
        Enumeration enumeration = this.m_nodes.elements();
        while (enumeration.hasMoreElements()) {
            cpeNode = (CpeNode)enumeration.nextElement();
            if (!cpeNode.m_selected) continue;
            vector.addElement(cpeNode);
            if (cpeNode.m_y >= n) continue;
            n = cpeNode.m_y;
        }
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            cpeNode = (CpeNode)enumeration2.nextElement();
            cpeNode.m_y = n;
        }
        vector = null;
    }

    Vector calculateInDegree(Vector vector) {
        Enumeration enumeration = this.m_edges.elements();
        while (enumeration.hasMoreElements()) {
            CpeEdge cpeEdge = (CpeEdge)enumeration.nextElement();
            if ("CpeEqEdge".equals(cpeEdge.getClass().getName())) continue;
            if (cpeEdge.toPosition) {
                ++((Vertex)vector.elementAt((int)cpeEdge.m_to.beginNumber)).inDegree;
                continue;
            }
            ++((Vertex)vector.elementAt((int)cpeEdge.m_to.endNumber)).inDegree;
        }
        return vector;
    }

    public void changeNodeKey(String string, String string2) {
        CpeNode cpeNode = null;
        Enumeration enumeration = this.m_nodes.elements();
        while (enumeration.hasMoreElements()) {
            CpeNode cpeNode2 = (CpeNode)enumeration.nextElement();
            if (!cpeNode2.m_lbl.toUpperCase().equals(string.toUpperCase())) continue;
            cpeNode = cpeNode2;
            cpeNode.m_key = string2;
            break;
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean checkEdgeHit(CpeEdge var1_1, Rectangle var2_2) {
        block13: {
            var3_3 = var1_1.fromX();
            var4_4 = var1_1.fromY();
            var5_5 = var1_1.toX();
            var6_6 = var1_1.toY();
            if (var2_2.inside(var3_3, var4_4) || var2_2.inside(var5_5, var6_6)) {
                return true;
            }
            if (var3_3 - var5_5 == 0) {
                return this.checkEdgeHity(var4_4, var6_6, var3_3, var2_2);
            }
            var7_7 = (double)(var4_4 - var6_6) / (double)(var3_3 - var5_5);
            if (var7_7 == 0.0) {
                return this.checkEdgeHitx(var3_3, var5_5, var4_4, var2_2);
            }
            var17_8 = -1.0 * (var7_7 * (double)var3_3 - (double)var4_4);
            if (var7_7 > 0.0) {
                if (var4_4 < var6_6) {
                    var13_9 = var4_4;
                    var15_10 = var6_6;
                } else {
                    var13_9 = var6_6;
                    var15_10 = var4_4;
                }
            } else if (var4_4 > var6_6) {
                var13_9 = var4_4;
                var15_10 = var6_6;
            } else {
                var13_9 = var6_6;
                var15_10 = var4_4;
            }
            var9_11 = var13_9;
            var19_12 = false;
            if (!(var9_11 > var15_10)) ** GOTO lbl43
            while (var9_11 >= var15_10) {
                var11_13 = (var9_11 - var17_8) / var7_7;
                if (var2_2.inside((int)var11_13, (int)var9_11)) {
                    var19_12 = true;
                    break block13;
                }
                var9_11 += var7_7;
            }
            break block13;
lbl-1000:
            // 1 sources

            {
                var11_14 = (var9_11 - var17_8) / var7_7;
                if (var2_2.inside((int)var11_14, (int)var9_11)) {
                    var19_12 = true;
                    break;
                }
                var9_11 += var7_7;
lbl43:
                // 2 sources

                ** while (var9_11 <= var15_10)
            }
        }
        return var19_12;
    }

    private boolean checkEdgeHitx(int n, int n2, int n3, Rectangle rectangle) {
        int n4;
        int n5;
        boolean bl = false;
        if (n < n2) {
            n5 = n;
            n4 = n2;
        } else {
            n5 = n2;
            n4 = n;
        }
        int n6 = n5;
        while (n6 <= n4) {
            if (rectangle.inside(n6, n3)) {
                bl = true;
                break;
            }
            ++n6;
        }
        return bl;
    }

    private boolean checkEdgeHity(int n, int n2, int n3, Rectangle rectangle) {
        int n4;
        int n5;
        boolean bl = false;
        if (n < n2) {
            n5 = n;
            n4 = n2;
        } else {
            n5 = n2;
            n4 = n;
        }
        int n6 = n5;
        while (n6 <= n4) {
            if (rectangle.inside(n3, n6)) {
                bl = true;
                break;
            }
            ++n6;
        }
        return bl;
    }

    public void clear() {
        this.m_edges.removeAllElements();
        this.m_nodes.removeAllElements();
        this.m_text.removeAllElements();
        this.preconditions.removeAllElements();
        this.effects.removeAllElements();
        this.requirements.removeAllElements();
        this.preferences.removeAllElements();
        this.variables.removeAllElements();
        this.resources.removeAllElements();
        this.others.removeAllElements();
        this.issues.removeAllElements();
    }

    private Vector collapsePoints() {
        CpeNode cpeNode;
        Vector<Vertex> vector = new Vector<Vertex>();
        int n = 0;
        Enumeration enumeration = this.m_nodes.elements();
        while (enumeration.hasMoreElements()) {
            cpeNode = (CpeNode)enumeration.nextElement();
            cpeNode.visitedBegin = false;
            cpeNode.visitedEnd = false;
            cpeNode.beginNumber = 0;
            cpeNode.endNumber = 0;
        }
        Enumeration enumeration2 = this.m_nodes.elements();
        while (enumeration2.hasMoreElements()) {
            CpeEdge cpeEdge;
            Enumeration enumeration3;
            Vertex vertex;
            cpeNode = (CpeNode)enumeration2.nextElement();
            if (!cpeNode.visitedBegin) {
                cpeNode.visitedBegin = true;
                cpeNode.beginNumber = n++;
                vertex = new Vertex(String.valueOf(cpeNode.m_lbl) + ".beg");
                enumeration3 = this.m_edges.elements();
                while (enumeration3.hasMoreElements()) {
                    cpeEdge = (CpeEdge)enumeration3.nextElement();
                    if (!"CpeEqEdge".equals(cpeEdge.getClass().getName())) continue;
                    if (cpeEdge.m_to.m_key == cpeNode.m_key && cpeEdge.toPosition) {
                        if (cpeEdge.fromPosition) {
                            cpeEdge.m_from.visitedBegin = true;
                            cpeEdge.m_from.beginNumber = n - 1;
                            vertex.name = String.valueOf(vertex.name) + "/" + cpeEdge.m_from.m_key + ".beg";
                        } else {
                            cpeEdge.m_from.visitedEnd = true;
                            cpeEdge.m_from.endNumber = n - 1;
                            vertex.name = String.valueOf(vertex.name) + "/" + cpeEdge.m_from.m_key + ".end";
                        }
                    }
                    if (cpeEdge.m_from.m_key != cpeNode.m_key || !cpeEdge.fromPosition) continue;
                    if (cpeEdge.toPosition) {
                        cpeEdge.m_to.visitedBegin = true;
                        cpeEdge.m_to.beginNumber = n - 1;
                        vertex.name = String.valueOf(vertex.name) + "/" + cpeEdge.m_to.m_key + ".beg";
                        continue;
                    }
                    cpeEdge.m_to.visitedEnd = true;
                    cpeEdge.m_to.endNumber = n - 1;
                    vertex.name = String.valueOf(vertex.name) + "/" + cpeEdge.m_to.m_key + ".end";
                }
                vector.addElement(vertex);
            }
            if (cpeNode.visitedEnd) continue;
            cpeNode.visitedEnd = true;
            cpeNode.endNumber = n++;
            vertex = new Vertex(String.valueOf(cpeNode.m_lbl) + ".end");
            enumeration3 = this.m_edges.elements();
            while (enumeration3.hasMoreElements()) {
                cpeEdge = (CpeEdge)enumeration3.nextElement();
                if (!"CpeEqEdge".equals(cpeEdge.getClass().getName())) continue;
                if (cpeEdge.m_to.m_key == cpeNode.m_key && !cpeEdge.toPosition) {
                    if (cpeEdge.fromPosition) {
                        cpeEdge.m_from.visitedBegin = true;
                        cpeEdge.m_from.beginNumber = n - 1;
                        vertex.name = String.valueOf(vertex.name) + "/" + cpeEdge.m_from.m_key + ".beg";
                    } else {
                        cpeEdge.m_from.visitedEnd = true;
                        cpeEdge.m_from.endNumber = n - 1;
                        vertex.name = String.valueOf(vertex.name) + "/" + cpeEdge.m_from.m_key + ".end";
                    }
                }
                if (cpeEdge.m_from.m_key != cpeNode.m_key || cpeEdge.fromPosition) continue;
                if (cpeEdge.toPosition) {
                    cpeEdge.m_to.visitedBegin = true;
                    cpeEdge.m_to.beginNumber = n - 1;
                    vertex.name = String.valueOf(vertex.name) + "/" + cpeEdge.m_to.m_key + ".beg";
                    continue;
                }
                cpeEdge.m_to.visitedEnd = true;
                cpeEdge.m_to.endNumber = n - 1;
                vertex.name = String.valueOf(vertex.name) + "/" + cpeEdge.m_to.m_key + ".end";
            }
            ++vertex.inDegree;
            vector.addElement(vertex);
        }
        return vector;
    }

    public void consumes(String string, String string2, String string3) {
        String string4 = "";
        string2 = string2.replace(')', ' ').replace('(', ' ').replace('\"', ' ').trim();
        Enumeration enumeration = this.preconditions.elements();
        while (enumeration.hasMoreElements()) {
            string4 = (String)enumeration.nextElement();
            if (string4.indexOf(string2) == -1 || string4.indexOf(string3) == -1) continue;
            this.preconditions.setElementAt(String.valueOf(string4) + " [" + string + "]", this.preconditions.indexOf(string4));
        }
    }

    public void copySelected() {
        Cpe cpe = Cpe.sharedInstance();
        cpe.clearCopySpace();
        Enumeration enumeration = this.m_nodes.elements();
        while (enumeration.hasMoreElements()) {
            CpeNode cpeNode = (CpeNode)enumeration.nextElement();
            if (!cpeNode.m_selected) continue;
            cpe.cpNodes.addElement(cpeNode);
        }
        Vector vector = new Vector();
        Enumeration enumeration2 = this.m_edges.elements();
        while (enumeration2.hasMoreElements()) {
            CpeEdge cpeEdge = (CpeEdge)enumeration2.nextElement();
            if (!cpeEdge.m_selected) continue;
            cpe.cpEdges.addElement(cpeEdge);
        }
        Vector vector2 = new Vector();
        Enumeration enumeration3 = this.m_text.elements();
        while (enumeration3.hasMoreElements()) {
            CpeText cpeText = (CpeText)enumeration3.nextElement();
            if (!cpeText.m_selected) continue;
            cpe.cpText.addElement(cpeText);
        }
    }

    private void createPopup() {
        int n;
        int n2;
        String[] stringArray = new String[]{"Add Before Link", "Add Equals Link", "Add Expansion", "-", "Show Expansion", "Edit Rationale", "-", "Delete Expansion", "Delete Node", "-", "Properties", "Add Activity", "Add Dummy", "Add Text", "-", "Delete Selection", "Edit Rationale", "-", "Properties"};
        String[] stringArray2 = new String[]{"addlink", "addeqlink", "addexp", "-", "showexp", "nration", "-", "delexp", "delnode", "-", "nodeprop", "newact", "newdummy", "addtext", "-", "delsel", "pration", "-", "procprop"};
        this.popup = new JPopupMenu();
        if (this.m_hitNode != null) {
            n2 = 0;
            n = 10;
            this.m_panel.m_hitNode = this.m_hitNode;
        } else {
            n2 = 11;
            n = stringArray.length - 1;
        }
        int n3 = n2;
        while (n3 <= n) {
            if (stringArray[n3].equals("-")) {
                this.popup.addSeparator();
            } else {
                JMenuItem jMenuItem = new JMenuItem(stringArray[n3]);
                jMenuItem.setActionCommand(stringArray2[n3]);
                jMenuItem.addActionListener(this.m_panel);
                this.popup.add(jMenuItem);
            }
            ++n3;
        }
        this.m_panel.add(this.popup);
    }

    public void delExpansion(CpeNode cpeNode) {
        JOptionPane.showMessageDialog(Cpe.sharedInstance().getFrame(), "Deleting an expansion is not supported yet", "CPE Message", 2);
    }

    void deselectAll() {
        Enumeration enumeration = this.m_nodes.elements();
        while (enumeration.hasMoreElements()) {
            ((CpeNode)enumeration.nextElement()).m_selected = false;
        }
        Enumeration enumeration2 = this.m_edges.elements();
        while (enumeration2.hasMoreElements()) {
            ((CpeEdge)enumeration2.nextElement()).m_selected = false;
        }
        Enumeration enumeration3 = this.m_text.elements();
        while (enumeration3.hasMoreElements()) {
            ((CpeText)enumeration3.nextElement()).m_selected = false;
        }
    }

    public void editRationale() {
        if (!this.m_panel.process.hasRationale) {
            this.m_panel.process.hasRationale = true;
            this.m_panel.process.rationale = this.m_panel.mainPanel.createRationale(this.m_panel.process.key);
            this.m_panel.repaint();
        }
    }

    public void editRationale(CpeNode cpeNode) {
        if (!cpeNode.hasRationale) {
            cpeNode.hasRationale = true;
            cpeNode.rationale = this.m_panel.mainPanel.createRationale(this.m_panel.process.key, cpeNode.m_key);
            this.m_panel.repaint();
        }
    }

    Rectangle getDrawableRect(Rectangle rectangle, Dimension dimension) {
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        if (n3 < 0 && (n = n - (n3 = -n3) + 1) < 0) {
            n3 += n;
            n = 0;
        }
        if (n4 < 0 && (n2 = n2 - (n4 = -n4) + 1) < 0) {
            n4 += n2;
            n2 = 0;
        }
        if (n + n3 > dimension.width) {
            n3 = dimension.width - n;
        }
        if (n2 + n4 > dimension.height) {
            n4 = dimension.height - n2;
        }
        return new Rectangle(n, n2, n3, n4);
    }

    String getLinear() {
        Vector vector = this.collapsePoints();
        vector = this.calculateInDegree(vector);
        String string = "";
        int[] nArray = new int[vector.size()];
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Vertex vertex = (Vertex)enumeration.nextElement();
            nArray[n] = vertex.inDegree;
            ++n;
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            int n3 = 0;
            while (n3 < vector.size() && nArray[n3] != 0) {
                ++n3;
            }
            if (n3 == vector.size()) {
                return "No Solution!";
            }
            int n4 = n3;
            nArray[n4] = nArray[n4] - 1;
            string = n2 == 0 ? ((Vertex)vector.elementAt((int)n3)).name : String.valueOf(string) + "\n-> " + ((Vertex)vector.elementAt((int)n3)).name;
            Enumeration enumeration2 = this.m_edges.elements();
            while (enumeration2.hasMoreElements()) {
                CpeEdge cpeEdge = (CpeEdge)enumeration2.nextElement();
                boolean bl = false;
                if (!"CpeEqEdge".equals(cpeEdge.getClass().getName())) {
                    if (cpeEdge.fromPosition) {
                        if (cpeEdge.m_from.beginNumber == n3) {
                            bl = true;
                        }
                    } else if (cpeEdge.m_from.endNumber == n3) {
                        bl = true;
                    }
                }
                if (!bl) continue;
                if (cpeEdge.toPosition) {
                    int n5 = cpeEdge.m_to.beginNumber;
                    nArray[n5] = nArray[n5] - 1;
                    continue;
                }
                int n6 = cpeEdge.m_to.endNumber;
                nArray[n6] = nArray[n6] - 1;
            }
            Enumeration enumeration3 = this.m_nodes.elements();
            while (enumeration3.hasMoreElements()) {
                CpeNode cpeNode = (CpeNode)enumeration3.nextElement();
                if (n3 != cpeNode.beginNumber) continue;
                int n7 = cpeNode.endNumber;
                nArray[n7] = nArray[n7] - 1;
            }
            ++n2;
        }
        return string;
    }

    private Point getMiddlePoint(CpeNode cpeNode, CpeNode cpeNode2) {
        Point point = new Point();
        point.x = cpeNode.m_x >= cpeNode2.m_x ? cpeNode2.m_x + (cpeNode.m_x - cpeNode2.m_x) / 2 : cpeNode.m_x + (cpeNode2.m_x - cpeNode.m_x) / 2;
        point.y = cpeNode.m_y >= cpeNode2.m_y ? cpeNode2.m_y + (cpeNode.m_y - cpeNode2.m_y) / 2 : cpeNode.m_y + (cpeNode2.m_y - cpeNode.m_y) / 2;
        return point;
    }

    public CpeNode getSingleSelectedNode() {
        CpeNode cpeNode = null;
        CpeNode cpeNode2 = null;
        int n = 0;
        Enumeration enumeration = this.m_nodes.elements();
        while (enumeration.hasMoreElements()) {
            cpeNode = (CpeNode)enumeration.nextElement();
            if (cpeNode.m_selected) {
                cpeNode2 = cpeNode;
                ++n;
            }
            if (n <= 1) continue;
            JOptionPane.showMessageDialog(Cpe.sharedInstance().getFrame(), "You must select only one node.", "CPE Message", 2);
            break;
        }
        if (n == 0) {
            JOptionPane.showMessageDialog(Cpe.sharedInstance().getFrame(), "You must first select a node.", "CPE Message", 2);
            cpeNode2 = null;
            return cpeNode2;
        }
        if (n == 1) {
            return cpeNode2;
        }
        cpeNode2 = null;
        return cpeNode2;
    }

    void linkDrawDown(int n, int n2) {
        int n3 = this.m_nodes.size();
        while (n3 > 0) {
            CpeNode cpeNode = (CpeNode)this.m_nodes.elementAt(n3 - 1);
            if (cpeNode.m_rect.inside(n, n2)) {
                boolean bl = cpeNode.isBegin(new Point(n, n2));
                if (this.locateEdge(this.m_panel.m_hitNode.m_key, this.m_linkBegin, cpeNode.m_key, bl) != null) break;
                if (this.m_linkEq) {
                    this.addEqEdge(this.m_panel.m_hitNode.m_key, this.m_linkBegin, cpeNode.m_key, bl);
                    break;
                }
                this.addEdge(this.m_panel.m_hitNode.m_key, this.m_linkBegin, cpeNode.m_key, bl);
                break;
            }
            --n3;
        }
    }

    public CpeEdge locateEdge(CpeEdge cpeEdge) {
        return this.locateEdge(cpeEdge.m_from.m_key, cpeEdge.fromPosition, cpeEdge.m_to.m_key, cpeEdge.toPosition);
    }

    public CpeEdge locateEdge(String string, boolean bl, String string2, boolean bl2) {
        CpeEdge cpeEdge = null;
        Enumeration enumeration = this.m_edges.elements();
        while (enumeration.hasMoreElements()) {
            CpeEdge cpeEdge2 = (CpeEdge)enumeration.nextElement();
            if (!cpeEdge2.m_from.m_key.equals(string) || cpeEdge2.fromPosition != bl || !cpeEdge2.m_to.m_key.equals(string2) || cpeEdge2.toPosition != bl2) continue;
            cpeEdge = cpeEdge2;
            break;
        }
        return cpeEdge;
    }

    CpeNode locateNode(String string) {
        CpeNode cpeNode = null;
        Enumeration enumeration = this.m_nodes.elements();
        while (enumeration.hasMoreElements()) {
            CpeNode cpeNode2 = (CpeNode)enumeration.nextElement();
            if (!cpeNode2.m_key.equals(string)) continue;
            cpeNode = cpeNode2;
            break;
        }
        return cpeNode;
    }

    CpeNode locateNodeByLabel(String string) {
        CpeNode cpeNode = null;
        Enumeration enumeration = this.m_nodes.elements();
        while (enumeration.hasMoreElements()) {
            CpeNode cpeNode2 = (CpeNode)enumeration.nextElement();
            if (!cpeNode2.m_lbl.equals(string)) continue;
            cpeNode = cpeNode2;
            break;
        }
        return cpeNode;
    }

    public boolean mouseDown(MouseEvent mouseEvent) {
        CpeNode cpeNode;
        this.m_hitNode = null;
        boolean bl = false;
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (this.m_linkDrawing) {
            this.m_linkDrawing = false;
            this.linkDrawDown(n, n2);
        }
        int n3 = this.m_text.size();
        while (n3 > 0) {
            cpeNode = (CpeText)this.m_text.elementAt(n3 - 1);
            if (cpeNode.m_rect.inside(n, n2)) {
                this.m_hitNode = cpeNode;
                bl = true;
                this.m_hitx = n;
                this.m_hity = n2;
                break;
            }
            --n3;
        }
        if (!bl) {
            int n4 = this.m_nodes.size();
            while (n4 > 0) {
                cpeNode = (CpeNode)this.m_nodes.elementAt(n4 - 1);
                if (cpeNode.m_rect.inside(n, n2)) {
                    this.m_hitNode = cpeNode;
                    this.m_hitx = n;
                    this.m_hity = n2;
                    break;
                }
                --n4;
            }
        }
        if (mouseEvent.isMetaDown() && !bl) {
            this.createPopup();
            this.popup.show(this.m_panel, n, n2);
            this.popupPoint.x = n;
            this.popupPoint.y = n2;
            return true;
        }
        if (this.m_hitNode != null) {
            this.m_hitNode.m_selected = true;
        } else {
            this.deselectAll();
            this.m_selecting = true;
            this.m_selectingRect = new Rectangle(n, n2, 0, 0);
        }
        this.m_panel.repaint();
        return true;
    }

    public boolean mouseDrag(MouseEvent mouseEvent) {
        int n;
        int n2 = mouseEvent.getX();
        if (this.m_panel.inside(n2, n = mouseEvent.getY())) {
            if (this.m_selecting) {
                this.m_selectingRect.resize(n2 - this.m_selectingRect.x, n - this.m_selectingRect.y);
            } else if (this.m_hitNode != null && !mouseEvent.isMetaDown()) {
                CpeNode cpeNode = null;
                Enumeration enumeration = this.m_nodes.elements();
                while (enumeration.hasMoreElements()) {
                    cpeNode = (CpeNode)enumeration.nextElement();
                    if (!cpeNode.m_selected) continue;
                    cpeNode.m_x += n2 - this.m_hitx;
                    cpeNode.m_y += n - this.m_hity;
                }
                Enumeration enumeration2 = this.m_text.elements();
                while (enumeration2.hasMoreElements()) {
                    cpeNode = (CpeNode)enumeration2.nextElement();
                    if (!cpeNode.m_selected) continue;
                    cpeNode.m_x += n2 - this.m_hitx;
                    cpeNode.m_y += n - this.m_hity;
                }
                this.m_hitx = n2;
                this.m_hity = n;
            }
        }
        this.m_panel.repaint();
        return true;
    }

    public boolean mouseMove(MouseEvent mouseEvent) {
        if (this.m_selecting) {
            this.m_selecting = false;
            this.m_panel.repaint();
        }
        if (this.m_linkDrawing) {
            this.m_linkToX = mouseEvent.getX();
            this.m_linkToY = mouseEvent.getY();
            this.m_panel.repaint();
        }
        return true;
    }

    public boolean mouseUp(MouseEvent mouseEvent) {
        int n;
        int n2 = mouseEvent.getX();
        if (this.m_panel.inside(n2, n = mouseEvent.getY()) && this.m_selecting) {
            this.m_selecting = false;
            this.selectingUp(n2, n);
        }
        this.m_hitNode = null;
        this.m_panel.repaint();
        return true;
    }

    public void newProcess() {
        this.m_dimension = this.m_panel.size();
        this.clear();
        if (this.startFinishFlag) {
            this.addNode(new CpeSpecialNode(FINISH_STRING, 200, 50));
            this.addNode(new CpeSpecialNode(START_STRING, 20, 50));
            this.addEdge(START_STRING, false, FINISH_STRING, true);
        } else {
            this.addNode(new CpeSpecialNode(END_STRING, 200, 50));
            this.addNode(new CpeSpecialNode(BEGIN_STRING, 20, 50));
            this.addEdge(BEGIN_STRING, false, END_STRING, true);
        }
    }

    public void pasteSelected() {
        Cpe cpe = Cpe.sharedInstance();
        Enumeration enumeration = cpe.cpNodes.elements();
        while (enumeration.hasMoreElements()) {
            CpeNode cpeNode = (CpeNode)enumeration.nextElement();
            if (this.locateNode(cpeNode.m_key) != null) continue;
            if ("CpeSpecialNode".equals(cpeNode.getClass().getName())) {
                this.addNewNode((CpeSpecialNode)cpeNode);
                continue;
            }
            this.addNewNode(cpeNode);
        }
        Enumeration enumeration2 = cpe.cpEdges.elements();
        while (enumeration2.hasMoreElements()) {
            CpeEdge cpeEdge = (CpeEdge)enumeration2.nextElement();
            if (this.locateNode(cpeEdge.m_from.m_key) == null || this.locateNode(cpeEdge.m_to.m_key) == null || this.locateEdge(cpeEdge) != null) continue;
            if ("CpeEqEdge".equals(cpeEdge.getClass().getName())) {
                this.addEdge((CpeEqEdge)cpeEdge);
                continue;
            }
            this.addEdge(cpeEdge);
        }
        Enumeration enumeration3 = cpe.cpText.elements();
        while (enumeration3.hasMoreElements()) {
            CpeText cpeText = (CpeText)enumeration3.nextElement();
            this.m_text.addElement(new CpeText(cpeText.m_key, cpeText.m_x, cpeText.m_y));
        }
    }

    public void removeEdge(String string, boolean bl, String string2, boolean bl2) {
        Enumeration enumeration = this.m_edges.elements();
        while (enumeration.hasMoreElements()) {
            CpeEdge cpeEdge = (CpeEdge)enumeration.nextElement();
            if (!cpeEdge.m_from.m_key.equals(string) || cpeEdge.fromPosition != bl || cpeEdge.toPosition != bl2 || !cpeEdge.m_to.m_key.equals(string2)) continue;
            this.m_edges.removeElement(cpeEdge);
            break;
        }
    }

    public void removeEdgeByLabels(String string, boolean bl, String string2, boolean bl2) {
        Enumeration enumeration = this.m_edges.elements();
        while (enumeration.hasMoreElements()) {
            CpeEdge cpeEdge = (CpeEdge)enumeration.nextElement();
            if (!cpeEdge.m_from.m_lbl.toUpperCase().equals(string.toUpperCase()) || cpeEdge.fromPosition != bl || cpeEdge.toPosition != bl2 || !cpeEdge.m_to.m_lbl.toUpperCase().equals(string2.toUpperCase())) continue;
            this.m_edges.removeElement(cpeEdge);
            break;
        }
    }

    public void removeInitialOrdering() {
        String string = null;
        String string2 = null;
        if (this.startFinishFlag) {
            string = START_STRING;
            string2 = FINISH_STRING;
        } else {
            string = BEGIN_STRING;
            string2 = END_STRING;
        }
        if (this.m_nodes.size() > 2 && this.locateNodeByLabel(string) != null && this.locateNodeByLabel(string2) != null) {
            this.removeEdgeByLabels(string, false, string2, true);
        }
    }

    void removeNode(CpeNode cpeNode) {
        CpeEdge cpeEdge;
        if (cpeNode.m_key.equals("") || cpeNode.m_key.equals(START_STRING) || cpeNode.m_key.equals(BEGIN_STRING) || cpeNode.m_key.equals(END_STRING) || cpeNode.m_key.equals(FINISH_STRING)) {
            return;
        }
        Vector<CpeEdge> vector = new Vector<CpeEdge>();
        Enumeration enumeration = this.m_edges.elements();
        while (enumeration.hasMoreElements()) {
            cpeEdge = (CpeEdge)enumeration.nextElement();
            if (!cpeEdge.m_from.m_key.equals(cpeNode.m_key) && !cpeEdge.m_to.m_key.equals(cpeNode.m_key)) continue;
            vector.addElement(cpeEdge);
        }
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            cpeEdge = (CpeEdge)enumeration2.nextElement();
            this.m_edges.removeElement(cpeEdge);
        }
        this.m_nodes.removeElement(cpeNode);
        vector = null;
    }

    void removeSelected() {
        CpeText cpeText;
        CpeEdge cpeEdge;
        CpeNode cpeNode;
        Cpe cpe = Cpe.sharedInstance();
        cpe.clearCopySpace();
        Vector<CpeNode> vector = new Vector<CpeNode>();
        Enumeration enumeration = this.m_nodes.elements();
        while (enumeration.hasMoreElements()) {
            cpeNode = (CpeNode)enumeration.nextElement();
            if (!cpeNode.m_selected) continue;
            vector.addElement(cpeNode);
            cpe.cpNodes.addElement(cpeNode);
        }
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            cpeNode = (CpeNode)enumeration2.nextElement();
            this.removeNode(cpeNode);
        }
        vector = null;
        Vector<CpeEdge> vector2 = new Vector<CpeEdge>();
        Enumeration enumeration3 = this.m_edges.elements();
        while (enumeration3.hasMoreElements()) {
            cpeEdge = (CpeEdge)enumeration3.nextElement();
            if (!cpeEdge.m_selected) continue;
            vector2.addElement(cpeEdge);
            cpe.cpEdges.addElement(cpeEdge);
        }
        Enumeration enumeration4 = vector2.elements();
        while (enumeration4.hasMoreElements()) {
            cpeEdge = (CpeEdge)enumeration4.nextElement();
            this.m_edges.removeElement(cpeEdge);
        }
        vector2 = null;
        Vector<CpeText> vector3 = new Vector<CpeText>();
        Enumeration enumeration5 = this.m_text.elements();
        while (enumeration5.hasMoreElements()) {
            cpeText = (CpeText)enumeration5.nextElement();
            if (!cpeText.m_selected) continue;
            vector3.addElement(cpeText);
            cpe.cpText.addElement(cpeText);
        }
        Enumeration enumeration6 = vector3.elements();
        while (enumeration6.hasMoreElements()) {
            cpeText = (CpeText)enumeration6.nextElement();
            this.m_text.removeElement(cpeText);
        }
        vector3 = null;
    }

    void renameNode(String string, String string2) {
        if (string.equals("") || string2.equals("") || string.equals(START_STRING) || string2.equals(START_STRING) || string.equals(FINISH_STRING) || string2.equals(FINISH_STRING) || string.equals(BEGIN_STRING) || string2.equals(BEGIN_STRING) || string.equals(END_STRING) || string2.equals(END_STRING) || this.locateNode(string2) != null) {
            return;
        }
        Enumeration enumeration = this.m_nodes.elements();
        while (enumeration.hasMoreElements()) {
            CpeNode cpeNode = (CpeNode)enumeration.nextElement();
            if (!cpeNode.m_key.equals(string)) continue;
            cpeNode.m_lbl = string2;
            break;
        }
    }

    public void requestExpansion() {
        CpeNode cpeNode = null;
        cpeNode = this.getSingleSelectedNode();
        if (cpeNode != null) {
            this.m_panel.m_hitNode = cpeNode;
            this.showExpansion(cpeNode);
        }
    }

    public void requestLink() {
        CpeNode cpeNode = null;
        cpeNode = this.getSingleSelectedNode();
        if (cpeNode != null) {
            this.m_panel.m_hitNode = cpeNode;
            this.addLink(cpeNode, true);
        }
    }

    public void requestNewEqual() {
        CpeNode cpeNode = null;
        cpeNode = this.getSingleSelectedNode();
        if (cpeNode != null) {
            this.m_panel.m_hitNode = cpeNode;
            this.addEqLink(cpeNode, true);
        }
    }

    public void requestProperties() {
        CpeNode cpeNode = null;
        CpeNode cpeNode2 = null;
        int n = 0;
        Enumeration enumeration = this.m_nodes.elements();
        while (enumeration.hasMoreElements()) {
            cpeNode = (CpeNode)enumeration.nextElement();
            if (cpeNode.m_selected) {
                cpeNode2 = cpeNode;
                ++n;
            }
            if (n <= 1) continue;
            JOptionPane.showMessageDialog(Cpe.sharedInstance().getFrame(), "You must select only one node.", "CPE Message", 2);
            break;
        }
        if (n == 0) {
            this.showProcessPropertyDialog();
        } else if (n == 1) {
            this.m_panel.m_hitNode = cpeNode2;
            this.showNodePropertyDialog();
        }
    }

    public void requestUp() {
        if (!this.topLevelFlag) {
            this.m_panel.mainPanel.showExpansion(this.expands, this.m_panel);
        }
    }

    void selectingUp(int n, int n2) {
        this.m_dimension = this.m_panel.size();
        Rectangle rectangle = this.getDrawableRect(this.m_selectingRect, this.m_dimension);
        Enumeration enumeration = this.m_nodes.elements();
        while (enumeration.hasMoreElements()) {
            CpeNode cpeNode = (CpeNode)enumeration.nextElement();
            if (!cpeNode.m_rect.intersects(rectangle)) continue;
            cpeNode.m_selected = true;
        }
        Enumeration enumeration2 = this.m_text.elements();
        while (enumeration2.hasMoreElements()) {
            CpeText cpeText = (CpeText)enumeration2.nextElement();
            if (!cpeText.m_rect.intersects(rectangle)) continue;
            cpeText.m_selected = true;
        }
        Enumeration enumeration3 = this.m_edges.elements();
        while (enumeration3.hasMoreElements()) {
            CpeEdge cpeEdge = (CpeEdge)enumeration3.nextElement();
            if (!cpeEdge.getRect().intersects(rectangle) || !this.checkEdgeHit(cpeEdge, rectangle)) continue;
            cpeEdge.m_selected = true;
        }
    }

    public void setKey(String string) {
        this.key = string;
        if (this.label.equals("")) {
            this.label = string;
        }
    }

    public void setLabel(String string) {
        if (!this.label.equals("")) {
            this.m_panel.mainPanel.renameProcess(this.m_panel, this.label, string, this.topLevelFlag);
        }
        this.label = string;
    }

    public void setStartFinishFlag(boolean bl) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (this.startFinishFlag == bl) {
            return;
        }
        this.startFinishFlag = bl;
        if (this.startFinishFlag) {
            string = BEGIN_STRING;
            string2 = END_STRING;
            string3 = START_STRING;
            string4 = FINISH_STRING;
        } else {
            string = START_STRING;
            string2 = FINISH_STRING;
            string3 = BEGIN_STRING;
            string4 = END_STRING;
        }
        Enumeration enumeration = this.m_nodes.elements();
        while (enumeration.hasMoreElements()) {
            CpeNode cpeNode = (CpeNode)enumeration.nextElement();
            if (cpeNode.m_key == string) {
                cpeNode.m_key = string3;
                cpeNode.m_lbl = string3;
            }
            if (cpeNode.m_key != string2) continue;
            cpeNode.m_key = string4;
            cpeNode.m_lbl = string4;
        }
        this.m_panel.repaint();
    }

    public void showExpansion(CpeNode cpeNode) {
        if (cpeNode.hasExpansion) {
            this.m_panel.mainPanel.showExpansion(cpeNode, this.m_panel);
        }
        this.m_panel.repaint();
    }

    public void showNodePropertyDialog() {
        if (this.m_sheet == null) {
            this.m_sheet = new CpeNodePropertyDialog(this.m_panel, "Node Property Sheet...");
        }
        ((Component)this.m_sheet).setLocation(Cpe.sharedInstance().getCenteringPoint(this.m_sheet));
        this.m_sheet.show();
    }

    public void showProcessPropertyDialog() {
        if (this.processSheet == null) {
            this.processSheet = new CpeProcPropertyDialog(this.m_panel, "Process Property Sheet...");
        }
        ((Component)this.processSheet).setLocation(Cpe.sharedInstance().getCenteringPoint(this.processSheet));
        this.processSheet.show();
    }

    public void supplies(String string, String string2, String string3) {
        String string4 = "";
        string2 = string2.replace(')', ' ').replace('(', ' ').replace('\"', ' ').trim();
        Enumeration enumeration = this.effects.elements();
        while (enumeration.hasMoreElements()) {
            string4 = (String)enumeration.nextElement();
            if (string4.indexOf(string2) == -1 || string4.indexOf(string) == -1) continue;
            this.effects.setElementAt(String.valueOf(string4) + " [" + string3 + "]", this.effects.indexOf(string4));
        }
    }

    void update(Graphics graphics) {
        Dimension dimension = this.m_panel.size();
        graphics.setColor(this.m_panel.getBackground());
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Enumeration enumeration = this.m_edges.elements();
        while (enumeration.hasMoreElements()) {
            ((CpeEdge)enumeration.nextElement()).draw(graphics, fontMetrics);
        }
        Enumeration enumeration2 = this.m_nodes.elements();
        while (enumeration2.hasMoreElements()) {
            ((CpeNode)enumeration2.nextElement()).draw(graphics, fontMetrics);
        }
        Enumeration enumeration3 = this.m_edges.elements();
        while (enumeration3.hasMoreElements()) {
            ((CpeEdge)enumeration3.nextElement()).drawArrow(graphics, fontMetrics);
        }
        Enumeration enumeration4 = this.m_text.elements();
        while (enumeration4.hasMoreElements()) {
            ((CpeText)enumeration4.nextElement()).draw(graphics, fontMetrics);
        }
        if (this.m_linkDrawing) {
            graphics.setColor(this.m_linkColor);
            if (this.m_linkBegin) {
                graphics.drawLine(this.m_panel.m_hitNode.m_rect.x + 10, this.m_panel.m_hitNode.m_y, this.m_linkToX, this.m_linkToY);
            } else {
                graphics.drawLine(this.m_panel.m_hitNode.m_rect.x + this.m_panel.m_hitNode.m_rect.width - 10, this.m_panel.m_hitNode.m_y, this.m_linkToX, this.m_linkToY);
            }
        }
        if (this.m_selecting) {
            Rectangle rectangle = this.getDrawableRect(this.m_selectingRect, dimension);
            graphics.setColor(this.m_linkColor);
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
        }
    }

    public void updateStatus(String string, Color color) {
    }

    class Vertex {
        public String name = "";
        public int inDegree = 0;

        Vertex(String string) {
            this.name = string;
        }
    }
}

