/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class CpeFileFTPDialog
extends JDialog {
    static final String DATADIR = "cpedata";
    static final String DATAEXT = "txt";
    static final String DATAID = "cpe";
    protected JButton btnOK;
    protected JButton btnCancel;
    protected JTextField m_userName = null;
    protected JTextField hostName = null;
    protected JTextField m_fileName = null;
    protected JPasswordField m_password = null;
    protected CpeProcessPanel m_frame = null;
    protected Vector processPanels = null;
    protected JComboBox processList = null;
    protected char m_type;
    protected JRadioButton m_ftp = null;
    protected JRadioButton m_local = null;
    protected ButtonGroup m_radGroup = null;
    protected JDialog dialog = this;

    public CpeFileFTPDialog(String string, char c, Vector vector) {
        super(Cpe.sharedInstance().getFrame(), string, false);
        this.processPanels = vector;
        this.m_type = c;
        JLabel jLabel = null;
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jLabel = new JLabel("Select Process: ");
        jLabel.setPreferredSize(new Dimension(90, 10));
        jLabel.setMinimumSize(new Dimension(90, 10));
        jPanel.add(jLabel);
        this.processList = new JComboBox();
        CpeProcessPanel cpeProcessPanel = null;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            cpeProcessPanel = (CpeProcessPanel)enumeration.nextElement();
            this.processList.addItem(cpeProcessPanel.process.label);
        }
        jPanel.add(this.processList);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jLabel = new JLabel("Host Name: ");
        jLabel.setPreferredSize(new Dimension(90, 10));
        jLabel.setMinimumSize(new Dimension(90, 10));
        jPanel2.add(jLabel);
        this.hostName = new JTextField(Cpe.sharedInstance().hostName, 32);
        jPanel2.add(this.hostName);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jLabel = new JLabel("User ID: ");
        jLabel.setPreferredSize(new Dimension(90, 10));
        jLabel.setMinimumSize(new Dimension(90, 10));
        jPanel3.add(jLabel);
        this.m_userName = new JTextField(Cpe.sharedInstance().userName, 15);
        jPanel3.add(this.m_userName);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jLabel = new JLabel("Password: ");
        jLabel.setPreferredSize(new Dimension(90, 10));
        jLabel.setMinimumSize(new Dimension(90, 10));
        jPanel4.add(jLabel);
        this.m_password = new JPasswordField(Cpe.sharedInstance().password, 15);
        jPanel4.add(this.m_password);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 0));
        jLabel = new JLabel("File Name: ");
        jLabel.setPreferredSize(new Dimension(90, 10));
        jLabel.setMinimumSize(new Dimension(90, 10));
        jPanel5.add(jLabel);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new FlowLayout());
        this.m_fileName = new JTextField(Cpe.sharedInstance().fileName, 32);
        JButton jButton = new JButton("...");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                File file;
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setDialogTitle("Select File...");
                int n = jFileChooser.showDialog(Cpe.sharedInstance(), "OK");
                if (n == 0 && (file = jFileChooser.getSelectedFile()) != null) {
                    CpeFileFTPDialog.this.m_fileName.setText(jFileChooser.getSelectedFile().getAbsolutePath());
                    ButtonModel buttonModel = CpeFileFTPDialog.this.m_radGroup.getSelection();
                    if (buttonModel.getActionCommand().equals("ftp")) {
                        CpeFileFTPDialog.this.m_radGroup.setSelected(buttonModel, false);
                    }
                }
            }
        });
        jPanel6.add(this.m_fileName);
        jPanel6.add(jButton);
        jPanel5.add(jPanel6);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BoxLayout(jPanel7, 0));
        jLabel = new JLabel("File System: ");
        jLabel.setPreferredSize(new Dimension(90, 10));
        jLabel.setMinimumSize(new Dimension(90, 10));
        jPanel7.add(jLabel);
        this.m_ftp = new JRadioButton("FTP", false);
        this.m_ftp.setAlignmentX(0.0f);
        this.m_ftp.setActionCommand("ftp");
        this.m_local = new JRadioButton("Local", true);
        this.m_local.setAlignmentX(0.0f);
        this.m_local.setActionCommand("local");
        this.m_radGroup = new ButtonGroup();
        this.m_radGroup.add(this.m_ftp);
        this.m_radGroup.add(this.m_local);
        jPanel7.add(this.m_ftp);
        jPanel7.add(this.m_local);
        jPanel7.add(Box.createHorizontalGlue());
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BoxLayout(jPanel8, 0));
        this.btnOK = new JButton("OK");
        jPanel8.add(this.btnOK);
        this.btnOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)CpeFileFTPDialog.this.processList.getSelectedItem();
                CpeProcessPanel cpeProcessPanel = null;
                Enumeration enumeration = CpeFileFTPDialog.this.processPanels.elements();
                while (enumeration.hasMoreElements()) {
                    cpeProcessPanel = (CpeProcessPanel)enumeration.nextElement();
                    if (!cpeProcessPanel.process.label.equals(string)) continue;
                    CpeFileFTPDialog.this.m_frame = cpeProcessPanel;
                    break;
                }
                if (CpeFileFTPDialog.this.m_type == 'O') {
                    if (CpeFileFTPDialog.this.m_radGroup.getSelection().getActionCommand().equals("ftp")) {
                        CpeFileFTPDialog.this.fileOpen();
                    } else {
                        CpeFileFTPDialog.this.fileOpenLocal();
                    }
                } else if (CpeFileFTPDialog.this.m_type == 'S') {
                    if (CpeFileFTPDialog.this.m_radGroup.getSelection().getActionCommand().equals("ftp")) {
                        CpeFileFTPDialog.this.fileSave();
                    } else {
                        CpeFileFTPDialog.this.fileSaveLocal();
                    }
                } else if (CpeFileFTPDialog.this.m_radGroup.getSelection().getActionCommand().equals("ftp")) {
                    CpeFileFTPDialog.this.fileImport();
                } else {
                    CpeFileFTPDialog.this.fileImportLocal();
                }
                Cpe.sharedInstance().userName = CpeFileFTPDialog.this.m_userName.getText();
                Cpe.sharedInstance().hostName = CpeFileFTPDialog.this.hostName.getText();
                Cpe.sharedInstance().password = CpeFileFTPDialog.this.m_password.getText();
                Cpe.sharedInstance().fileName = CpeFileFTPDialog.this.m_fileName.getText();
                ((Component)CpeFileFTPDialog.this.dialog).hide();
                CpeFileFTPDialog.this.dialog.dispose();
                Cpe.sharedInstance().ftpDlg = null;
            }
        });
        this.btnCancel = new JButton("Cancel");
        jPanel8.add(this.btnCancel);
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((Component)CpeFileFTPDialog.this.dialog).hide();
                CpeFileFTPDialog.this.dialog.dispose();
                Cpe.sharedInstance().ftpDlg = null;
            }
        });
        this.getContentPane().add(jPanel);
        this.getContentPane().add(jPanel2);
        this.getContentPane().add(jPanel3);
        this.getContentPane().add(jPanel4);
        this.getContentPane().add(jPanel5);
        this.getContentPane().add(jPanel7);
        this.getContentPane().add(Box.createRigidArea(new Dimension(0, 5)));
        this.getContentPane().add(jPanel8);
        this.pack();
    }

    private void fileImport() {
        Cpe.sharedInstance().setWait();
        ((Component)this).setCursor(Cursor.getPredefinedCursor(3));
        FtpModule ftpModule = new FtpModule(this.m_frame);
        if (ftpModule.connect(this.hostName.getText())) {
            if (ftpModule.login(this.m_userName.getText(), this.m_password.getText())) {
                ftpModule.getFile(this.m_type, "cpedata/" + this.m_fileName.getText());
                ftpModule.disconnect();
            } else {
                JOptionPane.showMessageDialog(Cpe.sharedInstance().getFrame(), "Unable to login to FTP server!", "CPE Message", 2);
                ftpModule.disconnect();
            }
        } else {
            JOptionPane.showMessageDialog(Cpe.sharedInstance().getFrame(), "Unable to connect!", "CPE Message", 2);
        }
        Cpe.sharedInstance().setNormal();
        ((Component)this).setCursor(Cursor.getPredefinedCursor(0));
    }

    private void fileImportLocal() {
        Cpe.sharedInstance().setWait();
        ((Component)this).setCursor(Cursor.getPredefinedCursor(3));
        FtpModule ftpModule = new FtpModule(this.m_frame);
        try {
            if (this.m_fileName.getText() != null) {
                FileInputStream fileInputStream = new FileInputStream(this.m_fileName.getText());
                ftpModule.getFileLocal(this.m_type, this.m_fileName.getText(), fileInputStream);
                ((InputStream)fileInputStream).close();
            } else {
                JOptionPane.showMessageDialog(Cpe.sharedInstance().getFrame(), "No file name given!", "CPE Message", 2);
            }
        }
        catch (Exception exception) {}
        Cpe.sharedInstance().setNormal();
        ((Component)this).setCursor(Cursor.getPredefinedCursor(0));
    }

    private void fileOpen() {
        Cpe.sharedInstance().setWait();
        ((Component)this).setCursor(Cursor.getPredefinedCursor(3));
        FtpModule ftpModule = new FtpModule(this.m_frame);
        if (ftpModule.connect(this.hostName.getText())) {
            if (ftpModule.login(this.m_userName.getText(), this.m_password.getText())) {
                ftpModule.getFile(this.m_type, "cpedata/" + this.m_fileName.getText());
                ftpModule.disconnect();
            } else {
                JOptionPane.showMessageDialog(Cpe.sharedInstance().getFrame(), "Unable to login to FTP server!", "CPE Message", 2);
                ftpModule.disconnect();
            }
        } else {
            JOptionPane.showMessageDialog(Cpe.sharedInstance().getFrame(), "Unable to connect!", "CPE Message", 2);
        }
        Cpe.sharedInstance().setNormal();
        ((Component)this).setCursor(Cursor.getPredefinedCursor(0));
    }

    private void fileOpenLocal() {
        Cpe.sharedInstance().setWait();
        ((Component)this).setCursor(Cursor.getPredefinedCursor(3));
        FtpModule ftpModule = new FtpModule(this.m_frame);
        try {
            if (this.m_fileName.getText() != null) {
                FileInputStream fileInputStream = new FileInputStream(this.m_fileName.getText());
                ftpModule.getFileLocal(this.m_type, this.m_fileName.getText(), fileInputStream);
                ((InputStream)fileInputStream).close();
            } else {
                JOptionPane.showMessageDialog(Cpe.sharedInstance().getFrame(), "No file name given!", "CPE Message", 2);
            }
        }
        catch (Exception exception) {}
        Cpe.sharedInstance().setNormal();
        ((Component)this).setCursor(Cursor.getPredefinedCursor(0));
    }

    private void fileSave() {
        Cpe.sharedInstance().setWait();
        ((Component)this).setCursor(Cursor.getPredefinedCursor(3));
        FtpModule ftpModule = new FtpModule(this.m_frame);
        if (ftpModule.connect(this.hostName.getText())) {
            if (ftpModule.login(this.m_userName.getText(), this.m_password.getText())) {
                ftpModule.sendFile(this.m_type, true, "cpedata/" + this.m_fileName.getText());
                ftpModule.disconnect();
            } else {
                JOptionPane.showMessageDialog(Cpe.sharedInstance().getFrame(), "Unable to login to FTP server!", "CPE Message", 2);
                ftpModule.disconnect();
            }
        } else {
            JOptionPane.showMessageDialog(Cpe.sharedInstance().getFrame(), "Unable to connect!", "CPE Message", 2);
        }
        Cpe.sharedInstance().setNormal();
        ((Component)this).setCursor(Cursor.getPredefinedCursor(0));
    }

    private void fileSaveLocal() {
        Cpe.sharedInstance().setWait();
        ((Component)this).setCursor(Cursor.getPredefinedCursor(3));
        FtpModule ftpModule = new FtpModule(this.m_frame);
        try {
            if (this.m_fileName.getText() != null) {
                FileOutputStream fileOutputStream = new FileOutputStream(this.m_fileName.getText());
                ftpModule.sendFileLocal(this.m_type, this.m_fileName.getText(), fileOutputStream);
                ((OutputStream)fileOutputStream).close();
            } else {
                JOptionPane.showMessageDialog(Cpe.sharedInstance().getFrame(), "No file name given!", "CPE Message", 2);
            }
        }
        catch (Exception exception) {}
        Cpe.sharedInstance().setNormal();
        ((Component)this).setCursor(Cursor.getPredefinedCursor(0));
    }
}

