/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;

class CpeEdge {
    CpeNode m_from;
    boolean fromPosition;
    CpeNode m_to;
    boolean toPosition;
    final Color m_edgeColor = Color.black;
    boolean m_selected = false;
    final Color m_selectedColor = Color.pink;

    CpeEdge(CpeNode cpeNode, boolean bl, CpeNode cpeNode2, boolean bl2) {
        this.m_from = cpeNode;
        this.fromPosition = bl;
        this.m_to = cpeNode2;
        this.toPosition = bl2;
    }

    public void draw(Graphics graphics, FontMetrics fontMetrics) {
        if (this.m_from == null || this.m_to == null) {
            return;
        }
        int n = this.m_from.m_y;
        int n2 = this.m_to.m_y;
        if (this.m_selected) {
            graphics.setColor(this.m_selectedColor);
        } else {
            graphics.setColor(this.m_edgeColor);
        }
        int n3 = this.m_from.calcWidth(fontMetrics);
        int n4 = this.m_to.calcWidth(fontMetrics);
        int n5 = this.fromPosition ? this.m_from.m_x - n3 / 2 : this.m_from.m_x + n3 / 2;
        int n6 = this.toPosition ? this.m_to.m_x - n4 / 2 : this.m_to.m_x + n4 / 2;
        graphics.drawLine(n5, n, n6, n2);
    }

    public void drawArrow(Graphics graphics, FontMetrics fontMetrics) {
        if (this.m_from == null || this.m_to == null) {
            return;
        }
        int n = this.m_from.m_y;
        int n2 = this.m_to.m_y;
        if (this.m_selected) {
            graphics.setColor(this.m_selectedColor);
        } else {
            graphics.setColor(this.m_edgeColor);
        }
        int n3 = this.m_to.calcWidth(fontMetrics);
        int n4 = this.m_from.calcWidth(fontMetrics);
        int n5 = this.fromPosition ? this.m_from.m_x - n4 / 2 : this.m_from.m_x + n4 / 2;
        int n6 = this.toPosition ? this.m_to.m_x - n3 / 2 : this.m_to.m_x + n3 / 2;
        this.placeArrow(graphics, n5, n, n6, n2, 4);
    }

    public int fromX() {
        if (this.fromPosition) {
            return this.m_from.m_x - (this.m_from.m_rect.width - 10) / 2;
        }
        return this.m_from.m_x + (this.m_from.m_rect.width - 10) / 2;
    }

    public int fromY() {
        return this.m_from.m_y;
    }

    public Rectangle getRect() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        if (this.m_from == null || this.m_to == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        int n6 = this.fromX();
        if (n6 < (n5 = this.toX())) {
            n4 = n6;
            n3 = n5 - n6;
        } else {
            n4 = n5;
            n3 = n6 - n5;
        }
        if (this.m_from.m_y < this.m_to.m_y) {
            n2 = this.m_from.m_y;
            n = this.m_to.m_y - this.m_from.m_y;
        } else {
            n2 = this.m_to.m_y;
            n = this.m_from.m_y - this.m_to.m_y;
        }
        if (n3 == 0) {
            n3 = 1;
        }
        if (n == 0) {
            n = 1;
        }
        return new Rectangle(n4, n2, n3, n);
    }

    public void placeArrow(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        int n6 = n3 - n;
        int n7 = n4 - n2;
        double d = Math.sqrt(n6 * n6 + n7 * n7);
        double d2 = (double)n7 / d;
        double d3 = (double)n6 / d;
        double d4 = d - (double)n5;
        double d5 = 0.0;
        double d6 = d4 - (double)(2 * n5);
        double d7 = n5;
        double d8 = d6;
        double d9 = -d7;
        double d10 = d4 - (double)(3 * n5 / 2);
        double d11 = 0.0;
        double d12 = d4 * d3 - d5 * d2;
        double d13 = d4 * d2 + d5 * d3;
        d4 = d12;
        d5 = d13;
        d12 = d6 * d3 - d7 * d2;
        d13 = d6 * d2 + d7 * d3;
        d6 = d12;
        d7 = d13;
        d12 = d8 * d3 - d9 * d2;
        d13 = d8 * d2 + d9 * d3;
        d8 = d12;
        d9 = d13;
        d12 = d10 * d3 - d11 * d2;
        d13 = d10 * d2 + d11 * d3;
        d10 = d12;
        d11 = d13;
        d4 += (double)n;
        d5 += (double)n2;
        d10 += (double)n;
        d11 += (double)n2;
        d6 += (double)n;
        d7 += (double)n2;
        d8 += (double)n;
        d9 += (double)n2;
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        nArray[0] = (int)d4;
        nArray[1] = (int)d6;
        nArray[2] = (int)d10;
        nArray[3] = (int)d8;
        nArray2[0] = (int)d5;
        nArray2[1] = (int)d7;
        nArray2[2] = (int)d11;
        nArray2[3] = (int)d9;
        graphics.fillPolygon(nArray, nArray2, 4);
    }

    public int toX() {
        if (this.toPosition) {
            return this.m_to.m_x - (this.m_to.m_rect.width - 10) / 2;
        }
        return this.m_to.m_x + (this.m_to.m_rect.width - 10) / 2;
    }

    public int toY() {
        return this.m_to.m_y;
    }
}

