/*
* @(#)CplSpec.java	1.0 98-Sept-22
* 
*/

import java.util.*;
import java.awt.*;
import com.sun.java.swing.tree.*;

/**
 * Common Process Editor (CPE) specification class.
 *
 * This class accumulates the parsed process specification and translates
 * it to the internal cpe structures.
 *
 * @version 1.0 98/9/22
 * @author Steve Polyak
 */

public class CplSpec extends Object 
{

  Hashtable types = new Hashtable(); //stores the new types
  Hashtable always = new Hashtable(); //stores the always items
  Hashtable plans = new Hashtable(); //stores the plans
  Hashtable processes = new Hashtable(); //stores the schemas
  Hashtable resources = new Hashtable(); //stores the objects
  Hashtable levels = new Hashtable(); //stores the levels
  Hashtable parents = new Hashtable(); //stores the new object parent hier
  Hashtable sortElements = new Hashtable(); //stores all SORT defined objects
  java.io.PrintStream stream = null;
  String domainName = "";
  CpeProcessPanel panel = null;

  CplSpec() {
  }

  public void reset() {
    types = new Hashtable(); //stores the new types
    always = new Hashtable(); //stores the always items
    plans = new Hashtable(); //stores the plans
    processes = new Hashtable(); //stores the schemas
    resources = new Hashtable(); //stores the objects
    levels = new Hashtable(); //stores the levels
    parents = new Hashtable(); //stores the levels
    sortElements = new Hashtable(); //stores all SORT defined objects
    stream = null;
  }

  // writeout is the main TF writing driver.
  public void writeOut(java.io.PrintStream stream) {
    //  this.stream = stream;
    //writeHeader();
  }

  // importer is the main driver for importing a cpd file.
  public void importer() {}
  public void importer(CpeProcessPanel panel) {
    this.panel = panel;
    SpecProcessItem plan = null;

    for (Enumeration e =  plans.elements(); e.hasMoreElements() ;) {
      plan = (SpecProcessItem) e.nextElement();
      panel.process.setLabel(plan.label.replace('\"',' ').trim());
      importActionConstraints(plan, this.panel.process);
    }
  }

  private void importActionConstraints(SpecProcessItem process,
				       CpeProcess cpeProcess) {

    SpecConstrItem constraint = null;
    String from = "";
    boolean fromBegin = true;
    String to = "";
    boolean toBegin = true;
    Vector nodeList = new Vector(); // easier to work with a local vector

    if (process.expands != null) {
      cpeProcess.expands = process.expands.replace('\"',' ').trim();
    }
    cpeProcess.taskProcess = process.taskProcess; //false for process
    cpeProcess.execProcess = process.execProcess; //false for process

    SpecVarItem varItem = null;
    int lowestValue = 999;
    int varCount = 0;
    int processedCount = 0;

    //get the lowest pos number
    for  (Enumeration eps =  process.variables.elements();
	  eps.hasMoreElements() ;)  {
      varItem = (SpecVarItem) eps.nextElement();
      if (varItem.pos < lowestValue) {
	lowestValue = varItem.pos;
      }
      varCount++;
    }

    //work down the count from highest to lowest
    while(processedCount < varCount) {
      for  (Enumeration e =  process.variables.elements(); 
	    e.hasMoreElements() ;)  {
	varItem = (SpecVarItem) e.nextElement();
	if (lowestValue == varItem.pos) {
	  cpeProcess.variables.addElement
	    (varItem.label.replace('\"',' ').trim());
	  processedCount++;
	}
      }
      lowestValue++;
    }

    if (process.as != null) {
      //ok, lets add all the nodes based on the include constraints
      for (Enumeration e =  process.as.constraints.elements(); 
	   e.hasMoreElements() ;)  {
	constraint = (SpecConstrItem) e.nextElement();

	if ("include-constraint".equals(constraint.type)) {
	  nodeList.addElement(constraint.node);
	}

	if ("include-constraint".equals(constraint.type) &&
	    "action".equals(constraint.node.type)) {
	  CpeNode cpeNode = new CpeNode(constraint.node.key,
					constraint.node.xpos,
					constraint.node.ypos);
	  cpeNode.setPattern(constraint.node.pattern.replace('"',' ').trim());
	  cpeNode.m_lbl = 
	    constraint.node.label.replace('"',' ').replace('~','\n').trim();

	  //recurse if it has an expansion.
	  if (constraint.node.expansion != null) {
	    cpeNode.hasExpansion = true;
	    cpeNode.expansion = cpeProcess.m_panel.mainPanel.createExpansion
	      (cpeProcess.key);
	    CpeProcess newProcess = (cpeProcess.m_panel.mainPanel.locatePanel
				     (cpeNode.expansion)).process;
	    //iconify subprocesses initially
	    try {
	      newProcess.m_panel.frame.setIcon(true);
	    } catch(java.beans.PropertyVetoException beane) {};
	    newProcess.setLabel(constraint.node.expansion.label
				.replace('\"',' ').trim());
		
	    importActionConstraints(constraint.node.expansion, newProcess);
	  }
	  cpeProcess.addNewNode(cpeNode);
	}
    
	if ("annotation-constraint".equals(constraint.type)) {
	  cpeProcess.m_text.addElement
	    (new CpeText(constraint.label.replace('"',' '), 
			 constraint.xpos, constraint.ypos));    
	}

	if ("include-constraint".equals(constraint.type) &&
	    ("begin".equals(constraint.node.type) ||
	     "end".equals(constraint.node.type))) {
	  cpeProcess.setStartFinishFlag(false);
	}
	if ("include-constraint".equals(constraint.type) &&
	    ("begin".equals(constraint.node.type) ||
	     "start".equals(constraint.node.type) ||
	     "finish".equals(constraint.node.type) ||
	     "end".equals(constraint.node.type))) {
	  //need to update the key on the enclosing nodes
	  cpeProcess.changeNodeKey(constraint.node.type, 
				   constraint.node.key);
	  //reposition node
	  CpeNode tmpNode =
	    cpeProcess.locateNode(constraint.node.key);
	  tmpNode.m_x = constraint.node.xpos;
	  tmpNode.m_y = constraint.node.ypos;
	}
      }

      //All include constraints have been processed, now address orderings
      for (Enumeration e1 =  process.as.constraints.elements(); 
	   e1.hasMoreElements() ;)  {
	constraint = (SpecConstrItem) e1.nextElement();
	if ("ordering-constraint".equals(constraint.type)) {

	  //pull apart e.g. "before(Obj1,Obj2)"
	  StringTokenizer st = new 
	    StringTokenizer
	    ((constraint.label.replace('\"',' ').trim()), "(),");
	  int i = 0;
	  for  (Enumeration  e2  = st; e2.hasMoreElements()  ; i++)  {	
	    String temp = (String) e2.nextElement();
	    switch (i) 
	      {
	      case 0:
		constraint.relation = temp;
	      case 1:
		constraint.tp1 = temp;
	      case 2:
		constraint.tp2 = temp;
	      }
	  } 

	  for  (Enumeration  e5  = nodeList.elements(); e5.hasMoreElements();){
	    SpecNodeItem nodeObj = (SpecNodeItem) e5.nextElement();

	    if(constraint.tp1.equals(nodeObj.beginTimePoint)) {
	      from = nodeObj.key;
	      fromBegin = true;
	      //correction for begin/start
	      if(("begin".equals(nodeObj.type)) ||
		 ("start".equals(nodeObj.type)))
		fromBegin = false;
	    }
	    else if (constraint.tp1.equals(nodeObj.endTimePoint)) {
	      from = nodeObj.key;
	      fromBegin = false;
	    }
	    if (constraint.tp2.equals(nodeObj.beginTimePoint)) {
	      to = nodeObj.key;
	      toBegin = true;
	    }
	    else if (constraint.tp2.equals(nodeObj.endTimePoint)) {
	      to = nodeObj.key;
	      toBegin = false;
	    }
	  }
	  if ("before".equals(constraint.relation)) {
	    //can't link within an action
	    if(!(from.equals(to)))
	      cpeProcess.addEdge(from,fromBegin,to,toBegin);
	  } else {
	    //can't link within an action
	    if(!(from.equals(to)))
	      cpeProcess.addEqEdge(from,fromBegin,to,toBegin);
	  }
	}
      }

      //right, let's address input, output, and resource constraints

      for (Enumeration e =  process.as.constraints.elements(); 
	   e.hasMoreElements() ;)  {
	constraint = (SpecConstrItem) e.nextElement();

	if ("input-constraint".equals(constraint.type)) {
	  cpeProcess.preconditions.addElement
	    (constraint.label.replace('\"',' ').trim());
	}
	else if ("output-constraint".equals(constraint.type)) {
	  cpeProcess.effects.addElement
	    (constraint.label.replace('\"',' ').trim());
	}
	else if ("resource-constraint".equals(constraint.type)) {
	  cpeProcess.resources.addElement
	    (constraint.label.replace('\"',' ').trim());
	}
      }
    }

    //annotate the input,output constraints with dependencies

    for  (Enumeration  eNodes  = nodeList.elements(); 
	  eNodes.hasMoreElements();) {
      SpecNodeItem nodeObj = (SpecNodeItem) eNodes.nextElement();

      for  (Enumeration  e1  = nodeObj.supplies.elements(); 
	    e1.hasMoreElements();) {
	SpecDependency dep = (SpecDependency) e1.nextElement();
	cpeProcess.supplies(dep.node.key, dep.pattern, nodeObj.key);
      }

      for  (Enumeration  e2  = nodeObj.consumes.elements(); 
	    e2.hasMoreElements();) {
	SpecDependency dep = (SpecDependency) e2.nextElement();
	cpeProcess.consumes(nodeObj.key, dep.pattern, dep.node.key);
      } 
    }

    //remove inital beg/end or start/finish if necessary
    cpeProcess.removeInitialOrdering();
    
  }

  //*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_
  // end of write routines
  //*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_


  //---------- Activity ----------------
  public void activityPattern(String id, String val) {
    SpecNodeItem item = null;

    //update the object name if exists, or create new
    item = (SpecNodeItem) sortElements.get(id);
    if (item == null) {
      item = new SpecNodeItem(id);
      item.key = id;
      sortElements.put(id,item);
    }
    item.pattern = val;
  }

  public void activitySpec(String id, String val) {}
  //System.out.println("received:" +id+" "+val);}
  public void activityExpands(String id, String val) {}
  //System.out.println("received:" +id+" "+val);}

  public void activityVariable(String id, String val, int pos) {
  }

  public void activityBegin(String id, String val) {
    SpecNodeItem item = null;
    SpecItem tp = null;

    //update the object name if exists, or create new
    item = (SpecNodeItem) sortElements.get(id);
    if (item == null) {
      item = new SpecNodeItem(id);
      item.key = id;
      sortElements.put(id,item);
    }

    //update the object name if exists, or create new
    tp = (SpecItem) sortElements.get(val);
    if (tp == null) {
      tp = new SpecNodeItem(val);
      sortElements.put(val,tp);
    }

    item.beginTimePoint = val;
  }

  public void activityEnd(String id, String val) {
    SpecNodeItem item = null;
    SpecItem tp = null;

    //update the object name if exists, or create new
    item = (SpecNodeItem) sortElements.get(id);
    if (item == null) {
      item = new SpecNodeItem(id);
      item.key = id;
      sortElements.put(id,item);
    }

    //update the object name if exists, or create new
    tp = (SpecItem) sortElements.get(val);
    if (tp == null) {
      tp = new SpecNodeItem(val);
      sortElements.put(val,tp);
    }

    item.endTimePoint = val;
  }

  //---------- Commands ----------------
  public void comIncludeDomain(String domain) {}
  //System.out.println("received:" +domain);}

  //---------- Constraint ----------------
  public void constrExpression(String id, String val) {

    SpecConstrItem item = null;

    //update the item if exists, or create new
    item = (SpecConstrItem) sortElements.get(id);
    if (item == null) {
      item = new SpecConstrItem(id);
      sortElements.put(id,item);
    }
    item.label = val;
  }

  public void constrAddedBy(String id, String val) {}
  //System.out.println("received:" +id+" "+val);}

  //---------- Level ----------------
  public void levelLabel(String id, String val) {
    SpecLevelItem item = null;

    //update the object name if exists, or create new
    item = (SpecLevelItem) sortElements.get(id);
    if (item == null) {
      item = new SpecLevelItem(id);
      levels.put(id,item);
      sortElements.put(id,item);
    }
    item.label = ((val.replace('-','_')).replace('"',' ')).trim();
  }

  public void levelNumber(String id, String val) {
    SpecLevelItem item = null;

    //update the object name if exists, or create new
    item = (SpecLevelItem) sortElements.get(id);
    if (item == null) {
      item = new SpecLevelItem(id);
      levels.put(id,item);
      sortElements.put(id,item);
    }
    item.number = (Integer.valueOf(val)).intValue();
  }

  public void levelContains(String id, String val) {
    // public void activityEnd(String id, String val) {
    SpecProcessItem process = null;
    SpecLevelItem level = null;
    
    //update the object name if exists, or create new
    level = (SpecLevelItem) sortElements.get(id);
    if (level == null) {
      level = new SpecLevelItem(id);
      levels.put(id,level);
      sortElements.put(id,level);
    }
    
    //update the object name if exists, or create new
    process = (SpecProcessItem) sortElements.get(val);
    if (process == null) {
      process = new SpecProcessItem(val);
      sortElements.put(val,process);
    }

    process.level = id;
    level.processes.addElement(process);
  }

  //---------- Node ----------------
  public void nodeLabel(String id, String val) {
    SpecNodeItem item = null;

    //update the object name if exists, or create new
    item = (SpecNodeItem) sortElements.get(id);
    if (item == null) {
      item = new SpecNodeItem(id);
      item.key = id;
      sortElements.put(id,item);
    }
    item.label = val;
  }

  public void nodeXPos(String id, String val) {
    SpecNodeItem item = null;

    //update the object name if exists, or create new
    item = (SpecNodeItem) sortElements.get(id);
    if (item == null) {
      item = new SpecNodeItem(id);
      item.key = id;
      sortElements.put(id,item);
    }
    item.xpos = (Integer.valueOf(val)).intValue();
  }

  public void nodeYPos(String id, String val) {
    SpecNodeItem item = null;

    //update the object name if exists, or create new
    item = (SpecNodeItem) sortElements.get(id);
    if (item == null) {
      item = new SpecNodeItem(id);
      item.key = id;
      sortElements.put(id,item);
    }
    item.ypos = (Integer.valueOf(val)).intValue();
  }

  //---------- Entity ----------------

  public void entityIsa(String id1, String id2) {
    
    SpecEntityItem item = null;

    //update the object name if exists, or create new
    item = (SpecEntityItem) parents.get(id1);
    if (item == null) {
      item = new SpecEntityItem(id1);
      parents.put(id1,item);
    }
    item.parent = id2;
  }

  //----- Annotation -----
  public void annotationXPos(String id, String val) {
    SpecConstrItem item = null;

    //update the object name if exists, or create new
    item = (SpecConstrItem) sortElements.get(id);
    if (item == null) {
      item = new SpecConstrItem(id);
      item.key = id;
      sortElements.put(id,item);
    }
    item.xpos = (Integer.valueOf(val)).intValue();
  }

  public void annotationYPos(String id, String val) {
    SpecConstrItem item = null;

    //update the object name if exists, or create new
    item = (SpecConstrItem) sortElements.get(id);
    if (item == null) {
      item = new SpecConstrItem(id);
      item.key = id;
      sortElements.put(id,item);
    }
    item.ypos = (Integer.valueOf(val)).intValue();
  }

  //---------- Object ----------------
  public void objectName(String id, String val) {
    
    SpecItem item = null;

    //update the object name if exists, or create new
    item = (SpecItem) sortElements.get(id);
    if (item == null) {
      item = new SpecItem(id);
      sortElements.put(id,item);
    }
    item.label = val;
  }

  public void objectIsResource(String id, String val) {

    SpecItem item = null;
    boolean isResource = false;

    //update the object if exists, or create new
    item = (SpecItem) sortElements.get(id);
    if (item == null) {
      item = new SpecItem(id);
      sortElements.put(id,item);
    }
    isResource = (("true".equals(val.toLowerCase())) ? true : false);

    item.isResource = isResource; 
    if (isResource) resources.put(id,item);
  }

  public void objectResourceType(String id, String val) {
    SpecItem item = null;
    //update the object if exists, or create new
    item = (SpecItem) sortElements.get(id);
    if (item == null) {
      item = new SpecItem(id);
      sortElements.put(id,item);
    }
    item.resourceType = val.replace('"',' ').trim();
  }

  public void objectUnit(String id, String val) {
    SpecItem item = null;
    //update the object if exists, or create new
    item = (SpecItem) sortElements.get(id);
    if (item == null) {
      item = new SpecItem(id);
      sortElements.put(id,item);
    }
    item.unit = val;
  }

  //---------- Process ----------------
  public void processLabel(String id, String val) {
    SpecProcessItem item = null;

    //update the object name if exists, or create new
    item = (SpecProcessItem) sortElements.get(id);
    if (item == null) {
      item = new SpecProcessItem(id);
      sortElements.put(id,item);
    }
    item.label = val.replace('-','_');
  }

  public void processSpec(String id, String val) {
    SpecProcessItem item = null;
    SpecActSpecItem asItem = null;

    //update the object name if exists, or create new
    item = (SpecProcessItem) sortElements.get(id);
    if (item == null) {
      item = new SpecProcessItem(id);
      sortElements.put(id,item);
    }

    //update the object name if exists, or create new
    asItem = (SpecActSpecItem) sortElements.get(val);
    if (asItem == null) {
      asItem = new SpecActSpecItem(val);
      sortElements.put(val,asItem);
    }

    item.as = asItem;
  }

  public void processIsExec(String id, String val) {

    SpecProcessItem item = null;

    //update the object name if exists, or create new
    item = (SpecProcessItem) sortElements.get(id);
    if (item == null) {
      item = new SpecProcessItem(id);
      sortElements.put(id,item);
    }
    item.execProcess = (("true".equals(val.toLowerCase())) ? true : false);
  }

  public void processExpands(String id, String val) {
    SpecProcessItem item = null;

    //update the object name if exists, or create new
    item = (SpecProcessItem) sortElements.get(id);
    if (item == null) {
      item = new SpecProcessItem(id);
      sortElements.put(id,item);
    }
    item.expands = val;
  }

  //this connects a sub-process to a node.
  public void processExpandsNode(String id, String val) {
    SpecProcessItem item = null;
    SpecNodeItem nItem = null;

    item = (SpecProcessItem) sortElements.get(id);
    if (item == null) {
      item = new SpecProcessItem(id);
      sortElements.put(id,item);
    }

    //update the object name if exists, or create new
    nItem = (SpecNodeItem) sortElements.get(val);
    if (nItem == null) {
      nItem = new SpecNodeItem(val);
      nItem.key = val;
      sortElements.put(val,nItem);
    }

    nItem.expansion = item;
  }

  public void processVariable(String id, String val, int pos) {

    SpecProcessItem item = null;
    SpecVarItem varItem = null;

    //update the object name if exists, or create new
    item = (SpecProcessItem) sortElements.get(id);
    if (item == null) {
      item = new SpecProcessItem(id);
      sortElements.put(id,item);
    }

    //update the object name if exists, or create new
    varItem = (SpecVarItem) sortElements.get(val);
    if (varItem == null) {
      varItem = new SpecVarItem(val);
      sortElements.put(val,varItem);
    }
    varItem.pos = pos;
    item.variables.addElement(varItem);
  }

  public void processStart(String id, String val) {}
  //System.out.println("received:" +id+" "+val);}
  public void processFinish(String id, String val) {}
  //System.out.println("received:" +id+" "+val);}

  //---------- Sort ----------------
  public void sortDeclaration(String type, String id, boolean newType) {

    SpecItem instItem = null;
    SpecTypeItem item = null; // for dynamically defined types

    //insert the sort element into the hashtable
    instItem = (SpecItem) sortElements.get(id);
    if (instItem == null) {
      //create new spec item of proper type
      if ("always-constraint".equals(type)) {instItem = new SpecItem(id);}
      else if ("plan".equals(type)) {instItem = new SpecProcessItem(id);}
      else if ("action".equals(type)) {instItem = new SpecNodeItem(id);
      ((SpecNodeItem)instItem).key = id;}
      else if ("unit".equals(type)) {instItem = new SpecUnitItem(id);}
      else if ("entity-variable".equals(type)) 
	{instItem = new SpecVarItem(id);}
      else if ("start".equals(type)) {instItem = new SpecNodeItem(id);}
      else if ("finish".equals(type)) {instItem = new SpecNodeItem(id);}
      else if ("begin".equals(type)) {instItem = new SpecNodeItem(id);}
      else if ("end".equals(type)) {instItem = new SpecNodeItem(id);}
      else if ("process".equals(type)) {instItem = new SpecProcessItem(id);}
      else if ("activity-specification".equals(type)) 
	{instItem = new SpecActSpecItem(id);}
      else if ("include-constraint".equals(type)) 
	{instItem = new SpecConstrItem(id);}
      else if ("ordering-constraint".equals(type)) 
	{instItem = new SpecConstrItem(id);}
      else {
        instItem = new SpecItem(id);
      }
      sortElements.put(id,instItem);
    }
    instItem.type = type;

    //if new type, add hashtable entry to the types
    if (newType) {
      item = (SpecTypeItem)types.get(type);
      if (item != null) {
	item.instances.addElement(instItem);
      }
      else {
	item = new SpecTypeItem(type); 
	item.instances.addElement(instItem);
	types.put(type, item);
      }
    }
    else {
      if ("always-constraint".equals(type)) {always.put(id,instItem);}
      else if ("plan".equals(type)) {
	plans.put(id,instItem);
	((SpecProcessItem)instItem).taskProcess = true;
      }
      else if ("process".equals(type)) {
	processes.put(id,instItem);
	((SpecProcessItem)instItem).taskProcess = false;
      }
    }
  }

  public void sortRangeDeclaration(String type, String id, boolean newType) {
    //System.out.println("received:"+type+" "+id);
    System.err.println("Range expressions not currently supported!");}

  //---------- Special ----------------
  public void includeNode(String id, String val) {
    SpecConstrItem cItem = null;
    SpecNodeItem nItem = null;

    //update the object name if exists, or create new
    cItem = (SpecConstrItem) sortElements.get(id);
    if (cItem == null) {
      cItem = new SpecConstrItem(id);
      sortElements.put(id,cItem);
    }

    //update the object name if exists, or create new
    nItem = (SpecNodeItem) sortElements.get(val);
    if (nItem == null) {
      nItem = new SpecNodeItem(val);
      nItem.key = val;
      sortElements.put(val,nItem);
    }

    cItem.node = nItem;
  }
  
  public void member(String memberStr, String setStr) {
    SpecActSpecItem asItem = null;
    SpecConstrItem cItem = null;

    //update the object name if exists, or create new
    asItem = (SpecActSpecItem) sortElements.get(setStr);
    if (asItem == null) {
      asItem = new SpecActSpecItem(setStr);
      sortElements.put(setStr,asItem);
    }

    //update the object name if exists, or create new
    cItem = (SpecConstrItem) sortElements.get(memberStr);
    if (cItem == null) {
      cItem = new SpecConstrItem(memberStr);
      sortElements.put(memberStr,cItem);
    }

    asItem.constraints.addElement(cItem);
  }

  //---------- Timepoint ----------------
  public void tpStart(String id, String val) {
    SpecNodeItem item = null;
    SpecItem tp = null;

    //update the object name if exists, or create new
    item = (SpecNodeItem) sortElements.get(id);
    if (item == null) {
      item = new SpecNodeItem(id);
      item.key = id;
      sortElements.put(id,item);
    }

    //update the object name if exists, or create new
    tp = (SpecItem) sortElements.get(val);
    if (tp == null) {
      tp = new SpecNodeItem(val);
      sortElements.put(val,tp);
    }

    item.beginTimePoint = val;    
    item.endTimePoint = val;    
  }

  public void tpFinish(String id, String val) {
    SpecNodeItem item = null;
    SpecItem tp = null;

    //update the object name if exists, or create new
    item = (SpecNodeItem) sortElements.get(id);
    if (item == null) {
      item = new SpecNodeItem(id);
      item.key = id;
      sortElements.put(id,item);
    }

    //update the object name if exists, or create new
    tp = (SpecItem) sortElements.get(val);
    if (tp == null) {
      tp = new SpecNodeItem(val);
      sortElements.put(val,tp);
    }

    item.beginTimePoint = val;    
    item.endTimePoint = val;    
  }

  //---------- Unit ----------------

  public void unitLabel(String id, String val) {
    SpecUnitItem item = null;
    //update the object if exists, or create new
    item = (SpecUnitItem) sortElements.get(id);
    if (item == null) {
      item = new SpecUnitItem(id);
      sortElements.put(id,item);
    }
    item.label = val;
  }

  public void unitType(String id, String val) {
    SpecUnitItem item = null;
    //update the object if exists, or create new
    item = (SpecUnitItem) sortElements.get(id);
    if (item == null) {
      item = new SpecUnitItem(id);
      sortElements.put(id,item);
    }
    item.unitType = val;
  }

  //---------- Variable ----------------
  public void varLabel(String id, String val) {

    SpecVarItem item = null;
    //update the object if exists, or create new
    item = (SpecVarItem) sortElements.get(id);
    if (item == null) {
      item = new SpecVarItem(id);
      sortElements.put(id,item);
    }
    item.label = val;
    //System.out.println(val);
  }

  //---------- Dependency ----------------
  public void dependency(String s, String p, String c) {
    SpecNodeItem item1 = null;
    SpecNodeItem item2 = null;

    //update the object name if exists, or create new
    item1 = (SpecNodeItem) sortElements.get(s);
    if (item1 == null) {
      item1 = new SpecNodeItem(s);
      item1.key = s;
      sortElements.put(s,item1);
    }

    //update the object name if exists, or create new
    item2 = (SpecNodeItem) sortElements.get(c);
    if (item2 == null) {
      item2 = new SpecNodeItem(c);
      item2.key = c;
      sortElements.put(c,item2);
    }
    item1.supplies.addElement(new SpecDependency(p,item2));
    item2.consumes.addElement(new SpecDependency(p,item1));
  }

  //The classes for specification items.

  class SpecTypeItem {            //note this one is special 
    public String label = "";
    public Vector instances = new Vector();
    SpecTypeItem(String label) {
      this.label = label;
    }
  }
 
  class SpecItem {                //root spec item class.
    public String label = "";
    public String id = "";
    public String type = "";
    public String resourceType = "";
    public boolean isResource=false;
    public String unit = "";
    SpecItem(String id) {
      this.id = id;
    }
  }

  class SpecEntityItem extends SpecItem {
    public String parent = "";
    SpecEntityItem(String id) {
      super(id);
    }
  }

  class SpecProcessItem extends SpecItem {
    public Vector variables = new Vector();
    public String expands = "";
    public String level = "";
    public SpecActSpecItem as = null;
    public boolean taskProcess = false;
    public boolean execProcess = false;
    SpecProcessItem(String id) {
      super(id);
    }
  }

  class SpecLevelItem extends SpecItem {
    public Vector processes = new Vector();
    public int number = 0;
    public boolean processed = false;
    SpecLevelItem(String id) {
      super(id);
    }
  }

  class SpecActSpecItem extends SpecItem {
    public Vector constraints = new Vector();
    SpecActSpecItem(String id) {
      super(id);
    }
  }

  class SpecConstrItem extends SpecItem {
    SpecNodeItem node = null;
    String tp1 = "";
    String tp2 = "";
    String relation = "";
    int xpos = -1;
    int ypos = -1;
    String key = "";

    SpecConstrItem(String id) {
      super(id);
    }
  }

  //used to store the GOST contributors
  class SpecDependency {
    public String pattern = "";
    public SpecNodeItem node = null; //supplier or consumer

    SpecDependency(String pattern, SpecNodeItem node){
      this.pattern = pattern;
      this.node = node;
    }
  }

  class SpecNodeItem extends SpecItem {
    public String pattern = "";
    public SpecProcessItem expansion = null;
    public String key = "";
    public String beginTimePoint = "";
    public String endTimePoint = "";
    //extensions, view-specific
    public int xpos = 10;
    public int ypos = 10;
    //extensions, concept-specific
    public Vector supplies = new Vector();
    public Vector consumes = new Vector();

    int assignedNumber = 0;
    SpecNodeItem(String id) {
      super(id);
    }
  }

  class SpecUnitItem extends SpecItem {
    public String unitType = "";
    SpecUnitItem(String id) {
      super(id);
    }
  }

  class SpecVarItem extends SpecItem {
    public int pos = 0;
    SpecVarItem(String id) {
      super(id);
    }
  }

  public String replaceKey(String text, String pattern, String newPattern) {
    //uses a modified rabin-karp algo for text search

    String outString = "";
    long q = 2113929255l, d = 32, d_bits = 5;
    int hit = 0;
    char[] a = text.toCharArray();
    char[] p = pattern.toCharArray();
    int M = p.length, N = a.length;
    long h1 = 0, h2 = 0, dM = 1;
    int i;

    for(i = 0; i < M - 1; i++)
      dM = (dM << d_bits) % q;
      
    for(i = 0; i < M; i++) {
      h1 = ((h1 << d_bits) + (long)p[i]) % q;
      h2 = ((h2 << d_bits) + (long)a[i]) % q;
    }

    /* There's got to be a string in here somewhere */
    i = 0;
    while(h1 != h2 && i < N - M) {
      h2 = (h2 + (q << d_bits) - (long)a[i] * dM) % q;
      h2 = ((h2 << d_bits) + (long)a[i + M]) % q;
      i++;
    }
      
    /* no match */
    if(i >= N - M) {
      hit = -1;
      return text;
    }

    /* match */
    hit = i;
    outString = text.substring(0,i) + newPattern + text.substring(i+M);
    //System.out.println("Match: " + text + " " + pattern + " " + i +" "+ M);
    return outString;
  }
}
