/*
* @(#)CpeSpec.java	1.0 98-Sept-17
* 
*/

import java.util.*;

/**
 * Common Process Editor (CPE) specification class.
 *
 * This class accumulates the parsed domain specification and translates
 * it to the internal cpe structures.
 *
 *  who     when                why
 *  STP     2-Oct-98     Adding GOST and TOME import.   
 *  STP     6-Oct-98     Adding Resource import.
 *
 * @version 1.0 98/9/17
 * @author Steve Polyak
 */

public class CpeSpec extends Object 
{

  Hashtable nodes = new Hashtable(); //stores all node objects
  Vector include_c = new Vector();
  Vector ordering_c = new Vector();
  Vector start_c = new Vector();
  Vector finish_c = new Vector();
  Vector begin_c = new Vector();
  Vector end_c = new Vector();
  Vector tome = new Vector();
  Vector gost = new Vector();
  Vector resources = new Vector();

  long cCount = 0;
  long processCount = 0;
  long tpCount = 0;
  long nodeCount = 0;
  int alwaysCount = 1;
  int outputCount = 1;
  int inputCount = 1;
  int resourceCount = 1;

  SpecTomeEntry tomeEntry = null;
  SpecGostEntry gostEntry = null;
  SpecContribEntry contribEntry = null;
  SpecResourceEntry resourceEntry = null;

  java.io.PrintStream stream = null;

  CpeSpec() {
  }

  public void reset() {
    nodes = new Hashtable();
    include_c = new Vector();
    ordering_c = new Vector();
    start_c = new Vector();
    finish_c = new Vector();
    begin_c = new Vector();
    end_c = new Vector();
    tome = new Vector();
    gost = new Vector(); 
    resources = new Vector();

    stream = null;
    cCount = 0;
    processCount = 0;
    tpCount = 0;
    nodeCount = 0;
    alwaysCount = 1;
    outputCount = 1;
    inputCount = 1;
  }

  // writeout is the main writing driver.
  public void writeOut(java.io.PrintStream stream) {
    this.stream = stream;

    writeHeader();
    writePlan();
    writeAlways();
    writeSorts();
  }

  public void writeHeader() {
    stream.println("// Common Process Translator O-Plan Output --> CPL");
    stream.println("// Author: Steve Polyak, Dept. AI, Edinburgh University");
    stream.println("// CPL generated on: " + new Date());
    stream.println("");
  }

  private void writeAlways() {

    for  (Enumeration e  = tome.elements(); e.hasMoreElements();) {      
      SpecTomeEntry entry = (SpecTomeEntry) e.nextElement();
      if (entry.nodeEnd.ref.equals(":always")) {
	String cId = "AC"+alwaysCount;
	alwaysCount++;
	stream.println("constraint.expression("+cId+")=\"{"+
		       entry.pattern.replace('(',' ').replace(')',' ').trim() +
		       "}=" + entry.value.replace('\"',' ').trim() + 
		       "\"");
      }
    }
  }
      
  public void writeSorts() {
    int i=0;
    String sortList = "";

    i=0;sortList="";
    for  (Enumeration e  = include_c.elements(); e.hasMoreElements();i++) {
      String temp = (String) e.nextElement();
      if (i==0) sortList = temp;
      else sortList = sortList + "," + temp;
    }
    stream.println("SORT cpo-include-constraint={"+sortList+"}");

    i=0;sortList="";
    for  (Enumeration e  = ordering_c.elements(); e.hasMoreElements();i++) {
      String temp = (String) e.nextElement();
      if (i==0) sortList = temp;
      else sortList = sortList + "," + temp;
    }
    stream.println("SORT cpo-ordering-constraint={"+sortList+"}");

    i=0;sortList="";
    for  (Enumeration e  = start_c.elements(); e.hasMoreElements();i++) {
      String temp = (String) e.nextElement();
      if (i==0) sortList = temp;
      else sortList = sortList + "," + temp;
    }
    stream.println("SORT cpo-start={"+sortList+"}");

    i=0;sortList="";
    for  (Enumeration e  = finish_c.elements(); e.hasMoreElements();i++) {
      String temp = (String) e.nextElement();
      if (i==0) sortList = temp;
      else sortList = sortList + "," + temp;
    }
    stream.println("SORT cpo-finish={"+sortList+"}");

    i=0;sortList="";
    for  (Enumeration e  = begin_c.elements(); e.hasMoreElements();i++) {
      String temp = (String) e.nextElement();
      if (i==0) sortList = temp;
      else sortList = sortList + "," + temp;
    }
    stream.println("SORT cpo-begin={"+sortList+"}");

    i=0;sortList="";
    for  (Enumeration e  = end_c.elements(); e.hasMoreElements();i++) {
      String temp = (String) e.nextElement();
      if (i==0) sortList = temp;
      else sortList = sortList + "," + temp;
    }
    stream.println("SORT cpo-end={"+sortList+"}");

    sortList="";
    for  (i=1; i < processCount; i++) {
      String temp = "P"+i;
      if (i==1) sortList = temp;
      else sortList = sortList + "," + temp;
    }
    stream.println("SORT cpo-process={"+sortList+"}");

    sortList="";
    for  (i=1; i < processCount; i++) {
      String temp = "AS"+i;
      if (i==1) sortList = temp;
      else sortList = sortList + "," + temp;
    }
    stream.println("SORT cpo-activity-specification={"+sortList+"}");

    sortList="";
    for  (i=0; i < tpCount; i++) {
      String temp = "T"+i;
      if (i==0) sortList = temp;
      else sortList = sortList + "," + temp;
    }
    stream.println("SORT cpo-timepoint={"+sortList+"}");

    i=0;sortList="";
    SpecNodeItem item = null;
    for  (Enumeration e =  nodes.elements(); e.hasMoreElements() ;)  {
      item = (SpecNodeItem) e.nextElement();
      if (item.type.toUpperCase().equals("ACTION")) {
	if (i==0) sortList = item.id;
	else sortList = sortList + "," + item.id;
      }
      i++;
    }
    stream.println("SORT cpo-action={"+sortList+"}");

    sortList="";
    for  (i=1; i < outputCount; i++) {
      String temp = "OUT"+i;
      if (i==1) sortList = temp;
      else sortList = sortList + "," + temp;
    }
    stream.println("SORT cpo-output-constraint={"+sortList+"}");

    sortList="";
    for  (i=1; i < inputCount; i++) {
      String temp = "INP"+i;
      if (i==1) sortList = temp;
      else sortList = sortList + "," + temp;
    }
    stream.println("SORT cpo-input-constraint={"+sortList+"}");

    sortList="";
    for  (i=1; i < resourceCount; i++) {
      String temp = "RES"+i;
      if (i==1) sortList = temp;
      else sortList = sortList + "," + temp;
    }
    stream.println("SORT cpo-resource-constraint={"+sortList+"}");

    sortList="";
    for  (i=1; i < alwaysCount; i++) {
      String temp = "AC"+i;
      if (i==1) sortList = temp;
      else sortList = sortList + "," + temp;
    }
    stream.println("SORT cpo-always-constraint={"+sortList+"}");
  }

  public void writePlan() {
    SpecNodeItem startNode = null;
    SpecNodeItem finishNode = null;
    SpecNodeItem item = null;
    SpecOrdItem ordItem = null;
    String tempId = "";

    stream.println("SORT cpo-plan={P0}");
    stream.println("process.label(P0)=\"Plan-0\"");
    stream.println("process.activity-spec(P0,AS0)");

    //locate the start and finish nodes
    for  (Enumeration e =  nodes.elements(); e.hasMoreElements() ;)  {
      item = (SpecNodeItem) e.nextElement();
      if (item.type.toUpperCase().equals("START"))
	startNode = item;
      else if (item.type.toUpperCase().equals("FINISH"))
	finishNode = item;
    }

    //output the start information
    startNode.visited = true;
    start_c.addElement(startNode.id);
    stream.println("node.label("+startNode.id+")=\"Start\"");
    startNode.endTp = "T"+tpCount++;
    stream.println("process.start-timepoint(P0)="+startNode.endTp);
    stream.println("start.timepoint("+startNode.id+")="+startNode.endTp);
    tempId = getIC();
    stream.println("include-node("+tempId+")="+startNode.id);
    stream.println("member("+tempId+",AS0)");

    //output the finish information
    finishNode.visited = true;
    finish_c.addElement(finishNode.id);
    stream.println("node.label("+finishNode.id+")=\"Finish\"");
    finishNode.beginTp = "T"+tpCount++;
    stream.println("process.finish-timepoint(P0)="+finishNode.beginTp);
    stream.println("finish.timepoint("+finishNode.id+")="+finishNode.beginTp);
    tempId = getIC();
    stream.println("include-node("+tempId+")="+finishNode.id);
    stream.println("member("+tempId+",AS0)");

    //process any overall resource constraints.
    SpecResourceEntry rEntry = null;
    for  (Enumeration e =  resources.elements(); e.hasMoreElements() ;)  {
      rEntry = (SpecResourceEntry) e.nextElement();
      if (rEntry.ref.equals("\"NODE\"")) {
	tempId = "RES" + resourceCount;
	resourceCount++;
	stream.println("constraint.expression("+tempId+")=\"consumes {"+
		       rEntry.value.replace('(',' ').replace(')',' ')
		       .replace('"',' ').trim() +
		       "}=[" + rEntry.min + "," + rEntry.max +  
		       "] at OVERALL\"");
	stream.println("member("+tempId+",AS0)");
      }
    }
    
    processCount++;
    
    //now process the endSuccs of the start node
    for  (Enumeration e =  startNode.endSucc.elements(); 
	  e.hasMoreElements() ;)  {
      ordItem = (SpecOrdItem) e.nextElement();
      processNode(ordItem,"AS0");
      tempId = getOC();
      stream.println("constraint.expression("+tempId+")=\"before("+
		     startNode.endTp + "," +
		     ((ordItem.pos.equals("begin_of")) ? ordItem.node.beginTp
		      : ordItem.node.endTp) + ")\"");
      stream.println("member("+tempId+",AS0)");
    }
  }

  public void processNode(SpecOrdItem ordItem, String actSpec) {

    String tempId = "";
    String endTp = "";
    String processSpec = "";
    SpecOrdItem ordItem2 = null;
    SpecOrdItem ordItem3 = null;
    SpecOrdItem ordItem4 = null;

    //do not process nodes that have already been visited.
    if(ordItem.node.visited == true) return;

    //writeout node info
    ordItem.node.visited = true;
    stream.println("node.label("+ordItem.node.id+")=\""+
		   ordItem.node.label.replace('(',' ')
		   .replace(')',' ').trim() + "\"");
    ordItem.node.beginTp = "T"+tpCount++;
    ordItem.node.endTp = "T"+tpCount++;
    stream.println("activity.begin-timepoint("+
		   ordItem.node.id+")="+ordItem.node.beginTp);
    stream.println("activity.end-timepoint("+
		   ordItem.node.id+")="+ordItem.node.endTp);
    stream.println("activity.pattern("+
		   ordItem.node.id+")=\""+
		   ordItem.node.label.replace('(',' ')
		   .replace(')',' ').trim() + "\"");
    tempId = getIC();
    stream.println("include-node("+tempId+")="+ordItem.node.id);
    stream.println("member("+tempId+","+actSpec+")");

    //process any resource constraints for this node.
    SpecResourceEntry rEntry = null;
    for  (Enumeration e =  resources.elements(); e.hasMoreElements() ;)  {
      rEntry = (SpecResourceEntry) e.nextElement();
      if (rEntry.ref.equals("\""+ordItem.node.id+"\"")) {
	tempId = "RES" + resourceCount;
	resourceCount++;
	stream.println("constraint.expression("+tempId+")=\"consumes {"+
		       rEntry.value.replace('(',' ').replace(')',' ')
		       .replace('"',' ').trim() +
		       "}=[" + rEntry.min + "," + rEntry.max +  
		       "] at " + ordItem.node.id + "\"");
	stream.println("member("+tempId+","+actSpec+")");
      }
    }

    //now process the endSuccs of this node (for this spec)
    for  (Enumeration e =  ordItem.node.endSucc.elements(); 
	  e.hasMoreElements() ;)  {
      ordItem2 = (SpecOrdItem) e.nextElement();
      processNode(ordItem2,actSpec);
      tempId = getOC();
      stream.println("constraint.expression("+tempId+")=\"before("+
		     ordItem.node.endTp + "," +
		     ((ordItem2.pos.equals("begin_of")) ? ordItem2.node.beginTp
		      : ordItem2.node.endTp) + ")\"");
      stream.println("member("+tempId+","+actSpec+")");
    }

    //peek in the TOME to see if it has effects recorded there.
    for  (Enumeration e  = tome.elements(); e.hasMoreElements();) {      
      SpecTomeEntry entry = (SpecTomeEntry) e.nextElement();
      
      if (entry.nodeEnd.ref.equals(ordItem.node.id)) {
	String cId = "OUT"+outputCount;
	outputCount++;
	stream.println("constraint.expression("+cId+")=\"{"+
		       entry.pattern.replace('(',' ').replace(')',' ').trim() +
		       "}=" + entry.value.replace('\"',' ').trim() + 
		       " at " + entry.nodeEnd.ref + "\"");
	stream.println("member("+cId+","+actSpec+")");
      }
    }

    //peek in the GOST to see if it has conditions recorded there.
    for  (Enumeration e  = gost.elements(); e.hasMoreElements();) {      
      SpecGostEntry entry = (SpecGostEntry) e.nextElement();
      
      if (entry.nodeEnd.ref.equals(ordItem.node.id)) {
	String cId = "INP"+inputCount;
	inputCount++;
	stream.println("constraint.expression("+cId+")=\"{"+
		       entry.pattern.replace('"',' ')
		       .replace('(',' ').replace(')',' ').trim() +
		       "}=" + entry.value.replace('\"',' ').trim() + 
		       " at " + entry.nodeEnd.ref + "\"");
	stream.println("member("+cId+","+actSpec+")");
	
	for  (Enumeration e1  = entry.contributors.elements(); 
	      e1.hasMoreElements();) {      
	  SpecContribEntry cEntry = (SpecContribEntry) e1.nextElement();
	  stream.println("dependency("+entry.nodeEnd.ref +
			 "," + entry.pattern +","+cEntry.nodeEnd.ref+")");
	}
      }
    }

    //if it has an expansion, we have to create a new process and attach it
    if (ordItem.node.subStarts.size() > 0) {
      String processKey = "P"+processCount;
      processSpec = "AS"+processCount;

      stream.println("process.label("+processKey+
		     ")=\"Process-"+processCount+"\"");
      stream.println("process.activity-spec("+processKey+
		     ","+processSpec+")");
      stream.println("process.expands("+processKey+")="+
		     ordItem.node.id);

      processCount++;

      //output the begin information
      String beginKey = "N"+nodeCount++;
      String beginTp = "T"+tpCount++;
      begin_c.addElement(beginKey);
      stream.println("node.label("+beginKey+")=\"Begin\"");
      stream.println("process.start-timepoint("+processKey+")="+beginTp);
      stream.println("start.timepoint("+beginKey+")="+beginTp);
      tempId = getIC();
      stream.println("include-node("+tempId+")="+beginKey);
      stream.println("member("+tempId+","+processSpec+")");

      //output the end information
      String endKey = "N"+nodeCount++;
      endTp = "T"+tpCount++;
      end_c.addElement(endKey);
      ordItem.node.expansionEnd = endTp;
      stream.println("node.label("+endKey+")=\"End\"");
      stream.println("process.finish-timepoint("+processKey+")="+endTp);
      stream.println("finish.timepoint("+endKey+")="+endTp);
      tempId = getIC();
      stream.println("include-node("+tempId+")="+endKey);
      stream.println("member("+tempId+","+processSpec+")");

      for  (Enumeration e =  ordItem.node.subStarts.elements();
	    e.hasMoreElements() ;)  {
	ordItem3 = (SpecOrdItem) e.nextElement();
	processNode(ordItem3,processSpec);
	tempId = getOC();
	stream.println("constraint.expression("+tempId+")=\"before("+
		       beginTp + "," +
		       ((ordItem3.pos.equals("begin_of")) ?
			ordItem3.node.beginTp
			: ordItem3.node.endTp) + ")\"");
	stream.println("member("+tempId+","+processSpec+")");
      }
    }

    if (ordItem.node.subFinishes.size() > 0) {
      for  (Enumeration e =  ordItem.node.subFinishes.elements();
	    e.hasMoreElements() ;)  {
	ordItem4 = (SpecOrdItem) e.nextElement();
	tempId = getOC();
	stream.println("constraint.expression("+tempId+")=\"before("+
		       ordItem.node.endTp + 
		       "," + ordItem4.node.expansionEnd +
		       ")\"");
	stream.println("member("+tempId+","+actSpec+")");      
      }
    }
  }

  public String getIC () {
    String id = "";

    id = "C"+cCount++;
    include_c.addElement(id);
    return id;
  }

  public String getOC () {
    String id = "";

    id = "C"+cCount++;
    ordering_c.addElement(id);
    return id;
  }

  public SpecNodeItem nodeReference(String ref) {
    SpecNodeItem item = null;

    ref = ref.toUpperCase().replace('-','_');

    //update the object name if exists, or create new
    item = (SpecNodeItem) nodes.get(ref);
    if (item == null) {
      item = new SpecNodeItem(ref);
      item.id = ref;
      nodes.put(ref,item);
    }
    return item;
  }

  public void nodeType(String ref, String type) {
    SpecNodeItem item = null;

    ref = ref.toUpperCase().replace('-','_');
    //update the object name if exists, or create new
    item = nodeReference(ref);
    item.type = type;
  }

  public void nodeLabel(String ref, String label) {
    SpecNodeItem item = null;
    ref = ref.toUpperCase().replace('-','_');

    //update the object name if exists, or create new
    item = nodeReference(ref);
    item.label = label.replace('"',' ').trim();
  }

  public void begPred(String ref, String pos, String ref2) {
    //ignoring this information
  }

  public void begSucc(String ref, String pos, String ref2) {
    SpecNodeItem item = null;
    SpecNodeItem item2 = null;
    ref = ref.toUpperCase().replace('-','_');
    ref2 = ref2.toUpperCase().replace('-','_');

    //ignoring info telling us the beg is before the end.
    //If the key successfully substrings then we know this is a subactivity.
    //otherwise, we record it.

    if (!(ref.equals(ref2))) {
      item = nodeReference(ref);
      item2 = nodeReference(ref2);
      if (ref2.startsWith(ref)) {
	//this is a subactivity
	item.subStarts.addElement(new SpecOrdItem(item2,pos));
      }
      else {
	//this is a same process-level ordering
	item.begSucc.addElement(new SpecOrdItem(item2,pos));
      }
    }
  }

  public void endPred(String ref, String pos, String ref2) {
    //ignoring this information
  }

  public void endSucc(String ref, String pos, String ref2) {

    SpecNodeItem item = null;
    SpecNodeItem item2 = null;
    ref = ref.toUpperCase().replace('-','_');
    ref2 = ref2.toUpperCase().replace('-','_');

    //If the key successfully substrings then we know this is a subactivity.
    //otherwise, we record it.

    item = nodeReference(ref);
    item2 = nodeReference(ref2);

    if (ref.startsWith(ref2)) {
      //this is a subactivity
      item.subFinishes.addElement(new SpecOrdItem(item2,pos));
    }
    else {
      //this is a same process-level ordering
      item.endSucc.addElement(new SpecOrdItem(item2,pos));
    }
  }

  //simple data structure to maintain pos/node pairings in the list
  class SpecOrdItem {
    public SpecNodeItem node = null;
    public String pos = "";
    SpecOrdItem (SpecNodeItem node, String pos) {
      this.node = node;
      this.pos = pos;
    }
  } 

  //root spec item class.
  class SpecItem {                
    public String label = "";
    public String id = "";
    public String type = "";
    SpecItem(String id) {
      this.id = id;
    }
  }

  class SpecNodeItem extends SpecItem {
    public boolean visited = false;
    public Vector endSucc = new Vector();
    public Vector begSucc = new Vector();
    public Vector subStarts = new Vector();
    public Vector subFinishes = new Vector();
    public String beginTp = "";
    public String endTp = "";
    public String expansionEnd = "";

    SpecNodeItem(String id) {
      super(id);
    }
  }

  class SpecNodeEnd {
    public String ref = "";
    public String end = "";
  }

  class SpecTomeEntry {
    public String pattern = "";
    public String value = "";
    public SpecNodeEnd nodeEnd = null;
  }

  class SpecGostEntry {
    public String type = "";
    public String pattern = "";
    public String value = "";
    public SpecNodeEnd nodeEnd = null;
    Vector contributors = new Vector();
  }

  class SpecContribEntry {
    public String method = "";
    public SpecNodeEnd nodeEnd = null;
  }

  class SpecResourceEntry {
    public String ref = "";
    public String min = "";
    public String value = "";
    public String max = "";
    public String parent = "";
    SpecResourceEntry(String ref) {
      this.ref = ref;
    }
  }

  // importer is the main driver for importing an oplan file.
  public void importer() {
  }

  // GOST specification methods.
  void gostType(String type) {
    gostEntry = new SpecGostEntry();
    gostEntry.type = type;
  }

  void gostPattern(String pattern) {
    gostEntry.pattern = pattern;
  }

  void gostValue(String value) {
    gostEntry.value = value;
  }

  void gostNodeEnd(String ref, String end) {
    gostEntry.nodeEnd = new SpecNodeEnd();
    gostEntry.nodeEnd.ref = ref.toUpperCase().replace('-','_');
    gostEntry.nodeEnd.end = end;
  }

  void gostContrNodeEnd(String ref, String end) {
    contribEntry = new SpecContribEntry();
    contribEntry.nodeEnd = new SpecNodeEnd();
    contribEntry.nodeEnd.ref = ref.toUpperCase().replace('-','_');
    contribEntry.nodeEnd.end = end;
  }

  void gostMethod(String method) {
    contribEntry.method = method;
    gostEntry.contributors.addElement(contribEntry);
  }

  void gostStop() {
    gost.addElement(gostEntry);
  }

  //TOME specification methods.
  void tomePattern(String pattern) {
    tomeEntry = new SpecTomeEntry();
    tomeEntry.pattern = pattern.replace('\"',' ').trim();
  }

  void tomeNodeEnd(String ref) {
    //for always end
    tomeEntry.nodeEnd = new SpecNodeEnd();
    tomeEntry.nodeEnd.ref = ref;
  }

  void tomeNodeEnd(String ref, String end) {
    tomeEntry.nodeEnd = new SpecNodeEnd();
    tomeEntry.nodeEnd.ref = ref.toUpperCase().replace('-','_');
    tomeEntry.nodeEnd.end = end;
  }

  void tomeValue(String value) {
    tomeEntry.value = value;
    tome.addElement(tomeEntry);
  }

  //Resource specification methods.
  void resourceNode(String ref) {
    resourceEntry = new SpecResourceEntry(ref.toUpperCase().replace('-','_'));
  }
  void resourceValue(String value) {
    resourceEntry.value = value;
  }
  void resourceMinMax(String min, String max) {
    resourceEntry.min = min;
    resourceEntry.max = max;
  }
  void resourceParent(String ref) {
    resourceEntry.parent = ref;
  }
  void resourceChildrenItem(String ref) {
    //ignoring children info
  }
  void resourceStop() {
    resources.addElement(resourceEntry);
  }
}
