/*
 * @(#)CpeRationScrollPane.java	1.0 98/4/28
 */

import com.sun.java.swing.*;
import java.awt.*;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import java.util.*;
import java.net.*;
import CpeRationPanel;

/**
 * CpeRationScrollPane provides a scrollable viewport onto the
 * CpeRationPanel. 
 *
 * @version 1.0 98/1/5
 * @author Steve Polyak
 */
class CpeRationScrollPane extends JScrollPane {
  public CpeMainPanel mainPanel;
  public CpeRationPanel panel;
  
  public CpeRationScrollPane(CpeMainPanel mainPanel, int layer, boolean top) {
    super();
    this.mainPanel = mainPanel;
    
    JPanel p = new JPanel();
    p.setSize(800,800);
    p.setOpaque(false);
    p.setLayout(new BorderLayout() );
    
    panel = new CpeRationPanel(mainPanel, top);
    panel.setOpaque(false);
    
    p.add(panel, BorderLayout.CENTER);
    
    getViewport().add(p);
  }
    
  public Dimension getMinimumSize() {
    return new Dimension(25, 25);
  }
  
  public boolean isOpaque() {
    return true;
  }
}

