/*
 * @(#)CpePosEdge.java	1.0 98/1/5
 * 
 */

import java.util.*;
import java.awt.*;
import CpeNode;

/**
 * CpePosEdge is a specialized process edge that denotes the equality of
 * of two process node's timepoints.
 *
 * @version 1.0 98/1/5
 * @author Steve Polyak 
 */
class CpePosEdge extends CpeEdge {
  
  CpePosEdge(CpeNode from, boolean fromPos, CpeNode to, boolean toPos){
    super(from, fromPos, to, toPos);
  }
    
  public void draw(Graphics g, FontMetrics fm) {

    if (m_from == null || m_to == null)
      return;

    int y1 = m_from.m_y;
    int y2 = m_to.m_y;
    int x1, x2;

    if (m_selected)
      g.setColor(m_selectedColor);
    else
      g.setColor(m_edgeColor);
    
    int wFrom = m_from.calcWidth(fm);
    int wTo = m_to.calcWidth(fm);

    if (fromPosition) {
      //drawing from the begin of the "from node"
      x1 = (m_from.m_x - wFrom/2);
    }
    else {
      //drawing from the end of the "from node"
      x1 = (m_from.m_x + wFrom/2);
    }

    if (toPosition) {
      //drawing to the begin of the "to node"
      x2 = (m_to.m_x - wTo/2);
    }
    else {
      //drawing to the end of the "to node"
      x2 = (m_to.m_x + wTo/2);
    }

    g.drawLine(x1, y1, x2, y2);
  }
  
  public void drawArrow(Graphics g, FontMetrics fm) {
  }
}
