/*
 * @(#)CpeNodePropertyDialog.java	1.0 98/1/5
 * 
 */

import java.awt.*;
import CpeProcessPanel;
import Cpe;
import com.sun.java.swing.*;
import java.awt.event.*;
import java.util.*;

/**
 * CpeNodePropertyDialog is used to display/set properties of the
 * nodes in the processes network.
 *
 * @version 1.0 98/1/5
 * @author Steve Polyak 
 */
public class CpeNodePropertyDialog extends JDialog {
  protected Button btnOK;
  protected Button btnCancel;
  protected JTextArea txtName = null;
  protected CpeProcessPanel m_panel = null;
  protected String m_oldText = "";
  protected String m_oldKey = "";
  protected Choice m_status = null;
  protected JTextField varInput;
  protected DefaultListModel varList;
  protected JTabbedPane tab;
  
  public CpeNodePropertyDialog(CpeProcessPanel parent, String title) {
    // Create a dialog with the specified title
    super(Cpe.sharedInstance().getFrame(), title, false);
    m_panel = parent;
    
    tab = new JTabbedPane();

    this.getContentPane().setLayout(new BorderLayout(25,5));

    JPanel fields = new JPanel();
    fields.setLayout(new GridLayout(3,2));

    fields.add (new Label("Activity Key:"));
    if (m_panel.m_hitNode != null) {
      fields.add (new Label(m_panel.m_hitNode.m_key));
    }

    fields.add (new Label("Activity Name:"));
    if (m_panel.m_hitNode != null) {
      m_oldText = m_panel.m_hitNode.m_lbl;
      m_oldKey = m_panel.m_hitNode.m_key;
    }
    txtName = new JTextArea(m_oldText);
    fields.add(new JScrollPane(txtName));
    fields.add (new Label("Activity Status:"));
    m_status = new Choice();
    m_status.addItem("Not Yet");
    m_status.addItem("Complete");
    m_status.addItem("Executing");
    m_status.addItem("Possible");
    m_status.addItem("Impossible");
    m_status.select(m_panel.m_hitNode.m_status);
    fields.add (m_status);

    tab.addTab("General",null,fields);

    //variables gui
    JPanel varPanel = new JPanel();
    varPanel.setLayout(new BorderLayout(25,5));
    JPanel varPanel1 = new JPanel();
    varPanel1.setLayout(new GridLayout(2,2));
    varInput = new JTextField();
    varPanel1.add(varInput);
    varList = new DefaultListModel();
    varPanel1.add(new JScrollPane
		  (new JList(varList), 
		   ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS,
		   ScrollPaneConstants.HORIZONTAL_SCROLLBAR_ALWAYS));
    varPanel.add("Center",varPanel1);

    JPanel varPanel2 = new JPanel();
    JButton addVBtn = new JButton("Add");
    addVBtn.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	varList.addElement(varInput.getText());
	varInput.setText("");
      }
    });
    varPanel2.add(addVBtn);
    JButton delVBtn = new JButton("Delete");
    delVBtn.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	varList.removeAllElements();
      }
    });
    varPanel2.add(delVBtn);
    varPanel.add("South",varPanel2);
    tab.addTab("Variables",null,varPanel);
    
    this.getContentPane().add("Center",tab);
    
    JPanel yn = new JPanel();
    btnOK = new Button("OK");
    yn.add (btnOK);
    btnCancel = new Button("Cancel");
    yn.add (btnCancel);
    this.getContentPane().add ("South",yn);
    
    importLists();

    this.setBounds(0,0,360,240);
  }
  
  // Pop down the window when the button is clicked.
  public boolean action(Event e, Object arg) {
    if (e.target == m_status)
      return false;
    
    if("Cancel".equals(arg) == false) {
      //update value as long as cancel wasn't pressed.
      String tempString = txtName.getText();
      m_panel.process.renameNode(m_oldKey, tempString);
      m_panel.m_hitNode.setStatus(m_status.getSelectedIndex());
      updateLists();
    }
    this.hide();
    this.dispose();
    m_panel.process.m_sheet = null;
    m_panel.repaint();
    
    return true;
  }

  private void updateLists() {
    String s = new String();
    for  (Enumeration e =  varList.elements() ; e.hasMoreElements()  ;)  
      {s = (String) e.nextElement();
      m_panel.m_hitNode.variables.addElement(s); }
  }

  private void importLists() {
    String s = new String();
    for  (Enumeration e =  m_panel.m_hitNode.variables.elements() ; 
	  e.hasMoreElements()  ;)  
      {s = (String) e.nextElement(); varList.addElement(s); }
  }

}
