/*
 * @(#)CpeNode.java	1.0 98/1/5
 * 
 */

import java.util.*;
import java.awt.*;

/**
 * CpeNode is the base class representing a node in the process network.
 * Specialized nodes will inherit from this class.
 *
 * @version 1.0 98/1/5
 * @author Steve Polyak 
 */
class CpeNode {
  int m_x;
  int m_y;
  Rectangle m_rect;
  String m_lbl;
  String pattern ="";
  String m_key;
  String tempSaveKey = ""; //used in save
  String expansion = "";
  String rationale = "";
  Vector variables;
  
  //For Toplogical Sort Check
  boolean visitedBegin = false;
  boolean visitedEnd = false;
  int beginNumber = 0;
  int endNumber = 0;

  // Flags
  boolean m_selected = false;
  boolean hasExpansion = false;
  boolean hasRationale = false;
  
  // status:
  // 0 = not yet
  // 1 = complete
  // 2 = executing
  // 3 = possible 
  // 4 = impossible
  int m_status = 0;
  
  // Graphics properties
  final Color m_nodeColor = Color.white;
  final Color m_selectedColor = Color.pink;

  protected  Color  m_statusColors[] =  { new Color(0xFFFFFF),
					  new Color(0x99ffff),
					  new Color(0x99ff99),
					  new Color(0xffcc66),
					  new Color(0xff6699) };
  
  CpeNode(String key,int x, int y) {
    m_key = key;
    m_lbl = key;
    m_rect = new Rectangle(x, y, 0, 0);
    m_x = x;
    m_y = y;
    variables = new Vector();
  }
  
  public void setStatus(int status) {
    m_status = status;
  }
 
  public void setPattern(String pattern) {
    this.pattern = pattern;
  }

  public void setRightPosition(int pos, FontMetrics fm) {
    int w = calcWidth(fm) + 10;
    int left = pos - w;
    m_x = left + w/2;
  }
 
  public void setLeftPosition(int pos, FontMetrics fm) {
    int w = calcWidth(fm) + 10;
    m_x = pos + w/2;
  }
  
  public void draw(Graphics g, FontMetrics fm) {
    int x = m_x;
    int y = m_y;
    
    int h = fm.getHeight() + 4;
    int count = rowCount();
    int w = calcWidth(fm) + 10;
   
    m_rect.width = w;
    m_rect.height = h * count;
    m_rect.x = x - w/2;
    m_rect.y = y - m_rect.height / 2;

    //if has expansion, draw a shadow
    if (hasExpansion) {
      g.setColor(Color.darkGray);
      drawShadow(g,(x - w/2)+3, (y - m_rect.height / 2)+3, w, m_rect.height);
    }

    //set node color
    if (m_selected)
      g.setColor(m_selectedColor);
    else
      g.setColor(m_statusColors[m_status]);
    //draw node
    drawFill(g,x - w/2, y - m_rect.height / 2, w, m_rect.height);
    
    g.setColor(Color.black);
    //draw border and label
    drawOutline(g,x - w/2, y - m_rect.height / 2, w-1, m_rect.height-1);

    //new flag to switch on node keys
    String label = new String(m_lbl);
    if (Cpe.sharedInstance().nodeKeysFlag) {
      label = m_key + "\n" + label;
    }

    //draw multi-line label
    int rowCount = 0;
    StringTokenizer st2 = new StringTokenizer(label, "\n");
    for  (Enumeration  e  = st2; e.hasMoreElements()  ; rowCount++)  {	
      String temp = (String) e.nextElement();
      g.drawString(temp, x - (w-10)/2, (y - (m_rect.height-4)/2) +
		   fm.getAscent() + (rowCount * h));      
    }
  }

  public int calcWidth(FontMetrics fm) {
    
    int w = 0;
    String temp = null;

    //new flag to switch on node keys
    String label = new String(m_lbl);
    if (Cpe.sharedInstance().nodeKeysFlag) {
      label = m_key + "\n" + label;
    }

    //calc multi-line width
    StringTokenizer st1 = new StringTokenizer(label, "\n");
    for  (Enumeration  e  = st1; e.hasMoreElements()  ;)  {	
      temp = (String) e.nextElement();
      if (fm.stringWidth(temp) > w)      
	w = fm.stringWidth(temp);      
    }
    return w;
  }

  public int rowCount() {
    //calc # of lines
    int count = 0;

    //new flag to switch on node keys
    String label = new String(m_lbl);
    if (Cpe.sharedInstance().nodeKeysFlag) {
      label = m_key + "\n" + label;
    }

    StringTokenizer st1 = new StringTokenizer(label, "\n");
    for (Enumeration  e  = st1; e.hasMoreElements(); count++)  
      {e.nextElement();}
    return count;
  }
  
  public void drawFill(Graphics g, int x, int y, int width, int height) {
    g.fillRect(x, y, width, height);
  }
  
  public void drawShadow(Graphics g, int x, int y, int width, int height) {
    g.fillRect(x, y, width, height);
  }
  
  public void drawOutline(Graphics g, int x, int y, int width, int height) {
    g.drawRect(x, y, width, height);
  }

  public boolean isBegin(Point pt) {
    Rectangle rect = new Rectangle(m_rect.x, m_rect.y, 
				   m_rect.width/2, m_rect.height);
    return rect.inside(pt.x, pt.y);
  }
}
