/*
 * @(#)CpeHelp.java	1.2 98/02/06
 */

import com.sun.java.swing.*;
import java.awt.*;
import java.net.URL;
import java.net.MalformedURLException;
import java.io.*;
import com.sun.java.swing.text.*;
import com.sun.java.swing.event.*;

/*
 * @version 1.2 02/06/98
 * @author Steve Polyak
 */
public class CpeHelp extends JInternalFrame {
  
  public CpeHelp() {
    super("Help", true, true, true, true);

    setIconifiable(true); 
    setFrameIcon( (Icon)UIManager.get("Tree.openIcon")); 

    setBounds( 200, 25, 400, 400);
    JPanel p = new JPanel();

    p.setOpaque(true);
    p.setBackground(UIManager.getColor("window"));
    p.setLayout(new BorderLayout() );
    HtmlPane html = new HtmlPane();

    p.add(html, BorderLayout.CENTER);

    getContentPane().add(p);
  }

  protected JToolBar buildToolBar() {
    JToolBar bar = new JToolBar();
    bar.add(new JButton("<<"));
    bar.add(new JButton(">>"));
    return bar;
  }
  public void pack() {
    Dimension size = getPreferredSize();
    setSize(size.width, size.height);
  }

}


class HtmlPane extends JPanel implements HyperlinkListener {
  JEditorPane html;

  public HtmlPane() {
    setLayout(new BorderLayout());
    try {
      File f = new File ("HelpFiles/toc.html");
      String s = f.getAbsolutePath();
      s = "file:"+s;
      URL url = new URL(s);
      html = new JEditorPane(s);
      html.setEditable(false);
      html.addHyperlinkListener(this);

      JScrollPane scroller = new JScrollPane();
      JViewport vp = scroller.getViewport();
      vp.add(html);
      add(scroller, BorderLayout.CENTER);
    } catch (MalformedURLException e) {
      System.out.println("Malformed URL: " + e);
    } catch (IOException e) {
      System.out.println("IOException: " + e);
    }	
  }

  /**
   * Notification of a change relative to a 
   * hyperlink.
   */
  public void hyperlinkUpdate(HyperlinkEvent e) {
    if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
      linkActivated(e.getURL());
    }
  }

  /**
   * Follows the reference in an
   * link.  The given url is the requested reference.
   * By default this calls <a href="#setPage">setPage</a>,
   * and if an exception is thrown the original previous
   * document is restored and a beep sounded.  If an 
   * attempt was made to follow a link, but it represented
   * a malformed url, this method will be called with a
   * null argument.
   *
   * @param u the URL to follow
   */
  protected void linkActivated(URL u) {
    Cursor c = html.getCursor();
    Cursor waitCursor = Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR);
    html.setCursor(waitCursor);
    SwingUtilities.invokeLater(new PageLoader(u, c));
  }

  /**
   * temporary class that loads synchronously (although
   * later than the request so that a cursor change
   * can be done).
   */
  class PageLoader implements Runnable {
	
    PageLoader(URL u, Cursor c) {
      url = u;
      cursor = c;
    }

    public void run() {
      if (url == null) {
	// restore the original cursor
	html.setCursor(cursor);

	// PENDING(prinz) remove this hack when 
	// automatic validation is activated.
	Container parent = html.getParent();
	parent.repaint();
      } else {
	Document doc = html.getDocument();
	try {
	  html.setPage(url);
	} catch (IOException ioe) {
	  html.setDocument(doc);
	  getToolkit().beep();
	} finally {
	  // schedule the cursor to revert after
	  // the paint has happended.
	  url = null;
	  SwingUtilities.invokeLater(this);
	}
      }
    }

    URL url;
    Cursor cursor;
  }

}
