/*
 * @(#)CpeTreeRenderer.java	1.0 98/05/07
 *
 */

import com.sun.java.swing.Icon;
import com.sun.java.swing.ImageIcon;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JTree;
import com.sun.java.swing.tree.TreeCellRenderer;
import com.sun.java.swing.tree.DefaultMutableTreeNode;
import java.awt.FontMetrics;
import java.awt.Component;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Dimension;

public class CpeTreeRenderer extends JLabel implements TreeCellRenderer
{
  static protected Font defaultFont;
  /** Icon to use when the item is collapsed. */
  static protected ImageIcon        collapsedIcon;
  /** Icon to use when the item is expanded. */
  static protected ImageIcon        expandedIcon;
  static protected ImageIcon        domainIcon;
  static protected ImageIcon        leafIcon;

  /** Color to use for the background when selected. */
  static protected final Color SelectedBackgroundColor = Color.yellow;

  static
  {
    try {
      defaultFont = new Font("Courier", Font.PLAIN, 12);
    } catch (Exception e) {}
    try {
      collapsedIcon = new ImageIcon("images/collapsed.gif");
      expandedIcon = new ImageIcon("images/expanded.gif");
      leafIcon = new ImageIcon("images/leaf.gif");
    } catch (Exception e) {
      System.out.println("Couldn't load images: " + e);
    }
  }

  /** Whether or not the item that was last configured is selected. */
  protected boolean            selected;

  /**
   * This is messaged from JTree whenever it needs to get the size
   * of the component or it wants to draw it.
   * This attempts to set the font based on value, which will be
   * a TreeNode.
   */
  public Component getTreeCellRendererComponent(JTree tree, Object value,
						boolean selected, boolean expanded,
						boolean leaf, int row,
						boolean hasFocus) {
    Font            font;
    String          stringValue = tree.convertValueToText(value, selected,
							  expanded, leaf, row, hasFocus);

    CpeTreeItem tempItem = (CpeTreeItem) (((DefaultMutableTreeNode)
					   value).getUserObject());

    //System.out.println(stringValue);

    /* Set the text. */
    setText(stringValue);
    /* Tooltips used by the tree. */
    setToolTipText(stringValue);

    //removed to comply with pluggable interface changes., STP

    /* Set the image. 

       //special image for object instances
       if (("CpeInstanceItem".equals(tempItem.getClass().getName()))
       || ("CpeAlwaysItem".equals(tempItem.getClass().getName())) 
       || ("CpeActionItem".equals(tempItem.getClass().getName())) )
       setIcon(leafIcon);
       else if(expanded)
       setIcon(expandedIcon);
       else if(!leaf)
       setIcon(collapsedIcon);
       else
       setIcon(expandedIcon); */


    /* Set the color and the font based on the SampleData userObject. 
       SampleData         
         userObject = (SampleData)((DefaultMutableTreeNode)value)
       .getUserObject();*/
    if(hasFocus)
      setForeground(Color.black);
    else
      setForeground(Color.black);
    //if(userObject.getFont() == null)
    setFont(defaultFont);
    //else
    //setFont(userObject.getFont());

    /* Update the selected flag for the next paint. */
    this.selected = selected;


    //stp - this is a bug fix for 1.2beta2
    setPreferredSize(new Dimension(150,20));
    //setMinimumSize(new Dimension(150,20));

    return this;
  }

  /**
   * paint is subclassed to draw the background correctly.  JLabel
   * currently does not allow backgrounds other than white, and it
   * will also fill behind the icon.  Something that isn't desirable.
   */
  public void paint(Graphics g) {
    Color            bColor;
    Icon             currentI = getIcon();


    if(selected) {
      bColor = SelectedBackgroundColor;
    }
    else if(getParent() != null)
      // Pick background color up from parent (which will come from
      //    the JTree we're contained in). 
      bColor = getParent().getBackground();
    else
      bColor = getBackground();
    g.setColor(bColor);
    if(currentI != null && getText() != null) {
      int          offset = (currentI.getIconWidth() + getIconTextGap());

      g.fillRect(offset, 0, getWidth() - 1 - offset,
		 getHeight() - 1);
    }
    else
      g.fillRect(0, 0, getWidth()-1, getHeight()-1);
    super.paint(g);
  } 
}

