/*
 * @(#)CpeTextPropertyDialog.java	1.0 98/1/5
 * 
 */

import java.awt.*;
import CpeProcessPanel;
import Cpe;
import com.sun.java.swing.*;

/**
 * CpeTextPropertyDialog is used to display/set properties of the
 * annotations in the processes network.
 *
 * @version 1.0 98/1/5
 * @author Steve Polyak 
 */
public class CpeTextPropertyDialog extends JDialog {
  protected Button btnOK;
  protected Button btnCancel;
  protected JTextArea txtName = null;
  protected CpeProcessPanel m_panel = null;
  
  public CpeTextPropertyDialog(CpeProcessPanel parent, String title) {
    // Create a dialog with the specified title
    super(Cpe.sharedInstance().getFrame(), title, false);
    m_panel = parent;
    
    this.getContentPane().setLayout(new BorderLayout(15,15));
    JPanel fields = new JPanel();
    fields.setLayout(new GridLayout(2,2));
    fields.add (new Label("Text:"));

    txtName = new JTextArea();
    fields.add (new JScrollPane(txtName));

    this.getContentPane().add("Center",fields);
    
    Panel yn = new Panel();
    btnOK = new Button("OK");
    yn.add (btnOK);
    btnCancel = new Button("Cancel");
    yn.add (btnCancel);
    this.getContentPane().add ("South",yn);
    
    // Resize the window to the preferred size of its components
    this.pack();
  }
  
  // Pop down the window when the button is clicked.
  public boolean action(Event e, Object arg) {
    
    if("Cancel".equals(arg) == false) {
      //update value as long as cancel wasn't pressed.
      String tempString = txtName.getText();
      m_panel.process.addText(tempString);
    }
    this.hide();
    this.dispose();
    m_panel.repaint();
    
    return true;
  }
}
