import com.sun.java.swing.*;
import com.sun.java.swing.text.*;
import com.sun.java.swing.tree.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

import CpeDomainPane;
import CpeTreeItem;

public class CpeLevelsItem extends CpeTreeItem
{
  
  CpeLevelsItem(String label) {
    super(label);
    collapsedIcon = "images/collapsed.gif";
    expandedIcon = "images/expanded.gif";
  }
  
  public JPopupMenu createPopup(CpeDomainPane pane) {
    String[] labels = new String[] { 
      "Add Level Above", "Add Level Below","Delete", "-", "Properties"};
      
    String[] commands = new String[] {
      "addlevabove", "addlevbelow", "delete", "-", "prop"};
      
    JPopupMenu popup = new JPopupMenu();
      
    for(int i=0; i <= 4; i++) {
      if (labels[i].equals("-")) {
	popup.addSeparator();
      }
      else {
	JMenuItem mi = new JMenuItem(labels[i]);
	mi.setActionCommand(commands[i]);
	mi.addActionListener(pane);
	popup.add(mi);
      }
    }
    return popup;
  }
    
  public DefaultMutableTreeNode getAction(DefaultMutableTreeNode node) {

    DefaultMutableTreeNode childNode = null;

    //this simply iterates once for now to go down to the actions
    //level. i < 1
    int i = 0;
    for  (Enumeration e = node.children(); e.hasMoreElements() && (i < 1);
	  i++){
      childNode = (DefaultMutableTreeNode) e.nextElement();
      //item = (CpeActionsItem) childNode.getUserObject();
    }
    return childNode;
  }

  public void writeOut(FtpModule ftp, DefaultMutableTreeNode node, int pos) {

    DefaultMutableTreeNode childNode;
    CpeActionsItem item;

    //write out label
    ftp.writeRemoteFile("domain-level.label("+key+")=\""+label+"\"");
    ftp.writeRemoteFile("domain-level.number("+key+")="+pos);

    //this simply iterates once for now to go down to the actions
    //level. i < 1
    int i = 0;
    for  (Enumeration e = node.children(); e.hasMoreElements() && (i < 1);
	  i++){
      childNode = (DefaultMutableTreeNode) e.nextElement();
      item = (CpeActionsItem) childNode.getUserObject();
      item.writeOut(ftp,childNode,key);
    }
  }
}
