import com.sun.java.swing.*;
import com.sun.java.swing.text.*;
import com.sun.java.swing.tree.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

import CpeDomainPane;
import CpeTreeItem;

public class CpeAlwaysRoot extends CpeTreeItem
{

  CpeAlwaysRoot(String label) {
    super(label);
    collapsedIcon = "images/collapsed.gif";
    expandedIcon = "images/expanded.gif";
  }

  public JPopupMenu createPopup(CpeDomainPane pane) {
    int ibegin, iend;
    String[] labels = new String[] { 
      "Add Expression"};
      
    String[] commands = new String[] {
      "addalwaysexp"};
      
    JPopupMenu popup = new JPopupMenu();
    ibegin = 0;
    iend = 0;
      
    for(int i=ibegin; i <= iend; i++) {
      if (labels[i].equals("-")) {
	popup.addSeparator();
      }
      else {
	JMenuItem mi = new JMenuItem(labels[i]);
	mi.setActionCommand(commands[i]);
	mi.addActionListener(pane);
	popup.add(mi);
      }
    }
    return popup;
  }

  public void writeOut(FtpModule ftp, DefaultMutableTreeNode node) {

    String alwaysString = "";
    DefaultMutableTreeNode childNode;
    CpeAlwaysItem item;

    //first determine how many levels there are.
    int childCount = node.getChildCount();

    if (childCount > 0) {
	
      int i = 0; //child counter
      for  (Enumeration e = node.children(); e.hasMoreElements();i++){
	childNode = (DefaultMutableTreeNode) e.nextElement();
	item = (CpeAlwaysItem) childNode.getUserObject();
	item.writeOut(ftp,childNode);
	if (i==0)
	  alwaysString = item.key;
	else
	  alwaysString = alwaysString + "," + item.key;
      }
      ftp.writeRemoteFile("SORT cpo-always-constraint={" +
			  alwaysString + "}");
    }
  }
}

