;;; CLIPS util functions for CPM
;;; Steve Polyak, Dept. of AI, University of Edinburgh
;;; Date: August 3, 1998

;;; Strips out a newline character
(deffunction strip-one-newline (?string)
  (bind ?pos (length ?string))
  (bind ?length ?pos)
  (bind ?found FALSE)
  (while (and (> ?pos 1) (neq ?found TRUE))
    (bind ?char (sub-string ?pos ?pos ?string))
    ;; Find the first newline from the end
    (if (eq ?char "
") then
    (bind ?found TRUE)
    else
    (bind ?pos (- ?pos 1)))
    )
  (if (eq ?found TRUE) then
    (if (> ?pos 1) then (return (upcase 
			 (str-cat (sub-string 1 (- ?pos 1) ?string)
				  (sub-string (+ ?pos 1) ?length ?string))))
	else (return (upcase ?string)))
    else (return (upcase ?string)))
  )

;;; Removes all newlines 
(deffunction strip-multiple-newline (?string)
  (bind ?pos (length ?string))
  (bind ?length ?pos)
  (bind ?output "")
  (while (> ?pos 0)
    (bind ?char (sub-string ?pos ?pos ?string))
    ;; omit any newline
    (if (neq ?char "
") then
    (bind ?output (str-cat ?char ?output)))
    (bind ?pos (- ?pos 1)))
  (return ?output))

;;; Get the filename only, given a full path
;;; E.g. c:\thing\test.txt -> test.txt

(deffunction get-file (?filename)
  (bind ?pos (length ?filename))
  (bind ?found FALSE)
  (while (and (> ?pos 1) (neq ?found TRUE))
    (bind ?char (sub-string ?pos ?pos ?filename))
					; Find the first backslash from the end
    (if (eq ?char "/") then
      (bind ?found TRUE)
      else
      (bind ?pos (- ?pos 1)))
    )
  (if (eq ?found TRUE) then
    (if (> ?pos 1) then (return (sub-string (+ ?pos 1) (length ?filename) ?filename))
	else (return ?filename))
    else (return ?filename))
  )

;;; Strip extension
(deffunction strip-extension (?filename)
  (bind ?pos (length ?filename))
  (bind ?found FALSE)
  (while (and (> ?pos 1) (neq ?found TRUE))
    (bind ?char (sub-string ?pos ?pos ?filename))
					; Find the first dot from the end
    (if (eq ?char ".") then
      (bind ?found TRUE)
      else
      (bind ?pos (- ?pos 1)))
    )
  (if (eq ?found TRUE) then
    (if (> ?pos 1) then (return (sub-string 1 (- ?pos 1) ?filename))
	else (return ?filename))
    else (return ?filename))
  )


