/*
 * Decompiled with CFR 0.152.
 */
import com.sun.java.swing.AbstractButton;
import com.sun.java.swing.Box;
import com.sun.java.swing.BoxLayout;
import com.sun.java.swing.ButtonGroup;
import com.sun.java.swing.ButtonModel;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JDialog;
import com.sun.java.swing.JFileChooser;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JOptionPane;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JPasswordField;
import com.sun.java.swing.JRadioButton;
import com.sun.java.swing.JTextField;
import com.sun.java.swing.JTree;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class CpeFileFTPDialog
extends JDialog {
    static final String DATADIR = "cpedata";
    static final String DATAEXT = "txt";
    static final String DATAID = "cpe";
    protected JButton btnOK;
    protected JButton btnCancel;
    protected JTextField m_userName = null;
    protected JTextField hostName = null;
    protected JTextField m_fileName = null;
    protected JPasswordField m_password = null;
    protected CpeProcessPanel m_frame = null;
    protected Vector processPanels = null;
    protected Choice m_slot = null;
    protected Choice whichProcess = null;
    protected char m_type;
    protected JTree tree;
    protected JRadioButton m_ftp = null;
    protected JRadioButton m_local = null;
    protected ButtonGroup m_radGroup = null;
    protected JDialog dialog = this;

    public CpeFileFTPDialog(String string, char c, JTree jTree) {
        super(Cpe.sharedInstance().getFrame(), string, false);
        this.tree = jTree;
        this.m_type = c;
        JLabel jLabel = null;
        this.getContentPane().setLayout((LayoutManager)new BoxLayout(this.getContentPane(), 1));
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new BoxLayout((Container)jPanel, 0));
        jLabel = new JLabel("Host Name: ");
        jLabel.setPreferredSize(new Dimension(90, 10));
        jLabel.setMinimumSize(new Dimension(90, 10));
        jPanel.add((Component)jLabel);
        this.hostName = new JTextField(Cpe.sharedInstance().hostName, 32);
        jPanel.add((Component)this.hostName);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new BoxLayout((Container)jPanel2, 0));
        jLabel = new JLabel("User ID: ");
        jLabel.setPreferredSize(new Dimension(90, 10));
        jLabel.setMinimumSize(new Dimension(90, 10));
        jPanel2.add((Component)jLabel);
        this.m_userName = new JTextField(Cpe.sharedInstance().userName, 15);
        jPanel2.add((Component)this.m_userName);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new BoxLayout((Container)jPanel3, 0));
        jLabel = new JLabel("Password: ");
        jLabel.setPreferredSize(new Dimension(90, 10));
        jLabel.setMinimumSize(new Dimension(90, 10));
        jPanel3.add((Component)jLabel);
        this.m_password = new JPasswordField(Cpe.sharedInstance().password, 15);
        jPanel3.add((Component)this.m_password);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new BoxLayout((Container)jPanel4, 0));
        jLabel = new JLabel("File Name: ");
        jLabel.setPreferredSize(new Dimension(90, 10));
        jLabel.setMinimumSize(new Dimension(90, 10));
        jPanel4.add((Component)jLabel);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new FlowLayout());
        this.m_fileName = new JTextField(Cpe.sharedInstance().fileName, 32);
        JButton jButton = new JButton("...");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                File file;
                JFileChooser jFileChooser = new JFileChooser();
                jFileChooser.setDialogTitle("Select File...");
                int n = jFileChooser.showDialog((Component)((Object)Cpe.sharedInstance()), "OK");
                if (n == 0 && (file = jFileChooser.getSelectedFile()) != null) {
                    CpeFileFTPDialog.this.m_fileName.setText(jFileChooser.getSelectedFile().getAbsolutePath());
                    ButtonModel buttonModel = CpeFileFTPDialog.this.m_radGroup.getSelection();
                    if (buttonModel.getActionCommand().equals("ftp")) {
                        CpeFileFTPDialog.this.m_radGroup.setSelected(buttonModel, false);
                    }
                }
            }
        });
        jPanel5.add((Component)this.m_fileName);
        jPanel5.add((Component)jButton);
        jPanel4.add((Component)jPanel5);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new BoxLayout((Container)jPanel6, 0));
        jLabel = new JLabel("File System: ");
        jLabel.setPreferredSize(new Dimension(90, 10));
        jLabel.setMinimumSize(new Dimension(90, 10));
        jPanel6.add((Component)jLabel);
        this.m_ftp = new JRadioButton("FTP", false);
        this.m_ftp.setAlignmentX(0.0f);
        this.m_ftp.setActionCommand("ftp");
        this.m_local = new JRadioButton("Local", true);
        this.m_local.setAlignmentX(0.0f);
        this.m_local.setActionCommand("local");
        this.m_radGroup = new ButtonGroup();
        this.m_radGroup.add((AbstractButton)this.m_ftp);
        this.m_radGroup.add((AbstractButton)this.m_local);
        jPanel6.add((Component)this.m_ftp);
        jPanel6.add((Component)this.m_local);
        jPanel6.add(Box.createHorizontalGlue());
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new BoxLayout((Container)jPanel7, 0));
        this.btnOK = new JButton("OK");
        jPanel7.add((Component)this.btnOK);
        this.btnOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (CpeFileFTPDialog.this.m_type == 'O') {
                    if (CpeFileFTPDialog.this.m_radGroup.getSelection().getActionCommand().equals("ftp")) {
                        CpeFileFTPDialog.this.fileOpen();
                    } else {
                        CpeFileFTPDialog.this.fileOpenLocal();
                    }
                } else if (CpeFileFTPDialog.this.m_type == 'S') {
                    if (CpeFileFTPDialog.this.m_radGroup.getSelection().getActionCommand().equals("ftp")) {
                        CpeFileFTPDialog.this.fileSave();
                    } else {
                        CpeFileFTPDialog.this.fileSaveLocal();
                    }
                } else if (CpeFileFTPDialog.this.m_radGroup.getSelection().getActionCommand().equals("ftp")) {
                    CpeFileFTPDialog.this.fileExport();
                } else {
                    CpeFileFTPDialog.this.fileExportLocal();
                }
                Cpe.sharedInstance().userName = CpeFileFTPDialog.this.m_userName.getText();
                Cpe.sharedInstance().hostName = CpeFileFTPDialog.this.hostName.getText();
                Cpe.sharedInstance().password = CpeFileFTPDialog.this.m_password.getText();
                Cpe.sharedInstance().fileName = CpeFileFTPDialog.this.m_fileName.getText();
                CpeFileFTPDialog.this.dialog.hide();
                CpeFileFTPDialog.this.dialog.dispose();
                Cpe.sharedInstance().ftpDlg = null;
            }
        });
        this.btnCancel = new JButton("Cancel");
        jPanel7.add((Component)this.btnCancel);
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CpeFileFTPDialog.this.dialog.hide();
                CpeFileFTPDialog.this.dialog.dispose();
                Cpe.sharedInstance().ftpDlg = null;
            }
        });
        this.getContentPane().add((Component)jPanel);
        this.getContentPane().add((Component)jPanel2);
        this.getContentPane().add((Component)jPanel3);
        this.getContentPane().add((Component)jPanel4);
        this.getContentPane().add((Component)jPanel6);
        this.getContentPane().add(Box.createRigidArea((Dimension)new Dimension(0, 5)));
        this.getContentPane().add((Component)jPanel7);
        ((Window)((Object)this)).pack();
    }

    public boolean action(Event event, Object object) {
        return false;
    }

    private void changeProcessSelection() {
    }

    private void fileExport() {
        Cpe.sharedInstance().setWait();
        ((Component)((Object)this)).setCursor(Cursor.getPredefinedCursor(3));
        FtpModule ftpModule = new FtpModule(this.tree);
        if (ftpModule.connect(this.hostName.getText())) {
            if (ftpModule.login(this.m_userName.getText(), this.m_password.getText())) {
                ftpModule.sendFile(this.m_type, true, "cpedata/" + this.m_fileName.getText());
                ftpModule.disconnect();
            } else {
                JOptionPane.showMessageDialog((Component)Cpe.sharedInstance().getFrame(), (Object)"Unable to login to FTP server!", (String)"CPE Message", (int)2);
                ftpModule.disconnect();
            }
        } else {
            JOptionPane.showMessageDialog((Component)Cpe.sharedInstance().getFrame(), (Object)"Unable to connect!", (String)"CPE Message", (int)2);
        }
        Cpe.sharedInstance().setNormal();
        ((Component)((Object)this)).setCursor(Cursor.getPredefinedCursor(0));
    }

    private void fileExportLocal() {
        Cpe.sharedInstance().setWait();
        ((Component)((Object)this)).setCursor(Cursor.getPredefinedCursor(3));
        FtpModule ftpModule = new FtpModule(this.tree);
        try {
            if (this.m_fileName.getText() != null) {
                FileOutputStream fileOutputStream = new FileOutputStream(this.m_fileName.getText());
                ftpModule.sendFileLocal(this.m_type, this.m_fileName.getText(), fileOutputStream);
                ((OutputStream)fileOutputStream).close();
            } else {
                JOptionPane.showMessageDialog((Component)Cpe.sharedInstance().getFrame(), (Object)"No file name given!", (String)"CPE Message", (int)2);
            }
        }
        catch (Exception exception) {}
        Cpe.sharedInstance().setNormal();
        ((Component)((Object)this)).setCursor(Cursor.getPredefinedCursor(0));
    }

    private void fileOpen() {
        Cpe.sharedInstance().setWait();
        ((Component)((Object)this)).setCursor(Cursor.getPredefinedCursor(3));
        FtpModule ftpModule = new FtpModule(this.tree);
        if (ftpModule.connect(this.hostName.getText())) {
            if (ftpModule.login(this.m_userName.getText(), this.m_password.getText())) {
                ftpModule.getFile("cpedata/" + this.m_fileName.getText());
                ftpModule.disconnect();
            } else {
                JOptionPane.showMessageDialog((Component)Cpe.sharedInstance().getFrame(), (Object)"Unable to login to FTP server!", (String)"CPE Message", (int)2);
                ftpModule.disconnect();
            }
        } else {
            JOptionPane.showMessageDialog((Component)Cpe.sharedInstance().getFrame(), (Object)"Unable to connect!", (String)"CPE Message", (int)2);
        }
        Cpe.sharedInstance().setNormal();
        ((Component)((Object)this)).setCursor(Cursor.getPredefinedCursor(0));
    }

    private void fileOpenLocal() {
        Cpe.sharedInstance().setWait();
        ((Component)((Object)this)).setCursor(Cursor.getPredefinedCursor(3));
        FtpModule ftpModule = new FtpModule(this.tree);
        try {
            if (this.m_fileName.getText() != null) {
                FileInputStream fileInputStream = new FileInputStream(this.m_fileName.getText());
                ftpModule.getFileLocal(this.m_fileName.getText(), fileInputStream);
                ((InputStream)fileInputStream).close();
            } else {
                JOptionPane.showMessageDialog((Component)Cpe.sharedInstance().getFrame(), (Object)"No file name given!", (String)"CPE Message", (int)2);
            }
        }
        catch (Exception exception) {}
        Cpe.sharedInstance().setNormal();
        ((Component)((Object)this)).setCursor(Cursor.getPredefinedCursor(0));
    }

    private void fileSave() {
        Cpe.sharedInstance().setWait();
        ((Component)((Object)this)).setCursor(Cursor.getPredefinedCursor(3));
        FtpModule ftpModule = new FtpModule(this.tree);
        if (ftpModule.connect(this.hostName.getText())) {
            if (ftpModule.login(this.m_userName.getText(), this.m_password.getText())) {
                ftpModule.sendFile(this.m_type, true, "cpedata/" + this.m_fileName.getText());
                ftpModule.disconnect();
            } else {
                JOptionPane.showMessageDialog((Component)Cpe.sharedInstance().getFrame(), (Object)"Unable to login to FTP server!", (String)"CPE Message", (int)2);
                ftpModule.disconnect();
            }
        } else {
            JOptionPane.showMessageDialog((Component)Cpe.sharedInstance().getFrame(), (Object)"Unable to connect!", (String)"CPE Message", (int)2);
        }
        Cpe.sharedInstance().setNormal();
        ((Component)((Object)this)).setCursor(Cursor.getPredefinedCursor(0));
    }

    private void fileSaveLocal() {
        Cpe.sharedInstance().setWait();
        ((Component)((Object)this)).setCursor(Cursor.getPredefinedCursor(3));
        FtpModule ftpModule = new FtpModule(this.tree);
        try {
            if (this.m_fileName.getText() != null) {
                FileOutputStream fileOutputStream = new FileOutputStream(this.m_fileName.getText());
                ftpModule.sendFileLocal(this.m_type, this.m_fileName.getText(), fileOutputStream);
                ((OutputStream)fileOutputStream).close();
            } else {
                JOptionPane.showMessageDialog((Component)Cpe.sharedInstance().getFrame(), (Object)"No file name given!", (String)"CPE Message", (int)2);
            }
        }
        catch (Exception exception) {}
        Cpe.sharedInstance().setNormal();
        ((Component)((Object)this)).setCursor(Cursor.getPredefinedCursor(0));
    }
}

