/*
 * @(#)CpeProcPropertyDialog.java	1.0 98/1/5
 * 
 */

import java.awt.event.*;
import java.util.*;
import CpeProcessPanel;
import Cpe;
import com.sun.java.swing.*;
import java.awt.*;

/**
 * CpeProcPropertyDialog is used to display/set properties of the
 * process network.
 *
 * @version 1.0 98/1/5
 * @author Steve Polyak 
 */
public class CpeProcPropertyDialog extends JDialog {
  protected Button btnOK;
  protected Button btnCancel;
  protected JTextField txtName = null;
  protected JTextField expands = null;
  protected CpeProcessPanel m_panel = null;
  protected String m_oldText = "";
  protected String m_oldKey = "";
  protected ButtonGroup group;
  protected JCheckBox taskable;
  protected JCheckBox executable;
  protected JTabbedPane tab;

  protected JTextField reqInput;
  protected DefaultListModel reqList;
  protected JTextField prefInput;
  protected DefaultListModel prefList;
  protected JTextField varInput;
  protected DefaultListModel varList;
  protected JTextField condInput;
  protected DefaultListModel condList;
  protected JTextField effInput;
  protected DefaultListModel effList;
  protected JTextField resInput;
  protected DefaultListModel resList;

  CpeProcPropertyDialog(CpeProcessPanel parent, String title) {
    // Create a dialog with the specified title
    super(Cpe.sharedInstance().getFrame(), title, false);
    m_panel = parent;

    tab = new JTabbedPane();
    
    //    this.setLayout(new BorderLayout(25,5));
    this.getContentPane().setLayout(new BorderLayout(25,5));
    JPanel fields = new JPanel();
    fields.setLayout(new GridLayout(4,2));
    fields.add (new Label("Process Name:"));
    m_oldText = m_panel.process.label;
    m_oldKey = m_panel.process.key;
    txtName = new JTextField(m_oldText);
    fields.add (txtName);

    fields.add (new Label("Expands:"));
    expands = new JTextField(m_panel.process.expands);
    fields.add (expands);

    //bounding nodes gui
    fields.add (new Label("Bounding Nodes:"));
    JPanel radioPanel = new JPanel();
    radioPanel.setLayout(new GridLayout(1,2));
    group = new ButtonGroup();
    JRadioButton button;
    if (m_panel.process.startFinishFlag)
      button = new JRadioButton("Start-Finish", true);
    else
      button = new JRadioButton("Start-Finish", false);
    button.setActionCommand("sf");
    group.add(button);
    radioPanel.add (button);
    if (m_panel.process.startFinishFlag)
      button = new JRadioButton("Begin-End", false);
    else
      button = new JRadioButton("Begin-End", true);
    button.setActionCommand("be");
    group.add(button);
    radioPanel.add(button);
    fields.add (radioPanel);

    //task level process gui
    JPanel checkPanel = new JPanel();
    checkPanel.setLayout(new FlowLayout());
    checkPanel.add (new Label("Process taskable:"));
    taskable = new JCheckBox();
    taskable.setSelected(parent.process.taskProcess);
    checkPanel.add(taskable);
    fields.add (checkPanel);

    JPanel checkPanel2 = new JPanel();
    checkPanel2.setLayout(new FlowLayout());
    checkPanel2.add (new Label("Process executable:"));
    executable = new JCheckBox();
    executable.setSelected(parent.process.execProcess);
    checkPanel2.add(executable);
    fields.add (checkPanel2);

    tab.addTab("General",null,fields);


    //requirements gui
    JPanel reqPanel = new JPanel();
    reqPanel.setLayout(new BorderLayout(25,5));
    JPanel reqPanel1 = new JPanel();
    reqPanel1.setLayout(new GridLayout(2,1));
    reqInput = new JTextField();
    reqPanel1.add(reqInput);
    reqList = new DefaultListModel();
    JList jlReq = new JList(reqList);
    jlReq.setFont(Cpe.sharedInstance().defaultFont);
    reqPanel1.add(new JScrollPane
		  (jlReq, ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS, 
		   ScrollPaneConstants.HORIZONTAL_SCROLLBAR_ALWAYS));
    reqPanel.add("Center",reqPanel1);

    JPanel reqPanel2 = new JPanel();
    JButton addRBtn = new JButton("Add");
    addRBtn.setFont(Cpe.sharedInstance().defaultFont);
    addRBtn.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	reqList.addElement(reqInput.getText());
	reqInput.setText("");
      }
    });
    reqPanel2.add(addRBtn);
    JButton delRBtn = new JButton("Delete");
    delRBtn.setFont(Cpe.sharedInstance().defaultFont);
    delRBtn.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	reqList.removeAllElements();
      }
    });
    reqPanel2.add(delRBtn);
    reqPanel.add("South",reqPanel2);
    //tab.addTab("Requirements",null,reqPanel);

    //preferences gui
    JPanel prefPanel = new JPanel();
    prefPanel.setLayout(new BorderLayout(25,5));
    JPanel prefPanel1 = new JPanel();
    prefPanel1.setLayout(new GridLayout(2,1));
    prefInput = new JTextField();
    prefPanel1.add(prefInput);
    prefList = new DefaultListModel();
    JList jlPref = new JList(prefList);
    jlPref.setFont(Cpe.sharedInstance().defaultFont);
    prefPanel1.add(new JScrollPane
		   (jlPref, ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS, 
		    ScrollPaneConstants.HORIZONTAL_SCROLLBAR_ALWAYS));
    prefPanel.add("Center",prefPanel1);

    JPanel prefPanel2 = new JPanel();
    JButton addPBtn = new JButton("Add");
    addPBtn.setFont(Cpe.sharedInstance().defaultFont);
    addPBtn.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	prefList.addElement(prefInput.getText());
	prefInput.setText("");
      }
    });
    prefPanel2.add(addPBtn);
    JButton delPBtn = new JButton("Delete");
    delPBtn.setFont(Cpe.sharedInstance().defaultFont);
    delPBtn.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	prefList.removeAllElements();
      }
    });
    prefPanel2.add(delPBtn);
    prefPanel.add("South",prefPanel2);
    //tab.addTab("Preferences",null,prefPanel);

    //variables gui
    JPanel varPanel = new JPanel();
    varPanel.setLayout(new BorderLayout(25,5));
    JPanel varPanel1 = new JPanel();
    varPanel1.setLayout(new GridLayout(2,1));
    varInput = new JTextField();
    varPanel1.add(varInput);
    varList = new DefaultListModel();
    JList jlVar = new JList(varList);
    jlVar.setFont(Cpe.sharedInstance().defaultFont);
    varPanel1.add(new JScrollPane
		  (jlVar, ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS, 
		   ScrollPaneConstants.HORIZONTAL_SCROLLBAR_ALWAYS));
    varPanel.add("Center",varPanel1);

    JPanel varPanel2 = new JPanel();
    JButton addVBtn = new JButton("Add");
    addVBtn.setFont(Cpe.sharedInstance().defaultFont);
    addVBtn.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	varList.addElement(varInput.getText());
	varInput.setText("");
      }
    });
    varPanel2.add(addVBtn);
    JButton delVBtn = new JButton("Delete");
    delVBtn.setFont(Cpe.sharedInstance().defaultFont);
    delVBtn.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	varList.removeAllElements();
      }
    });
    varPanel2.add(delVBtn);
    varPanel.add("South",varPanel2);
    tab.addTab("Variables",null,varPanel);

    //resources gui
    JPanel resPanel = new JPanel();
    resPanel.setLayout(new BorderLayout(25,5));
    JPanel resPanel1 = new JPanel();
    resPanel1.setLayout(new GridLayout(2,1));
    resInput = new JTextField();
    resPanel1.add(resInput);
    resList = new DefaultListModel();
    JList jlRes = new JList(resList);
    jlRes.setFont(Cpe.sharedInstance().defaultFont);
    resPanel1.add(new JScrollPane
		  (jlRes, ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS,
		   ScrollPaneConstants.HORIZONTAL_SCROLLBAR_ALWAYS));
    resPanel.add("Center",resPanel1);

    JPanel resPanel2 = new JPanel();
    JButton addRsBtn = new JButton("Add");
    addRsBtn.setFont(Cpe.sharedInstance().defaultFont);
    addRsBtn.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	resList.addElement(resInput.getText());
	resInput.setText("");
      }
    });
    resPanel2.add(addRsBtn);
    JButton delRsBtn = new JButton("Delete");
    delRsBtn.setFont(Cpe.sharedInstance().defaultFont);
    delRsBtn.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	resList.removeAllElements();
      }
    });
    resPanel2.add(delRsBtn);
    resPanel.add("South",resPanel2);
    JButton buildRsBtn = new JButton("TF...");
    buildRsBtn.setFont(Cpe.sharedInstance().defaultFont);
    buildRsBtn.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {

	JOptionPane.showMessageDialog(Cpe.sharedInstance().getFrame(), 
				      "Build a TF Expression...", 
				      "CDE Expression Builder", 
				      JOptionPane.INFORMATION_MESSAGE);
      }
    });
    resPanel2.add(buildRsBtn);
    resPanel.add("South",resPanel2);
    tab.addTab("Resources",null,resPanel);

    //conditions gui
    JPanel condPanel = new JPanel();
    condPanel.setLayout(new BorderLayout(25,5));
    JPanel condPanel1 = new JPanel();
    condPanel1.setLayout(new GridLayout(2,1));
    condInput = new JTextField();
    condPanel1.add(condInput);
    condList = new DefaultListModel();
    JList jlCond = new JList(condList);
    jlCond.setFont(Cpe.sharedInstance().defaultFont);
    condPanel1.add(new JScrollPane
		   (jlCond, ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS,
		    ScrollPaneConstants.HORIZONTAL_SCROLLBAR_ALWAYS));
    condPanel.add("Center",condPanel1);

    JPanel condPanel2 = new JPanel();
    JButton addCBtn = new JButton("Add");
    addCBtn.setFont(Cpe.sharedInstance().defaultFont);
    addCBtn.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	condList.addElement(condInput.getText());
	condInput.setText("");
      }
    });
    condPanel2.add(addCBtn);
    JButton delCBtn = new JButton("Delete");
    delCBtn.setFont(Cpe.sharedInstance().defaultFont);
    delCBtn.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	condList.removeAllElements();
      }
    });
    condPanel2.add(delCBtn);
    JButton buildCBtn = new JButton("TF...");
    buildCBtn.setFont(Cpe.sharedInstance().defaultFont);
    buildCBtn.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {

	JOptionPane.showMessageDialog(Cpe.sharedInstance().getFrame(), 
				      "Build a TF Expression...", 
				      "CDE Expression Builder", 
				      JOptionPane.INFORMATION_MESSAGE);
      }
    });
    condPanel2.add(buildCBtn);
    condPanel.add("South",condPanel2);
    tab.addTab("Conditions",null,condPanel);


    //effects gui
    JPanel effPanel = new JPanel();
    effPanel.setLayout(new BorderLayout(25,5));
    JPanel effPanel1 = new JPanel();
    effPanel1.setLayout(new GridLayout(2,1));
    effInput = new JTextField();
    effPanel1.add(effInput);
    effList = new DefaultListModel();
    JList jlEff = new JList(effList);
    jlEff.setFont(Cpe.sharedInstance().defaultFont);
    effPanel1.add(new JScrollPane
		  (jlEff, ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS,
		   ScrollPaneConstants.HORIZONTAL_SCROLLBAR_ALWAYS));
    effPanel.add("Center",effPanel1);

    JPanel effPanel2 = new JPanel();
    JButton addEBtn = new JButton("Add");
    addEBtn.setFont(Cpe.sharedInstance().defaultFont);
    addEBtn.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	effList.addElement(effInput.getText());
	effInput.setText("");
      }
    });
    effPanel2.add(addEBtn);
    JButton delEBtn = new JButton("Delete");
    delEBtn.setFont(Cpe.sharedInstance().defaultFont);
    delEBtn.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	effList.removeAllElements();
      }
    });
    effPanel2.add(delEBtn);
    JButton buildEBtn = new JButton("TF...");
    buildEBtn.setFont(Cpe.sharedInstance().defaultFont);
    buildEBtn.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {

	JOptionPane.showMessageDialog(Cpe.sharedInstance().getFrame(), 
				      "Build a TF Expression...", 
				      "CDE Expression Builder", 
				      JOptionPane.INFORMATION_MESSAGE);
      }
    });
    effPanel2.add(buildEBtn);
    effPanel.add("South",effPanel2);
    tab.addTab("Effects",null,effPanel);

    this.getContentPane().add("Center",tab);
    
    JPanel yn = new JPanel();
    btnOK = new Button("OK");
    yn.add (btnOK);
    btnCancel = new Button("Cancel");
    yn.add (btnCancel);
    this.getContentPane().add ("South",yn);
    
    importLists();

    // Resize the window to the preferred size of its components
    //this.pack();
    this.setBounds(0,0,385,290);
  }
  
  // Pop down the window when the button is clicked.
  public boolean action(Event e, Object arg) {
    
    if("Cancel".equals(arg) == false) {
      //update value as long as cancel wasn't pressed.
      String tempString = txtName.getText();
      m_panel.process.expands = expands.getText();
      m_panel.process.setLabel(tempString);

      if (group.getSelection().getActionCommand().equals("sf")) {
	m_panel.process.setStartFinishFlag(true);
      } else {
	m_panel.process.setStartFinishFlag(false);
      }

      m_panel.process.taskProcess = taskable.isSelected();
      m_panel.process.execProcess = executable.isSelected();

      updateLists();
    }
    this.hide();
    this.dispose();
    m_panel.process.m_sheet = null;
    m_panel.repaint();
    
    return true;
  }

  private void updateLists() {
    String s = new String();

    m_panel.process.requirements.removeAllElements();
    m_panel.process.preferences.removeAllElements();
    m_panel.process.variables.removeAllElements();
    m_panel.process.preconditions.removeAllElements();
    m_panel.process.effects.removeAllElements();
    m_panel.process.resources.removeAllElements();

    for  (Enumeration e =  reqList.elements() ; e.hasMoreElements()  ;)  
      {s = (String) e.nextElement();
      m_panel.process.requirements.addElement(s); }
    for  (Enumeration e =  prefList.elements() ; e.hasMoreElements()  ;)  
      {s = (String) e.nextElement(); 
      m_panel.process.preferences.addElement(s); }
    for  (Enumeration e =  varList.elements() ; e.hasMoreElements()  ;)  
      {s = (String) e.nextElement(); 
      m_panel.process.variables.addElement(s); }
    for  (Enumeration e =  condList.elements() ; e.hasMoreElements()  ;)  
      {s = (String) e.nextElement(); 
      m_panel.process.preconditions.addElement(s); }
    for  (Enumeration e =  effList.elements() ; e.hasMoreElements()  ;)  
      {s = (String) e.nextElement(); 
      m_panel.process.effects.addElement(s); }
    for  (Enumeration e =  resList.elements() ; e.hasMoreElements()  ;)  
      {s = (String) e.nextElement(); 
      m_panel.process.resources.addElement(s);}
  }

  private void importLists() {
    String s = new String();
    for  (Enumeration e =  m_panel.process.requirements.elements() ; 
	  e.hasMoreElements()  ;)  
      {s = (String) e.nextElement(); reqList.addElement(s); }
    for  (Enumeration e =  m_panel.process.preferences.elements() ; 
	  e.hasMoreElements()  ;)  
      {s = (String) e.nextElement(); prefList.addElement(s); }
    for  (Enumeration e =  m_panel.process.variables.elements() ; 
	  e.hasMoreElements()  ;)  
      {s = (String) e.nextElement(); varList.addElement(s); }
    for  (Enumeration e =  m_panel.process.preconditions.elements() ; 
	  e.hasMoreElements()  ;)  
      {s = (String) e.nextElement(); condList.addElement(s); }
    for  (Enumeration e =  m_panel.process.effects.elements() ; 
	  e.hasMoreElements()  ;)  
      {s = (String) e.nextElement(); effList.addElement(s); }
    for  (Enumeration e =  m_panel.process.resources.elements() ; 
	  e.hasMoreElements()  ;)  
      {s = (String) e.nextElement(); resList.addElement(s); }
  }

  public void show() {
    tab.setSelectedIndex(0);
    super.show();
  }
}
