/*
 * @(#)CpeNegEdge.java	1.0 98/1/5
 * 
 */

import java.util.*;
import java.awt.*;
//import java.awt.geom.*;
import CpeNode;

/**
 * CpeNegEdge is a specialized process edge that denotes the equality of
 * of two process node's timepoints.
 *
 * @version 1.0 98/1/5
 * @author Steve Polyak 
 */
class CpeNegEdge extends CpeEdge {
  
  CpeNegEdge(CpeNode from, boolean fromPos, CpeNode to, boolean toPos){
    super(from, fromPos, to, toPos);
  }
    
  public void draw(Graphics g, FontMetrics fm) {

    if (m_from == null || m_to == null)
      return;

    int y1 = m_from.m_y;
    int y2 = m_to.m_y;
    int x1, x2;

    if (m_selected)
      g.setColor(m_selectedColor);
    else
      g.setColor(Color.red);
    
    int wFrom = m_from.calcWidth(fm);
    int wTo = m_to.calcWidth(fm);

    if (fromPosition) {
      //drawing from the begin of the "from node"
      x1 = (m_from.m_x - wFrom/2);
    }
    else {
      //drawing from the end of the "from node"
      x1 = (m_from.m_x + wFrom/2);
    }

    if (toPosition) {
      //drawing to the begin of the "to node"
      x2 = (m_to.m_x - wTo/2);
    }
    else {
      //drawing to the end of the "to node"
      x2 = (m_to.m_x + wTo/2);
    }
   
    // g.drawLine(x1, y1, x2, y2);
    drawDashedLine(g,x1,y1,x2,y2,3,3);
  }
  
  public void drawArrow(Graphics g, FontMetrics fm) {
  }

  public void drawDashedLine(Graphics g,int x1,int y1,int x2,int y2,
			     double dashlength, double spacelength) {
    double linelength=Math.sqrt((x2-x1)*(x2-x1)+(y2-y1)*(y2-y1));
    double yincrement=(y2-y1)/(linelength/(dashlength+spacelength));
    double xincdashspace=(x2-x1)/(linelength/(dashlength+spacelength));
    double yincdashspace=(y2-y1)/(linelength/(dashlength+spacelength));
    double xincdash=(x2-x1)/(linelength/(dashlength));
    double yincdash=(y2-y1)/(linelength/(dashlength));
    int counter=0;
    for (double i=0;i<linelength-dashlength;i+=dashlength+spacelength){
      g.drawLine((int) (x1+xincdashspace*counter),
		 (int) (y1+yincdashspace*counter),
		 (int) (x1+xincdashspace*counter+xincdash),
		 (int) (y1+yincdashspace*counter+yincdash));
      counter++;
    }
    if ((dashlength+spacelength)*counter<=linelength)
      g.drawLine((int) (x1+xincdashspace*counter),
                 (int) (y1+yincdashspace*counter),
                 x2,y2);
  }

}
