/*
 * @(#)CpeFileFTPDialog.java	1.0 98/1/5
 * 
 */

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.io.*;
import FtpModule;  
import CpeProcessPanel;
import com.sun.java.swing.*;
import com.sun.java.swing.event.*;
import com.sun.java.swing.preview.*;

/**
 * CpeFileFTPDialog displays a dialog for saving and loading processes.
 * It uses the FtpModule for actual i/o due to the applet restriction
 * on access to the local file system. 
 *
 * @version 1.0 98/1/5
 * @author Steve Polyak 
 */
public class CpeFileFTPDialog extends JDialog {
  final static String DATADIR =    "cpedata";
  final static String DATAEXT =    "txt";
  final static String DATAID  =    "cpe";

  protected JButton btnOK;
  protected JButton btnCancel;
  protected JTextField m_userName = null;
  protected JTextField hostName = null;
  protected JTextField m_fileName = null;
  protected JPasswordField m_password = null;
  protected CpeProcessPanel m_frame = null;
  protected Vector processPanels = null;
  protected Choice m_slot = null;
  protected Choice whichProcess = null;
  protected char m_type; //O=open,S=save,E=export
  protected JTree tree;
  protected JRadioButton m_ftp = null;
  protected JRadioButton m_local = null;
  protected ButtonGroup m_radGroup = null;
  protected JDialog dialog = null;

  public CpeFileFTPDialog(String title, char type, JTree tree) {
    // Create a dialog with the specified title
    super(Cpe.sharedInstance().getFrame(), title, false);
    dialog = this;
    this.tree = tree;
    m_type = type;
    JLabel testLabel = null;
    
    this.getContentPane().setLayout(new BoxLayout(this.getContentPane(),
						  BoxLayout.Y_AXIS));
    //setup host name  
    JPanel panel1 = new JPanel();
    panel1.setLayout(new BoxLayout(panel1, BoxLayout.X_AXIS));
    testLabel =  new JLabel("Host Name: ");
    testLabel.setPreferredSize(new Dimension(90, 10));
    testLabel.setMinimumSize(new Dimension(90, 10));
    panel1.add (testLabel);
    hostName = new JTextField(Cpe.sharedInstance().hostName,32);
    panel1.add (hostName);

        
    //setup user id
    JPanel panel2 = new JPanel();
    panel2.setLayout(new BoxLayout(panel2, BoxLayout.X_AXIS));
    testLabel =  new JLabel("User ID: ");
    testLabel.setPreferredSize(new Dimension(90, 10));
    testLabel.setMinimumSize(new Dimension(90, 10));
    panel2.add (testLabel);
    m_userName = new JTextField(Cpe.sharedInstance().userName,15);
    panel2.add (m_userName);
    
    //setup password
    JPanel panel3 = new JPanel();
    panel3.setLayout(new BoxLayout(panel3, BoxLayout.X_AXIS));
    testLabel =  new JLabel("Password: ");
    testLabel.setPreferredSize(new Dimension(90, 10));
    testLabel.setMinimumSize(new Dimension(90, 10));
    panel3.add (testLabel);
    m_password = new JPasswordField(Cpe.sharedInstance().password,15);
    panel3.add (m_password);
    
    //setup filename
    JPanel panel4 = new JPanel();
    panel4.setLayout(new BoxLayout(panel4, BoxLayout.X_AXIS));
    testLabel =  new JLabel("File Name: ");
    testLabel.setPreferredSize(new Dimension(90, 10));
    testLabel.setMinimumSize(new Dimension(90, 10));
    panel4.add (testLabel);
    JPanel filePanel = new JPanel();
    filePanel.setLayout(new FlowLayout());
    m_fileName = new JTextField(Cpe.sharedInstance().fileName,32);
    JButton fileButton = new JButton("...");
    fileButton.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	JFileChooser chooser = new JFileChooser();
	//chooser.setDialogType(JFileChooser.CUSTOM_DIALOG);
	chooser.setDialogTitle("Select File...");
	int retval = chooser.showDialog(Cpe.sharedInstance(),"OK");
	if(retval == 0) {
	  File theFile = chooser.getSelectedFile();
	  if(theFile != null) {
	    m_fileName.setText(chooser.getSelectedFile().getAbsolutePath());
	      
	    ButtonModel bm = m_radGroup.getSelection();
	    if (bm.getActionCommand().equals("ftp")) {
	      m_radGroup.setSelected(bm,false);
	    }
	  }
	}}});
    filePanel.add (m_fileName);
    filePanel.add (fileButton);
    panel4.add (filePanel);

    //setup filesystem
    JPanel panel5 = new JPanel();
    panel5.setLayout(new BoxLayout(panel5, BoxLayout.X_AXIS));
    testLabel =  new JLabel("File System: ");
    testLabel.setPreferredSize(new Dimension(90, 10));
    testLabel.setMinimumSize(new Dimension(90, 10));
    panel5.add (testLabel);
    m_ftp = new JRadioButton("FTP",false);
    m_ftp.setAlignmentX(LEFT_ALIGNMENT);
    m_ftp.setActionCommand("ftp");
    m_local = new JRadioButton("Local",true);
    m_local.setAlignmentX(LEFT_ALIGNMENT);
    m_local.setActionCommand("local");
    m_radGroup = new ButtonGroup();
    m_radGroup.add(m_ftp);
    m_radGroup.add(m_local);
    panel5.add (m_ftp);
    panel5.add (m_local);
    panel5.add(Box.createHorizontalGlue());
    
    //setup yn
    JPanel panel6 = new JPanel();
    panel6.setLayout(new BoxLayout(panel6, BoxLayout.X_AXIS));
    btnOK = new JButton("OK");
    panel6.add (btnOK);
    btnOK.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	if (m_type == 'O') {
	  if (m_radGroup.getSelection().getActionCommand().equals("ftp")) 
	    fileOpen();
	  else
	    fileOpenLocal();
	}
	else if (m_type == 'S') {
	  if (m_radGroup.getSelection().getActionCommand().equals("ftp"))
	    fileSave();
	  else
	    fileSaveLocal();
	}
	else if (m_type == 'T'){
	  // export to TF
	  if (m_radGroup.getSelection().getActionCommand().equals("ftp")) 
	    fileTFExport();
	  else
	    fileExportTFLocal();
	}
	else if (m_type == 'A'){
	  // export to ACT  
	  if (m_radGroup.getSelection().getActionCommand().equals("ftp")) 
	    fileACTExport();
	  else
	    fileExportACTLocal();
	};

	//save values  
	Cpe.sharedInstance().userName = m_userName.getText();
	Cpe.sharedInstance().hostName = hostName.getText();
	Cpe.sharedInstance().password = m_password.getText();
	Cpe.sharedInstance().fileName = m_fileName.getText();
	
	dialog.hide();
	dialog.dispose();
	Cpe.sharedInstance().ftpDlg = null;
      }});

    btnCancel = new JButton("Cancel");
    panel6.add (btnCancel);
    btnCancel.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	dialog.hide();
	dialog.dispose();
	Cpe.sharedInstance().ftpDlg = null;
      }});

    getContentPane().add (panel1);
    getContentPane().add (panel2);
    getContentPane().add (panel3);
    getContentPane().add (panel4);
    getContentPane().add (panel5);
    getContentPane().add(Box.createRigidArea(new Dimension(0,5)));
    getContentPane().add (panel6);
    
    // Resize the window to the preferred size of its components
    this.pack();
  }
  
  // Pop down the window when the button is clicked.
  public boolean action(Event e, Object arg) {

    //old code removed.

    return false;
  }

  private void changeProcessSelection() {
    //code removed.
  } 

  private void fileSave() {
    
    Cpe.sharedInstance().setWait();
    setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
    
    FtpModule ftp = new FtpModule(tree);
    
    if(ftp.connect(hostName.getText())) {
      if (ftp.login(m_userName.getText(),m_password.getText())) {

	ftp.sendFile(m_type,true, DATADIR + "/" + m_fileName.getText());
	
	ftp.disconnect();
      }
      else {
	JOptionPane.showMessageDialog(Cpe.sharedInstance().getFrame(), 
				      "Unable to login to FTP server!",
				      "CPE Message", 
				      JOptionPane.WARNING_MESSAGE);
	ftp.disconnect();
      }
    }
    else {
      JOptionPane.showMessageDialog(Cpe.sharedInstance().getFrame(), 
				    "Unable to connect!",
				    "CPE Message", 
				    JOptionPane.WARNING_MESSAGE);
    }
    Cpe.sharedInstance().setNormal();    
    setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));

    //m_frame.repaint();
  }

  private void fileSaveLocal() {

    Cpe.sharedInstance().setWait();
    setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
    
    FtpModule ftp = new FtpModule(tree);
    OutputStream os;
    
    try {
      if (m_fileName.getText() != null) {
	os = new FileOutputStream(m_fileName.getText());
	ftp.sendFileLocal(m_type,m_fileName.getText(),os);
	os.close();
      }
      else {
	JOptionPane.showMessageDialog(Cpe.sharedInstance().getFrame(), 
				      "No file name given!",
				      "CPE Message", 
				      JOptionPane.WARNING_MESSAGE);
      }
    } catch (Exception e) {}

    Cpe.sharedInstance().setNormal();
    setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
  }
  
  private void fileOpen()
  {
    Cpe.sharedInstance().setWait();
    setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
    
    FtpModule ftp = new FtpModule(tree);
    
    if(ftp.connect(hostName.getText())) {
      if (ftp.login(m_userName.getText(),m_password.getText())) {

	ftp.getFile(DATADIR + "/" + m_fileName.getText());
	ftp.disconnect();
      }
      else {
	JOptionPane.showMessageDialog(Cpe.sharedInstance().getFrame(), 
				      "Unable to login to FTP server!",
				      "CPE Message", 
				      JOptionPane.WARNING_MESSAGE);
	ftp.disconnect();
      }
    }
    else {
      JOptionPane.showMessageDialog(Cpe.sharedInstance().getFrame(), 
				    "Unable to connect!",
				    "CPE Message", 
				    JOptionPane.WARNING_MESSAGE);
    }

    Cpe.sharedInstance().setNormal();
    setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
    //m_frame.repaint();    
  }
  
  private void fileOpenLocal()
  {
    Cpe.sharedInstance().setWait();
    setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
    
    FtpModule ftp = new FtpModule(tree);
    InputStream in;
    
    try {
      if (m_fileName.getText() != null) {
	in = new FileInputStream(m_fileName.getText());
	ftp.getFileLocal(m_fileName.getText(),in);
	in.close();
      }
      else {
	JOptionPane.showMessageDialog(Cpe.sharedInstance().getFrame(), 
				      "No file name given!",
				      "CPE Message", 
				      JOptionPane.WARNING_MESSAGE);
      }
    } catch (Exception e) {}

    Cpe.sharedInstance().setNormal();
    setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
    //m_frame.repaint();    
  }
  
  //export to TF
  private void fileTFExport() {
    
    Cpe.sharedInstance().setWait();
    setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
    
    FtpModule ftp = new FtpModule(tree);
    
    if(ftp.connect(hostName.getText())) {
      if (ftp.login(m_userName.getText(),m_password.getText())) {

	ftp.sendFile(m_type,true, DATADIR + "/" + m_fileName.getText());
	
	ftp.disconnect();
      }
      else {
	JOptionPane.showMessageDialog(Cpe.sharedInstance().getFrame(), 
				      "Unable to login to FTP server!",
				      "CPE Message", 
				      JOptionPane.WARNING_MESSAGE);
	ftp.disconnect();
      }
    }
    else {
      JOptionPane.showMessageDialog(Cpe.sharedInstance().getFrame(), 
				    "Unable to connect!",
				    "CPE Message", 
				    JOptionPane.WARNING_MESSAGE);
    }
    Cpe.sharedInstance().setNormal();
    setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
    //m_frame.repaint();
  }
  private void fileExportTFLocal() {
    Cpe.sharedInstance().setWait();
    setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
    
    FtpModule ftp = new FtpModule(tree);
    OutputStream os;
    
    try {
      if (m_fileName.getText() != null) {
	os = new FileOutputStream(m_fileName.getText());
	ftp.sendFileLocal(m_type,m_fileName.getText(),os);
	os.close();
      }
      else {
	JOptionPane.showMessageDialog(Cpe.sharedInstance().getFrame(), 
				      "No file name given!",
				      "CPE Message", 
				      JOptionPane.WARNING_MESSAGE);
      }
    } catch (Exception e) {}

    Cpe.sharedInstance().setNormal();
    setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
  }
  
  /// ACT EXPORT
   private void fileACTExport() {
    
    Cpe.sharedInstance().setWait();
    setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
    
    FtpModule ftp = new FtpModule(tree);
    
    if(ftp.connect(hostName.getText())) {
      if (ftp.login(m_userName.getText(),m_password.getText())) {

	ftp.sendFile(m_type,true, DATADIR + "/" + m_fileName.getText());
	
	ftp.disconnect();
      }
      else {
	JOptionPane.showMessageDialog(Cpe.sharedInstance().getFrame(), 
				      "Unable to login to FTP server!",
				      "CPE Message", 
				      JOptionPane.WARNING_MESSAGE);
	ftp.disconnect();
      }
    }
    else {
      JOptionPane.showMessageDialog(Cpe.sharedInstance().getFrame(), 
				    "Unable to connect!",
				    "CPE Message", 
				    JOptionPane.WARNING_MESSAGE);
    }
    Cpe.sharedInstance().setNormal();
    setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
    //m_frame.repaint();
  }
  private void fileExportACTLocal() {
    Cpe.sharedInstance().setWait();
    setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
    
    FtpModule ftp = new FtpModule(tree);
    OutputStream os;
    
    try {
      if (m_fileName.getText() != null) {
	os = new FileOutputStream(m_fileName.getText());
	ftp.sendFileLocal(m_type,m_fileName.getText(),os);
	os.close();
      }
      else {
	JOptionPane.showMessageDialog(Cpe.sharedInstance().getFrame(), 
				      "No file name given!",
				      "CPE Message", 
				      JOptionPane.WARNING_MESSAGE);
      }
    } catch (Exception e) {}

    Cpe.sharedInstance().setNormal();
    setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
  }

}
