/*
 * @(#)CpeChildPane.java	1.0 98/1/5
 * 
 */

import java.awt.*;
import java.util.*;
import CpeMainPanel;
import CpeScrollPane;
import com.sun.java.swing.*;
import com.sun.java.swing.event.*;
import java.awt.event.*;

/**
 * CpeChildPane holds a toolbar and scroll pane
 *
 * @version 1.0 98/1/5
 * @author Steve Polyak 
 */
public class CpeChildPane extends JPanel {
  CpeScrollPane scroll;
  JToolBar toolBar;
  Dialog aboutBox;

  public CpeChildPane(CpeMainPanel mainPanel, int layer, boolean top) {

    setLayout(new BorderLayout());
    toolBar = new JToolBar();
    addTool(toolBar, "newactivity");
    addTool(toolBar, "newdummy");
    addTool(toolBar, "newtext");
    toolBar.addSeparator();
    addTool(toolBar, "newbefore");
    addTool(toolBar, "newequal");
    toolBar.addSeparator();
    //addTool(toolBar, "expand");
    //if (top == false)
    //  addTool(toolBar, "up");
    addTool(toolBar, "properties");
    toolBar.addSeparator();
    addTool(toolBar, "cut");
    addTool(toolBar, "copy");
    addTool(toolBar, "paste");
    toolBar.addSeparator();
    addTool(toolBar, "aligntop");
    addTool(toolBar, "alignbottom");
    addTool(toolBar, "alignleft");
    addTool(toolBar, "alignright");
    addTool(toolBar, "aligncenter");
    add(toolBar, BorderLayout.NORTH);

    scroll = new CpeScrollPane(mainPanel, layer, top);
    add(scroll, BorderLayout.CENTER);
  }

  public void addTool(JToolBar toolBar, String name) {
    JButton b = 
      (JButton) toolBar.add
      (new JButton(Cpe.sharedInstance().loadImageIcon("images/" +
						      name +
						      ".gif",name)));
    b.setToolTipText(name);
    b.setActionCommand(name);
    b.setMargin(new Insets(0,0,0,0));
    
    //for all of the toolbar commands, we will pass them along to a
    //special process panel method.
    b.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	scroll.panel.toolbarActionPerformed(e);
      }
    });
  }
}

