import com.sun.java.swing.*;
import com.sun.java.swing.text.*;
import com.sun.java.swing.tree.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

import CpeDomainPane;
import CpeTreeItem;
import CpeProcess;

public class CpeActionItem extends CpeTreeItem
{

  CpeProcess process = null;

  CpeActionItem(String label) {
    super(label);
  }

  public void setProcess(CpeProcess process) {
    this.process = process;
  }

  public JPopupMenu createPopup(CpeDomainPane pane) {
    String[] labels = new String[] { 
      "Delete","Cut","-", "Edit"};
      
    String[] commands = new String[] {
      "delproc", "cutproc","-", "editproc"};
      
    JPopupMenu popup = new JPopupMenu();
      
    for(int i=0; i <= 3; i++) {
      if (labels[i].equals("-")) {
	popup.addSeparator();
      }
      else {
	JMenuItem mi = new JMenuItem(labels[i]);
	mi.setActionCommand(commands[i]);
	mi.addActionListener(pane);
	popup.add(mi);
      }
    }
    return popup;
  }


  public void writeOut(FtpModule ftp, DefaultMutableTreeNode node) {

    ftp.writeFunctionStr("process.label",key,label);
    if (process != null ) {

      if (process.taskProcess)
	ftp.cpo_plan.addElement(key); //SORT ref
      else
	ftp.cpo_process.addElement(key); //SORT ref
      ftp.cpo_activity_spec.addElement(key+"as"); //SORT ref

      ftp.writeFunctionStr("process.expands",key,process.expands);
      ftp.write2Relation("process.activity-spec",key,key+"as");
      ftp.writeFunction("process.is-executable",key,
			((process.execProcess) ? "true" : "false"));
      ftp.writeFunction("process.start-timepoint",key,key+"st");
      ftp.cpo_timepoint.addElement(key+"st"); //SORT ref
      ftp.writeFunction("process.finish-timepoint",key,key+"ft");
      ftp.cpo_timepoint.addElement(key+"ft"); //SORT ref

      writeOutProcess(ftp);
    }
  }

  private void writeOutProcess(FtpModule ftp) {
      
    CpeNode tempNode = null;
    CpeEdge tempEdge = null;

    //write out variables
    writeVariables(ftp);

    int count = 0;

    //write nodes
    for  (Enumeration e =  process.m_nodes.elements() ; 
	  e.hasMoreElements()  ;count++)  {	
      tempNode = (CpeNode) e.nextElement();
      //save the reference key
      tempNode.tempSaveKey = key+"n"+count;
      ftp.writeFunction("include-node",key+"c"+count,tempNode.tempSaveKey);
      ftp.cpo_include_c.addElement(key+"c"+count); //record it for SORT
      ftp.write2Relation("member",key+"c"+count,key+"as");
      ftp.writeFunctionStr("node.label",tempNode.tempSaveKey
			   ,tempNode.m_lbl.replace('\n', '~'));

      //position extensions
      ftp.writeFunction("node.xpos",tempNode.tempSaveKey,
			"" + tempNode.m_x);
      ftp.writeFunction("node.ypos",tempNode.tempSaveKey,
			"" + tempNode.m_y);
	
      //0 is always finish/end and 1 is always start/begin... 
      if (count == 0) {
	ftp.writeFunction("finish.timepoint", tempNode.tempSaveKey,
			  tempNode.tempSaveKey+"bt");	  
	ftp.cpo_timepoint.addElement(tempNode.tempSaveKey+"bt"); //SORT ref
	if (process.startFinishFlag)
	  ftp.cpo_finish.addElement(tempNode.tempSaveKey); //SORT ref
	else
	  ftp.cpo_end.addElement(tempNode.tempSaveKey); //SORT ref
      }
      else if (count == 1) {
	ftp.writeFunction("start.timepoint", tempNode.tempSaveKey,
			  tempNode.tempSaveKey+"et");	  
	ftp.cpo_timepoint.addElement(tempNode.tempSaveKey+"et"); //SORT ref
	if (process.startFinishFlag)
	  ftp.cpo_start.addElement(tempNode.tempSaveKey); //SORT ref
	else
	  ftp.cpo_begin.addElement(tempNode.tempSaveKey); //SORT ref
      }
      else {
	ftp.cpo_action.addElement(tempNode.tempSaveKey); //SORT ref
	ftp.writeFunctionStr("activity.pattern",key+
			     "n"+count,tempNode.pattern);
	ftp.writeFunction("activity.begin-timepoint", tempNode.tempSaveKey,
			  tempNode.tempSaveKey+"bt");	  
	ftp.cpo_timepoint.addElement(tempNode.tempSaveKey+"bt"); //SORT ref
	ftp.writeFunction("activity.end-timepoint", tempNode.tempSaveKey,
			  tempNode.tempSaveKey+"et");
	ftp.cpo_timepoint.addElement(tempNode.tempSaveKey+"et"); //SORT ref

      }
    }
    //write out temporal constraints

    for  (Enumeration e1 =  process.m_edges.elements() ; 
	  e1.hasMoreElements()  ;count++)  {	
      tempEdge = (CpeEdge) e1.nextElement();

      ftp.cpo_ordering_c.addElement(key+"c"+count); //record it for SORT
      if ("CpeEqEdge".equals(tempEdge.getClass().getName())) {

	ftp.writeFunctionStr("constraint.expression", key+"c"+count, 
			     "equal(" +
			     tempEdge.m_from.tempSaveKey +
			     ((tempEdge.fromPosition == true) ? "bt" : "et")
			     + "," + tempEdge.m_to.tempSaveKey +
			     ((tempEdge.toPosition == true) ? "bt" : "et")+
			     ")");
      }
      else {
	ftp.writeFunctionStr("constraint.expression", key+"c"+count, 
			     "before(" +
			     tempEdge.m_from.tempSaveKey +
			     ((tempEdge.fromPosition == true) ? "bt" : "et")
			     + "," +  tempEdge.m_to.tempSaveKey +
			     ((tempEdge.toPosition == true) ? "bt" : "et")+
			     ")");
      }

      ftp.write2Relation("member",key+"c"+count,key+"as");
    }

    //write out conditions
    writeConditions(ftp);
 
    //write out effects
    writeEffects(ftp);
      
    //write out resources
    writeResources(ftp);

    //finally, write out annotations
    count = 0;
    CpeText text = null;
    for  (Enumeration e =  process.m_text.elements() ; 
	  e.hasMoreElements()  ;count++)  {	

      ftp.cpo_annot_c.addElement(key+"ann"+count); //record it for SORT
      text = (CpeText) e.nextElement();
      ftp.write2Relation("member",key+"ann"+count,key+"as");
      ftp.writeFunction("annotation.xpos",key+"ann"+count,
			"" + text.m_x);
      ftp.writeFunction("annotation.ypos",key+"ann"+count,
			"" + text.m_y);
      ftp.writeFunctionStr("constraint.expression", key+"ann"+count, 
			   text.m_lbl.replace('\n', '~'));
    }
  }

  public void writeConditions(FtpModule ftp) {

    String tempCondition = "";
    int count = 0;
    CpeNode tempNode;

    for  (Enumeration e =  process.preconditions.elements() ; 
	  e.hasMoreElements()  ;count++)  {	
      tempCondition = (String) e.nextElement();
      ftp.cpo_input_c.addElement(key+"inp"+count); //record it for SORT

      //need to replace old "act" key references with new ref.
      for  (Enumeration e1 =  process.m_nodes.elements() ; 
	    e1.hasMoreElements()  ;)  {	
	tempNode = (CpeNode) e1.nextElement();
	tempCondition = 
	  replaceKey(tempCondition, tempNode.m_key, tempNode.tempSaveKey);
      }

      ftp.writeFunctionStr("constraint.expression", key+"inp"+count, 
			   tempCondition);
      ftp.write2Relation("member",key+"inp"+count,key+"as");
    }
  }

  public void writeEffects(FtpModule ftp) {
    String tempEffect = "";
    int count = 0;

    for  (Enumeration e =  process.effects.elements() ; 
	  e.hasMoreElements()  ;count++)  {	
      tempEffect = (String) e.nextElement();
	
      ftp.cpo_output_c.addElement(key+"out"+count); //record it for SORT

      ftp.writeFunctionStr("constraint.expression", key+"out"+count, 
			   tempEffect);
      ftp.write2Relation("member",key+"out"+count,key+"as");
    }
  }

  public void writeResources(FtpModule ftp) {
    String tempResource = "";
    int count = 0;

    for  (Enumeration e =  process.resources.elements() ; 
	  e.hasMoreElements()  ;count++)  {	
      tempResource = (String) e.nextElement();
	
      ftp.cpo_resource_c.addElement(key+"res"+count); //record it for SORT

      ftp.writeFunctionStr("constraint.expression", key+"res"+count, 
			   tempResource);
      ftp.write2Relation("member",key+"res"+count,key+"as");
    }
  }

  public void writeVariables(FtpModule ftp) {
    String tempVariable = "";
    int count = 1;

    for  (Enumeration e =  process.variables.elements() ; 
	  e.hasMoreElements()  ;count++)  {	
      tempVariable = (String) e.nextElement();
	
      ftp.cpo_var.addElement(key+"var"+count); //record it for SORT

      ftp.writeFunctionStr("var.label",key+"var"+count,tempVariable);
      ftp.write3Relation("process.variable",key,key+"var"+count,count);
    }
  }
    

  public String replaceKey(String text, String pattern, String newPattern) {
    //uses a modified rabin-karp algo for text search

    String outString = "";
    long q = 2113929255l, d = 32, d_bits = 5;
    int hit = 0;
    char[] a = text.toCharArray();
    char[] p = pattern.toCharArray();
    int M = p.length, N = a.length;
    long h1 = 0, h2 = 0, dM = 1;
    int i;

    for(i = 0; i < M - 1; i++)
      dM = (dM << d_bits) % q;
      
    for(i = 0; i < M; i++) {
      h1 = ((h1 << d_bits) + (long)p[i]) % q;
      h2 = ((h2 << d_bits) + (long)a[i]) % q;
    }

    /* There's got to be a string in here somewhere */
    i = 0;
    while(h1 != h2 && i < N - M) {
      h2 = (h2 + (q << d_bits) - (long)a[i] * dM) % q;
      h2 = ((h2 << d_bits) + (long)a[i + M]) % q;
      i++;
    }
      
    /* no match */
    if(i >= N - M) {
      hit = -1;
      return text;
    }

    /* match */
    hit = i;
    outString = text.substring(0,i) + newPattern + text.substring(i+M);
    //System.out.println("Match: " + text + " " + pattern + " " + i +" "+ M);
    return outString;
  }

}

