/*
* @(#)Cpe.java	1.0 98/1/5
* This has been converted over for the Common Domain Editor (CDE)    
*/

import com.sun.java.swing.*;
import com.sun.java.swing.event.*;
import com.sun.java.swing.text.*;
import com.sun.java.swing.border.*;
import com.sun.java.swing.tree.*;
import com.sun.java.swing.plaf.*;
import com.sun.java.swing.plaf.metal.*;

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.io.*;
import java.applet.*;
import java.net.*;
import CpeDomainPane;
import CpeFileFTPDialog;

/**
 * Cpe acts as the main content pane for the CpeApplet. All other
 * components are built on top of this class. The class provides
 * a static shared instance that is accesible to all classes. 
 *
 * @version 1.0 98/1/5
 * @author Steve Polyak
 * @author ... and sun's JFC Swing Team
 */
public class Cpe extends JPanel
{
  // This
  Cpe cpe;
    
  // The Frame
  public static JFrame frame;
  public Font defaultFont = new Font("Courier", Font.PLAIN, 12);
	
  // Default UI
  public String currentUI = "Metal";

  public String hostName = "www.dai.ed.ac.uk";
  public String userName = "";
  public String fileName = "";
  public String password = "";
  public String slot="00";
  public String cpaURL="???.dai.ed.ac.uk";
  public int cpaPort=6792;

  public int sessionType = 0;
  // session types: 0=Domain Expert,1=Domain Specialist
	
  // List of open process panels
  Vector processPanelList = new Vector();
	
  // The width and height of the frame
  public static int WIDTH = 690;
  public static int HEIGHT = 520;
  public static int INITIAL_WIDTH = 400;
  public static int INITIAL_HEIGHT = 200;
	
  public int processCount = 0;
  public int objectCount = 0;
  public boolean debugFlag = false;
  public boolean tfExport = false;
  public boolean actExport = false;
	
  // Some components used in the applet
  public JTabbedPane tabbedPane = null;
  public JMenuBar menuBar = null;
  public CpeDomainPane domainPane = null;
  public JSplitPane splitPane = null;
  public CpeFileFTPDialog ftpDlg = null;
  public Dialog closeDlg = null;  
  public Choice closeChoice = null;  
  public Dialog logonDlg = null;  
  public Choice logonChoice = null;  
  public TextField logonName = null;
  public TabPlacementChanger tabPlacement;

  public JTabbedPane statusTabbedPane = null;
  public CpeMessageArea messageArea = null;
  public CpeMessageArea cpaMessageArea = null;
  public JSplitPane workSplitPane = null;
  public JPanel workPane = null;
  public cpd cpdParse = new cpd(System.in); 
  public cpdAct cpdActParse = new cpdAct(System.in);
  
	
	
  //temporary copy space for copy/paste
  public Vector cpNodes = new Vector();
  public Vector cpEdges = new Vector();
  public Vector cpText = new Vector();
	
	
  private static final int oplan_tf_2_3 = 1;
  private static final int sipe_act_2_2 = 2;
  
  // This != null if we are an applet
  java.applet.Applet applet;
  static Cpe instance;
	
  public Cpe() {
    this(null);
  }
  
  /*******************************************/
  /****** Construct the Cde window ********/
  /*******************************************/
  public Cpe(java.applet.Applet anApplet) {
    super(false); // double buffer
    //stp 8-5-1998 super(true);

    instance = this;
    applet = anApplet;
    cpe = this;
    setName("Main Cde Panel");
    setFont(defaultFont);
    getFrame().setTitle("Common Domain Editor");
		
    setLayout(new BorderLayout());
		

    statusTabbedPane = new JTabbedPane();;
    workPane = new JPanel();
    workPane.setLayout(new GridLayout(1,1));
    statusTabbedPane.setPreferredSize(new Dimension(100, 100));
    workPane.setPreferredSize(new Dimension(400, 400));

    //general message panel
    JPanel messagePanel = new JPanel();
    messagePanel.setLayout(new GridLayout(1,1));
    messageArea = new CpeMessageArea();
    messageArea.setEditable(false);
    messageArea.setFont(defaultFont);

    messagePanel.add(new JScrollPane(messageArea));
    statusTabbedPane.addTab("General", null, messagePanel);

    //cpa message panel
    JPanel cpaMessagePanel = new JPanel();
    cpaMessagePanel.setLayout(new GridLayout(1,1));
    cpaMessageArea = new CpeMessageArea();
    cpaMessageArea.setEditable(false);
    cpaMessageArea.setFont(defaultFont);

    cpaMessagePanel.add(new JScrollPane(cpaMessageArea));
    statusTabbedPane.addTab("CPA Output", null, cpaMessagePanel);

    statusTabbedPane.setTabPlacement(JTabbedPane.BOTTOM);

    workSplitPane = new 
      JSplitPane(JSplitPane.VERTICAL_SPLIT, workPane, statusTabbedPane);
    workSplitPane.setContinuousLayout(true);
    workSplitPane.setOneTouchExpandable(true);
    workSplitPane.setPreferredSize(new Dimension(650, 348));
    add(workSplitPane, BorderLayout.CENTER);
    
    updateRoot();
    setNormal();

    // Create a tab pane
    tabbedPane = new JTabbedPane();
		
    // Add magic key to enable timer logging
    tabbedPane.registerKeyboardAction(new ToggleLogging(),
				      KeyStroke.getKeyStroke 
				      ('l', InputEvent.ALT_MASK),
				      WHEN_IN_FOCUSED_WINDOW);
    tabbedPane.setTabPlacement(JTabbedPane.BOTTOM);
  }
	
  public void newProcess(CpeActionItem item) {
		
    if (domainPane == null) {
      newDomain();
    }
    setWait();
    processCount++;
    
    JPanel windowPanel = new JPanel();
    CpeMainPanel panel2 = new CpeMainPanel("Process_" + processCount, item);
		
    panel2.setPreferredSize(new Dimension(434, 232));
    //windowPanel.setDoubleBuffered(true); STP 8-5-1998
    windowPanel.setDoubleBuffered(false);
    windowPanel.setLayout(new BorderLayout());
    windowPanel.add(panel2, BorderLayout.CENTER);
  		
    if ((item.process != null) && (!(item.process.label.equals("")))) {
      tabbedPane.addTab(item.process.label, null, windowPanel);
    }else {
      tabbedPane.addTab(panel2.getKey() + "_1", null, windowPanel);
    }
    setNormal();
    tabbedPane.repaint();
  }

  public void openDomain() {
    newDomain();

    if (domainPane != null) {
      
      if (ftpDlg == null) {
	ftpDlg = new CpeFileFTPDialog
	  ("FTP/File Open...", 'O', domainPane.tree);
      }
      ftpDlg.setLocation(getCenteringPoint(ftpDlg));
      ftpDlg.show();
    }
  }

  public void newDomain() {
    
    setWait();

    if (domainPane != null) {

      //clear all past work
      int count = tabbedPane.getTabCount();
      for (int i = count-1; i > -1; i--) {
	tabbedPane.removeTabAt(i);
      }
		
      //remove(menuBar);
      if (processPanelList.size() > 0) {
	processPanelList.removeAllElements();
	workPane.remove(tabbedPane);
      }
    
      if (splitPane != null) {
	workPane.remove(splitPane);
	splitPane = null;
	domainPane = null;
      }
      processCount = 0;
    }

    domainPane = new CpeDomainPane(this);
		
    domainPane.setPreferredSize(new Dimension(216, 116));
    tabbedPane.setPreferredSize(new Dimension(434, 232));
    
    splitPane = new 
      JSplitPane(JSplitPane.HORIZONTAL_SPLIT, domainPane, tabbedPane);
    splitPane.setContinuousLayout(true);
    splitPane.setOneTouchExpandable(true);
    splitPane.setPreferredSize(new Dimension(650, 348));
    workPane.add(splitPane, BorderLayout.CENTER);
    
    updateRoot();
    setNormal();
  }
	
  public void showLogon() {
    Object[] message = new Object[3];
    JComboBox cb = new JComboBox();
    cb.addItem("Domain Expert");
    cb.addItem("Domain Specialist");
		
    message[0] = "Select your role for this session and type in your name:";

    try {
      message[2] = new JTextField(System.getProperty("user.name"));
    } catch (SecurityException er) {
      message[2] = new JTextField();
    }
   
    ((JTextField) message[2]).setFont(defaultFont);
    cb.setFont(defaultFont);
    message[1] = cb;
    
    String[] options = {"OK"};

    JOptionPane.showOptionDialog(Cpe.sharedInstance().getFrame(), 
				 message, 
				 "CDE Logon", 
				 JOptionPane.DEFAULT_OPTION, 
				 JOptionPane.QUESTION_MESSAGE,
				 null, options, options[0]);
    userName = ((JTextField) message[2]).getText();
    sessionType = cb.getSelectedIndex();

    //building menu based on session type
    menuBar = createMenuBar();
    add(menuBar, BorderLayout.NORTH);
    updateRoot();
  } 
	
	
  public void newLogon() {
		
    //clear all past work
    int count = tabbedPane.getTabCount();
    for (int i = count-1; i > -1; i--) {
      tabbedPane.removeTabAt(i);
    }
		
    remove(menuBar);
    if (processPanelList.size() > 0) {
      processPanelList.removeAllElements();
      workPane.remove(tabbedPane);
    }
    
    if (splitPane != null) {
      workPane.remove(splitPane);
      splitPane = null;
      domainPane = null;
    }
    processCount = 0;
    updateRoot();
    showLogon();
    
  }
	
  class ToggleLogging extends AbstractAction {
    public void actionPerformed(ActionEvent e) {
      Timer.setLogTimers(!Timer.getLogTimers());
    }
		
    public boolean isEnabled() {
      return true;
    }
  }
	
	
  /**
   * MenuBar
   */
  Dialog aboutBox;
  JDialog helpBox;
  JCheckBoxMenuItem cb;
  JRadioButtonMenuItem rb;
  
  JMenuBar createMenuBar() {
    // MenuBar
    JMenuBar menuBar = new JMenuBar();
    menuBar.setFont(defaultFont);
    JMenuItem mi;
    JMenu mDomain;
		
    // File Menu
    JMenu file = (JMenu) menuBar.add(new JMenu("File"));
    //file.setMnemonic('F');
		
    //mDomain = (JMenu) file.add(new JMenu("Domain"));
    
    mi = (JMenuItem) file.add(new JMenuItem("New Domain"));
    //    mi.setMnemonic('N');
    mi.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	Cpe.this.newDomain();
      }
    });
    mi = (JMenuItem) file.add(new JMenuItem("Open Domain..."));
    //mi.setMnemonic('O');
    mi.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	Cpe.this.openDomain();
      }
    });
      
    mi = (JMenuItem) file.add(new JMenuItem("Save Domain As..."));
    //    mi.setMnemonic('S');
    mi.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	Cpe.this.saveDomainAs();
      }
    });
    
    file.add(new JSeparator());
    JMenu export = (JMenu) file.add(new JMenu("Export to..."));
    //    export.setMnemonic('E');
    mi = (JMenuItem) export.add(new JMenuItem("TF v2.3"));    
    mi.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	exportTo(oplan_tf_2_3);
      }
    });

    
    //    export.setMnemonic('E');
    mi = (JMenuItem) export.add(new JMenuItem("Act v2.2"));    
    mi.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	exportTo(sipe_act_2_2);
      }
    });

   
   
    //    export.setMnemonic('E');
    mi = (JMenuItem) export.add(new JMenuItem("PDDL"));    
    mi.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	exportTo(sipe_act_2_2);
      }
    });
   
   
    //    export.setMnemonic('E');
    mi = (JMenuItem) export.add(new JMenuItem("NIST-PSL"));    
    mi.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	exportTo(sipe_act_2_2);
      }
    });

    mi = (JMenuItem) file.add(new JMenuItem("Logoff"));
    //    mi.setMnemonic('L');
    mi.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	newLogon();
      }
    });
    file.add(new JSeparator());
    mi = (JMenuItem) file.add(new JMenuItem("Exit"));
    //mi.setKeyAccelerator('x');
    //    mi.setMnemonic('x');
    mi.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	System.exit(0);
      }
    });
    
    // Options Menu
    JMenu options = (JMenu) menuBar.add(new JMenu("Options"));
    //options.setKeyAccelerator('p');
    //    options.setMnemonic('p');		
    ButtonGroup group = new ButtonGroup();
    ToggleUIListener toggleUIListener = new ToggleUIListener();
    rb = (JRadioButtonMenuItem) 
      options.add(new JRadioButtonMenuItem("Windows Style Look and Feel"));
    rb.setSelected(UIManager.getLookAndFeel().getName().equals("Windows"));
    group.add(rb);
    rb.addItemListener(toggleUIListener);
    
    rb = (JRadioButtonMenuItem)
      options.add(new JRadioButtonMenuItem("Motif Look and Feel"));
    rb.setSelected(UIManager.getLookAndFeel().getName().equals("CDE/Motif"));
    group.add(rb);
    rb.addItemListener(toggleUIListener);
    
    rb = (JRadioButtonMenuItem)
      options.add(new JRadioButtonMenuItem("Macintosh Look and Feel"));
    rb.setSelected(UIManager.getLookAndFeel().getName().equals("Macintosh"));
    //rb.setEnabled(false);
    group.add(rb);
    rb.addItemListener(toggleUIListener);
    
    rb = (JRadioButtonMenuItem)
      options.add(new JRadioButtonMenuItem("Java Look and Feel (Metal)"));
    rb.setSelected(UIManager.getLookAndFeel().getName().equals("Metal"));
    group.add(rb);
    rb.addItemListener(toggleUIListener);

    rb = (JRadioButtonMenuItem)
      options.add(new JRadioButtonMenuItem("Java Look and Feel (Khaki)"));
    rb.setSelected(UIManager.getLookAndFeel().getName().equals("Khaki"));
    group.add(rb);
    rb.addItemListener(toggleUIListener);

    rb = (JRadioButtonMenuItem)
      options.add(new JRadioButtonMenuItem("Java Look and Feel (Emerald)"));
    rb.setSelected(UIManager.getLookAndFeel().getName().equals("Emerald"));
    group.add(rb);
    rb.addItemListener(toggleUIListener);
		    
    // Tab Placement submenu
    options.add(new JSeparator());
	
    tabPlacement = new TabPlacementChanger();
    tabPlacement.getAccessibleContext().setAccessibleDescription
      ("Sub-menu containing options for placement of the TabbedPane");
    options.add(tabPlacement);
    
    options.add(new JSeparator());
		
    cb = (JCheckBoxMenuItem) 
      options.add(new JCheckBoxMenuItem("Debugging"));
    cb.setSelected(false);
    
    ActionListener l = new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	if(cb.isSelected()) {
	  Cpe.sharedInstance().setDebug(true);
	} else {
	  Cpe.sharedInstance().setDebug(false);
	}
      }
    };
    cb.addActionListener(l);
    
    //tools Menu
    JMenu tools = (JMenu) menuBar.add(new JMenu("Tools"));
    JMenu assist = (JMenu) tools.add(new JMenu("Assistant"));
    //JMenu planner = (JMenu) tools.add(new JMenu("Planner"));
    mi = (JMenuItem) assist.add(new JMenuItem("Check Process"));
    mi.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
				
	//first check to see if there are any open processes, if not
        //say so and return. else we need to collect the processes
        //and put them in a listbox to choose from. pass the chosen
        //process onto the check process method.

	if (processCount==0) {
	  JOptionPane.showMessageDialog(Cpe.sharedInstance().getFrame(), 
					"There are no processes.", 
					"CDE Message", 
					JOptionPane.INFORMATION_MESSAGE);     
	  return;
	}

	Object[] message = new Object[4];
	message[0] = "Setup CPA address and port then click OK:";
	message[1] = new JTextField(Cpe.sharedInstance().cpaURL);
	message[2] = new JTextField(""+Cpe.sharedInstance().cpaPort);
        Choice whichProcess = new Choice();
        message[3] = whichProcess;
	((JTextField) message[1]).setFont(defaultFont);
	((JTextField) message[2]).setFont(defaultFont);

        CpeProcessPanel tempPanel = null;
	for  (Enumeration ep =  processPanelList.elements() ; 
	      ep.hasMoreElements()  ;)  {	
	  tempPanel = (CpeProcessPanel) ep.nextElement();
	  whichProcess.addItem(tempPanel.process.label);
	}
	whichProcess.select(0);
    
	String[] optionsd = {"OK","Cancel"};

	int result = JOptionPane.showOptionDialog
	  (Cpe.sharedInstance().getFrame(), 
	   message, 
	   "CPA Setup", 
	   JOptionPane.DEFAULT_OPTION, 
	   JOptionPane.QUESTION_MESSAGE,
	   null, optionsd, optionsd[0]);
	
	if (result == 1) return;

	Cpe.sharedInstance().cpaURL = ((JTextField) message[1]).getText();
	Cpe.sharedInstance().cpaPort 
	  = (new Integer((((JTextField) message[2]).getText()))).intValue();

	setWait();
	//fetch the selected process
	for  (Enumeration ef =  processPanelList.elements() ; 
	      ef.hasMoreElements()  ;)  {	
	  tempPanel = (CpeProcessPanel) ef.nextElement();
	  if(tempPanel.process.label.equals
	     (whichProcess.getItem(whichProcess.getSelectedIndex()))) {
	    break;
	  }
	}
	if (tempPanel != null)
	  cpaProcessCheck(tempPanel); 
	setNormal();
      } 
    });

    //Help Menu
    JMenu help = (JMenu) menuBar.add(new JMenu("Help"));
    //file.setKeyAccelerator('H');
    //help.setMnemonic('H');
    mi = (JMenuItem) help.add(new JMenuItem("About"));
    //mi.setKeyAccelerator('t');
    //mi.setMnemonic('t');
    mi.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	if(aboutBox == null) {
	  aboutBox = new Dialog(Cpe.sharedInstance().getFrame(),
				"About CPE", false);
	  JPanel groupPanel = new JPanel(new BorderLayout());
	  ImageIcon groupPicture = 
	    loadImageIcon("images/Copyright.gif",
			  "Common Process Editor (CPE)");
	  aboutBox.add(groupPanel, BorderLayout.CENTER);
	  groupPanel.add(new JLabel(groupPicture), BorderLayout.CENTER);
	  JPanel buttonPanel = new JPanel(true);
	  groupPanel.add(buttonPanel, BorderLayout.SOUTH);
	  JButton button = (JButton) buttonPanel.add(new JButton("OK"));
	  button.addActionListener(new ActionListener() {
	    public void actionPerformed(ActionEvent e) {
	      aboutBox.setVisible(false);
	    }
	  });
	}
	aboutBox.pack();
	aboutBox.setLocation(getCenteringPoint(aboutBox));
	aboutBox.show();
      }
    });
    mi = (JMenuItem) help.add(new JMenuItem("Contents"));
    //mi.setKeyAccelerator('C');
    //mi.setMnemonic('C');
    mi.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {

	JOptionPane.showMessageDialog(Cpe.sharedInstance().getFrame(), 
				      "Help is currently unavailable.", 
				      "CDE Message", 
				      JOptionPane.INFORMATION_MESSAGE);	
      }
    });
    
    return menuBar;
  }
  

  /**
   * Tab Listener
   */
  void createTabListener() {
    // add listener to know when we've been shown
    ChangeListener changeListener = new ChangeListener() {
      public void stateChanged(ChangeEvent e) {
	JTabbedPane tab = (JTabbedPane) e.getSource();
	if (tab.getTabCount() > 0) {
	  int index = tab.getSelectedIndex();
	  Component currentPage = tab.getComponentAt(index);
	  RepaintManager repaintManager = 
	    RepaintManager.currentManager(instance);
	  
	  if(!repaintManager.isDoubleBufferingEnabled()) {
	    repaintManager.setDoubleBufferingEnabled(true);
	  }
	}
      }
    };
    tabbedPane.addChangeListener(changeListener);
  } 


  /**
   * Switch the between the Windows, Motif, Mac, and the Java Look and Feel
   */
  class ToggleUIListener implements ItemListener {
    public void itemStateChanged(ItemEvent e) {
      //there are no processes yet.
      // if (processPanelList.size() == 0)
      //return;
		
      setWait();
      JRadioButtonMenuItem rb = (JRadioButtonMenuItem) e.getSource();
      try {
	if(rb.isSelected() &&
	   rb.getText().equals("Windows Style Look and Feel")) {
	  currentUI = "Windows";
	  UIManager.setLookAndFeel
	    ("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
	  tabPlacement.setEnabled(true);
	  SwingUtilities.updateComponentTreeUI(getRootComponent());
	} else if(rb.isSelected()
		  && rb.getText().equals("Macintosh Look and Feel")) {
	  currentUI = "Macintosh";
	  UIManager.setLookAndFeel
	    ("com.sun.java.swing.plaf.mac.MacLookAndFeel");
	  tabPlacement.setEnabled(false);
	  SwingUtilities.updateComponentTreeUI(getRootComponent());
	} else if(rb.isSelected()
		  && rb.getText().equals("Motif Look and Feel")) {
	  currentUI = "Motif";
	  UIManager.setLookAndFeel
	    ("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
	  tabPlacement.setEnabled(true);
	  SwingUtilities.updateComponentTreeUI(getRootComponent());
	} else if(rb.isSelected()
		  && rb.getText().equals("Java Look and Feel (Metal)")) {
	  currentUI = "Metal";
	  // com.sun.java.swing.jlf.JLFLookAndFeel.setCurrentTheme
	  //( new com.sun.java.swing.jlf.JLFDefaultTheme()); 
	  UIManager.setLookAndFeel
	    ("com.sun.java.swing.plaf.metal.MetalLookAndFeel");
	  MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
	  tabPlacement.setEnabled(true);
	  SwingUtilities.updateComponentTreeUI(getRootComponent());
	} else if(rb.isSelected()
		  && rb.getText().equals("Java Look and Feel (Khaki)")) {
	  currentUI = "Khaki";
	  MetalLookAndFeel.setCurrentTheme(new KhakiMetalTheme());
	  UIManager.setLookAndFeel
	    ("com.sun.java.swing.plaf.metal.MetalLookAndFeel");	    
	  tabPlacement.setEnabled(true);
	  SwingUtilities.updateComponentTreeUI(getRootComponent());
	} else if(rb.isSelected()
		  && rb.getText().equals("Java Look and Feel (Emerald)")) {
	  currentUI = "Emerald";
	  MetalLookAndFeel.setCurrentTheme(new GreenMetalTheme());
	  UIManager.setLookAndFeel
	    ("com.sun.java.swing.plaf.metal.MetalLookAndFeel");	    
	  tabPlacement.setEnabled(true);
	  SwingUtilities.updateComponentTreeUI(getRootComponent());
	}

      } catch (Exception exc) {
	rb.setEnabled(false);
	System.err.println("Could not load LookAndFeel: " + rb.getText());
      }
      
      updateRoot();
      setNormal();
    }
  }
  
  class TabPlacementChanger extends JMenu implements ItemListener {
    JRadioButtonMenuItem topRb, leftRb, rightRb, bottomRb;
    
    public TabPlacementChanger() {
      super("Tab Placement");
      
      ButtonGroup tabGroup = new ButtonGroup();
      
      topRb = (JRadioButtonMenuItem)add(new JRadioButtonMenuItem("Top"));
      topRb.getAccessibleContext().setAccessibleDescription
	("Position the TabbedPane on the top of the window");
      topRb.addItemListener(this);
      tabGroup.add(topRb);
      
      leftRb = (JRadioButtonMenuItem)add(new JRadioButtonMenuItem("Left"));
      leftRb.getAccessibleContext().setAccessibleDescription
	("Position the TabbedPane on the left of the window");
      leftRb.addItemListener(this);
      tabGroup.add(leftRb);
      
      bottomRb = (JRadioButtonMenuItem)add(new JRadioButtonMenuItem
					   ("Bottom"));
      bottomRb.getAccessibleContext().setAccessibleDescription
	("Position the TabbedPane on the bottom of the window");
      bottomRb.setSelected(true);
      bottomRb.addItemListener(this);
      tabGroup.add(bottomRb);
      
      rightRb = (JRadioButtonMenuItem)add(new JRadioButtonMenuItem("Right"));
      rightRb.getAccessibleContext().setAccessibleDescription
	("Position the TabbedPane on the right of the window");
      rightRb.addItemListener(this);
      tabGroup.add(rightRb);
    }

    public void itemStateChanged(ItemEvent e) {
      JRadioButtonMenuItem rb = (JRadioButtonMenuItem) e.getSource();
      if (rb.isSelected()) {
	String selected = rb.getText();
	int placement;
	if (selected.equals("Top")) {
	  placement = JTabbedPane.TOP;
	} else if (selected.equals("Left")) {
	  placement = JTabbedPane.LEFT;
	} else if (selected.equals("Bottom")) {
	  placement = JTabbedPane.BOTTOM;
	} else {
	  placement = JTabbedPane.RIGHT;
	}
	tabbedPane.setTabPlacement(placement);
	tabbedPane.validate();
      }
    }

    public void setEnabled(boolean enabled) {
      super.setEnabled(enabled);
      if (!enabled) {
	topRb.setSelected(true);
      } else {
	int placement = tabbedPane.getTabPlacement();
	switch(placement) {
	case JTabbedPane.TOP:
	  topRb.setSelected(true);
	  break;
	case JTabbedPane.LEFT:
	  leftRb.setSelected(true);
	  break;
	case JTabbedPane.BOTTOM:
	  bottomRb.setSelected(true);
	  break;
	case JTabbedPane.RIGHT:
	  rightRb.setSelected(true);
	  break;
	default:
	}
      }
    }
  }

  public ImageIcon loadImageIcon(String filename, String description) {
    if(applet == null) {
      return new ImageIcon(filename, description);
    } else {
      URL url;
      try {
	url = new URL(applet.getCodeBase(),filename);
      } catch(MalformedURLException e) {
	return null;
      }
      return new ImageIcon(url, description);
    }
  }

  public static Cpe sharedInstance() {
    return instance;
  }
  
  public java.applet.Applet getApplet() {
    return applet;
  }

  public boolean isApplet() {
    return (applet != null);
  }

  public Container getRootComponent() {
    if(isApplet())
      return applet;
    else
      return frame;
  }

  public Frame getFrame() {
    if(isApplet()) {
      Container parent;
      for(parent = getApplet();
	  parent != null && !(parent instanceof Frame) ;
	  parent = parent.getParent());
      if(parent != null)
	return (Frame)parent;
      else
	return null;
    } else
      return frame;
  }

  public void addProcess(CpeProcessPanel panel) {
    processPanelList.addElement(panel);
  }

  public void openProcess() {
  }
  
  public void saveAsProcess() {
  }

  public void saveDomainAs() {
    
    if (domainPane != null) {
      
      if (ftpDlg == null) {
	ftpDlg = new 
	  CpeFileFTPDialog("FTP/File Save...", 'S', domainPane.tree);
      }
      ftpDlg.setLocation(getCenteringPoint(ftpDlg));
      ftpDlg.show();
    }
  }
  
  public void setWait() {
    Component root = Cpe.sharedInstance().getRootComponent();
    root.setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
  }
  
  public void setNormal() {
    Component root = Cpe.sharedInstance().getRootComponent();
    root.setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
  }
  
  public void updateRoot() {
    Component root = Cpe.sharedInstance().getRootComponent();
    root.invalidate();
    root.validate();
    root.repaint();
  }
  
  public void setDebug(boolean flag) {
    debugFlag = flag;
  }
  
  public Point getCenteringPoint(Dialog dialog) {
    Point point = new Point();
    Frame frame = getFrame();
    
    Point fLoc = frame.getLocation();
    Dimension fSize = frame.getSize();
    Dimension dSize = dialog.getSize();
    
    point.x = (fLoc.x + fSize.width/2) - (dSize.width/2);
    point.y = (fLoc.y + fSize.height/2) - (dSize.height/2);
    
    return point;
  }
  
  public void renameTab(String original, String newlabel) {
    
    int count = tabbedPane.getTabCount();
    
    for (int i = 0; i < count; i++) {
      if (original.equals(tabbedPane.getTitleAt(i))) {
	tabbedPane.setTitleAt(i, newlabel);
	break;
      }
    }
  }
  
  public void clearCopySpace() {
    cpNodes.removeAllElements();
    cpEdges.removeAllElements();
    cpText.removeAllElements();
  }
  
  public void closeProcess(String process) {
    int count = tabbedPane.getTabCount();
    
    //remove the tab
    for (int i = 0; i < count; i++) {
      if (process.equals(tabbedPane.getTitleAt(i))) {
	tabbedPane.removeTabAt(i);
	break;
      }
    }
    
    //remove it from the list
    CpeProcessPanel tempPanel = null;
    for  (Enumeration e =  processPanelList.elements() ; 
	  e.hasMoreElements()  ;)  {	
      tempPanel = (CpeProcessPanel) e.nextElement();
      if(tempPanel.process.label.equals(process)) {
	processPanelList.removeElement(tempPanel);
	break;
      }
    }
  }

  public void closeProcess() {
    
    if (processPanelList.size() == 0) 
      return;
    
    closeDlg = new Dialog(getFrame(),"Close Process...", true);
    closeDlg.setLayout(new BorderLayout(15,15));
    Panel fields = new Panel();
    fields.setLayout(new GridLayout(1,2));
    fields.add(new JLabel("Which process:"));
    closeChoice = new Choice();    
    
    CpeProcessPanel tempPanel = null;
    for  (Enumeration e =  processPanelList.elements() ; 
	  e.hasMoreElements()  ;)  {	
      tempPanel = (CpeProcessPanel) e.nextElement();
      closeChoice.addItem(tempPanel.process.label);
    }
    fields.add(closeChoice);
    
    closeDlg.add("Center",fields);
    
    Panel yn = new Panel();
    JButton btnOK = new JButton("OK");
    yn.add (btnOK);
    btnOK.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	if (Cpe.this.closeDlg != null) {
	  Cpe.this.closeProcess(Cpe.this.closeChoice.getSelectedItem());
	  Cpe.this.closeDlg.dispose();
	  Cpe.this.closeDlg = null;
	}
      }
    });
    
    JButton btnCancel = new JButton("Cancel");
    yn.add (btnCancel);
    btnCancel.addActionListener(new ActionListener() {
      public void actionPerformed(ActionEvent e) {
	if (Cpe.this.closeDlg != null) {
	  Cpe.this.closeDlg.dispose();
	  Cpe.this.closeDlg = null;
	}
      }
    });
    closeDlg.add ("South",yn);
    
    // Resize the window to the preferred size of its components
    closeDlg.pack();
    closeDlg.setLocation(getCenteringPoint(closeDlg));
    closeDlg.show();
  }

  public void bringProcToFront (CpeProcess process) {
    int count = tabbedPane.getTabCount();
    
    for (int i = 0; i < count; i++) {
      if (process.label.equals(tabbedPane.getTitleAt(i))) {
	tabbedPane.setSelectedIndex(i);
	updateRoot();
	break;
      }
    }
    
  }

  public void displayMessage(String message) {
    messageArea.append(message+"\n");
    updateRoot();
  }

  public void displayCPAMessage(String message) {
    cpaMessageArea.append(message+"\n");
    updateRoot();
  }

  public void exportTo(int target) {

    if (domainPane != null) {
      
      if (ftpDlg == null) {
        if (target == oplan_tf_2_3){      
	        ftpDlg = new CpeFileFTPDialog("Export to TF...", 
				      'T', domainPane.tree);
		// it is the 'T' parameter that informs the dialog box
		// that TF is the target
				      
		}
		else if (target == sipe_act_2_2){
		    ftpDlg = new CpeFileFTPDialog("Export to ACT...", 
				      'A', domainPane.tree);
				      
		// it is the 'A' parameter that informs the dialog box
		// that ACT is the target
		}
  
      }
     
      ftpDlg.setLocation(getCenteringPoint(ftpDlg));
      ftpDlg.show();
    }
  }

  private void cpaProcessCheck(CpeProcessPanel panel) {
    Socket s;
    DataInputStream in = null;
    PrintStream out = null;
    String line = null;

    statusTabbedPane.setSelectedIndex
      (statusTabbedPane.indexOfTab("CPA Output"));

    try 
      {
	s = new Socket(Cpe.sharedInstance().cpaURL,
		       Cpe.sharedInstance().cpaPort);
	
	in = new DataInputStream(s.getInputStream());
	out = new PrintStream(s.getOutputStream());

	//asserting nodes 
	CpeNode tempNode;
	for  (Enumeration en =  panel.process.m_nodes.elements() ; 
	      en.hasMoreElements()  ;)  {	
	  tempNode = (CpeNode) en.nextElement();
	  out.println("add_node("+prologPrepStr(tempNode.m_lbl)+").");
	  flushInput(in);
	}

	//asserting orderings - still need the equals
	CpeEdge tempEdge;
	for  (Enumeration ed =  panel.process.m_edges.elements() ; 
	      ed.hasMoreElements()  ;)  {	
	  tempEdge = (CpeEdge) ed.nextElement();
	  if (("CpeEqEdge".equals(tempEdge.getClass().getName()))) {
	    out.println("add_equal(" +
			(tempEdge.fromPosition ? 
			 "begin_point(" : "end_point(")+
			prologPrepStr(tempEdge.m_from.m_lbl) +
			")," +
			(tempEdge.toPosition ? "begin_point(" : "end_point(")+
			prologPrepStr(tempEdge.m_to.m_lbl) +
			")).");
	  } else {
	    out.println("add_before(" +
			(tempEdge.fromPosition ? 
			 "begin_point(" : "end_point(")+
			prologPrepStr(tempEdge.m_from.m_lbl) +
			")," +
			(tempEdge.toPosition ? "begin_point(" : "end_point(")+
			prologPrepStr(tempEdge.m_to.m_lbl) +
			")).");
	  }
	  flushInput(in);
	}

	//requesting check_process
	out.println("check_process.");
	for (;;) {
	  line = in.readLine();
	  if (line.equals("end")) break;
	  displayCPAMessage(line);
	}

	out.println("bye.");
	if (out != null) out.close(); 
	if (in != null) in.close(); 
	
      } catch (IOException ef) {}
      
  }

  private void flushInput(DataInputStream in) {
    String line = null;

    try {
      for (;;) {
	line = in.readLine();
	if (line.equals("end")) break;
      }
    } catch (Exception e) {}
  }

  /** 
   * prologPrepStr cleans up a string to be sent to sicstus
   *
   */
  private String prologPrepStr(String string) {
    return 
      string.toLowerCase().replace('\n','_').replace(' ','_')
      .replace('?','v').replace('(','_').replace(')','_').replace('-','_');
  }



  public class KhakiMetalTheme extends DefaultMetalTheme {

    public String getName() { return "Sandstone"; }

    private final ColorUIResource primary1 = new 
    ColorUIResource( 87,  87,  47);
    private final ColorUIResource primary2 = new 
    ColorUIResource(159, 151, 111);
    private final ColorUIResource primary3 = new 
    ColorUIResource(199, 183, 143);
    
    private final ColorUIResource secondary1 = new 
    ColorUIResource( 111,  111,  111);
    private final ColorUIResource secondary2 = new 
    ColorUIResource(159, 159, 159);
    private final ColorUIResource secondary3 = new 
    ColorUIResource(231, 215, 183);
    
    protected ColorUIResource getPrimary1() { return primary1; }
    protected ColorUIResource getPrimary2() { return primary2; }
    protected ColorUIResource getPrimary3() { return primary3; }
    
    protected ColorUIResource getSecondary1() { return secondary1; }
    protected ColorUIResource getSecondary2() { return secondary2; }
    protected ColorUIResource getSecondary3() { return secondary3; }
    
  }


  public class GreenMetalTheme extends DefaultMetalTheme {
    
    public String getName() { return "Emerald"; }
    
    // greenish colors
    private final ColorUIResource primary1 = new 
    ColorUIResource(51, 102, 51);
    private final ColorUIResource primary2 = new 
    ColorUIResource(102, 153, 102);
    private final ColorUIResource primary3 = new 
    ColorUIResource(153, 204, 153); 
    
    protected ColorUIResource getPrimary1() { return primary1; }  
    protected ColorUIResource getPrimary2() { return primary2; } 
    protected ColorUIResource getPrimary3() { return primary3; } 

  }
}

