/*
* @(#)CdeSpecAct.java	1.0 98-May-18
* 
*/

import java.util.*;
import java.awt.*;
import com.sun.java.swing.tree.*;
import actNode.*;

/**
 * Common Domain Editor (CDE) specification class.
 *
 * This class accumulates the parsed domain specification and translates
 * it to the internal cpe structures.
 *
 * @version 1.0 98/5/18
 * @author Steve Polyak
 */

public class CdeSpecAct extends Object {

Hashtable types = new Hashtable(); //stores the new types
  Hashtable always = new Hashtable(); //stores the always items
  Hashtable plans = new Hashtable(); //stores the plans
  Hashtable processes = new Hashtable(); //stores the schemas
  Hashtable resources = new Hashtable(); //stores the objects
  Hashtable levels = new Hashtable(); //stores the levels
  Hashtable parents = new Hashtable(); //stores the new object parent hier
  Hashtable sortElements = new Hashtable(); //stores all SORT defined objects
  java.io.PrintStream stream = null;
  String domainName = "";

    int initalOnlyUseIfCount = 0;
    int initalAchieveCount = 0;
    int initalUnsupervisedCount = 0;
    int initalSupervisedCount = 0;

  CdeSpecAct() {
  }

  public void reset() {
    types = new Hashtable(); //stores the new types
    always = new Hashtable(); //stores the always items
    plans = new Hashtable(); //stores the plans
    processes = new Hashtable(); //stores the schemas
    resources = new Hashtable(); //stores the objects
    levels = new Hashtable(); //stores the levels
    parents = new Hashtable(); //stores the levels
    sortElements = new Hashtable(); //stores all SORT defined objects
    stream = null;
    domainName = "";
  }

 
  

  //*_*_*_*_*_ ACT Writing Code *_*_*_*_*_*_


// writeout is the main TF writing driver.
  public void writeOut(java.io.PrintStream stream) {
    this.stream = stream;
    writeHeader();
    writeTypes();
    //writeAlways();
    //writeResourceInfo();
    //writeTasks();
    //writeSchemas();
    
    writeActs();

  }










  public void writeHeader() {
    stream.println(";;; Domain: " + domainName);
    stream.println("");
    stream.println(";;; Common Process Translator CPL-->Act v2.2");
    stream.println(";;; Author: Peter Jarvis, AIAI, Edinburgh University");
    stream.println(";;; Act Description generated on: " + new Date());
    stream.println("");
  }

  private void writeTypes() {
    String typeString = "";
    SpecItem obj = null;
    SpecTypeItem item = null;
    int i = 0;
    for  (Enumeration e =  types.elements(); e.hasMoreElements()  ;i++)  {
      item = (SpecTypeItem) e.nextElement();
      if (i == 0) {
	typeString = "CLASS: "+ item.label.replace('\"',' ').trim()+""; 
      }
      else {
	typeString = "CLASS " + item.label.replace('\"',' ').trim()+""; 
      }
      
    stream.println(typeString);
    
      for  (Enumeration e1 =  item.instances.elements(); 
	    e1.hasMoreElements()  ;i++)  {
	obj = (SpecItem) e1.nextElement();
	typeString = "INSTANCES: " + obj.label.replace('\"',' ').trim();
      }
      typeString = typeString + "";
      
      stream.println(typeString);
    }
    stream.println("");
  }

  private void writeAlways() {
    String outString = "always ";
    SpecItem obj = null;
    int i = 0;
    for  (Enumeration e =  always.elements(); e.hasMoreElements()  ;i++)  {
      obj = (SpecItem) e.nextElement();
      if (i == 0) {
	outString = outString + obj.label.replace('\"',' ').trim(); 
      }
      else {
	outString = "       " + obj.label.replace('\"',' ').trim(); 
      }
      if (e.hasMoreElements()) {
	outString = outString + ",";
      }
      else {
	outString = outString + ";";
      }
      stream.println(outString);
    }
    stream.println("");
  }

 /* private void writeTasks() {
    String outString = "task ";
    SpecProcessItem obj = null;
    for  (Enumeration e =  plans.elements(); e.hasMoreElements() ;)  {
      obj = (SpecProcessItem) e.nextElement();
      stream.println(outString + 
		     obj.label.replace(' ','_').replace('\"',' ').trim() + 
		     ";");

      writeVariables(obj);

      if (((obj.expands.equals("\"\""))==false) && 
	  ((obj.expands.equals(""))==false)) {
	stream.println("  expands {" + 
		       obj.expands.replace('\"',' ').trim() +
		       "};");
      }
      
      //write nodes
      if (obj.as != null) {
	writeNodes(obj.as, obj, Processes);
      }
      stream.println("end_task;");
      stream.println("");
    }
    stream.println("");
  }*/
  
  private void writeNodes(SpecActSpecItem as, SpecProcessItem dog, Hashtable Processes) {

  
    
    boolean noShow = false; //used to hide begin-end orderings
    String outString = "";
    SpecConstrItem constr = null;
    int nodeCount = 1;
    int actNodeCount = 1;
    int initialCount = 0;
    int startCount = 0;
    int initialOrderingCount = 0;
    int initialInputCount = 0;
    int initialOutputCount = 0;
    int initialResourceCount = 0;
    
    
    
    int currentNodeCount = 1;
    Vector nodeList = new Vector(); // easier to work with a local vector

    Vector actNodeList = new Vector();
    
    String startRelationship = new String();
    String endRelationship = new String();
    int startNode = 999;
    int endNode = 999;
    String tempString = new String();
    // just counts the number of ordering, input, output, resource, and include
    // constraints.
       
    for (Enumeration e1 =  as.constraints.elements();e1.hasMoreElements() ;) {
      constr = (SpecConstrItem) e1.nextElement();
      if ("include-constraint".equals(constr.type) &&
	  ("start".equals(constr.node.type) ||
	   "finish".equals(constr.node.type) ||
	   "action".equals(constr.node.type))) {
	initialCount++;
        if ("start".equals(constr.node.type)) startCount++;
      }
      if ("ordering-constraint".equals(constr.type)) initialOrderingCount++;
      if ("input-constraint".equals(constr.type)) {
        initialInputCount++;
        
        // we need to count the number of instances of each condition type.
        // first token of the constraint label will be its type
    
        String constraintLabel = new String(constr.label.replace('\"',' ').toUpperCase().trim());
        
        StringTokenizer tokenizer = new StringTokenizer(constraintLabel);
    
        String token = tokenizer.nextToken();
    
        if ("ONLY_USE_IF".equals(token)) initalOnlyUseIfCount++;
        if ("ACHIEVE".equals(token)) initalAchieveCount++;
        if ("UNSUPERVISED".equals(token)) initalUnsupervisedCount++;
        if ("SUPERVISED".equals(token)) initalSupervisedCount++;
    
        
      }  
      if ("output-constraint".equals(constr.type)) initialOutputCount++;
      if ("resource-constraint".equals(constr.type)) initialResourceCount++;
    }

    if (startCount > 0) {
      //there are start-finish nodes, need to start count at 3 rather than 1
      currentNodeCount = 3;
    }

   //***************


    for  (Enumeration e =  as.constraints.elements(); e.hasMoreElements() ;) {
      constr = (SpecConstrItem) e.nextElement();
      //----include-----
      if ("include-constraint".equals(constr.type))
	     nodeList.addElement(constr.node);

      if ("include-constraint".equals(constr.type) &&
	     ("start".equals(constr.node.type) ||
	     "finish".equals(constr.node.type) ||
	     "action".equals(constr.node.type))){

	            //update node number for ordering links later
	            if ("start".equals(constr.node.type.toLowerCase())) 
	            constr.node.assignedNumber = 1;
	            else if ("finish".equals(constr.node.type.toLowerCase())) 
	            constr.node.assignedNumber = 2;
	            else
	            constr.node.assignedNumber = currentNodeCount++;
                // end of assign numbers

                actNode tempActNode = new actNode();
                tempActNode.nodeNumber = constr.node.assignedNumber;
                
	            
	            if ("action".equals(constr.node.type)){
	              tempActNode.nodeType = "N";
	            
	                if("".equals((constr.node.pattern.replace('\"',' ').trim()))) { 
	                    tempActNode.matchPattern = 
	                    (constr.node.label.replace('\"',' ').trim().toLowerCase());
	                }
	                else {
	                    tempActNode.matchPattern =
	                    (constr.node.pattern.replace('\"',' ').trim());
	                }
    	            tempActNode.actStartNo = actNodeCount++;
    	            tempActNode.actEndNo = actNodeCount++;
    	            
    	            // find the expansion list
    	            
    	            //**********
    	            for  (Enumeration dax =  Processes.elements(); dax.hasMoreElements() ;) {
                      
                      SpecProcessItem curry = (SpecProcessItem) dax.nextElement();
	                   
	                   if (curry.expands.toUpperCase().replace('\"',' ').trim().equals(tempActNode.matchPattern.toUpperCase().replace('\"',' ').trim())){
	                    
	                        tempActNode.expandsToList.addElement(curry.label.replace('\"',' ').trim());
	                        
	                    
	                   }
	                    
	                   
	                   

    	            }
    	            
    	            //**********
    	        }
	            else { 
	        
	            // should be a start or finish node
	     
	             if ("start".equals(constr.node.type)){
	              
	                tempActNode.matchPattern = "Start";
	                tempActNode.nodeType = "S";
	                tempActNode.actEndNo = actNodeCount++;
	             }
	             else if ("finish".equals(constr.node.type)){
	                tempActNode.matchPattern = "Finish";
	                tempActNode.nodeType = "F";
	                tempActNode.actStartNo = actNodeCount++;
	             }
	    
		 //outString = outString + (constr.node.label.replace('\"',' ').trim().toLowerCase());
	    }
	    
	    actNodeList.addElement(tempActNode);
	    nodeCount++;
      }
    }

    //----orderings-----
   
    int ordCount = 1;
    String fromPos = "";
    String toPos = "";

    for  (Enumeration e3 = as.constraints.elements(); e3.hasMoreElements() ;) {
      constr = (SpecConstrItem) e3.nextElement();

      if ("ordering-constraint".equals(constr.type)) {

	//pull apart e.g. "before(Obj1,Obj2)"
	StringTokenizer st = new 
	  StringTokenizer((constr.label.replace('\"',' ').trim()), "(),");
	int i = 0;
	for  (Enumeration  e2  = st; e2.hasMoreElements()  ; i++)  {	
	  String temp = (String) e2.nextElement();
	  switch (i) 
	    {
	    case 0:
              constr.relation = temp;
	    case 1:
              constr.tp1 = temp;
	    case 2:
              constr.tp2 = temp;
	    }
	}
	noShow = false;
	for  (Enumeration  e5  = nodeList.elements(); e5.hasMoreElements();){
	  SpecNodeItem nodeObj = (SpecNodeItem) e5.nextElement();

      

	  if (("end".equals(nodeObj.type)) || 
	      ("begin".equals(nodeObj.type))) {
	    if ((constr.tp1.equals(nodeObj.beginTimePoint)) ||
		(constr.tp2.equals(nodeObj.beginTimePoint))) {
	      noShow = true;
	    }
	  }
	  if("finish".equals(nodeObj.type)){
	    if (constr.tp1.equals(nodeObj.beginTimePoint)) {
	        startRelationship = "begin_of";
	        startNode = nodeObj.assignedNumber;
	    }
	    if (constr.tp2.equals(nodeObj.beginTimePoint)) {
	        endRelationship = "begin_of";
	        endNode = nodeObj.assignedNumber;
	    }
	  }
	  else if ("start".equals(nodeObj.type)){
	    if (constr.tp1.equals(nodeObj.beginTimePoint)) {
	        startRelationship = "end_of";
	        startNode = nodeObj.assignedNumber;
	    }
	    if (constr.tp2.equals(nodeObj.beginTimePoint)) {
	      endRelationship = "end_of";
	      endNode = nodeObj.assignedNumber;
	    }
	  }
	  else {
	    if(constr.tp1.equals(nodeObj.beginTimePoint)) {
	      startRelationship = "begin_of";
	      startNode = nodeObj.assignedNumber;
	    }
	    else if (constr.tp1.equals(nodeObj.endTimePoint)) {
	      startRelationship = "end_of";
	      startNode = nodeObj.assignedNumber;
	    }
	    if (constr.tp2.equals(nodeObj.beginTimePoint)) {
	      endRelationship = "begin_of";
	      endNode = nodeObj.assignedNumber;
	    }
	    else if (constr.tp2.equals(nodeObj.endTimePoint)) {
	      startRelationship = "end_of";
	      startNode = nodeObj.assignedNumber;
	    }
	  }
	} 
	if (noShow == false) {
	  if ("before".equals(constr.relation)) {
	   
	       // loop through actNodeList
	         
	       
	       for  (Enumeration  e10  = actNodeList.elements(); e10.hasMoreElements();){
	           actNode tempActNode = (actNode) e10.nextElement();
	           if (tempActNode.nodeNumber == startNode){
	                
	                if ("begin_of".equals(startRelationship)){
	                    
	                    if ("begin_of".equals(endRelationship)){
	                        
	                        // link begin to begin. 
	                        
	                        endNode = (endNode + (endNode-1))-2; // convert to Sipe plot node    
	                        
	                        String eva = new String();
	                        eva = ""+endNode;
	                        
	                        tempActNode.startSucc.addElement(eva);
	                    
	                    }
	                    else { // end_relationship equals end of
	                     
	                         // link begin to end    
	                         endNode = (endNode + (endNode))-2; // convert to Sipe plot node    
	                        
	                        String eva = new String();
	                        eva = ""+endNode;
	                        
	                        tempActNode.startSucc.addElement(eva);
	                    }
	                    
	                    
	                    
	                }
	                else { // startRelation must == end_of
	            
	                   if ("begin_of".equals(endRelationship)){
	                       // link end to begin
	                       
	                       endNode = (endNode + (endNode-1))-2; // convert to Sipe plot node    
	                        
	                        String eva = new String();
	                        eva = ""+endNode;
	                        
	                        tempActNode.endSucc.addElement(eva);
	                       
	                    
	                    }
	                    else { // end_relationship equals end of
	                     
	                        // link end to end
	                        
	                        endNode = (endNode + (endNode))-2; // convert to Sipe plot node    
	                        
	                        String eva = new String();
	                        eva = ""+endNode;
	                        
	                        tempActNode.endSucc.addElement(eva);    
	                        
	                    }
	                }
	           }
	        
	       }
	       
	    
	    ordCount ++;
	  }
	}
      }
    }
    

    // start writing the plot.

   /* stream.println("Debug Info comming out...");

   for (Enumeration e12 = actNodeList.elements(); e12.hasMoreElements();){
        actNode tempActNode = (actNode) e12.nextElement();   
        
        stream.println("");
        stream.println("************");
        stream.println("Node Number: "+tempActNode.nodeNumber);
        stream.println("Node Type: "+tempActNode.nodeType);
        stream.println("actStartNo: "+tempActNode.actStartNo);
        stream.println("actEndNo : "+tempActNode.actEndNo);
        stream.println("startSucc :"+tempActNode.startSucc);
        stream.println("endSucc :"+tempActNode.endSucc);
        stream.println("matchPattern :"+tempActNode.matchPattern);
        stream.println("expandsToList :"+tempActNode.expandsToList); 
    }*/


    stream.println("  (PLOT");
    
	for  (Enumeration  e10  = actNodeList.elements(); e10.hasMoreElements();){
	    actNode tempActNode = (actNode) e10.nextElement();
	    
	    if ("S".equals(tempActNode.nodeType)){
	      // start node   
	      stream.println("    (P"+tempActNode.actEndNo+" (TYPE PARALLEL)");
	      // write orderings
	      
	      Vector tempVec = tempActNode.endSucc;
	      String tempStr = new String();      
	      tempStr = "      (ORDERINGS ";
	      for (Enumeration cat = tempVec.elements(); cat.hasMoreElements();){
	      
	       tempStr = tempStr +"(NEXT (P"+cat.nextElement()+"))";
	        
	      }
	       
	      stream.println(tempStr+")");
	      
	      // write conditions
	      writeTheConditions(dog);
	    }
	    else if ("F".equals(tempActNode.nodeType)){
	      // end node;   
	      stream.println("    (P"+tempActNode.actStartNo+" (TYPE PARALLEL)");
	      
	      // write orderings
	      Vector tempVec = tempActNode.endSucc;
	      String tempStr = new String();      
	      tempStr = "      (ORDERINGS (";
	      for (Enumeration cat = tempVec.elements(); cat.hasMoreElements();){
	      
	       tempStr = tempStr +"(NEXT (P"+cat.nextElement()+"))";
	        
	      }
	      stream.println(tempStr+"))");
	      
	      writeTheEffects(dog);
	    }
	    else if ("N".equals(tempActNode.nodeType)){
	      // normal node;   
	     stream.println("    (P"+tempActNode.actStartNo+" (TYPE PARALLEL)");  
	      Vector tempVec = tempActNode.startSucc;
	      String tempStr = new String();      
	      tempStr = "      (ORDERINGS (";
	      for (Enumeration cat = tempVec.elements(); cat.hasMoreElements();){
	      
	       tempStr = tempStr +"(NEXT (P"+cat.nextElement()+"))";
	        
	      }
	      
	      tempStr = tempStr +"(NEXT(P"+tempActNode.actEndNo+")";
	      stream.println(tempStr+")");
	      
	      if (!tempActNode.expandsToList.isEmpty()){
	        stream.print("      (ACHIEVE-BY (("+tempActNode.matchPattern+")");
    	      
	        tempVec = tempActNode.expandsToList;
	        for (Enumeration rabbit = tempVec.elements(); rabbit.hasMoreElements();){
    	       
	            stream.print("("+rabbit.nextElement()+")");
	        }
	        stream.println(")");
	      }
	      
	      stream.println("    (P"+tempActNode.actEndNo+" (TYPE PARALLEL)");  
	      Vector temp1Vec = tempActNode.endSucc;
	      String temp1Str = new String();      
	      temp1Str = "      (ORDERINGS (";
	     for (Enumeration cat = temp1Vec.elements(); cat.hasMoreElements();){
	      
	       temp1Str = temp1Str +"(NEXT (P"+cat.nextElement()+"))";
	        
	      }
	      
	      
	      stream.println(temp1Str+"))");
	    }
    
    }
   stream.println ("  )"); // ;;; END PLOT
  }


  private void writeConditions(int initialCount, SpecActSpecItem as,
			       Vector nodeList) {
    int count = 1;
    SpecConstrItem constr = null;
    SpecNodeItem nodeObj = null;
    String tempCondition = "";
    String outString = "";

    if (initialCount == 0) return;

    for  (Enumeration e =  as.constraints.elements(); e.hasMoreElements() ;) {
      constr = (SpecConstrItem) e.nextElement();

      if ("input-constraint".equals(constr.type)) {

	if (count == 1) outString = "  conditions ";
	else outString = "             ";

	//need to update node id references
	tempCondition = constr.label.replace('\"',' ').trim();
	for  (Enumeration  e1 = nodeList.elements(); e1.hasMoreElements();){
	  nodeObj = (SpecNodeItem) e1.nextElement();
	  tempCondition = 
	    replaceKey(tempCondition, nodeObj.id, 
		       (new Integer(nodeObj.assignedNumber)).toString());
	}
	outString = outString + tempCondition;

	if (initialCount > count) outString = outString + ",";
	else outString = outString + ";";
	stream.println(outString);
	count++;
      }
    }
  }

  private void writeEffects(int initialCount, SpecActSpecItem as) {
    int count = 1;
    SpecConstrItem constr = null;
    String outString = "";

    if (initialCount == 0) return;
    
    for  (Enumeration e =  as.constraints.elements(); e.hasMoreElements() ;) {
      constr = (SpecConstrItem) e.nextElement();

      if ("output-constraint".equals(constr.type)) {

	if (count == 1) outString = "  only_use_for_effects ";
	else outString = "                       ";

	outString = outString + constr.label.replace('\"',' ').trim();

	if (initialCount > count) outString = outString + ",";
	else outString = outString + ";";
	stream.println(outString);
	count++;
      }
    }
  }

  private void writeResources(int initialCount, SpecActSpecItem as) {

    int count = 1;
    SpecConstrItem constr = null;
    String outString = "";

    if (initialCount == 0) return;
    
    for  (Enumeration e =  as.constraints.elements(); e.hasMoreElements() ;) {
      constr = (SpecConstrItem) e.nextElement();

      if ("resource-constraint".equals(constr.type)) {

	if (count == 1) outString = "  resources ";
	else outString = "            ";

	outString = outString + constr.label.replace('\"',' ').trim();

	if (initialCount > count) outString = outString + ",";
	else outString = outString + ";";
	stream.println(outString);
	count++;
      }
    }
  }


  private String fromTFExprToACTExpr(String tfExpression){
    
      String actExpr = new String();
      
      StringTokenizer tokenizer = new StringTokenizer(tfExpression);
      String token = tokenizer.nextToken();
      token = tokenizer.nextToken().replace('{',' ').trim();
      
      actExpr = token+"(";
    
      boolean lastCharWasEquals = false;
      
      while (tokenizer.hasMoreTokens()){
        
            token = tokenizer.nextToken().replace('{',' ').trim();
            token = token.replace('}',' ').trim();
            if (!token.equals("=")){
                
                actExpr = actExpr +  token;
                
                if (!lastCharWasEquals){
                 actExpr = actExpr +", ";   
                }
                
            }
            else
            {
             lastCharWasEquals = true;   
            }
      }
    
      actExpr = actExpr+")";  
    return actExpr;
    
  }

  private void writeActs() {
    String outString = "";
    SpecProcessItem obj = null;
    for  (Enumeration e =  processes.elements(); e.hasMoreElements() ;)  {
     
      // looping for each process --> act
      
      // output name of the act 
      obj = (SpecProcessItem) e.nextElement();
      stream.println("(" + 
		     obj.label.replace(' ','-').replace('\"',' ').toUpperCase().trim());


      writeEnvironment(obj);
      writePlot(obj, processes);
  
    
      stream.println(")");//;;; END PLOT
      stream.println("");
    }
  }

 private void writeEnvironment(SpecProcessItem obj){

   stream.println("  (ENVIRONMENT");
    
   // first part CUE matches "expands" 
    
   if (((obj.expands.equals("\"\""))==false) &&
	  ((obj.expands.equals(""))==false)) {
	stream.println("    (CUE (ACHIEVE (" + 
		       obj.expands.replace('\"',' ').toUpperCase().trim() +
		       ")))");
      }
   
   // write preconditions
   
   if (initalOnlyUseIfCount > 0){
       stream.print("    (PRECONDITIONS (");
   
       if (initalOnlyUseIfCount > 1){
         stream.print(" AND (");
       }
   
        // output only_use_if conditions
        SpecConstrItem constr = null;
        for (Enumeration e1 = obj.as.constraints.elements(); e1.hasMoreElements();){
            constr = (SpecConstrItem) e1.nextElement();
            if ("input-constraint".equals(constr.type)){
                
              String constraintLabel = new String(constr.label.replace('\"',' ').toUpperCase().trim());
              StringTokenizer tokenizer = new StringTokenizer(constraintLabel);
              String token = tokenizer.nextToken();
    
              if ("ONLY_USE_IF".equals(token)){   
                stream.println("("+ fromTFExprToACTExpr(constr.label.replace('\"',' ').toUpperCase().trim()) + ")");
            }
            }
        }
   
   
   
   
       if (initalOnlyUseIfCount > 1){
         stream.print(" )");
       } 
       stream.println("     ))");
   }
   
   
      // write variables
   stream.println("    (SETTING  (TEST (AND");
   writeVariables(obj);
   stream.println("     )))");    ///;;; end TEST
      
      
   
    
      //write Resources
      
   stream.println("    (RESOURCES (USE-RESOURCE");
    
   writeTheResources(obj);
   
   stream.println("     ))"); ///;;; end of RESOURCES
   
   stream.println("    (PROPERTIES");
   stream.println("      (AUTHORING-SYSTEM CDE)");
   stream.println("    )");    ///;;; end of PROPERTIES
   stream.println("  ) ");  ///;;; end of ENVIRONMENT
    
 }
 
 private void writePlot (SpecProcessItem obj, Hashtable Processes){
  
     if (obj.as != null) {
    	writeNodes(obj.as, obj, Processes);
      }

    
 }



  
 private void writeTheResources(SpecProcessItem obj){
    
   SpecConstrItem constr = null;
   
   for (Enumeration e1 = obj.as.constraints.elements(); e1.hasMoreElements();){
     constr = (SpecConstrItem) e1.nextElement();
     if ("resource-constraint".equals(constr.type)){
        stream.println("                 (" + constr.label.replace('\"',' ').toUpperCase().trim() + ")");
     }
   }
 }

 private void writeTheConditions(SpecProcessItem obj){
    
   SpecConstrItem constr = null;
   
   
   if (initalAchieveCount > 0){
   
       stream.print("      (ACHIEVE (");
       if (initalAchieveCount >1) stream.print("(and");
   
   
       for (Enumeration e1 = obj.as.constraints.elements(); e1.hasMoreElements();){
         constr = (SpecConstrItem) e1.nextElement();
         if ("input-constraint".equals(constr.type)){
              String constraintLabel = new String(constr.label.replace('\"',' ').toUpperCase().trim());
              StringTokenizer tokenizer = new StringTokenizer(constraintLabel);
              String token = tokenizer.nextToken();
    
              if ("ACHIEVE".equals(token)){   
                stream.println("("+ fromTFExprToACTExpr(constr.label.replace('\"',' ').toUpperCase().trim()) + ")");
            }
         }
       }
    if (initalAchieveCount >1) stream.print(")");
    stream.println(")"); ///;;; end ACHIEVE
   }// end of if achivecount
   
   if (initalUnsupervisedCount > 0){
    
         stream.print("      (WAIT-UNTIL (");
       if (initalUnsupervisedCount >1) stream.print("(and");
   
   
       for (Enumeration e1 = obj.as.constraints.elements(); e1.hasMoreElements();){
         constr = (SpecConstrItem) e1.nextElement();
         if ("input-constraint".equals(constr.type)){
              String constraintLabel = new String(constr.label.replace('\"',' ').toUpperCase().trim());
              StringTokenizer tokenizer = new StringTokenizer(constraintLabel);
              String token = tokenizer.nextToken();
    
              if ("UNSUPERVISED".equals(token)){   
                stream.println("("+ fromTFExprToACTExpr(constr.label.replace('\"',' ').toUpperCase().trim()) + ")");
            }
         }
       }
    if (initalUnsupervisedCount >1) stream.print(")");
    stream.println(")"); ///;;; end Unsupervised to wait until
   }
 }

private void writeTheEffects(SpecProcessItem obj){
    
   SpecConstrItem constr = null;
   stream.println("      (CONCLUDE (AND(");
   for (Enumeration e1 = obj.as.constraints.elements(); e1.hasMoreElements();){
     constr = (SpecConstrItem) e1.nextElement();
     if ("output-constraint".equals(constr.type)){
        stream.println("                 (" + constr.label.replace('\"',' ').toUpperCase().trim() + ")");
     }
   }
   stream.println("      )");///;;; end CONCLUDE
 }

  private void writeVariables(SpecProcessItem proc) {
    
    SpecVarItem obj = null;

    //needs work to setup more than one variable per schema/task
    //remember that you have the pos property
    for  (Enumeration e =  proc.variables.elements(); e.hasMoreElements() ;){
      obj = (SpecVarItem) e.nextElement();
      stream.println("                          (" + obj.label.replace('\"',' ').toUpperCase().trim() + ")");
      
    }
  }


private void writeResourceInfo() {

    SpecItem obj = null;
    SpecUnitItem tempUnit = null;
    int initialResourceCount = 0;
    int initialResourceUnitCount = 0;
    int resourceCount = 1;
    int resourceUnitCount = 1;

    //first count all resources and resources with units
    for  (Enumeration e =  resources.elements(); e.hasMoreElements() ;)  {
      obj = (SpecItem) e.nextElement();
      initialResourceCount++;
      if (("".equals(obj.unit))==false) {
	tempUnit= (SpecUnitItem) sortElements.get(obj.unit);
	if (tempUnit != null) {
	  initialResourceUnitCount++;
	}
      }
    }

    //write resource_unit string
    String outString = "";
    for  (Enumeration e =  resources.elements(); e.hasMoreElements() ;)  {
      obj = (SpecItem) e.nextElement();
      
      if (("".equals(obj.unit))==false) {
	tempUnit= (SpecUnitItem) sortElements.get(obj.unit);
	if (tempUnit != null) {
	  if (resourceUnitCount == 1) 
	    outString = "resource_units ";
	  else
	    outString = "               ";

	  outString = outString + 
	    tempUnit.label.replace('\"',' ').trim() +
	    " = " +
	    tempUnit.unitType.replace('\"',' ').trim() ;
	}
	if (initialResourceUnitCount > resourceUnitCount) {
	  outString = outString + ",";
	}
	else {
	  outString = outString + ";";
	}
	stream.println(outString);
	resourceUnitCount++;
      }
    }

    //write resource_types entries
    outString = "";

    if (initialResourceCount > 0) {
      stream.println("");
      stream.println("resource_types");
    }
    for  (Enumeration e =  resources.elements(); e.hasMoreElements() ;)  {
      obj = (SpecItem) e.nextElement();
      
      tempUnit = null;
      if (("".equals(obj.unit))==false) {
	tempUnit= (SpecUnitItem) sortElements.get(obj.unit);
      }
      outString = "  " + obj.resourceType + " {resource " +
	obj.label.replace('\"',' ').trim() + "}";
      if (tempUnit != null) {
	outString = outString + " = " +
	  tempUnit.label.replace('\"',' ').trim();
      }
      if (initialResourceCount > resourceCount) {
	outString = outString + ",";
      }
      else {
	outString = outString + ";";
      }
      stream.println(outString);
      resourceCount++;
    }
    stream.println("");
  }

  //*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_
  // end of write routines
  //*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_


  //---------- Activity ----------------
  public void activityPattern(String id, String val) {
    SpecNodeItem item = null;

    //update the object name if exists, or create new
    item = (SpecNodeItem) sortElements.get(id);
    if (item == null) {
      item = new SpecNodeItem(id);
      item.key = id;
      sortElements.put(id,item);
    }
    item.pattern = val;
  }

  public void activitySpec(String id, String val) {}
  //System.out.println("received:" +id+" "+val);}
  public void activityExpands(String id, String val) {}
  //System.out.println("received:" +id+" "+val);}

  public void activityVariable(String id, String val, int pos) {
  }

  public void activityBegin(String id, String val) {
    SpecNodeItem item = null;
    SpecItem tp = null;

    //update the object name if exists, or create new
    item = (SpecNodeItem) sortElements.get(id);
    if (item == null) {
      item = new SpecNodeItem(id);
      item.key = id;
      sortElements.put(id,item);
    }

    //update the object name if exists, or create new
    tp = (SpecItem) sortElements.get(val);
    if (tp == null) {
      tp = new SpecNodeItem(val);
      sortElements.put(val,tp);
    }

    item.beginTimePoint = val;
  }

  public void activityEnd(String id, String val) {
    SpecNodeItem item = null;
    SpecItem tp = null;

    //update the object name if exists, or create new
    item = (SpecNodeItem) sortElements.get(id);
    if (item == null) {
      item = new SpecNodeItem(id);
      item.key = id;
      sortElements.put(id,item);
    }

    //update the object name if exists, or create new
    tp = (SpecItem) sortElements.get(val);
    if (tp == null) {
      tp = new SpecNodeItem(val);
      sortElements.put(val,tp);
    }

    item.endTimePoint = val;
  }

  //---------- Commands ----------------
  public void comIncludeDomain(String domain) {}
  //System.out.println("received:" +domain);}
  public void comDomainDef(String domain) {
    this.domainName = domain;}
  /*  public void comObjectCount(int count) {
      this.domainObjectCount = count; } */

  //---------- Constraint ----------------
  public void constrExpression(String id, String val) {

    SpecConstrItem item = null;

    //update the item if exists, or create new
    item = (SpecConstrItem) sortElements.get(id);
    if (item == null) {
      item = new SpecConstrItem(id);
      sortElements.put(id,item);
    }
    item.label = val;
  }

  public void constrAddedBy(String id, String val) {}
  //System.out.println("received:" +id+" "+val);}

  //---------- Level ----------------
  public void levelLabel(String id, String val) {
    SpecLevelItem item = null;

    //update the object name if exists, or create new
    item = (SpecLevelItem) sortElements.get(id);
    if (item == null) {
      item = new SpecLevelItem(id);
      levels.put(id,item);
      sortElements.put(id,item);
    }
    item.label = ((val.replace('-','_')).replace('"',' ')).trim();
  }

  public void levelNumber(String id, String val) {
    SpecLevelItem item = null;

    //update the object name if exists, or create new
    item = (SpecLevelItem) sortElements.get(id);
    if (item == null) {
      item = new SpecLevelItem(id);
      levels.put(id,item);
      sortElements.put(id,item);
    }
    item.number = (Integer.valueOf(val)).intValue();
  }

  public void levelContains(String id, String val) {
    // public void activityEnd(String id, String val) {
    SpecProcessItem process = null;
    SpecLevelItem level = null;
    
    //update the object name if exists, or create new
    level = (SpecLevelItem) sortElements.get(id);
    if (level == null) {
      level = new SpecLevelItem(id);
      levels.put(id,level);
      sortElements.put(id,level);
    }
    
    //update the object name if exists, or create new
    process = (SpecProcessItem) sortElements.get(val);
    if (process == null) {
      process = new SpecProcessItem(val);
      sortElements.put(val,process);
    }

    process.level = id;
    level.processes.addElement(process);
  }

  //---------- Node ----------------
  public void nodeLabel(String id, String val) {
    SpecNodeItem item = null;

    //update the object name if exists, or create new
    item = (SpecNodeItem) sortElements.get(id);
    if (item == null) {
      item = new SpecNodeItem(id);
      item.key = id;
      sortElements.put(id,item);
    }
    item.label = val;
  }

  public void nodeXPos(String id, String val) {
    SpecNodeItem item = null;

    //update the object name if exists, or create new
    item = (SpecNodeItem) sortElements.get(id);
    if (item == null) {
      item = new SpecNodeItem(id);
      item.key = id;
      sortElements.put(id,item);
    }
    item.xpos = (Integer.valueOf(val)).intValue();
  }

  public void nodeYPos(String id, String val) {
    SpecNodeItem item = null;

    //update the object name if exists, or create new
    item = (SpecNodeItem) sortElements.get(id);
    if (item == null) {
      item = new SpecNodeItem(id);
      item.key = id;
      sortElements.put(id,item);
    }
    item.ypos = (Integer.valueOf(val)).intValue();
  }

  //---------- Entity ----------------

  public void entityIsa(String id1, String id2) {
    
    SpecEntityItem item = null;

    //update the object name if exists, or create new
    item = (SpecEntityItem) parents.get(id1);
    if (item == null) {
      item = new SpecEntityItem(id1);
      parents.put(id1,item);
    }
    item.parent = id2;
  }

  //----- Annotation -----
  public void annotationXPos(String id, String val) {
    SpecConstrItem item = null;

    //update the object name if exists, or create new
    item = (SpecConstrItem) sortElements.get(id);
    if (item == null) {
      item = new SpecConstrItem(id);
      item.key = id;
      sortElements.put(id,item);
    }
    item.xpos = (Integer.valueOf(val)).intValue();
  }

  public void annotationYPos(String id, String val) {
    SpecConstrItem item = null;

    //update the object name if exists, or create new
    item = (SpecConstrItem) sortElements.get(id);
    if (item == null) {
      item = new SpecConstrItem(id);
      item.key = id;
      sortElements.put(id,item);
    }
    item.ypos = (Integer.valueOf(val)).intValue();
  }

  //---------- Object ----------------
  public void objectName(String id, String val) {
    
    SpecItem item = null;

    //update the object name if exists, or create new
    item = (SpecItem) sortElements.get(id);
    if (item == null) {
      item = new SpecItem(id);
      sortElements.put(id,item);
    }
    item.label = val;
  }

  public void objectIsResource(String id, String val) {

    SpecItem item = null;
    boolean isResource = false;

    //update the object if exists, or create new
    item = (SpecItem) sortElements.get(id);
    if (item == null) {
      item = new SpecItem(id);
      sortElements.put(id,item);
    }
    isResource = (("true".equals(val.toLowerCase())) ? true : false);

    item.isResource = isResource; 
    if (isResource) resources.put(id,item);
  }

  public void objectResourceType(String id, String val) {
    SpecItem item = null;
    //update the object if exists, or create new
    item = (SpecItem) sortElements.get(id);
    if (item == null) {
      item = new SpecItem(id);
      sortElements.put(id,item);
    }
    item.resourceType = val.replace('"',' ').trim();
  }

  public void objectUnit(String id, String val) {
    SpecItem item = null;
    //update the object if exists, or create new
    item = (SpecItem) sortElements.get(id);
    if (item == null) {
      item = new SpecItem(id);
      sortElements.put(id,item);
    }
    item.unit = val;
  }

  //---------- Process ----------------
  public void processLabel(String id, String val) {
    SpecProcessItem item = null;

    //update the object name if exists, or create new
    item = (SpecProcessItem) sortElements.get(id);
    if (item == null) {
      item = new SpecProcessItem(id);
      sortElements.put(id,item);
    }
    item.label = val.replace('-','_');
  }

  public void processSpec(String id, String val) {
    SpecProcessItem item = null;
    SpecActSpecItem asItem = null;

    //update the object name if exists, or create new
    item = (SpecProcessItem) sortElements.get(id);
    if (item == null) {
      item = new SpecProcessItem(id);
      sortElements.put(id,item);
    }

    //update the object name if exists, or create new
    asItem = (SpecActSpecItem) sortElements.get(val);
    if (asItem == null) {
      asItem = new SpecActSpecItem(val);
      sortElements.put(val,asItem);
    }

    item.as = asItem;
  }

  public void processIsExec(String id, String val) {

    SpecProcessItem item = null;

    //update the object name if exists, or create new
    item = (SpecProcessItem) sortElements.get(id);
    if (item == null) {
      item = new SpecProcessItem(id);
      sortElements.put(id,item);
    }
    item.execProcess = (("true".equals(val.toLowerCase())) ? true : false);
  }

  public void processExpands(String id, String val) {
    SpecProcessItem item = null;

    //update the object name if exists, or create new
    item = (SpecProcessItem) sortElements.get(id);
    if (item == null) {
      item = new SpecProcessItem(id);
      sortElements.put(id,item);
    }
    item.expands = val;
  }

  public void processVariable(String id, String val, int pos) {

    SpecProcessItem item = null;
    SpecVarItem varItem = null;

    //update the object name if exists, or create new
    item = (SpecProcessItem) sortElements.get(id);
    if (item == null) {
      item = new SpecProcessItem(id);
      sortElements.put(id,item);
    }

    //update the object name if exists, or create new
    varItem = (SpecVarItem) sortElements.get(val);
    if (varItem == null) {
      varItem = new SpecVarItem(val);
      sortElements.put(val,varItem);
    }
    varItem.pos = pos;
    item.variables.addElement(varItem);
  }

  public void processStart(String id, String val) {}
  //System.out.println("received:" +id+" "+val);}
  public void processFinish(String id, String val) {}
  //System.out.println("received:" +id+" "+val);}

  //---------- Sort ----------------
  public void sortDeclaration(String type, String id, boolean newType) {

    SpecItem instItem = null;
    SpecTypeItem item = null; // for dynamically defined types

    //insert the sort element into the hashtable
    instItem = (SpecItem) sortElements.get(id);
    if (instItem == null) {
      //create new spec item of proper type
      if ("always-constraint".equals(type)) {instItem = new SpecItem(id);}
      else if ("plan".equals(type)) {instItem = new SpecProcessItem(id);}
      else if ("action".equals(type)) {instItem = new SpecNodeItem(id);
      ((SpecNodeItem)instItem).key = id;}
      else if ("unit".equals(type)) {instItem = new SpecUnitItem(id);}
      else if ("entity-variable".equals(type)) 
	{instItem = new SpecVarItem(id);}
      else if ("start".equals(type)) {instItem = new SpecNodeItem(id);}
      else if ("finish".equals(type)) {instItem = new SpecNodeItem(id);}
      else if ("begin".equals(type)) {instItem = new SpecNodeItem(id);}
      else if ("end".equals(type)) {instItem = new SpecNodeItem(id);}
      else if ("process".equals(type)) {instItem = new SpecProcessItem(id);}
      else if ("activity-specification".equals(type)) 
	{instItem = new SpecActSpecItem(id);}
      else if ("include-constraint".equals(type)) 
	{instItem = new SpecConstrItem(id);}
      else if ("ordering-constraint".equals(type)) 
	{instItem = new SpecConstrItem(id);}
      else {
        instItem = new SpecItem(id);
      }
      sortElements.put(id,instItem);
    }
    instItem.type = type;

    //if new type, add hashtable entry to the types
    if (newType) {
      item = (SpecTypeItem)types.get(type);
      if (item != null) {
	item.instances.addElement(instItem);
      }
      else {
	item = new SpecTypeItem(type); 
	item.instances.addElement(instItem);
	types.put(type, item);
      }
    }
    else {
      if ("always-constraint".equals(type)) {always.put(id,instItem);}
      else if ("plan".equals(type)) {
	plans.put(id,instItem);
	((SpecProcessItem)instItem).taskProcess = true;
      }
      else if ("process".equals(type)) {
	processes.put(id,instItem);
	((SpecProcessItem)instItem).taskProcess = false;
      }
    }
  }

  public void sortRangeDeclaration(String type, String id, boolean newType) {
    //System.out.println("received:"+type+" "+id);
    System.err.println("Range expressions not currently supported!");}

  //---------- Special ----------------
  public void includeNode(String id, String val) {
    SpecConstrItem cItem = null;
    SpecNodeItem nItem = null;

    //update the object name if exists, or create new
    cItem = (SpecConstrItem) sortElements.get(id);
    if (cItem == null) {
      cItem = new SpecConstrItem(id);
      sortElements.put(id,cItem);
    }

    //update the object name if exists, or create new
    nItem = (SpecNodeItem) sortElements.get(val);
    if (nItem == null) {
      nItem = new SpecNodeItem(val);
      nItem.key = val;
      sortElements.put(val,nItem);
    }

    cItem.node = nItem;
  }
  
  public void member(String memberStr, String setStr) {
    SpecActSpecItem asItem = null;
    SpecConstrItem cItem = null;

    //update the object name if exists, or create new
    asItem = (SpecActSpecItem) sortElements.get(setStr);
    if (asItem == null) {
      asItem = new SpecActSpecItem(setStr);
      sortElements.put(setStr,asItem);
    }

    //update the object name if exists, or create new
    cItem = (SpecConstrItem) sortElements.get(memberStr);
    if (cItem == null) {
      cItem = new SpecConstrItem(memberStr);
      sortElements.put(memberStr,cItem);
    }

    asItem.constraints.addElement(cItem);
  }

  //---------- Timepoint ----------------
  public void tpStart(String id, String val) {
    SpecNodeItem item = null;
    SpecItem tp = null;

    //update the object name if exists, or create new
    item = (SpecNodeItem) sortElements.get(id);
    if (item == null) {
      item = new SpecNodeItem(id);
      item.key = id;
      sortElements.put(id,item);
    }

    //update the object name if exists, or create new
    tp = (SpecItem) sortElements.get(val);
    if (tp == null) {
      tp = new SpecNodeItem(val);
      sortElements.put(val,tp);
    }

    item.beginTimePoint = val;    
    item.endTimePoint = val;    
  }

  public void tpFinish(String id, String val) {
    SpecNodeItem item = null;
    SpecItem tp = null;

    //update the object name if exists, or create new
    item = (SpecNodeItem) sortElements.get(id);
    if (item == null) {
      item = new SpecNodeItem(id);
      item.key = id;
      sortElements.put(id,item);
    }

    //update the object name if exists, or create new
    tp = (SpecItem) sortElements.get(val);
    if (tp == null) {
      tp = new SpecNodeItem(val);
      sortElements.put(val,tp);
    }

    item.beginTimePoint = val;    
    item.endTimePoint = val;    
  }

  //---------- Unit ----------------

  public void unitLabel(String id, String val) {
    SpecUnitItem item = null;
    //update the object if exists, or create new
    item = (SpecUnitItem) sortElements.get(id);
    if (item == null) {
      item = new SpecUnitItem(id);
      sortElements.put(id,item);
    }
    item.label = val;
  }

  public void unitType(String id, String val) {
    SpecUnitItem item = null;
    //update the object if exists, or create new
    item = (SpecUnitItem) sortElements.get(id);
    if (item == null) {
      item = new SpecUnitItem(id);
      sortElements.put(id,item);
    }
    item.unitType = val;
  }

  //---------- Variable ----------------
  public void varLabel(String id, String val) {

    SpecVarItem item = null;
    //update the object if exists, or create new
    item = (SpecVarItem) sortElements.get(id);
    if (item == null) {
      item = new SpecVarItem(id);
      sortElements.put(id,item);
    }
    item.label = val;
    //System.out.println(val);
  }

  //The classes for specification items.

  class SpecTypeItem {            //note this one is special 
    public String label = "";
    public Vector instances = new Vector();
    SpecTypeItem(String label) {
      this.label = label;
    }
  }
 
  class SpecItem {                //root spec item class.
    public String label = "";
    public String id = "";
    public String type = "";
    public String resourceType = "";
    public boolean isResource=false;
    public String unit = "";
    SpecItem(String id) {
      this.id = id;
    }
  }

  class SpecEntityItem extends SpecItem {
    public String parent = "";
    SpecEntityItem(String id) {
      super(id);
    }
  }

  class SpecProcessItem extends SpecItem {
    public Vector variables = new Vector();
    public String expands = "";
    public String level = "";
    public SpecActSpecItem as = null;
    public boolean taskProcess = false;
    public boolean execProcess = false;
    SpecProcessItem(String id) {
      super(id);
    }
  }

  class SpecLevelItem extends SpecItem {
    public Vector processes = new Vector();
    public int number = 0;
    public boolean processed = false;
    SpecLevelItem(String id) {
      super(id);
    }
  }

  class SpecActSpecItem extends SpecItem {
    public Vector constraints = new Vector();
    SpecActSpecItem(String id) {
      super(id);
    }
  }

  class SpecConstrItem extends SpecItem {
    SpecNodeItem node = null;
    String tp1 = "";
    String tp2 = "";
    String relation = "";
    int xpos = -1;
    int ypos = -1;
    String key = "";

    SpecConstrItem(String id) {
      super(id);
    }
  }

  class SpecNodeItem extends SpecItem {
    public String pattern = "";
    public String key = "";
    public String beginTimePoint = "";
    public String endTimePoint = "";
    //extensions
    public int xpos = 10;
    public int ypos = 10;

    int assignedNumber = 0;
    SpecNodeItem(String id) {
      super(id);
    }
  }

  class SpecUnitItem extends SpecItem {
    public String unitType = "";
    SpecUnitItem(String id) {
      super(id);
    }
  }

  class SpecVarItem extends SpecItem {
    public int pos = 0;
    SpecVarItem(String id) {
      super(id);
    }
  }

  public String replaceKey(String text, String pattern, String newPattern) {
    //uses a modified rabin-karp algo for text search

    String outString = "";
    long q = 2113929255l, d = 32, d_bits = 5;
    int hit = 0;
    char[] a = text.toCharArray();
    char[] p = pattern.toCharArray();
    int M = p.length, N = a.length;
    long h1 = 0, h2 = 0, dM = 1;
    int i;

    for(i = 0; i < M - 1; i++)
      dM = (dM << d_bits) % q;
      
    for(i = 0; i < M; i++) {
      h1 = ((h1 << d_bits) + (long)p[i]) % q;
      h2 = ((h2 << d_bits) + (long)a[i]) % q;
    }

    /* There's got to be a string in here somewhere */
    i = 0;
    while(h1 != h2 && i < N - M) {
      h2 = (h2 + (q << d_bits) - (long)a[i] * dM) % q;
      h2 = ((h2 << d_bits) + (long)a[i + M]) % q;
      i++;
    }
      
    /* no match */
    if(i >= N - M) {
      hit = -1;
      return text;
    }

    /* match */
    hit = i;
    outString = text.substring(0,i) + newPattern + text.substring(i+M);
    //System.out.println("Match: " + text + " " + pattern + " " + i +" "+ M);
    return outString;
  }
  
  }