/*
* @(#)CdeSpec.java	1.0 98-May-18
* 
*/

import java.util.*;
import java.awt.*;
import com.sun.java.swing.tree.*;

/**
 * Common Domain Editor (CDE) specification class.
 *
 * This class accumulates the parsed domain specification and translates
 * it to the internal cpe structures.
 *
 * @version 1.0 98/5/18
 * @author Steve Polyak
 */

public class CdeSpec extends Object 
{

  Hashtable types = new Hashtable(); //stores the new types
  Hashtable always = new Hashtable(); //stores the always items
  Hashtable plans = new Hashtable(); //stores the plans
  Hashtable processes = new Hashtable(); //stores the schemas
  Hashtable resources = new Hashtable(); //stores the objects
  Hashtable levels = new Hashtable(); //stores the levels
  Hashtable parents = new Hashtable(); //stores the new object parent hier
  Hashtable sortElements = new Hashtable(); //stores all SORT defined objects
  java.io.PrintStream stream = null;
  String domainName = "";

  CdeSpec() {
  }

  public void reset() {
    types = new Hashtable(); //stores the new types
    always = new Hashtable(); //stores the always items
    plans = new Hashtable(); //stores the plans
    processes = new Hashtable(); //stores the schemas
    resources = new Hashtable(); //stores the objects
    levels = new Hashtable(); //stores the levels
    parents = new Hashtable(); //stores the levels
    sortElements = new Hashtable(); //stores all SORT defined objects
    stream = null;
    domainName = "";
  }

  // writeout is the main TF writing driver.
  public void writeOut(java.io.PrintStream stream) {
    this.stream = stream;
    writeHeader();
    writeTypes();
    writeAlways();
    writeResourceInfo();
    writeTasks();
    writeSchemas();
  }

  // importer is the main driver for importing a cpd file.
  public void importer() {

    CpeDomainPane domain = Cpe.sharedInstance().domainPane;

    //Rename domain with imported name
    ((CpeDomainRoot)domain.top.getUserObject()).label = domainName;

    importLevels(domain);
    importTypes(domain);
    importAlways(domain);
  }

  //*_*_*_*_*_ Importer Code *_*_*_*_*_*_
  private void importAlways(CpeDomainPane domain) {
    SpecItem item = null;
    for  (Enumeration e =  always.elements(); e.hasMoreElements() ;)  {
      item = (SpecItem) e.nextElement();
      domain.addAlwaysExpression(item.label.replace('\"',' ').trim()); 
    }
  }

  private void importTypes(CpeDomainPane domain) {
    SpecEntityItem parentItem = null;
    SpecTypeItem item = null;

    for  (Enumeration e =  parents.elements(); e.hasMoreElements() ;)  {
      parentItem = (SpecEntityItem) e.nextElement();
      if (parentItem.parent.equals("\"cpo-activity-relatable-object\"")) {

	for  (Enumeration e1 =  types.elements(); e1.hasMoreElements() ;)  {
	  item = (SpecTypeItem) e1.nextElement();
	  if (parentItem.id.equals("\"cpo-object-"+
				   item.label.replace('"',' ').trim()
				   +"\"")) {
	    importTypesSub(domain, item, domain.types);
	  }
	}
      }
    }
  }

  private void importTypesSub(CpeDomainPane domain, SpecTypeItem item,
			      DefaultMutableTreeNode node) {
    CpeTypeItem typeItem = null;
    SpecTypeItem newItem = null;
    CpeInstanceItem instItem = null;
    SpecItem objItem = null;
    SpecEntityItem parentItem = null;

    typeItem = domain.addType(item.label.replace('"',' ').trim(),
			      node);

    for  (Enumeration e2 =  item.instances.elements(); 
	  e2.hasMoreElements() ;)  {
      objItem = (SpecItem) e2.nextElement();
      instItem = domain.addInstance
	(objItem.label.replace('"',' ').trim(), typeItem.node);

      instItem.resourceType = objItem.resourceType;
      instItem.isResource = objItem.isResource;
      
      SpecUnitItem unitItem = (SpecUnitItem) sortElements.get(objItem.unit);
      if (unitItem != null) {
	instItem.units = unitItem.label.replace('"',' ').trim();
	instItem.unitType = unitItem.unitType.replace('"',' ').trim();
      }

    }

    for  (Enumeration e =  parents.elements(); e.hasMoreElements() ;)  {
      parentItem = (SpecEntityItem) e.nextElement();
      if (parentItem.parent.equals("\"cpo-object-"+
				   item.label.replace('"',' ').trim()
				   +"\"")) {
	for  (Enumeration e1 =  types.elements(); e1.hasMoreElements() ;)  {
	  newItem = (SpecTypeItem) e1.nextElement();
	  if (parentItem.id.equals("\"cpo-object-"+
				   newItem.label.replace('"',' ').trim()
				   +"\"")) {
	    importTypesSub(domain, newItem, typeItem.node);
	  }
	}

      }

    }
  }

  private void importLevels(CpeDomainPane domain) {

    SpecLevelItem level = null;
    int highestValue = 0;
    int levelCount = 0;
    int processedCount = 0;

    //get the lowest level number, may not be 0
    for  (Enumeration e =  levels.elements(); e.hasMoreElements() ;)  {
      level = (SpecLevelItem) e.nextElement();
      if (level.number > highestValue) {
	highestValue = level.number;
      }
      levelCount++;
    }

    //work down the level count from highest to lowest
    while(processedCount < levelCount) {
      for  (Enumeration e =  levels.elements(); e.hasMoreElements() ;)  {
	level = (SpecLevelItem) e.nextElement();
	if (highestValue == level.number) {
	  DefaultMutableTreeNode domLevelNode = domain.addLevel(level.label);
	  importActions(domain,level,domLevelNode);
	  level.processed = true;
	  processedCount++;
	}
      }
      highestValue--;
    }
    importOtherActions(domain);
  }

  private void importActions(CpeDomainPane domain, SpecLevelItem level,
			     DefaultMutableTreeNode domLevelNode) {
    CpeLevelsItem levelItem = ((CpeLevelsItem)domLevelNode.getUserObject());
    SpecProcessItem process = null;

    for (Enumeration e =  level.processes.elements(); 
	 e.hasMoreElements() ;)  {
      process = (SpecProcessItem) e.nextElement();
      CpeActionItem actionItem = domain.addAct
	(process.label.replace('\"',' ').trim(),
	 levelItem.getAction(domLevelNode));
      importActionConstraints(process,actionItem);
    }
  }

  private void importOtherActions(CpeDomainPane domain) {

    //The purpose of this method is to pickup those processes that
    //werent connected to modelling levels yet (e.g. coming from CPM)
    int orphanCount = 0;

    SpecProcessItem process = null;

    for (Enumeration e =  processes.elements(); e.hasMoreElements() ;)  {
      process = (SpecProcessItem) e.nextElement();
      if (process.level == "") orphanCount++;
    }
    for (Enumeration e =  plans.elements(); e.hasMoreElements() ;)  {
      process = (SpecProcessItem) e.nextElement();
      if (process.level == "") orphanCount++;
    }
    if (orphanCount == 0) return;
    //looks like we have at least one orphan... add a default level

    DefaultMutableTreeNode domLevelNode = domain.addLevel("New_Level");
    CpeLevelsItem levelItem = ((CpeLevelsItem)domLevelNode.getUserObject());

    for (Enumeration e =  processes.elements(); e.hasMoreElements() ;)  {
      process = (SpecProcessItem) e.nextElement();
      if (process.level == "") {
	CpeActionItem actionItem = domain.addAct
	  (process.label.replace('\"',' ').trim(),
	   levelItem.getAction(domLevelNode));
	importActionConstraints(process,actionItem);
      }
    }
    for (Enumeration e =  plans.elements(); e.hasMoreElements() ;)  {
      process = (SpecProcessItem) e.nextElement();
      if (process.level == "") {
	CpeActionItem actionItem = domain.addAct
	  (process.label.replace('\"',' ').trim(),
	   levelItem.getAction(domLevelNode));
	importActionConstraints(process,actionItem);
      }
    }
  }

  private void importActionConstraints(SpecProcessItem process,
				       CpeActionItem actionItem) {
    //remember that: process = the imported constructs and
    //               actionitem = the wrapper for the newly built process
    SpecConstrItem constraint = null;
    String from = "";
    boolean fromBegin = true;
    String to = "";
    boolean toBegin = true;
    Vector nodeList = new Vector(); // easier to work with a local vector

    actionItem.process.expands = process.expands.replace('\"',' ').trim();
    actionItem.process.taskProcess = process.taskProcess; //false for process
    actionItem.process.execProcess = process.execProcess; //false for process

    
    SpecVarItem varItem = null;
    int lowestValue = 999;
    int varCount = 0;
    int processedCount = 0;

    //get the lowest pos number
    for  (Enumeration eps =  process.variables.elements();
	  eps.hasMoreElements() ;)  {
      varItem = (SpecVarItem) eps.nextElement();
      if (varItem.pos < lowestValue) {
	lowestValue = varItem.pos;
      }
      varCount++;
    }

    //work down the count from highest to lowest
    while(processedCount < varCount) {
      for  (Enumeration e =  process.variables.elements(); 
	    e.hasMoreElements() ;)  {
	varItem = (SpecVarItem) e.nextElement();
	if (lowestValue == varItem.pos) {
	  actionItem.process.variables.addElement
	    (varItem.label.replace('\"',' ').trim());
	  processedCount++;
	}
      }
      lowestValue++;
    }

    if (process.as != null) {
      //ok, lets add all the nodes based on the include constraints
      for (Enumeration e =  process.as.constraints.elements(); 
	   e.hasMoreElements() ;)  {
	constraint = (SpecConstrItem) e.nextElement();

	if ("include-constraint".equals(constraint.type))
	  nodeList.addElement(constraint.node);

	if ("include-constraint".equals(constraint.type) &&
	    "action".equals(constraint.node.type)) {
	  CpeNode cpeNode = new CpeNode(constraint.node.key,
					constraint.node.xpos,
					constraint.node.ypos);
	  cpeNode.setPattern(constraint.node.pattern.replace('"',' ').trim());
	  cpeNode.m_lbl = 
	    constraint.node.label.replace('"',' ').replace('~','\n').trim();
	  actionItem.process.addNewNode(cpeNode);
	}

	if ("annotation-constraint".equals(constraint.type)) {
	  actionItem.process.m_text.addElement
	    (new CpeText(constraint.label.replace('"',' ').replace('~','\n')
			 .trim(), 
			 constraint.xpos, constraint.ypos));    
	}

	if ("include-constraint".equals(constraint.type) &&
	    ("begin".equals(constraint.node.type) ||
	     "end".equals(constraint.node.type))) {
	  actionItem.process.setStartFinishFlag(false);
	}
	if ("include-constraint".equals(constraint.type) &&
	    ("begin".equals(constraint.node.type) ||
	     "start".equals(constraint.node.type) ||
	     "finish".equals(constraint.node.type) ||
	     "end".equals(constraint.node.type))) {
	  //need to update the key on the enclosing nodes
	  actionItem.process.changeNodeKey(constraint.node.type, 
					   constraint.node.key);
	  //reposition node
	  CpeNode tmpNode =
	    actionItem.process.locateNode(constraint.node.key);
	  tmpNode.m_x = constraint.node.xpos;
	  tmpNode.m_y = constraint.node.ypos;
	}
      }

      //All include constraints have been processed, now address orderings
      for (Enumeration e1 =  process.as.constraints.elements(); 
	   e1.hasMoreElements() ;)  {
	constraint = (SpecConstrItem) e1.nextElement();
	if ("ordering-constraint".equals(constraint.type)) {

	  //pull apart e.g. "before(Obj1,Obj2)"
	  StringTokenizer st = new 
	    StringTokenizer
	    ((constraint.label.replace('\"',' ').trim()), "(),");
	  int i = 0;
	  for  (Enumeration  e2  = st; e2.hasMoreElements()  ; i++)  {	
	    String temp = (String) e2.nextElement();
	    switch (i) 
	      {
	      case 0:
		constraint.relation = temp;
	      case 1:
		constraint.tp1 = temp;
	      case 2:
		constraint.tp2 = temp;
	      }
	  } 

	  for  (Enumeration  e5  = nodeList.elements(); e5.hasMoreElements();){
	    SpecNodeItem nodeObj = (SpecNodeItem) e5.nextElement();

	    if(constraint.tp1.equals(nodeObj.beginTimePoint)) {
	      from = nodeObj.key;
	      fromBegin = true;
	      //correction for begin/start
	      if(("begin".equals(nodeObj.type)) ||
		 ("start".equals(nodeObj.type)))
		fromBegin = false;
	    }
	    else if (constraint.tp1.equals(nodeObj.endTimePoint)) {
	      from = nodeObj.key;
	      fromBegin = false;
	    }
	    if (constraint.tp2.equals(nodeObj.beginTimePoint)) {
	      to = nodeObj.key;
	      toBegin = true;
	    }
	    else if (constraint.tp2.equals(nodeObj.endTimePoint)) {
	      to = nodeObj.key;
	      toBegin = false;
	    }
	  }
	  if ("before".equals(constraint.relation)) {
	    //can't link within an action
	    if(!(from.equals(to)))
	      actionItem.process.addEdge(from,fromBegin,to,toBegin);
	  } else {
	    //can't link within an action
	    if(!(from.equals(to)))
	      actionItem.process.addEqEdge(from,fromBegin,to,toBegin);
	  }
	}
      }

      //right, let's address input, output, and resource constraints

      for (Enumeration e =  process.as.constraints.elements(); 
	   e.hasMoreElements() ;)  {
	constraint = (SpecConstrItem) e.nextElement();

	if ("input-constraint".equals(constraint.type)) {
	  actionItem.process.preconditions.addElement
	    (constraint.label.replace('\"',' ').trim());
	}
	else if ("output-constraint".equals(constraint.type)) {
	  actionItem.process.effects.addElement
	    (constraint.label.replace('\"',' ').trim());
	}
	else if ("resource-constraint".equals(constraint.type)) {
	  actionItem.process.resources.addElement
	    (constraint.label.replace('\"',' ').trim());
	}
      }
    }
    
    //remove inital beg/end or start/finish if necessary
    actionItem.process.removeInitialOrdering();

  }

  //*_*_*_*_*_ TF Writing Code *_*_*_*_*_*_

  public void writeHeader() {
    stream.println(";;; Domain: " + domainName);
    stream.println("");
    stream.println(";;; Common Process Translator CPL<-->TF v2.3");
    stream.println(";;; Author: Steve Polyak, Dept. AI, Edinburgh University");
    stream.println(";;; Task Formalism generated on: " + new Date());
    stream.println("");
  }

  private void writeTypes() {
    String typeString = "types ";
    SpecItem obj = null;
    SpecTypeItem item = null;
    int i = 0;
    for  (Enumeration e =  types.elements(); e.hasMoreElements()  ;i++)  {
      item = (SpecTypeItem) e.nextElement();
      if (i == 0) {
	typeString = typeString + item.label.replace('\"',' ').trim()+" = ("; 
      }
      else {
	typeString = "      " + item.label.replace('\"',' ').trim()+" = ("; 
      }
      for  (Enumeration e1 =  item.instances.elements(); 
	    e1.hasMoreElements()  ;i++)  {
	obj = (SpecItem) e1.nextElement();
	typeString = typeString + " " + obj.label.replace('\"',' ').trim();
      }
      typeString = typeString + ")";
      if (e.hasMoreElements()) {
	typeString = typeString + ",";
      }
      else {
	typeString = typeString + ";";
      }
      stream.println(typeString);
    }
    stream.println("");
  }

  private void writeAlways() {
    String outString = "always ";
    SpecItem obj = null;
    int i = 0;
    for  (Enumeration e =  always.elements(); e.hasMoreElements()  ;i++)  {
      obj = (SpecItem) e.nextElement();
      if (i == 0) {
	outString = outString + obj.label.replace('\"',' ').trim(); 
      }
      else {
	outString = "       " + obj.label.replace('\"',' ').trim(); 
      }
      if (e.hasMoreElements()) {
	outString = outString + ",";
      }
      else {
	outString = outString + ";";
      }
      stream.println(outString);
    }
    stream.println("");
  }

  private void writeTasks() {
    String outString = "task ";
    SpecProcessItem obj = null;
    for  (Enumeration e =  plans.elements(); e.hasMoreElements() ;)  {
      obj = (SpecProcessItem) e.nextElement();
      stream.println(outString + 
		     obj.label.replace(' ','_').replace('\"',' ').trim() + 
		     ";");

      writeVariables(obj);

      if (((obj.expands.equals("\"\""))==false) && 
	  ((obj.expands.equals(""))==false)) {
	stream.println("  expands {" + 
		       obj.expands.replace('\"',' ').trim() +
		       "};");
      }
      
      //write nodes
      if (obj.as != null) {
	writeNodes(obj.as);
      }
      stream.println("end_task;");
      stream.println("");
    }
    stream.println("");
  }
  
  private void writeNodes(SpecActSpecItem as) {
    boolean noShow = false; //used to hide begin-end orderings
    String outString = "";
    SpecConstrItem constr = null;
    int nodeCount = 1;
    int initialCount = 0;
    int startCount = 0;
    int initialOrderingCount = 0;
    int initialInputCount = 0;
    int initialOutputCount = 0;
    int initialResourceCount = 0;
    int currentNodeCount = 1;
    Vector nodeList = new Vector(); // easier to work with a local vector

    // first count the number of constraint types to position the ";"
    for (Enumeration e1 =  as.constraints.elements();e1.hasMoreElements() ;) {
      constr = (SpecConstrItem) e1.nextElement();
      if ("include-constraint".equals(constr.type) &&
	  ("start".equals(constr.node.type) ||
	   "finish".equals(constr.node.type) ||
	   "action".equals(constr.node.type))) {
	initialCount++;
        if ("start".equals(constr.node.type)) startCount++;
      }
      if ("ordering-constraint".equals(constr.type)) initialOrderingCount++;
      if ("input-constraint".equals(constr.type)) initialInputCount++;
      if ("output-constraint".equals(constr.type)) initialOutputCount++;
      if ("resource-constraint".equals(constr.type)) initialResourceCount++;
    }

    if (startCount > 0) {
      //there are start-finish nodes, need to start count at 3 rather than 1
      currentNodeCount = 3;
    }

    for  (Enumeration e =  as.constraints.elements(); e.hasMoreElements() ;) {
      constr = (SpecConstrItem) e.nextElement();
      //----include-----
      if ("include-constraint".equals(constr.type))
	nodeList.addElement(constr.node);

      if ("include-constraint".equals(constr.type) &&
	  ("start".equals(constr.node.type) ||
	   "finish".equals(constr.node.type) ||
	   "action".equals(constr.node.type))){

	//update node number for ordering links later
	if ("start".equals(constr.node.type.toLowerCase())) 
	  constr.node.assignedNumber = 1;
	else if ("finish".equals(constr.node.type.toLowerCase())) 
	  constr.node.assignedNumber = 2;
	else
	  constr.node.assignedNumber = currentNodeCount++;

	if (nodeCount == 1) outString = "  nodes ";
	else outString = "        ";
	outString = outString + constr.node.assignedNumber + " ";
	if ("action".equals(constr.node.type)){
	  outString = outString + "action {"; 
	  if("".equals((constr.node.pattern.replace('\"',' ').trim()))) { 
	    outString = outString + 
	      (constr.node.label.replace('\"',' ').trim().toLowerCase());
	  }
	  else {
	    outString = outString + 
	      (constr.node.pattern.replace('\"',' ').trim());
	  }
	}
	else { outString = outString + 
		 (constr.node.label.replace('\"',' ').trim().toLowerCase());
	}
	if ("action".equals(constr.node.type))
	  outString = outString + "}";
	if (initialCount > nodeCount) outString = outString + ",";
	else outString = outString + ";";
	stream.println(outString);
	nodeCount++;
      }
    }

    //----ordering-----
    outString = "  orderings ";
    int ordCount = 1;
    String fromPos = "";
    String toPos = "";

    for  (Enumeration e3 = as.constraints.elements(); e3.hasMoreElements() ;) {
      constr = (SpecConstrItem) e3.nextElement();

      if ("ordering-constraint".equals(constr.type)) {

	//pull apart e.g. "before(Obj1,Obj2)"
	StringTokenizer st = new 
	  StringTokenizer((constr.label.replace('\"',' ').trim()), "(),");
	int i = 0;
	for  (Enumeration  e2  = st; e2.hasMoreElements()  ; i++)  {	
	  String temp = (String) e2.nextElement();
	  switch (i) 
	    {
	    case 0:
              constr.relation = temp;
	    case 1:
              constr.tp1 = temp;
	    case 2:
              constr.tp2 = temp;
	    }
	}
	noShow = false;
	for  (Enumeration  e5  = nodeList.elements(); e5.hasMoreElements();){
	  SpecNodeItem nodeObj = (SpecNodeItem) e5.nextElement();

	  if (("end".equals(nodeObj.type)) || 
	      ("begin".equals(nodeObj.type))) {
	    if ((constr.tp1.equals(nodeObj.beginTimePoint)) ||
		(constr.tp2.equals(nodeObj.beginTimePoint))) {
	      noShow = true;
	    }
	  }
	  if("finish".equals(nodeObj.type)){
	    if (constr.tp1.equals(nodeObj.beginTimePoint)) {
	      fromPos = "begin_of " + nodeObj.assignedNumber;
	    }
	    if (constr.tp2.equals(nodeObj.beginTimePoint)) {
	      toPos = "begin_of " + nodeObj.assignedNumber;
	    }
	  }
	  else if ("start".equals(nodeObj.type)){
	    if (constr.tp1.equals(nodeObj.beginTimePoint)) {
	      fromPos = "end_of " + nodeObj.assignedNumber;
	    }
	    if (constr.tp2.equals(nodeObj.beginTimePoint)) {
	      toPos = "end_of " + nodeObj.assignedNumber;
	    }
	  }
	  else {
	    if(constr.tp1.equals(nodeObj.beginTimePoint)) {
	      fromPos = "begin_of " + nodeObj.assignedNumber;
	    }
	    else if (constr.tp1.equals(nodeObj.endTimePoint)) {
	      fromPos = "end_of " + nodeObj.assignedNumber;
	    }
	    if (constr.tp2.equals(nodeObj.beginTimePoint)) {
	      toPos = "begin_of " + nodeObj.assignedNumber;
	    }
	    else if (constr.tp2.equals(nodeObj.endTimePoint)) {
	      toPos = "end_of " + nodeObj.assignedNumber;
	    }
	  }
	} 
	if (noShow == false) {
	  if ("before".equals(constr.relation)) {
	    if (ordCount != 1)
	      outString = outString + ", ";
	    outString = outString + fromPos + " ---> " + toPos;
	    ordCount ++;
	  }
	}
      }
    }
    if (ordCount > 1) {
      outString = outString + ";";
      stream.println(outString);      
    }

    writeConditions(initialInputCount, as, nodeList);
    writeEffects(initialOutputCount, as);
    writeResources(initialResourceCount, as);
    stream.println("");
  }

  private void writeConditions(int initialCount, SpecActSpecItem as,
			       Vector nodeList) {
    int count = 1;
    SpecConstrItem constr = null;
    SpecNodeItem nodeObj = null;
    String tempCondition = "";
    String outString = "";

    if (initialCount == 0) return;

    for  (Enumeration e =  as.constraints.elements(); e.hasMoreElements() ;) {
      constr = (SpecConstrItem) e.nextElement();

      if ("input-constraint".equals(constr.type)) {

	if (count == 1) outString = "  conditions ";
	else outString = "             ";

	//need to update node id references
	tempCondition = constr.label.replace('\"',' ').trim();
	for  (Enumeration  e1 = nodeList.elements(); e1.hasMoreElements();){
	  nodeObj = (SpecNodeItem) e1.nextElement();
	  tempCondition = 
	    replaceKey(tempCondition, nodeObj.id, 
		       (new Integer(nodeObj.assignedNumber)).toString());
	}
	outString = outString + tempCondition;

	if (initialCount > count) outString = outString + ",";
	else outString = outString + ";";
	stream.println(outString);
	count++;
      }
    }
  }

  private void writeEffects(int initialCount, SpecActSpecItem as) {
    int count = 1;
    SpecConstrItem constr = null;
    String outString = "";

    if (initialCount == 0) return;
    
    for  (Enumeration e =  as.constraints.elements(); e.hasMoreElements() ;) {
      constr = (SpecConstrItem) e.nextElement();

      if ("output-constraint".equals(constr.type)) {

	if (count == 1) outString = "  only_use_for_effects ";
	else outString = "                       ";

	outString = outString + constr.label.replace('\"',' ').trim();

	if (initialCount > count) outString = outString + ",";
	else outString = outString + ";";
	stream.println(outString);
	count++;
      }
    }
  }

  private void writeResources(int initialCount, SpecActSpecItem as) {

    int count = 1;
    SpecConstrItem constr = null;
    String outString = "";

    if (initialCount == 0) return;
    
    for  (Enumeration e =  as.constraints.elements(); e.hasMoreElements() ;) {
      constr = (SpecConstrItem) e.nextElement();

      if ("resource-constraint".equals(constr.type)) {

	if (count == 1) outString = "  resources ";
	else outString = "            ";

	outString = outString + constr.label.replace('\"',' ').trim();

	if (initialCount > count) outString = outString + ",";
	else outString = outString + ";";
	stream.println(outString);
	count++;
      }
    }
  }

  private void writeSchemas() {
    String outString = "schema ";
    SpecProcessItem obj = null;
    for  (Enumeration e =  processes.elements(); e.hasMoreElements() ;)  {
      obj = (SpecProcessItem) e.nextElement();
      stream.println(outString + 
		     obj.label.replace(' ','_').replace('\"',' ').trim() + 
		     ";");

      writeVariables(obj);

      if (((obj.expands.equals("\"\""))==false) &&
	  ((obj.expands.equals(""))==false)) {
	stream.println("  expands {" + 
		       obj.expands.replace('\"',' ').trim() +
		       "};");
      }
      //write nodes
      if (obj.as != null) {
	writeNodes(obj.as);
      }
      stream.println("end_schema;");
      stream.println("");
    }
  }

  private void writeVariables(SpecProcessItem proc) {
    
    SpecVarItem obj = null;

    //needs work to setup more than one variable per schema/task
    //remember that you have the pos property
    for  (Enumeration e =  proc.variables.elements(); e.hasMoreElements() ;){
      obj = (SpecVarItem) e.nextElement();
      stream.println("  " + obj.label.replace('\"',' ').trim() + ";");
    }
  }

  private void writeResourceInfo() {

    SpecItem obj = null;
    SpecUnitItem tempUnit = null;
    int initialResourceCount = 0;
    int initialResourceUnitCount = 0;
    int resourceCount = 1;
    int resourceUnitCount = 1;

    //first count all resources and resources with units
    for  (Enumeration e =  resources.elements(); e.hasMoreElements() ;)  {
      obj = (SpecItem) e.nextElement();
      initialResourceCount++;
      if (("".equals(obj.unit))==false) {
	tempUnit= (SpecUnitItem) sortElements.get(obj.unit);
	if (tempUnit != null) {
	  initialResourceUnitCount++;
	}
      }
    }

    //write resource_unit string
    String outString = "";
    for  (Enumeration e =  resources.elements(); e.hasMoreElements() ;)  {
      obj = (SpecItem) e.nextElement();
      
      if (("".equals(obj.unit))==false) {
	tempUnit= (SpecUnitItem) sortElements.get(obj.unit);
	if (tempUnit != null) {
	  if (resourceUnitCount == 1) 
	    outString = "resource_units ";
	  else
	    outString = "               ";

	  outString = outString + 
	    tempUnit.label.replace('\"',' ').trim() +
	    " = " +
	    tempUnit.unitType.replace('\"',' ').trim() ;
	}
	if (initialResourceUnitCount > resourceUnitCount) {
	  outString = outString + ",";
	}
	else {
	  outString = outString + ";";
	}
	stream.println(outString);
	resourceUnitCount++;
      }
    }

    //write resource_types entries
    outString = "";

    if (initialResourceCount > 0) {
      stream.println("");
      stream.println("resource_types");
    }
    for  (Enumeration e =  resources.elements(); e.hasMoreElements() ;)  {
      obj = (SpecItem) e.nextElement();
      
      tempUnit = null;
      if (("".equals(obj.unit))==false) {
	tempUnit= (SpecUnitItem) sortElements.get(obj.unit);
      }
      outString = "  " + obj.resourceType + " {resource " +
	obj.label.replace('\"',' ').trim() + "}";
      if (tempUnit != null) {
	outString = outString + " = " +
	  tempUnit.label.replace('\"',' ').trim();
      }
      if (initialResourceCount > resourceCount) {
	outString = outString + ",";
      }
      else {
	outString = outString + ";";
      }
      stream.println(outString);
      resourceCount++;
    }
    stream.println("");
  }


  //*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_
  // end of write routines
  //*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_*_


  //---------- Activity ----------------
  public void activityPattern(String id, String val) {
    SpecNodeItem item = null;

    //update the object name if exists, or create new
    item = (SpecNodeItem) sortElements.get(id);
    if (item == null) {
      item = new SpecNodeItem(id);
      item.key = id;
      sortElements.put(id,item);
    }
    item.pattern = val;
  }

  public void activitySpec(String id, String val) {}
  //System.out.println("received:" +id+" "+val);}
  public void activityExpands(String id, String val) {}
  //System.out.println("received:" +id+" "+val);}

  public void activityVariable(String id, String val, int pos) {
  }

  public void activityBegin(String id, String val) {
    SpecNodeItem item = null;
    SpecItem tp = null;

    //update the object name if exists, or create new
    item = (SpecNodeItem) sortElements.get(id);
    if (item == null) {
      item = new SpecNodeItem(id);
      item.key = id;
      sortElements.put(id,item);
    }

    //update the object name if exists, or create new
    tp = (SpecItem) sortElements.get(val);
    if (tp == null) {
      tp = new SpecNodeItem(val);
      sortElements.put(val,tp);
    }

    item.beginTimePoint = val;
  }

  public void activityEnd(String id, String val) {
    SpecNodeItem item = null;
    SpecItem tp = null;

    //update the object name if exists, or create new
    item = (SpecNodeItem) sortElements.get(id);
    if (item == null) {
      item = new SpecNodeItem(id);
      item.key = id;
      sortElements.put(id,item);
    }

    //update the object name if exists, or create new
    tp = (SpecItem) sortElements.get(val);
    if (tp == null) {
      tp = new SpecNodeItem(val);
      sortElements.put(val,tp);
    }

    item.endTimePoint = val;
  }

  //---------- Commands ----------------
  public void comIncludeDomain(String domain) {}
  //System.out.println("received:" +domain);}
  public void comDomainDef(String domain) {
    this.domainName = domain;}
  /*  public void comObjectCount(int count) {
      this.domainObjectCount = count; } */

  //---------- Constraint ----------------
  public void constrExpression(String id, String val) {

    SpecConstrItem item = null;

    //update the item if exists, or create new
    item = (SpecConstrItem) sortElements.get(id);
    if (item == null) {
      item = new SpecConstrItem(id);
      sortElements.put(id,item);
    }
    item.label = val;
  }

  public void constrAddedBy(String id, String val) {}
  //System.out.println("received:" +id+" "+val);}

  //---------- Level ----------------
  public void levelLabel(String id, String val) {
    SpecLevelItem item = null;

    //update the object name if exists, or create new
    item = (SpecLevelItem) sortElements.get(id);
    if (item == null) {
      item = new SpecLevelItem(id);
      levels.put(id,item);
      sortElements.put(id,item);
    }
    item.label = ((val.replace('-','_')).replace('"',' ')).trim();
  }

  public void levelNumber(String id, String val) {
    SpecLevelItem item = null;

    //update the object name if exists, or create new
    item = (SpecLevelItem) sortElements.get(id);
    if (item == null) {
      item = new SpecLevelItem(id);
      levels.put(id,item);
      sortElements.put(id,item);
    }
    item.number = (Integer.valueOf(val)).intValue();
  }

  public void levelContains(String id, String val) {
    // public void activityEnd(String id, String val) {
    SpecProcessItem process = null;
    SpecLevelItem level = null;
    
    //update the object name if exists, or create new
    level = (SpecLevelItem) sortElements.get(id);
    if (level == null) {
      level = new SpecLevelItem(id);
      levels.put(id,level);
      sortElements.put(id,level);
    }
    
    //update the object name if exists, or create new
    process = (SpecProcessItem) sortElements.get(val);
    if (process == null) {
      process = new SpecProcessItem(val);
      sortElements.put(val,process);
    }

    process.level = id;
    level.processes.addElement(process);
  }

  //---------- Node ----------------
  public void nodeLabel(String id, String val) {
    SpecNodeItem item = null;

    //update the object name if exists, or create new
    item = (SpecNodeItem) sortElements.get(id);
    if (item == null) {
      item = new SpecNodeItem(id);
      item.key = id;
      sortElements.put(id,item);
    }
    item.label = val;
  }

  public void nodeXPos(String id, String val) {
    SpecNodeItem item = null;

    //update the object name if exists, or create new
    item = (SpecNodeItem) sortElements.get(id);
    if (item == null) {
      item = new SpecNodeItem(id);
      item.key = id;
      sortElements.put(id,item);
    }
    item.xpos = (Integer.valueOf(val)).intValue();
  }

  public void nodeYPos(String id, String val) {
    SpecNodeItem item = null;

    //update the object name if exists, or create new
    item = (SpecNodeItem) sortElements.get(id);
    if (item == null) {
      item = new SpecNodeItem(id);
      item.key = id;
      sortElements.put(id,item);
    }
    item.ypos = (Integer.valueOf(val)).intValue();
  }

  //---------- Entity ----------------

  public void entityIsa(String id1, String id2) {
    
    SpecEntityItem item = null;

    //update the object name if exists, or create new
    item = (SpecEntityItem) parents.get(id1);
    if (item == null) {
      item = new SpecEntityItem(id1);
      parents.put(id1,item);
    }
    item.parent = id2;
  }

  //----- Annotation -----
  public void annotationXPos(String id, String val) {
    SpecConstrItem item = null;

    //update the object name if exists, or create new
    item = (SpecConstrItem) sortElements.get(id);
    if (item == null) {
      item = new SpecConstrItem(id);
      item.key = id;
      sortElements.put(id,item);
    }
    item.xpos = (Integer.valueOf(val)).intValue();
  }

  public void annotationYPos(String id, String val) {
    SpecConstrItem item = null;

    //update the object name if exists, or create new
    item = (SpecConstrItem) sortElements.get(id);
    if (item == null) {
      item = new SpecConstrItem(id);
      item.key = id;
      sortElements.put(id,item);
    }
    item.ypos = (Integer.valueOf(val)).intValue();
  }

  //---------- Object ----------------
  public void objectName(String id, String val) {
    
    SpecItem item = null;

    //update the object name if exists, or create new
    item = (SpecItem) sortElements.get(id);
    if (item == null) {
      item = new SpecItem(id);
      sortElements.put(id,item);
    }
    item.label = val;
  }

  public void objectIsResource(String id, String val) {

    SpecItem item = null;
    boolean isResource = false;

    //update the object if exists, or create new
    item = (SpecItem) sortElements.get(id);
    if (item == null) {
      item = new SpecItem(id);
      sortElements.put(id,item);
    }
    isResource = (("true".equals(val.toLowerCase())) ? true : false);

    item.isResource = isResource; 
    if (isResource) resources.put(id,item);
  }

  public void objectResourceType(String id, String val) {
    SpecItem item = null;
    //update the object if exists, or create new
    item = (SpecItem) sortElements.get(id);
    if (item == null) {
      item = new SpecItem(id);
      sortElements.put(id,item);
    }
    item.resourceType = val.replace('"',' ').trim();
  }

  public void objectUnit(String id, String val) {
    SpecItem item = null;
    //update the object if exists, or create new
    item = (SpecItem) sortElements.get(id);
    if (item == null) {
      item = new SpecItem(id);
      sortElements.put(id,item);
    }
    item.unit = val;
  }

  //---------- Process ----------------
  public void processLabel(String id, String val) {
    SpecProcessItem item = null;

    //update the object name if exists, or create new
    item = (SpecProcessItem) sortElements.get(id);
    if (item == null) {
      item = new SpecProcessItem(id);
      sortElements.put(id,item);
    }
    item.label = val.replace('-','_');
  }

  public void processSpec(String id, String val) {
    SpecProcessItem item = null;
    SpecActSpecItem asItem = null;

    //update the object name if exists, or create new
    item = (SpecProcessItem) sortElements.get(id);
    if (item == null) {
      item = new SpecProcessItem(id);
      sortElements.put(id,item);
    }

    //update the object name if exists, or create new
    asItem = (SpecActSpecItem) sortElements.get(val);
    if (asItem == null) {
      asItem = new SpecActSpecItem(val);
      sortElements.put(val,asItem);
    }

    item.as = asItem;
  }

  public void processIsExec(String id, String val) {

    SpecProcessItem item = null;

    //update the object name if exists, or create new
    item = (SpecProcessItem) sortElements.get(id);
    if (item == null) {
      item = new SpecProcessItem(id);
      sortElements.put(id,item);
    }
    item.execProcess = (("true".equals(val.toLowerCase())) ? true : false);
  }

  public void processExpands(String id, String val) {
    SpecProcessItem item = null;

    //update the object name if exists, or create new
    item = (SpecProcessItem) sortElements.get(id);
    if (item == null) {
      item = new SpecProcessItem(id);
      sortElements.put(id,item);
    }
    item.expands = val;
  }

  public void processVariable(String id, String val, int pos) {

    SpecProcessItem item = null;
    SpecVarItem varItem = null;

    //update the object name if exists, or create new
    item = (SpecProcessItem) sortElements.get(id);
    if (item == null) {
      item = new SpecProcessItem(id);
      sortElements.put(id,item);
    }

    //update the object name if exists, or create new
    varItem = (SpecVarItem) sortElements.get(val);
    if (varItem == null) {
      varItem = new SpecVarItem(val);
      sortElements.put(val,varItem);
    }
    varItem.pos = pos;
    item.variables.addElement(varItem);
  }

  public void processStart(String id, String val) {}
  //System.out.println("received:" +id+" "+val);}
  public void processFinish(String id, String val) {}
  //System.out.println("received:" +id+" "+val);}

  //---------- Sort ----------------
  public void sortDeclaration(String type, String id, boolean newType) {

    SpecItem instItem = null;
    SpecTypeItem item = null; // for dynamically defined types

    //insert the sort element into the hashtable
    instItem = (SpecItem) sortElements.get(id);
    if (instItem == null) {
      //create new spec item of proper type
      if ("always-constraint".equals(type)) {instItem = new SpecItem(id);}
      else if ("plan".equals(type)) {instItem = new SpecProcessItem(id);}
      else if ("action".equals(type)) {instItem = new SpecNodeItem(id);
      ((SpecNodeItem)instItem).key = id;}
      else if ("unit".equals(type)) {instItem = new SpecUnitItem(id);}
      else if ("entity-variable".equals(type)) 
	{instItem = new SpecVarItem(id);}
      else if ("start".equals(type)) {instItem = new SpecNodeItem(id);}
      else if ("finish".equals(type)) {instItem = new SpecNodeItem(id);}
      else if ("begin".equals(type)) {instItem = new SpecNodeItem(id);}
      else if ("end".equals(type)) {instItem = new SpecNodeItem(id);}
      else if ("process".equals(type)) {instItem = new SpecProcessItem(id);}
      else if ("activity-specification".equals(type)) 
	{instItem = new SpecActSpecItem(id);}
      else if ("include-constraint".equals(type)) 
	{instItem = new SpecConstrItem(id);}
      else if ("ordering-constraint".equals(type)) 
	{instItem = new SpecConstrItem(id);}
      else {
        instItem = new SpecItem(id);
      }
      sortElements.put(id,instItem);
    }
    instItem.type = type;

    //if new type, add hashtable entry to the types
    if (newType) {
      item = (SpecTypeItem)types.get(type);
      if (item != null) {
	item.instances.addElement(instItem);
      }
      else {
	item = new SpecTypeItem(type); 
	item.instances.addElement(instItem);
	types.put(type, item);
      }
    }
    else {
      if ("always-constraint".equals(type)) {always.put(id,instItem);}
      else if ("plan".equals(type)) {
	plans.put(id,instItem);
	((SpecProcessItem)instItem).taskProcess = true;
      }
      else if ("process".equals(type)) {
	processes.put(id,instItem);
	((SpecProcessItem)instItem).taskProcess = false;
      }
    }
  }

  public void sortRangeDeclaration(String type, String id, boolean newType) {
    //System.out.println("received:"+type+" "+id);
    System.err.println("Range expressions not currently supported!");}

  //---------- Special ----------------
  public void includeNode(String id, String val) {
    SpecConstrItem cItem = null;
    SpecNodeItem nItem = null;

    //update the object name if exists, or create new
    cItem = (SpecConstrItem) sortElements.get(id);
    if (cItem == null) {
      cItem = new SpecConstrItem(id);
      sortElements.put(id,cItem);
    }

    //update the object name if exists, or create new
    nItem = (SpecNodeItem) sortElements.get(val);
    if (nItem == null) {
      nItem = new SpecNodeItem(val);
      nItem.key = val;
      sortElements.put(val,nItem);
    }

    cItem.node = nItem;
  }
  
  public void member(String memberStr, String setStr) {
    SpecActSpecItem asItem = null;
    SpecConstrItem cItem = null;

    //update the object name if exists, or create new
    asItem = (SpecActSpecItem) sortElements.get(setStr);
    if (asItem == null) {
      asItem = new SpecActSpecItem(setStr);
      sortElements.put(setStr,asItem);
    }

    //update the object name if exists, or create new
    cItem = (SpecConstrItem) sortElements.get(memberStr);
    if (cItem == null) {
      cItem = new SpecConstrItem(memberStr);
      sortElements.put(memberStr,cItem);
    }

    asItem.constraints.addElement(cItem);
  }

  //---------- Timepoint ----------------
  public void tpStart(String id, String val) {
    SpecNodeItem item = null;
    SpecItem tp = null;

    //update the object name if exists, or create new
    item = (SpecNodeItem) sortElements.get(id);
    if (item == null) {
      item = new SpecNodeItem(id);
      item.key = id;
      sortElements.put(id,item);
    }

    //update the object name if exists, or create new
    tp = (SpecItem) sortElements.get(val);
    if (tp == null) {
      tp = new SpecNodeItem(val);
      sortElements.put(val,tp);
    }

    item.beginTimePoint = val;    
    item.endTimePoint = val;    
  }

  public void tpFinish(String id, String val) {
    SpecNodeItem item = null;
    SpecItem tp = null;

    //update the object name if exists, or create new
    item = (SpecNodeItem) sortElements.get(id);
    if (item == null) {
      item = new SpecNodeItem(id);
      item.key = id;
      sortElements.put(id,item);
    }

    //update the object name if exists, or create new
    tp = (SpecItem) sortElements.get(val);
    if (tp == null) {
      tp = new SpecNodeItem(val);
      sortElements.put(val,tp);
    }

    item.beginTimePoint = val;    
    item.endTimePoint = val;    
  }

  //---------- Unit ----------------

  public void unitLabel(String id, String val) {
    SpecUnitItem item = null;
    //update the object if exists, or create new
    item = (SpecUnitItem) sortElements.get(id);
    if (item == null) {
      item = new SpecUnitItem(id);
      sortElements.put(id,item);
    }
    item.label = val;
  }

  public void unitType(String id, String val) {
    SpecUnitItem item = null;
    //update the object if exists, or create new
    item = (SpecUnitItem) sortElements.get(id);
    if (item == null) {
      item = new SpecUnitItem(id);
      sortElements.put(id,item);
    }
    item.unitType = val;
  }

  //---------- Variable ----------------
  public void varLabel(String id, String val) {

    SpecVarItem item = null;
    //update the object if exists, or create new
    item = (SpecVarItem) sortElements.get(id);
    if (item == null) {
      item = new SpecVarItem(id);
      sortElements.put(id,item);
    }
    item.label = val;
    //System.out.println(val);
  }

  //The classes for specification items.

  class SpecTypeItem {            //note this one is special 
    public String label = "";
    public Vector instances = new Vector();
    SpecTypeItem(String label) {
      this.label = label;
    }
  }
 
  class SpecItem {                //root spec item class.
    public String label = "";
    public String id = "";
    public String type = "";
    public String resourceType = "";
    public boolean isResource=false;
    public String unit = "";
    SpecItem(String id) {
      this.id = id;
    }
  }

  class SpecEntityItem extends SpecItem {
    public String parent = "";
    SpecEntityItem(String id) {
      super(id);
    }
  }

  class SpecProcessItem extends SpecItem {
    public Vector variables = new Vector();
    public String expands = "";
    public String level = "";
    public SpecActSpecItem as = null;
    public boolean taskProcess = false;
    public boolean execProcess = false;
    SpecProcessItem(String id) {
      super(id);
    }
  }

  class SpecLevelItem extends SpecItem {
    public Vector processes = new Vector();
    public int number = 0;
    public boolean processed = false;
    SpecLevelItem(String id) {
      super(id);
    }
  }

  class SpecActSpecItem extends SpecItem {
    public Vector constraints = new Vector();
    SpecActSpecItem(String id) {
      super(id);
    }
  }

  class SpecConstrItem extends SpecItem {
    SpecNodeItem node = null;
    String tp1 = "";
    String tp2 = "";
    String relation = "";
    int xpos = -1;
    int ypos = -1;
    String key = "";

    SpecConstrItem(String id) {
      super(id);
    }
  }

  class SpecNodeItem extends SpecItem {
    public String pattern = "";
    public String key = "";
    public String beginTimePoint = "";
    public String endTimePoint = "";
    //extensions
    public int xpos = 10;
    public int ypos = 10;

    int assignedNumber = 0;
    SpecNodeItem(String id) {
      super(id);
    }
  }

  class SpecUnitItem extends SpecItem {
    public String unitType = "";
    SpecUnitItem(String id) {
      super(id);
    }
  }

  class SpecVarItem extends SpecItem {
    public int pos = 0;
    SpecVarItem(String id) {
      super(id);
    }
  }

  public String replaceKey(String text, String pattern, String newPattern) {
    //uses a modified rabin-karp algo for text search

    String outString = "";
    long q = 2113929255l, d = 32, d_bits = 5;
    int hit = 0;
    char[] a = text.toCharArray();
    char[] p = pattern.toCharArray();
    int M = p.length, N = a.length;
    long h1 = 0, h2 = 0, dM = 1;
    int i;

    for(i = 0; i < M - 1; i++)
      dM = (dM << d_bits) % q;
      
    for(i = 0; i < M; i++) {
      h1 = ((h1 << d_bits) + (long)p[i]) % q;
      h2 = ((h2 << d_bits) + (long)a[i]) % q;
    }

    /* There's got to be a string in here somewhere */
    i = 0;
    while(h1 != h2 && i < N - M) {
      h2 = (h2 + (q << d_bits) - (long)a[i] * dM) % q;
      h2 = ((h2 << d_bits) + (long)a[i + M]) % q;
      i++;
    }
      
    /* no match */
    if(i >= N - M) {
      hit = -1;
      return text;
    }

    /* match */
    hit = i;
    outString = text.substring(0,i) + newPattern + text.substring(i+M);
    //System.out.println("Match: " + text + " " + pattern + " " + i +" "+ M);
    return outString;
  }
}
