/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.shared;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import EDU.oswego.cs.dl.util.concurrent.WriterPreferenceReadWriteLock;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.Lock;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LockMRSW
implements Lock {
    static Log log = LogFactory.getLog((Class)LockMRSW.class);
    Map threadStates = new HashMap();
    int threadStatesSize = this.threadStates.size();
    WriterPreferenceReadWriteLock mrswLock = new WriterPreferenceReadWriteLock();
    SynchronizedInt activeReadLocks = new SynchronizedInt(0);
    SynchronizedInt activeWriteLocks = new SynchronizedInt(0);

    public LockMRSW() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Lock : " + Thread.currentThread().getName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void enterCriticalSection(boolean readLockRequested) {
        LockState state = this.getLockState();
        if (log.isDebugEnabled()) {
            log.debug((Object)(Thread.currentThread().getName() + " >> enterCS: " + this.report(state)));
        }
        if (state.readLocks > 0 && state.writeLocks == 0 && !readLockRequested) {
            ++state.readLocks;
            this.activeReadLocks.increment();
            if (log.isDebugEnabled()) {
                log.debug((Object)(Thread.currentThread().getName() + " << enterCS: promotion attempt: " + this.report(state)));
            }
            throw new JenaException("enterCriticalSection: Write lock request while holding read lock - potential deadlock");
        }
        if (state.writeLocks > 0 && readLockRequested) {
            readLockRequested = false;
        }
        try {
            if (readLockRequested) {
                if (state.readLocks == 0) {
                    this.mrswLock.readLock().acquire();
                }
                ++state.readLocks;
                this.activeReadLocks.increment();
            } else {
                if (state.writeLocks == 0) {
                    this.mrswLock.writeLock().acquire();
                }
                ++state.writeLocks;
                this.activeWriteLocks.increment();
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)(Thread.currentThread().getName() + " << enterCS: " + this.report(state)));
            }
        }
    }

    public final void leaveCriticalSection() {
        LockState state = this.getLockState();
        if (log.isDebugEnabled()) {
            log.debug((Object)(Thread.currentThread().getName() + " >> leaveCS: " + this.report(state)));
        }
        try {
            if (state.readLocks > 0) {
                --state.readLocks;
                this.activeReadLocks.decrement();
                if (state.readLocks == 0) {
                    this.mrswLock.readLock().release();
                }
                state.clean();
                return;
            }
            if (state.writeLocks > 0) {
                --state.writeLocks;
                this.activeWriteLocks.decrement();
                if (state.writeLocks == 0) {
                    this.mrswLock.writeLock().release();
                }
                state.clean();
                return;
            }
            throw new JenaException("leaveCriticalSection: No lock held (" + Thread.currentThread().getName() + ")");
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)(Thread.currentThread().getName() + " << leaveCS: " + this.report(state)));
            }
        }
    }

    private String report(LockState state) {
        StringBuffer sb = new StringBuffer();
        sb.append("Thread R/W: ");
        sb.append(Integer.toString(state.readLocks));
        sb.append("/");
        sb.append(Integer.toString(state.writeLocks));
        sb.append(" :: Model R/W: ");
        sb.append(Integer.toString(this.activeReadLocks.get()));
        sb.append("/");
        sb.append(Integer.toString(this.activeWriteLocks.get()));
        sb.append(" (thread: ");
        sb.append(state.thread.getName());
        sb.append(")");
        return sb.toString();
    }

    synchronized LockState getLockState() {
        Thread thisThread = Thread.currentThread();
        LockState state = (LockState)this.threadStates.get(thisThread);
        if (state == null) {
            state = new LockState(this);
            this.threadStates.put(thisThread, state);
            this.threadStatesSize = this.threadStates.size();
        }
        return state;
    }

    synchronized void removeLockState(Thread thread) {
        this.threadStates.remove(thread);
    }

    static class LockState {
        int readLocks = 0;
        int writeLocks = 0;
        LockMRSW lock;
        Thread thread;

        LockState(LockMRSW theLock) {
            this.lock = theLock;
            this.thread = Thread.currentThread();
        }

        void clean() {
            if (this.lock.activeReadLocks.get() == 0 && this.lock.activeWriteLocks.get() == 0) {
                this.lock.removeLockState(this.thread);
            }
        }
    }
}

