/*
 * Decompiled with CFR 0.152.
 */
package rfabroker;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.ontology.Individual;
import com.hp.hpl.jena.ontology.OntClass;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.ontology.OntProperty;
import com.hp.hpl.jena.ontology.OntResource;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.ModelMaker;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.util.Vector;
import javax.swing.DefaultListModel;
import rfabroker.BrokerInterface;

public class Broker {
    OntModelSpec mySpec;
    BrokerInterface myBrokerInterface = new BrokerInterface(this);
    ModelMaker myModelMaker;
    OntModel currentModel;
    ExtendedIterator rfaProfileIterator;
    ExtendedIterator resProfileIterator;
    ExtendedIterator availableResourcesIterator;
    ExtendedIterator modelMakerModelsIterator;
    DefaultListModel matchesListModel;

    public Broker() {
        this.myBrokerInterface.setVisible(true);
        this.print("Initializing...\n");
        this.print("Database Initialization...");
        String className = "com.mysql.jdbc.Driver";
        try {
            Class.forName(className);
        }
        catch (ClassNotFoundException ex1) {
            this.print("Could Not Establish Database Connection");
        }
        String DB_URL = "jdbc:mysql://localhost/rfa";
        String DB_USER = "rfa";
        String DB_PASSWD = "rfa";
        String DB = "MySQL";
        this.print(" OK!\n");
        this.print("Jena Framework Initialization...");
        this.myModelMaker = ModelFactory.createMemModelMaker();
        this.mySpec = new OntModelSpec(OntModelSpec.OWL_DL_MEM_RDFS_INF);
        this.mySpec.setImportModelMaker(this.myModelMaker);
        this.mySpec.setBaseModelMaker(this.myModelMaker);
        Model baseModel1 = this.myModelMaker.createModel("newKB");
        this.currentModel = ModelFactory.createOntologyModel((OntModelSpec)this.mySpec, (Model)baseModel1);
        this.myBrokerInterface.addResourceButton.setEnabled(true);
        this.print(" OK!\n");
    }

    public static void main(String[] args) {
        Broker myBroker = new Broker();
    }

    public void addDocument(String documentURL) {
        Model newModel = this.myModelMaker.createModel(documentURL);
        OntModel newOntModel = ModelFactory.createOntologyModel((OntModelSpec)this.mySpec, (Model)newModel);
        newOntModel.read(documentURL);
        this.currentModel.addSubModel((Model)newOntModel);
        this.print("Reading Resource document : " + documentURL + " OK! \n");
        this.refreshLoadedDocuments();
        this.refreshAvailableResources();
    }

    public void brokerRfa(String documentURL) {
        this.matchesListModel = new DefaultListModel();
        Model newModel = this.myModelMaker.createModel(documentURL);
        OntModel newOntModel = ModelFactory.createOntologyModel((OntModelSpec)this.mySpec, (Model)newModel);
        newOntModel.read(documentURL);
        this.currentModel.addSubModel((Model)newOntModel);
        this.print("|-- Searching for RFA Profile Class.\n");
        OntClass rfaProfileClass = this.currentModel.getOntClass("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#rfaProfile");
        if (rfaProfileClass != null) {
            this.rfaProfileIterator = rfaProfileClass.listInstances();
            if (this.rfaProfileIterator.hasNext()) {
                Individual rfaProfile = (Individual)this.rfaProfileIterator.next();
                this.print("|-- Brokering RFA : " + rfaProfile.getLocalName() + "\n");
                OntClass transportRfaProfileClass = this.currentModel.getOntClass("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#rfaTransportProfile");
                OntClass provideRfaProfileClass = this.currentModel.getOntClass("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#rfaProvideProfile");
                if (rfaProfile.hasRDFType((Resource)transportRfaProfileClass)) {
                    this.brokerTransportRFA(rfaProfile);
                } else if (rfaProfile.hasRDFType((Resource)provideRfaProfileClass)) {
                    this.brokerProvideRFA(rfaProfile);
                } else {
                    this.brokerGenericRfa(rfaProfile);
                }
            } else {
                this.print("|-- There is no Profile Class in the loaded Documents!\n");
            }
        } else {
            this.print("|-- There is no Service Profile in the given URL\n");
        }
    }

    void brokerTransportRFA(Individual rfaProfile) {
        this.print("|------ Brokering Transport RFA : " + rfaProfile.getLocalName() + "\n");
        OntClass departurePointOntClass = this.currentModel.getOntClass("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#DeparturePoint");
        OntClass destinationPointOntClass = this.currentModel.getOntClass("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#DestinationPoint");
        OntClass weightInputOntClass = this.currentModel.getOntClass("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#WeightInput");
        OntResource rfaDepartureLocationOntResource = this.getLocationOntResource4Direction(rfaProfile, departurePointOntClass);
        OntResource rfaDestinationLocationOntResource = this.getLocationOntResource4Direction(rfaProfile, destinationPointOntClass);
        Individual rfaWeightInputIndividual = this.getProfileInput(rfaProfile, weightInputOntClass);
        Vector usedTransportersVector = new Vector();
        Vector emptyChainContainer = new Vector();
        Vector chainContainer = this.getChainsOfTransporters(rfaDepartureLocationOntResource, rfaDestinationLocationOntResource, rfaWeightInputIndividual, usedTransportersVector, emptyChainContainer);
        if (chainContainer.size() != 0) {
            this.printChainContainer(chainContainer);
        }
    }

    Vector getChainsOfTransporters(OntResource departureLocationOntResource, OntResource destinationLocationOntResource, Individual weightInputIndividual, Vector usedTransportersVector, Vector chainContainer) {
        this.print("|-------------- Looking for Transport Chain:\n");
        this.print("|-------------- Ultimate Destination is :" + destinationLocationOntResource.getLocalName() + "\n");
        this.print("|-------------- Starting Point is :" + departureLocationOntResource.getLocalName() + "\n");
        this.print("|-------------- Current # of used Transporters : " + usedTransportersVector.size() + "\n");
        OntClass resourceTransportProfileClass = this.currentModel.getOntClass("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#resTransportProfile");
        ExtendedIterator myResProfileIterator = resourceTransportProfileClass.listInstances();
        while (myResProfileIterator.hasNext()) {
            Individual currentResProfile = (Individual)myResProfileIterator.next();
            if (usedTransportersVector.contains(currentResProfile)) continue;
            this.print("|-------------- Checking Profile for Chain :" + currentResProfile.getLocalName() + "\n");
            OntClass departurePointOntClass = this.currentModel.getOntClass("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#DeparturePoint");
            OntClass destinationPointOntClass = this.currentModel.getOntClass("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#DestinationPoint");
            OntClass weightInputOntClass = this.currentModel.getOntClass("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#WeightInput");
            OntResource resDepartureLocationOntResource = this.getLocationOntResource4Direction(currentResProfile, departurePointOntClass);
            OntResource resDestinationLocationOntResource = this.getLocationOntResource4Direction(currentResProfile, destinationPointOntClass);
            Individual resWeightInputIndividual = this.getProfileInput(currentResProfile, weightInputOntClass);
            Boolean checkResult1 = this.compareOntResources(departureLocationOntResource, resDepartureLocationOntResource);
            Boolean checkResult3 = this.checkResourceForInput(weightInputIndividual, currentResProfile);
            Boolean checkResult2 = false;
            checkResult2 = usedTransportersVector.size() == 0 ? this.compareOntResources(destinationLocationOntResource, resDestinationLocationOntResource) : this.compareOntResources(resDestinationLocationOntResource, destinationLocationOntResource);
            if (checkResult1.booleanValue()) {
                this.print("|-------------- Resource has a matching Daparture Point\n");
            }
            if (checkResult2.booleanValue()) {
                this.print("|-------------- Resource has a matching Dastination Point\n");
            }
            if (checkResult3.booleanValue()) {
                this.print("|-------------- Resource respects Weight Restrictions\n");
            }
            if (!checkResult2.booleanValue() || !checkResult3.booleanValue()) continue;
            if (checkResult1.booleanValue()) {
                usedTransportersVector.add(currentResProfile);
                Vector clone = (Vector)usedTransportersVector.clone();
                chainContainer.add(clone);
                usedTransportersVector.remove(currentResProfile);
                continue;
            }
            usedTransportersVector.add(currentResProfile);
            chainContainer = this.getChainsOfTransporters(departureLocationOntResource, resDepartureLocationOntResource, weightInputIndividual, usedTransportersVector, chainContainer);
            usedTransportersVector.remove(currentResProfile);
            this.print("|-------------- Ultimate Destination is AGAIN :" + destinationLocationOntResource.getLocalName() + "\n");
            this.print("|-------------- Current # of used Transporters is AGAIN : " + usedTransportersVector.size() + "\n");
        }
        return chainContainer;
    }

    void brokerProvideRFA(Individual rfaProvideProfile) {
        this.print("|------ Brokering Providing RFA : " + rfaProvideProfile.getLocalName() + "\n");
        Vector chainContainer = this.brokerRfaDirectly(rfaProvideProfile);
        OntClass goodsInputClass = this.currentModel.getOntClass("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#GoodsInput");
        OntClass resourceProvideProfileClass = this.currentModel.getOntClass("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#resProvideProfile");
        OntClass resourceTransportProfileClass = this.currentModel.getOntClass("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#resTransportProfile");
        OntClass destinationPointOntClass = this.currentModel.getOntClass("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#DestinationPoint");
        Individual rfaGoodsInput = this.getProfileInput(rfaProvideProfile, goodsInputClass);
        Individual weightRestrictionInput = this.createWeightRestrictionInput(rfaProvideProfile);
        ExtendedIterator myResProfileIterator = resourceProvideProfileClass.listInstances();
        while (myResProfileIterator.hasNext()) {
            Individual currentResProfile = (Individual)myResProfileIterator.next();
            this.print("|---------- Checking Providing Resource Profile : " + currentResProfile.getLocalName() + "\n");
            Individual resGoodsInput = this.getProfileInput(currentResProfile, goodsInputClass);
            Boolean checkResult1 = this.checkMatchOfInputs(rfaGoodsInput, resGoodsInput);
            if (!checkResult1.booleanValue()) continue;
            this.print("|---------- Profile satisfies Goods Input\n");
            OntResource rfaDestinationLocation = this.getLocationOntResource4Direction(rfaProvideProfile, destinationPointOntClass);
            OntResource resDestinationLocation = this.getLocationOntResource4Direction(currentResProfile, destinationPointOntClass);
            this.print("|---------- Checking for Chain from " + resDestinationLocation.getLocalName() + " to " + rfaDestinationLocation.getLocalName() + "\n");
            Vector emptyVector = new Vector();
            Vector aChainContainer = this.getChainsOfTransporters(resDestinationLocation, rfaDestinationLocation, weightRestrictionInput, emptyVector, emptyVector);
            aChainContainer = this.addProfile2ChainContainer(aChainContainer, currentResProfile);
            chainContainer.addAll(aChainContainer);
        }
        this.printChainContainer(chainContainer);
    }

    Individual createWeightRestrictionInput(Individual rfaProvideProfile) {
        OntClass goodsInputClass = this.currentModel.getOntClass("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#GoodsInput");
        OntClass weightInputClass = this.currentModel.getOntClass("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#ExWeightInput");
        OntProperty requestQuantityProperty = this.currentModel.getOntProperty("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#requestQuantity");
        OntProperty requestGoodTypeProperty = this.currentModel.getOntProperty("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#requestGoodInput");
        OntProperty hasWeightProperty = this.currentModel.getOntProperty("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#hasWeight");
        OntProperty hasWeightMeasureUnitProperty = this.currentModel.getOntProperty("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#hasWeightMeasureUnit");
        Individual goodsInput = this.getProfileInput(rfaProvideProfile, goodsInputClass);
        RDFNode goodsQuantityNode = goodsInput.getPropertyValue((Property)requestQuantityProperty);
        Literal goodsQuantityLiteral = (Literal)goodsQuantityNode.as(Literal.class);
        int goodsQuantity = goodsQuantityLiteral.getInt();
        RDFNode goodsTypeNode = goodsInput.getPropertyValue((Property)requestGoodTypeProperty);
        Literal goodsTypeLiteral = (Literal)goodsTypeNode.as(Literal.class);
        String goodsTypeString = (String)goodsTypeLiteral.getValue();
        Individual goodsType = this.currentModel.getIndividual(goodsTypeString);
        RDFNode goodsTypeWeightNode = goodsType.getPropertyValue((Property)hasWeightProperty);
        Literal goodsTypeWeightLiteral = (Literal)goodsTypeWeightNode.as(Literal.class);
        int goodsTypeWeight = goodsTypeWeightLiteral.getInt();
        int combinedWeight = goodsQuantity * goodsTypeWeight;
        Literal combinedWeightLiteral = this.currentModel.createTypedLiteral((Object)combinedWeight, (RDFDatatype)XSDDatatype.XSDnonNegativeInteger);
        RDFNode weightMeasureUnitNode = goodsType.getPropertyValue((Property)hasWeightMeasureUnitProperty);
        Individual weightRestrictionInput = weightInputClass.createIndividual("aWeightRestrictionInput");
        weightRestrictionInput.addProperty((Property)hasWeightMeasureUnitProperty, weightMeasureUnitNode);
        weightRestrictionInput.addProperty((Property)hasWeightProperty, (RDFNode)combinedWeightLiteral);
        return weightRestrictionInput;
    }

    void brokerGenericRfa(Individual rfaProfile) {
        this.print("|------ Brokering Generic RFA : " + rfaProfile.getLocalName() + "\n");
        Vector chainContainer = this.brokerRfaDirectly(rfaProfile);
        this.printChainContainer(chainContainer);
    }

    Vector brokerRfaDirectly(Individual rfaProfile) {
        this.print("|---------- Brokering RFA Directly : " + rfaProfile.getLocalName() + "\n");
        Vector chainContainer = new Vector();
        OntClass resourceProfileClass = this.currentModel.getOntClass("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#resProfile");
        if (resourceProfileClass != null) {
            this.resProfileIterator = resourceProfileClass.listInstances();
            int debugCount = 1;
            while (this.resProfileIterator.hasNext()) {
                Individual currentResProfile = (Individual)this.resProfileIterator.next();
                this.print("|-------------- Checking Profile  : " + currentResProfile.getLocalName() + "\n");
                Boolean checkResult = this.checkMatchOfProfiles(rfaProfile, currentResProfile);
                if (checkResult.booleanValue()) {
                    Vector<Individual> chainVector = new Vector<Individual>();
                    chainVector.add(currentResProfile);
                    chainContainer.add(chainVector);
                }
                ++debugCount;
            }
        }
        return chainContainer;
    }

    Boolean checkMatchOfProfiles(Individual rfaProfile, Individual resProfile) {
        this.print("|------------------ Comparing Profiles : " + rfaProfile.getLocalName() + " VS " + resProfile.getLocalName() + "\n");
        Property hasInputProperty = this.currentModel.getProperty("http://www.daml.org/services/owl-s/1.2/Profile.owl#hasInput");
        NodeIterator rfaHasInputValuesIterator = rfaProfile.listPropertyValues(hasInputProperty);
        while (rfaHasInputValuesIterator.hasNext()) {
            RDFNode currentRfaInputNode = (RDFNode)rfaHasInputValuesIterator.next();
            Individual currentRfaInputIndividual = (Individual)currentRfaInputNode.as(Individual.class);
            this.print("|---------------------- Looking in Profile for Input : " + currentRfaInputIndividual.getLocalName() + "\n");
            Boolean matchResourceInput = this.checkResourceForInput(currentRfaInputIndividual, resProfile);
            if (matchResourceInput.booleanValue()) continue;
            this.print("|---------------------- Input NOT Present in Profile!\n");
            return false;
        }
        return true;
    }

    Boolean checkResourceForInput(Individual rfaInput, Individual resProfile) {
        this.print("|-------------------------- Looking in Profile " + resProfile.getLocalName() + " for equivalent Input of : " + rfaInput.getLocalName() + "\n");
        Property hasInputProperty = this.currentModel.getProperty("http://www.daml.org/services/owl-s/1.2/Profile.owl#hasInput");
        NodeIterator resHasInputValuesIterator = resProfile.listPropertyValues(hasInputProperty);
        while (resHasInputValuesIterator.hasNext()) {
            RDFNode currentResInputNode = (RDFNode)resHasInputValuesIterator.next();
            Individual currentResInputIndividual = (Individual)currentResInputNode.as(Individual.class);
            Boolean tempInputsMatch = this.checkMatchOfInputs(rfaInput, currentResInputIndividual);
            if (!tempInputsMatch.booleanValue()) continue;
            this.print("|-------------------------- Found equivalent Inputs! : " + rfaInput.getLocalName() + " <------> " + currentResInputIndividual.getLocalName() + "\n");
            return true;
        }
        this.print("|-------------------------- NO equivalent Input.\n");
        return false;
    }

    Boolean checkMatchOfInputs(Individual rfaInput, Individual resInput) {
        this.print("|------------------------------ Comparing Inputs " + rfaInput.getLocalName() + " VS " + resInput.getLocalName() + "\n");
        OntClass rfaInputType = (OntClass)rfaInput.getRDFType(true).as(OntClass.class);
        OntClass resInputType = (OntClass)resInput.getRDFType(true).as(OntClass.class);
        if (rfaInputType.hasSuperClass((Resource)resInputType)) {
            this.print("|---------------------------------- Point 1: Type match : " + rfaInputType.getLocalName() + " <-----> " + resInputType.getLocalName() + "\n");
            StmtIterator rfaInputStatements = rfaInput.listProperties();
            OntProperty typeOntProperty = this.currentModel.getOntProperty("http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
            while (rfaInputStatements.hasNext()) {
                Statement rfaInputTempStatement = (Statement)rfaInputStatements.next();
                OntProperty rfaInputTempProperty = (OntProperty)rfaInputTempStatement.getPredicate().as(OntProperty.class);
                if (typeOntProperty.equals(rfaInputTempProperty)) continue;
                if (resInput.hasProperty((Property)rfaInputTempProperty)) {
                    this.print("|---------------------------------- Point 2: Resource : " + resInput.getLocalName() + " has Property " + rfaInputTempProperty.getLocalName() + "\n");
                    Boolean checkResult = this.checkRfaPropertyValueAgainstResPropertyValue(rfaInput, rfaInputTempProperty, rfaInput.getPropertyValue((Property)rfaInputTempProperty), resInput, resInput.getPropertyValue((Property)rfaInputTempProperty));
                    if (!checkResult.booleanValue()) {
                        this.print("|---------------------------------- Point 3: Input Property Values MISmatch.\n");
                        return false;
                    }
                    this.print("|---------------------------------- Point 3: Values in this property Match for both Profiles\n");
                    continue;
                }
                this.print("|---------------------------------- Point 2: Input MISmatch : Property " + rfaInputTempProperty.getLocalName() + " Missing\n");
                return false;
            }
            return true;
        }
        this.print("|---------------------------------- Point 1: Type MISmatch : " + rfaInputType.getLocalName() + " IS NOT " + resInputType.getLocalName() + "\n");
        return false;
    }

    Boolean checkRfaPropertyValueAgainstResPropertyValue(Individual firstInput, OntProperty firstInputTempProperty, RDFNode firstInputPropertyValueNode, Individual secondInput, RDFNode secondInputPropertyValueNode) {
        this.print("|-------------------------------------- Comparing Property Value VS Property Value: " + firstInputPropertyValueNode.toString() + " VS " + secondInputPropertyValueNode.toString() + " for Input " + firstInput.getLocalName() + "\n");
        if (firstInputPropertyValueNode.isLiteral() && secondInputPropertyValueNode.isLiteral()) {
            this.print("|-------------------------------------- Both Input Property Values are literals\n");
            Literal rfaInputPropertyValueLiteral = (Literal)firstInputPropertyValueNode.as(Literal.class);
            Literal resInputPropertyValueLiteral = (Literal)secondInputPropertyValueNode.as(Literal.class);
            OntClass boundInputOntClass = this.currentModel.getOntClass("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#BoundInput");
            if (firstInput.hasRDFType((Resource)boundInputOntClass) && rfaInputPropertyValueLiteral.getDatatypeURI().equals("http://www.w3.org/2001/XMLSchema#nonNegativeInteger")) {
                Boolean checkResult = this.compareBoundLiterals(firstInput, firstInputTempProperty, rfaInputPropertyValueLiteral, secondInput, resInputPropertyValueLiteral);
                return checkResult;
            }
            OntResource rfaInputPropertyValueLiteral2Resource = this.currentModel.getOntResource(rfaInputPropertyValueLiteral.getValue().toString());
            OntResource resInputPropertyValueLiteral2Resource = this.currentModel.getOntResource(resInputPropertyValueLiteral.getValue().toString());
            Boolean checkResult = this.compareOntResources(rfaInputPropertyValueLiteral2Resource, resInputPropertyValueLiteral2Resource);
            return checkResult;
        }
        if (firstInputPropertyValueNode.isResource() && secondInputPropertyValueNode.isResource()) {
            OntResource rfaInputPropertyValue = (OntResource)firstInputPropertyValueNode.as(OntResource.class);
            OntResource resInputPropertyValue = (OntResource)secondInputPropertyValueNode.as(OntResource.class);
            Boolean checkResult = this.compareOntResources(rfaInputPropertyValue, resInputPropertyValue);
            return checkResult;
        }
        this.print("|-------------------------------------- Property Values MISmatch\n");
        return false;
    }

    Boolean compareOntResources(OntResource firstResource, OntResource secondResource) {
        OntClass secondResourceClass;
        Individual firstResourceIndividual;
        this.print("|-------------------------------------- Comparing Resources " + firstResource.toString() + " AND " + secondResource.toString() + "\n");
        if (firstResource.equals(secondResource)) {
            this.print("|-------------------------------------- Resources match...\n");
            return true;
        }
        if (firstResource.isClass() && secondResource.isClass()) {
            OntClass secondResourceClass2;
            OntClass firstResourceClass = (OntClass)firstResource.as(OntClass.class);
            if (firstResourceClass.hasSuperClass((Resource)(secondResourceClass2 = (OntClass)secondResource.as(OntClass.class)))) {
                this.print("|-------------------------------------- Resources match...\n");
                return true;
            }
        } else if (firstResource.isIndividual() && secondResource.isClass() && (firstResourceIndividual = (Individual)firstResource.as(Individual.class)).hasRDFType((Resource)(secondResourceClass = (OntClass)secondResource.as(OntClass.class)))) {
            this.print("|-------------------------------------- Resources match...\n");
            return true;
        }
        this.print("|-------------------------------------- Resources mismatch...\n");
        return false;
    }

    Boolean compareBoundLiterals(Individual firstInput, OntProperty someInputProperty, Literal firstLiteral, Individual secondInput, Literal secondLiteral) {
        OntClass minimumBoundInputOntClass = this.currentModel.getOntClass("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#MinimumBoundInput");
        OntClass maximumBoundInputOntClass = this.currentModel.getOntClass("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#MaximumBoundInput");
        OntClass exactBoundInputOntClass = this.currentModel.getOntClass("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#MaximumBoundInput");
        this.print("|------------------------------------------ Comparing Bound Literals : FirstInput is " + firstInput.getLocalName() + " and Second Input is " + secondInput.getLocalName() + "\n");
        if (firstInput.hasRDFType((Resource)minimumBoundInputOntClass) && (firstInput.hasRDFType((Resource)minimumBoundInputOntClass) || firstInput.hasRDFType((Resource)exactBoundInputOntClass)) && firstLiteral.getInt() >= secondLiteral.getInt()) {
            this.print("|------------------------------------------ Bound Literals Match\n");
            return true;
        }
        if (secondInput.hasRDFType((Resource)maximumBoundInputOntClass) && (firstInput.hasRDFType((Resource)maximumBoundInputOntClass) || firstInput.hasRDFType((Resource)exactBoundInputOntClass)) && firstLiteral.getInt() <= secondLiteral.getInt()) {
            this.print("|------------------------------------------ Bound Literals Match\n");
            return true;
        }
        this.print("|------------------------------------------ Bound Literals MISMatch\n");
        return false;
    }

    Individual getLocationInput4Direction(Individual someProfile, OntClass desiredDirectionOntClass) {
        OntProperty hasInputProperty = this.currentModel.getOntProperty("http://www.daml.org/services/owl-s/1.2/Profile.owl#hasInput");
        OntProperty hasDirectionProperty = this.currentModel.getOntProperty("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#hasDirection");
        OntClass locationInputOntClass = this.currentModel.getOntClass("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#InputLocation");
        NodeIterator profileInputValuesIterator = someProfile.listPropertyValues((Property)hasInputProperty);
        while (profileInputValuesIterator.hasNext()) {
            RDFNode directionLiteralNode;
            Literal directionLiteral;
            OntClass directionOntClass;
            RDFNode currentProfileInputNode = (RDFNode)profileInputValuesIterator.next();
            Individual currentProfileInputIndividual = (Individual)currentProfileInputNode.as(Individual.class);
            if (!currentProfileInputIndividual.hasRDFType((Resource)locationInputOntClass) || !(directionOntClass = this.currentModel.getOntClass((directionLiteral = (Literal)(directionLiteralNode = currentProfileInputIndividual.getPropertyValue((Property)hasDirectionProperty)).as(Literal.class)).getValue().toString())).hasSuperClass((Resource)desiredDirectionOntClass)) continue;
            return currentProfileInputIndividual;
        }
        return null;
    }

    OntResource getLocationOntResource4Direction(Individual someProfile, OntClass desiredDirectionOntClass) {
        OntProperty hasLocationProperty = this.currentModel.getOntProperty("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#hasLocation");
        Individual rfaDirectionLocationInput = this.getLocationInput4Direction(someProfile, desiredDirectionOntClass);
        RDFNode profileDirectionLiteralNode = rfaDirectionLocationInput.getPropertyValue((Property)hasLocationProperty);
        Literal profileDirectionLiteral = (Literal)profileDirectionLiteralNode.as(Literal.class);
        OntResource directionOntResource = this.currentModel.getOntResource(profileDirectionLiteral.getValue().toString());
        return directionOntResource;
    }

    Individual getProfileInput(Individual someProfile, OntClass inputTypeOntClass) {
        OntProperty hasInputProperty = this.currentModel.getOntProperty("http://www.daml.org/services/owl-s/1.2/Profile.owl#hasInput");
        NodeIterator profileInputValuesIterator = someProfile.listPropertyValues((Property)hasInputProperty);
        while (profileInputValuesIterator.hasNext()) {
            RDFNode currentProfileInputNode = (RDFNode)profileInputValuesIterator.next();
            Individual currentProfileInputIndividual = (Individual)currentProfileInputNode.as(Individual.class);
            if (!currentProfileInputIndividual.hasRDFType((Resource)inputTypeOntClass)) continue;
            return currentProfileInputIndividual;
        }
        return null;
    }

    void refreshLoadedDocuments() {
        this.print("|-- Refreshing Loaded Documents List...");
        DefaultListModel<String> tempModel1 = new DefaultListModel<String>();
        this.modelMakerModelsIterator = this.currentModel.listClasses();
        while (this.modelMakerModelsIterator.hasNext()) {
            tempModel1.addElement(this.modelMakerModelsIterator.next().toString());
        }
        this.myBrokerInterface.loadedDocumentsList.setModel(tempModel1);
        this.myBrokerInterface.loadedDocumentsList.repaint();
        this.print(" OK!\n");
    }

    void refreshAvailableResources() {
        this.print("|-- Refreshing Available Resources List...\n");
        DefaultListModel<String> tempModel2 = new DefaultListModel<String>();
        this.print("|-- Getting Profile Class \n");
        OntClass resourceProfileClass = this.currentModel.getOntClass("http://homepages.inf.ed.ac.uk/s0570652/ontologies/rfaDomain.owl#resProfile");
        this.print("|-- Checking if Profile class is inserted... \n");
        if (resourceProfileClass == null) {
            this.print("|-- resourceProfileClass is null \n");
        } else {
            this.print("|-- Listing Profile instances... ");
            this.availableResourcesIterator = resourceProfileClass.listInstances();
            while (this.availableResourcesIterator.hasNext()) {
                Individual tempAvailableResourceInstance = (Individual)this.availableResourcesIterator.next();
                tempModel2.addElement(tempAvailableResourceInstance.getLocalName());
            }
            this.myBrokerInterface.availableResourcesList.setModel(tempModel2);
            this.myBrokerInterface.availableResourcesList.repaint();
        }
        this.print("OK!\n");
    }

    public void print(String aString) {
        System.out.println(aString);
        this.myBrokerInterface.jTextArea2.append(aString);
        this.myBrokerInterface.jTextArea2.repaint();
    }

    void printChainContainer(Vector chainContainer) {
        for (int currentIndex = chainContainer.size() - 1; currentIndex >= 0; --currentIndex) {
            Vector currentChain = (Vector)chainContainer.get(currentIndex);
            this.printChain(currentChain);
        }
    }

    void printChain(Vector chainVector) {
        Individual currentProfile;
        String chainString = new String();
        if (chainVector.size() > 1) {
            chainString = chainString.concat("Chain : ");
        }
        for (int currentIndex = chainVector.size() - 1; currentIndex > 0; --currentIndex) {
            currentProfile = (Individual)chainVector.get(currentIndex);
            chainString = chainString.concat(currentProfile.getLocalName() + " --> ");
        }
        currentProfile = (Individual)chainVector.get(0);
        chainString = chainString.concat(currentProfile.getLocalName());
        this.matchesListModel.addElement(chainString);
        this.myBrokerInterface.matchesList.setModel(this.matchesListModel);
        this.myBrokerInterface.matchesList.repaint();
        this.print(chainString);
    }

    Vector addProfile2ChainContainer(Vector chainContainer, Individual resProfile) {
        for (int currentIndex = chainContainer.size() - 1; currentIndex >= 0; --currentIndex) {
            Vector tempChain = (Vector)chainContainer.get(currentIndex);
            tempChain.add(resProfile);
        }
        return chainContainer;
    }
}

