/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.test;

import com.hp.hpl.jena.query.expr.ExprEvalException;
import com.hp.hpl.jena.query.expr.NodeValue;
import com.hp.hpl.jena.query.expr.nodevalue.Functions;
import com.hp.hpl.jena.query.expr.nodevalue.NodeValueDecimal;
import com.hp.hpl.jena.query.expr.nodevalue.NodeValueDouble;
import com.hp.hpl.jena.query.expr.nodevalue.NodeValueFloat;
import com.hp.hpl.jena.query.expr.nodevalue.NodeValueInteger;
import com.hp.hpl.jena.query.util.Utils;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestFunctions
extends TestCase {
    private static final double accuracyExact_D = 0.0;
    private static final double accuracyExact_F = 0.0;
    private static final double accuracyClose_D = 1.0E-6;
    private static final double accuracyClose_F = (double)1.0E-6f;

    public static TestSuite suite() {
        TestSuite ts = new TestSuite(TestFunctions.class);
        ts.setName(Utils.classShortName(TestFunctions.class));
        return ts;
    }

    public void testAddIntegerInteger() {
        NodeValue nv1 = NodeValue.makeInteger(5L);
        NodeValue nv2 = NodeValue.makeInteger(7L);
        NodeValue r = Functions.add(nv1, nv2);
        TestFunctions.assertTrue((String)("Not an integer: " + r), (boolean)r.isInteger());
        TestFunctions.assertTrue((String)("Not a NodeValueInteger: " + r), (boolean)(r instanceof NodeValueInteger));
        TestFunctions.assertEquals((String)"Wrong result", (long)12L, (long)r.getInteger().longValue());
    }

    public void testAddDecimalDecimal() {
        NodeValue nv1 = NodeValue.makeDecimal(4.3);
        NodeValue nv2 = NodeValue.makeDecimal(3.7);
        NodeValue r = Functions.add(nv1, nv2);
        TestFunctions.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDecimal());
        TestFunctions.assertTrue((String)("Not a NodeValueDecimal: " + r), (boolean)(r instanceof NodeValueDecimal));
        TestFunctions.assertEquals((String)"Wrong result", (double)8.0, (double)r.getDecimal().doubleValue(), (double)0.0);
    }

    public void testAddFloatFloat() {
        NodeValue nv1 = NodeValue.makeFloat(7.5f);
        NodeValue nv2 = NodeValue.makeFloat(2.5f);
        NodeValue r = Functions.add(nv1, nv2);
        TestFunctions.assertTrue((String)("Not a float: " + r), (boolean)r.isDouble());
        TestFunctions.assertTrue((String)("Not a NodeValueFloat: " + r), (boolean)(r instanceof NodeValueFloat));
        TestFunctions.assertEquals((String)"Wrong result", (double)10.0, (double)r.getFloat(), (double)0.0);
        TestFunctions.assertEquals((String)"Wrong result (as doubles)", (double)10.0, (double)r.getDouble(), (double)0.0);
    }

    public void testAddDoubleDouble() {
        NodeValue nv1 = NodeValue.makeDouble(7.5);
        NodeValue nv2 = NodeValue.makeDouble(2.5);
        NodeValue r = Functions.add(nv1, nv2);
        TestFunctions.assertTrue((String)("Not a double: " + r), (boolean)r.isDouble());
        TestFunctions.assertTrue((String)("Not a NodeValueDouble: " + r), (boolean)(r instanceof NodeValueDouble));
        TestFunctions.assertEquals((String)"Wrong result", (double)10.0, (double)r.getDouble(), (double)0.0);
    }

    public void testAddIntegerDecimal() {
        NodeValue nv1 = NodeValue.makeInteger(5L);
        NodeValue nv2 = NodeValue.makeDecimal(7L);
        NodeValue r = Functions.add(nv1, nv2);
        TestFunctions.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDecimal());
        TestFunctions.assertTrue((String)("Not a NodeValueDecimal: " + r), (boolean)(r instanceof NodeValueDecimal));
        TestFunctions.assertEquals((String)"Wrong result", (long)12L, (long)r.getDecimal().longValue());
    }

    public void testAddDecimalInteger() {
        NodeValue nv1 = NodeValue.makeDecimal(7L);
        NodeValue nv2 = NodeValue.makeInteger(5L);
        NodeValue r = Functions.add(nv1, nv2);
        TestFunctions.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDecimal());
        TestFunctions.assertTrue((String)("Not a NodeValueDecimal: " + r), (boolean)(r instanceof NodeValueDecimal));
        TestFunctions.assertEquals((String)"Wrong result", (long)12L, (long)r.getDecimal().longValue());
    }

    public void testAddIntegerFloat() {
        NodeValue nv1 = NodeValue.makeInteger(5L);
        NodeValue nv2 = NodeValue.makeFloat(7.0f);
        NodeValue r = Functions.add(nv1, nv2);
        TestFunctions.assertTrue((String)("Not a float: " + r), (boolean)r.isFloat());
        TestFunctions.assertTrue((String)("Not a NodeValueFloat: " + r), (boolean)(r instanceof NodeValueFloat));
        TestFunctions.assertEquals((String)"Wrong result", (double)12.0, (double)r.getDouble(), (double)0.0);
    }

    public void testAddFloatInteger() {
        NodeValue nv1 = NodeValue.makeFloat(7.0f);
        NodeValue nv2 = NodeValue.makeInteger(5L);
        NodeValue r = Functions.add(nv1, nv2);
        TestFunctions.assertTrue((String)("Not a float: " + r), (boolean)r.isFloat());
        TestFunctions.assertTrue((String)("Not a NodeValueFloat: " + r), (boolean)(r instanceof NodeValueFloat));
        TestFunctions.assertEquals((String)"Wrong result", (double)12.0, (double)r.getDouble(), (double)0.0);
    }

    public void testAddIntegerDouble() {
        NodeValue nv1 = NodeValue.makeInteger(5L);
        NodeValue nv2 = NodeValue.makeDouble(7.0);
        NodeValue r = Functions.add(nv1, nv2);
        TestFunctions.assertTrue((String)("Not a double: " + r), (boolean)r.isDouble());
        TestFunctions.assertTrue((String)("Not a NodeValueDouble: " + r), (boolean)(r instanceof NodeValueDouble));
        TestFunctions.assertEquals((String)"Wrong result", (double)12.0, (double)r.getDouble(), (double)0.0);
    }

    public void testAddDoubleInteger() {
        NodeValue nv1 = NodeValue.makeDouble(7.0);
        NodeValue nv2 = NodeValue.makeInteger(5L);
        NodeValue r = Functions.add(nv1, nv2);
        TestFunctions.assertTrue((String)("Not a double: " + r), (boolean)r.isDouble());
        TestFunctions.assertTrue((String)("Not a NodeValueDouble: " + r), (boolean)(r instanceof NodeValueDouble));
        TestFunctions.assertEquals((String)"Wrong result", (double)12.0, (double)r.getDouble(), (double)0.0);
    }

    public void testAddDecimalFloat() {
        NodeValue nv1 = NodeValue.makeDecimal(3.5);
        NodeValue nv2 = NodeValue.makeFloat(4.5f);
        NodeValue r = Functions.add(nv1, nv2);
        TestFunctions.assertTrue((String)("Not a Float: " + r), (boolean)r.isFloat());
        TestFunctions.assertTrue((String)("Not a NodeValueFloat: " + r), (boolean)(r instanceof NodeValueFloat));
        TestFunctions.assertEquals((String)"Wrong result", (double)8.0, (double)r.getFloat(), (double)0.0);
    }

    public void testAddFloatDecimal() {
        NodeValue nv1 = NodeValue.makeFloat(4.5f);
        NodeValue nv2 = NodeValue.makeDecimal(3.5);
        NodeValue r = Functions.add(nv1, nv2);
        TestFunctions.assertTrue((String)("Not a Float: " + r), (boolean)r.isFloat());
        TestFunctions.assertTrue((String)("Not a NodeValueFloat: " + r), (boolean)(r instanceof NodeValueFloat));
        TestFunctions.assertEquals((String)"Wrong result", (double)8.0, (double)r.getFloat(), (double)0.0);
    }

    public void testAddDecimalDouble() {
        NodeValue nv1 = NodeValue.makeDecimal(3.5);
        NodeValue nv2 = NodeValue.makeDouble(4.5);
        NodeValue r = Functions.add(nv1, nv2);
        TestFunctions.assertTrue((String)("Not a double: " + r), (boolean)r.isDouble());
        TestFunctions.assertTrue((String)("Not a NodeValueDouble: " + r), (boolean)(r instanceof NodeValueDouble));
        TestFunctions.assertEquals((String)"Wrong result", (double)8.0, (double)r.getDouble(), (double)0.0);
    }

    public void testAddDoubleDecimal() {
        NodeValue nv1 = NodeValue.makeDouble(4.5);
        NodeValue nv2 = NodeValue.makeDecimal(3.5);
        NodeValue r = Functions.add(nv1, nv2);
        TestFunctions.assertTrue((String)("Not a double: " + r), (boolean)r.isDouble());
        TestFunctions.assertTrue((String)("Not a NodeValueDouble: " + r), (boolean)(r instanceof NodeValueDouble));
        TestFunctions.assertEquals((String)"Wrong result", (double)8.0, (double)r.getDouble(), (double)0.0);
    }

    public void testAddDoubleFloat() {
        NodeValue nv1 = NodeValue.makeDouble(4.5);
        NodeValue nv2 = NodeValue.makeFloat(3.5f);
        NodeValue r = Functions.add(nv1, nv2);
        TestFunctions.assertTrue((String)("Not a double: " + r), (boolean)r.isDouble());
        TestFunctions.assertTrue((String)("Not a NodeValueDouble: " + r), (boolean)(r instanceof NodeValueDouble));
        TestFunctions.assertEquals((String)"Wrong result", (double)8.0, (double)r.getDouble(), (double)0.0);
    }

    public void testAddFloatDouble() {
        NodeValue nv1 = NodeValue.makeFloat(4.5f);
        NodeValue nv2 = NodeValue.makeDouble(3.5);
        NodeValue r = Functions.add(nv1, nv2);
        TestFunctions.assertTrue((String)("Not a double: " + r), (boolean)r.isDouble());
        TestFunctions.assertTrue((String)("Not a NodeValueDouble: " + r), (boolean)(r instanceof NodeValueDouble));
        TestFunctions.assertEquals((String)"Wrong result", (double)8.0, (double)r.getDouble(), (double)0.0);
    }

    public void testDivideIntegerInteger() {
        NodeValue nv1 = NodeValue.makeInteger(25L);
        NodeValue nv2 = NodeValue.makeInteger(2L);
        NodeValue r = Functions.divide(nv1, nv2);
        TestFunctions.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDecimal());
        TestFunctions.assertTrue((String)("Not a NodeValueDecimal: " + r), (boolean)(r instanceof NodeValueDecimal));
        TestFunctions.assertEquals((String)"Wrong result", (double)12.5, (double)r.getDecimal().doubleValue(), (double)0.0);
    }

    public void testDivideByZero1() {
        NodeValue nv1 = NodeValue.makeInteger(1L);
        NodeValue nv2 = NodeValue.makeInteger(0L);
        try {
            NodeValue r = Functions.divide(nv1, nv2);
            TestFunctions.fail((String)"No expection from .divide");
        }
        catch (ExprEvalException exprEvalException) {
            // empty catch block
        }
    }

    public void testDivideByZero2() {
        NodeValue nv1 = NodeValue.makeInteger(1L);
        NodeValue nv2 = NodeValue.makeDouble(0.0);
        NodeValue r = Functions.divide(nv1, nv2);
        TestFunctions.assertTrue((String)("Not a double: " + r), (boolean)r.isDouble());
        TestFunctions.assertTrue((String)("Not a +INF: " + r), (r.getDouble() == Double.POSITIVE_INFINITY ? 1 : 0) != 0);
    }

    public void testDivideByZero3() {
        NodeValue nv1 = NodeValue.makeInteger(-1L);
        NodeValue nv2 = NodeValue.makeDouble(0.0);
        NodeValue r = Functions.divide(nv1, nv2);
        TestFunctions.assertTrue((String)("Not a double: " + r), (boolean)r.isDouble());
        TestFunctions.assertTrue((String)("Not a -INF: " + r), (r.getDouble() == Double.NEGATIVE_INFINITY ? 1 : 0) != 0);
    }

    public void testSubtractDoubleDecimal() {
        NodeValue nv1 = NodeValue.makeDouble(4.5);
        NodeValue nv2 = NodeValue.makeDecimal(3.5);
        NodeValue r = Functions.subtract(nv1, nv2);
        TestFunctions.assertTrue((String)("Not a double: " + r), (boolean)r.isDouble());
        TestFunctions.assertTrue((String)("Not a NodeValueDouble: " + r), (boolean)(r instanceof NodeValueDouble));
        TestFunctions.assertEquals((String)"Wrong result", (double)1.0, (double)r.getDouble(), (double)0.0);
    }

    public void testSubtractDecimalInteger() {
        NodeValue nv1 = NodeValue.makeDecimal(3.5);
        NodeValue nv2 = NodeValue.makeInteger(2L);
        NodeValue r = Functions.subtract(nv1, nv2);
        TestFunctions.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDecimal());
        TestFunctions.assertTrue((String)("Not a NodeValueDecimal: " + r), (boolean)(r instanceof NodeValueDecimal));
        TestFunctions.assertTrue((String)"Wrong result", (boolean)NodeValue.sameValueAs(NodeValue.makeDecimal(1.5), r));
    }

    public void testMultiplyDoubleDecimal() {
        NodeValue nv1 = NodeValue.makeDouble(4.5);
        NodeValue nv2 = NodeValue.makeDecimal(3.5);
        NodeValue r = Functions.multiply(nv1, nv2);
        TestFunctions.assertTrue((String)("Not a double: " + r), (boolean)r.isDouble());
        TestFunctions.assertTrue((String)("Not a NodeValueDouble: " + r), (boolean)(r instanceof NodeValueDouble));
        TestFunctions.assertEquals((String)"Wrong result", (double)15.75, (double)r.getDouble(), (double)0.0);
    }

    public void testMultiplyDecimalInteger() {
        NodeValue nv1 = NodeValue.makeDecimal(3.5);
        NodeValue nv2 = NodeValue.makeInteger(2L);
        NodeValue r = Functions.multiply(nv1, nv2);
        TestFunctions.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDecimal());
        TestFunctions.assertTrue((String)("Not a NodeValueDecimal: " + r), (boolean)(r instanceof NodeValueDecimal));
        TestFunctions.assertEquals((String)"Wrong result", (long)7L, (long)r.getDecimal().longValue());
    }

    public void testCompare1() {
        NodeValue nv5 = NodeValue.makeInteger(5L);
        NodeValue nv7 = NodeValue.makeInteger(7L);
        TestFunctions.assertEquals((String)("Does not compare " + nv5 + " & " + nv7), (int)-1, (int)NodeValue.compare(nv5, nv7));
        NodeValue nv5b = NodeValue.makeInteger(5L);
        TestFunctions.assertEquals((String)("Does not compare " + nv5 + " & " + nv5b), (int)0, (int)NodeValue.compare(nv5, nv5b));
    }

    public void testCompare2() {
        NodeValue nv5 = NodeValue.makeInteger(5L);
        NodeValue nv7 = NodeValue.makeNodeInteger(7L);
        TestFunctions.assertEquals((String)("Does not compare " + nv5 + " & " + nv7), (int)-1, (int)NodeValue.compare(nv5, nv7));
        NodeValue nv5b = NodeValue.makeNodeInteger(5L);
        TestFunctions.assertEquals((String)("Does not compare " + nv5 + " & " + nv5b), (int)0, (int)NodeValue.compare(nv5, nv5b));
    }

    public void testCompare3() {
        NodeValue nv5 = NodeValue.makeInteger(5L);
        NodeValue nv7 = NodeValue.makeDouble(7.0);
        TestFunctions.assertEquals((String)("Does not compare " + nv5 + " & " + nv7), (int)-1, (int)NodeValue.compare(nv5, nv7));
    }

    public void testCompare4() {
        NodeValue nv5 = NodeValue.makeInteger(5L);
        NodeValue nv7 = NodeValue.makeFloat(7.0f);
        TestFunctions.assertEquals((String)("Does not compare " + nv5 + " & " + nv7), (int)-1, (int)NodeValue.compare(nv5, nv7));
    }

    public void testCompare5() {
        NodeValue nv5 = NodeValue.makeInteger(5L);
        NodeValue nv7 = NodeValue.makeDecimal(7L);
        TestFunctions.assertEquals((String)("Does not compare " + nv5 + " & " + nv7), (int)-1, (int)NodeValue.compare(nv5, nv7));
    }

    public void testCompare10() {
        NodeValue nv1 = NodeValue.makeDate("2005-10-14T13:09:43Z");
        NodeValue nv2 = NodeValue.makeNodeDate("2005-10-14T14:09:43Z");
        TestFunctions.assertEquals((String)("Does not compare " + nv1 + " & " + nv2), (int)-1, (int)NodeValue.compare(nv1, nv2));
    }

    public void testCompare11() {
        NodeValue nv1 = NodeValue.makeDate("2005-10-14T13:09:43-08:00");
        NodeValue nv2 = NodeValue.makeNodeDate("2005-10-14T13:09:43+01:00");
        TestFunctions.assertEquals((String)("Does not compare " + nv1 + " & " + nv2), (int)1, (int)NodeValue.compare(nv1, nv2));
    }

    public void testCompare20() {
        NodeValue nv1 = NodeValue.makeString("abcd");
        NodeValue nv2 = NodeValue.makeNodeString("abc");
        TestFunctions.assertEquals((String)("Does not compare " + nv1 + " & " + nv2), (int)1, (int)NodeValue.compare(nv1, nv2));
    }

    public void testCompare21() {
        NodeValue nv5 = NodeValue.makeInteger(5L);
        NodeValue nv7 = NodeValue.makeString("5");
        try {
            NodeValue.compare(nv5, nv7);
            TestFunctions.fail((String)("Should not compare (but did) " + nv5 + " & " + nv7));
        }
        catch (ExprEvalException ex) {
            // empty catch block
        }
        int x = NodeValue.compareAlways(nv5, nv7);
        TestFunctions.assertEquals((String)("Does not compare " + nv5 + " & " + nv7), (int)1, (int)NodeValue.compareAlways(nv5, nv7));
    }

    public void testCompare22() {
        NodeValue nv1 = NodeValue.makeNodeString("aaa");
        NodeValue nv2 = NodeValue.makeString("aaabbb");
        int x = NodeValue.compare(nv1, nv2);
        TestFunctions.assertEquals((String)"Not CMP_LESS", (int)x, (int)-1);
        TestFunctions.assertTrue((String)"It's CMP_GREATER", (x != 1 ? 1 : 0) != 0);
        TestFunctions.assertTrue((String)"It's CMP_EQUAL", (x != 0 ? 1 : 0) != 0);
    }

    public void testAbs1() {
        NodeValue nv = NodeValue.makeInteger(2L);
        NodeValue r = Functions.abs(nv);
        TestFunctions.assertTrue((String)("Not an integer: " + r), (boolean)r.isInteger());
        TestFunctions.assertTrue((String)("Not a NodeValueInteger: " + r), (boolean)(r instanceof NodeValueInteger));
        TestFunctions.assertEquals((String)"Wrong result", (long)2L, (long)r.getInteger().longValue());
    }

    public void testAbs2() {
        NodeValue nv = NodeValue.makeInteger(-2L);
        NodeValue r = Functions.abs(nv);
        TestFunctions.assertTrue((String)("Not an integer: " + r), (boolean)r.isInteger());
        TestFunctions.assertTrue((String)("Not a NodeValueInteger: " + r), (boolean)(r instanceof NodeValueInteger));
        TestFunctions.assertEquals((String)"Wrong result", (long)2L, (long)r.getInteger().longValue());
    }

    public void testAbs3() {
        NodeValue nv = NodeValue.makeDecimal(2L);
        NodeValue r = Functions.abs(nv);
        TestFunctions.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDecimal());
        TestFunctions.assertTrue((String)("Not a NodeValueDecimal: " + r), (boolean)(r instanceof NodeValueDecimal));
        TestFunctions.assertEquals((String)"Wrong result", (double)2.0, (double)r.getDecimal().doubleValue(), (double)0.0);
    }

    public void testAbs4() {
        NodeValue nv = NodeValue.makeDecimal(-2L);
        NodeValue r = Functions.abs(nv);
        TestFunctions.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDecimal());
        TestFunctions.assertTrue((String)("Not a NodeValueDecimal: " + r), (boolean)(r instanceof NodeValueDecimal));
        TestFunctions.assertEquals((String)"Wrong result", (double)2.0, (double)r.getDecimal().doubleValue(), (double)0.0);
    }

    public void testAbs5() {
        NodeValue nv = NodeValue.makeFloat(2.0f);
        NodeValue r = Functions.abs(nv);
        TestFunctions.assertTrue((String)("Not an float: " + r), (boolean)r.isFloat());
        TestFunctions.assertTrue((String)("Not a NodeValueFloat: " + r), (boolean)(r instanceof NodeValueFloat));
        TestFunctions.assertEquals((String)"Wrong result", (double)2.0, (double)r.getFloat(), (double)0.0);
    }

    public void testAbs6() {
        NodeValue nv = NodeValue.makeFloat(-2.0f);
        NodeValue r = Functions.abs(nv);
        TestFunctions.assertTrue((String)("Not an float: " + r), (boolean)r.isFloat());
        TestFunctions.assertTrue((String)("Not a NodeValueFloat: " + r), (boolean)(r instanceof NodeValueFloat));
        TestFunctions.assertEquals((String)"Wrong result", (double)2.0, (double)r.getFloat(), (double)0.0);
    }

    public void testAbs7() {
        NodeValue nv = NodeValue.makeDouble(2.0);
        NodeValue r = Functions.abs(nv);
        TestFunctions.assertTrue((String)("Not an double: " + r), (boolean)r.isDouble());
        TestFunctions.assertTrue((String)("Not a NodeValueDouble: " + r), (boolean)(r instanceof NodeValueDouble));
        TestFunctions.assertEquals((String)"Wrong result", (double)2.0, (double)r.getDouble(), (double)0.0);
    }

    public void testAbs8() {
        NodeValue nv = NodeValue.makeDouble(-2.0);
        NodeValue r = Functions.abs(nv);
        TestFunctions.assertTrue((String)("Not an double: " + r), (boolean)r.isDouble());
        TestFunctions.assertTrue((String)("Not a NodeValueDouble: " + r), (boolean)(r instanceof NodeValueDouble));
        TestFunctions.assertEquals((String)"Wrong result", (double)2.0, (double)r.getDouble(), (double)0.0);
    }

    public void testCeiling1() {
        NodeValue nv = NodeValue.makeDecimal(2.6);
        NodeValue r = Functions.ceiling(nv);
        TestFunctions.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDecimal());
        TestFunctions.assertTrue((String)("Not a NodeValueDecimal: " + r), (boolean)(r instanceof NodeValueDecimal));
        TestFunctions.assertEquals((String)"Wrong result", (long)3L, (long)r.getDecimal().longValue());
    }

    public void testCeiling2() {
        NodeValue nv = NodeValue.makeDecimal(-3.6);
        NodeValue r = Functions.ceiling(nv);
        TestFunctions.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDecimal());
        TestFunctions.assertTrue((String)("Not a NodeValueDecimal: " + r), (boolean)(r instanceof NodeValueDecimal));
        TestFunctions.assertEquals((String)"Wrong result", (long)-3L, (long)r.getDecimal().longValue());
    }

    public void testCeiling3() {
        NodeValue nv = NodeValue.makeDouble(2.6);
        NodeValue r = Functions.ceiling(nv);
        TestFunctions.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDouble());
        TestFunctions.assertTrue((String)("Not a NodeValueDouble: " + r), (boolean)(r instanceof NodeValueDouble));
        TestFunctions.assertEquals((String)"Wrong result", (double)3.0, (double)r.getDouble(), (double)0.0);
    }

    public void testCeiling4() {
        NodeValue nv = NodeValue.makeDouble(-3.6);
        NodeValue r = Functions.ceiling(nv);
        TestFunctions.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDouble());
        TestFunctions.assertTrue((String)("Not a NodeValueDouble: " + r), (boolean)(r instanceof NodeValueDouble));
        TestFunctions.assertEquals((String)"Wrong result", (double)-3.0, (double)r.getDouble(), (double)0.0);
    }

    public void testCeiling5() {
        NodeValue nv = NodeValue.makeInteger(3L);
        NodeValue r = Functions.ceiling(nv);
        TestFunctions.assertTrue((String)("Not an integer: " + r), (boolean)r.isInteger());
        TestFunctions.assertTrue((String)("Not a NodeValueInteger: " + r), (boolean)(r instanceof NodeValueInteger));
        TestFunctions.assertEquals((String)"Wrong result", (long)3L, (long)r.getInteger().longValue());
    }

    public void testFloor1() {
        NodeValue nv = NodeValue.makeDecimal(2.6);
        NodeValue r = Functions.floor(nv);
        TestFunctions.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDecimal());
        TestFunctions.assertTrue((String)("Not a NodeValueDecimal: " + r), (boolean)(r instanceof NodeValueDecimal));
        TestFunctions.assertEquals((String)"Wrong result", (long)2L, (long)r.getDecimal().longValue());
    }

    public void testFloor2() {
        NodeValue nv = NodeValue.makeDecimal(-3.6);
        NodeValue r = Functions.floor(nv);
        TestFunctions.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDecimal());
        TestFunctions.assertTrue((String)("Not a NodeValueDecimal: " + r), (boolean)(r instanceof NodeValueDecimal));
        TestFunctions.assertEquals((String)"Wrong result", (long)-4L, (long)r.getDecimal().longValue());
    }

    public void testFloor3() {
        NodeValue nv = NodeValue.makeDouble(2.6);
        NodeValue r = Functions.floor(nv);
        TestFunctions.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDouble());
        TestFunctions.assertTrue((String)("Not a NodeValueDouble: " + r), (boolean)(r instanceof NodeValueDouble));
        TestFunctions.assertEquals((String)"Wrong result", (double)2.0, (double)r.getDouble(), (double)0.0);
    }

    public void testFloor4() {
        NodeValue nv = NodeValue.makeDouble(-3.6);
        NodeValue r = Functions.floor(nv);
        TestFunctions.assertTrue((String)("Not a decimal: " + r), (boolean)r.isDouble());
        TestFunctions.assertTrue((String)("Not a NodeValueDouble: " + r), (boolean)(r instanceof NodeValueDouble));
        TestFunctions.assertEquals((String)"Wrong result", (double)-4.0, (double)r.getDouble(), (double)0.0);
    }

    public void testFloor5() {
        NodeValue nv = NodeValue.makeInteger(3L);
        NodeValue r = Functions.floor(nv);
        TestFunctions.assertTrue((String)("Not an integer: " + r), (boolean)r.isInteger());
        TestFunctions.assertTrue((String)("Not a NodeValueInteger: " + r), (boolean)(r instanceof NodeValueInteger));
        TestFunctions.assertEquals((String)"Wrong result", (long)3L, (long)r.getInteger().longValue());
    }
}

