/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.serializer;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryVisitor;
import com.hp.hpl.jena.query.SortCondition;
import com.hp.hpl.jena.query.expr.ExprVisitor;
import com.hp.hpl.jena.query.serializer.FmtExprXML;
import com.hp.hpl.jena.query.serializer.FormatterElement;
import com.hp.hpl.jena.query.serializer.FormatterTemplate;
import com.hp.hpl.jena.query.serializer.FormatterXML;
import com.hp.hpl.jena.query.serializer.SerializationContext;
import com.hp.hpl.jena.query.util.IndentedWriter;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;

public class QuerySerializerXML
implements QueryVisitor {
    static final int INDENT = 2;
    FormatterTemplate fmtTemplate;
    FormatterElement fmtElement;
    ExprVisitor fmtExpr;
    IndentedWriter out = null;

    QuerySerializerXML(OutputStream outStream, SerializationContext context) {
        this(new IndentedWriter(outStream), context);
    }

    QuerySerializerXML(IndentedWriter writer, SerializationContext context) {
        this.out = writer;
        FormatterXML fmt = new FormatterXML(writer, context);
        this.fmtElement = fmt;
        this.fmtTemplate = fmt;
        this.fmtExpr = new FmtExprXML(writer, context);
    }

    public void startVisit(Query query2) {
        this.out.println("<rdf-query>");
        this.out.incIndent(2);
    }

    public void visitResultForm(Query query2) {
    }

    public void visitBase(Query query2) {
    }

    public void visitPrefixes(Query query2) {
    }

    public void visitSelectResultForm(Query query2) {
        this.out.print("<select");
        this.resultFormModifiers(query2);
        this.out.println(">");
        this.out.incIndent(2);
        this.writeVarList(query2.getResultVars());
        this.out.decIndent(2);
        this.out.println("</select>");
    }

    public void visitConstructResultForm(Query query2) {
        this.out.print("<construct");
        this.resultFormModifiers(query2);
        this.out.println(">");
        this.out.incIndent(2);
        query2.getConstructTemplate().visit(this.fmtTemplate);
        this.out.decIndent(2);
        this.out.println("</construct>");
    }

    public void visitDescribeResultForm(Query query2) {
        this.out.print("<describe");
        this.resultFormModifiers(query2);
        this.out.println(">");
        this.out.incIndent(2);
        this.writeVarList(query2.getResultVars());
        this.writeURIList(query2.getResultURIs());
        this.out.decIndent(2);
        this.out.println("</describe>");
    }

    public void visitAskResultForm(Query query2) {
        this.out.println("<ask/>");
    }

    public void visitDatasetDecl(Query query2) {
    }

    public void visitQueryPattern(Query query2) {
        query2.getQueryBlock().visit(this.fmtElement);
    }

    public void visitOrderBy(Query query2) {
        if (query2.hasOrderBy()) {
            this.out.println("<order>");
            this.out.incIndent(2);
            Iterator iter = query2.getOrderBy().iterator();
            while (iter.hasNext()) {
                this.out.println("<order-by>");
                this.out.incIndent(2);
                SortCondition sc = (SortCondition)iter.next();
                sc.format(this.fmtExpr, this.out);
                this.out.decIndent(2);
                this.out.println("</order-by>");
            }
            this.out.decIndent(2);
            this.out.println("</order>");
        }
    }

    public void visitLimit(Query query2) {
    }

    public void visitOffset(Query query2) {
    }

    public void finishVisit(Query query2) {
        this.out.decIndent(2);
        this.out.println("</rdf-query>");
        this.out.flush();
    }

    void writeVarList(List vars) {
        Iterator iter = vars.iterator();
        while (iter.hasNext()) {
            String var = (String)iter.next();
            this.out.println("<variable name=\"" + var + "\"/>");
        }
    }

    void writeURIList(List uris) {
        Iterator iter = uris.iterator();
        while (iter.hasNext()) {
            String uri = (String)iter.next();
            this.out.println("<uri uri=\"" + uri + "\"/>");
        }
    }

    void resultFormModifiers(Query query2) {
        if (query2.isDistinct()) {
            this.out.print(" distinct=\"true\"");
        }
        if (query2.hasLimit()) {
            this.out.print(" limit=\"" + query2.getLimit() + "\"");
        }
        if (query2.hasOffset()) {
            this.out.print(" offset=\"" + query2.getOffset() + "\"");
        }
    }
}

