/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.serializer;

import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.query.core.Template;
import com.hp.hpl.jena.query.core.TemplateGroup;
import com.hp.hpl.jena.query.core.TemplateTriple;
import com.hp.hpl.jena.query.serializer.FormatterBase;
import com.hp.hpl.jena.query.serializer.FormatterTemplate;
import com.hp.hpl.jena.query.serializer.SerializationContext;
import com.hp.hpl.jena.query.util.IndentedLineBuffer;
import com.hp.hpl.jena.query.util.IndentedWriter;
import java.util.ArrayList;
import java.util.Iterator;

public class FmtTemplateARQ
extends FormatterBase
implements FormatterTemplate {
    public FmtTemplateARQ(IndentedWriter out, SerializationContext context) {
        super(out, context);
    }

    public static void format(IndentedWriter out, SerializationContext cxt, Template template) {
        FmtTemplateARQ fmt = new FmtTemplateARQ(out, cxt);
        fmt.startVisit();
        template.visit(fmt);
        fmt.finishVisit();
    }

    public static String asString(Template template) {
        SerializationContext cxt = new SerializationContext(null, null, null);
        IndentedLineBuffer b = new IndentedLineBuffer();
        FmtTemplateARQ.format(b.getIndentedWriter(), cxt, template);
        return b.toString();
    }

    public void visit(TemplateGroup template) {
        this.out.print("{");
        this.out.incIndent(2);
        this.out.pad();
        ArrayList<Triple> acc = new ArrayList<Triple>();
        Iterator iter = template.templates();
        while (iter.hasNext()) {
            Template temp = (Template)iter.next();
            if (temp instanceof TemplateTriple) {
                Triple triple = ((TemplateTriple)temp).getTriple();
                acc.add(triple);
                continue;
            }
            if (acc != null && acc.size() > 0) {
                this.formatTriples(acc);
            }
            acc = new ArrayList();
            temp.visit(this);
            this.out.print(" .");
            this.out.newline();
        }
        if (acc != null && acc.size() > 0) {
            this.formatTriples(acc);
        }
        this.out.decIndent(2);
        this.out.print("}");
        this.out.newline();
    }

    public void visit(TemplateTriple template) {
        this.formatTriple(template.getTriple());
    }
}

