/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.expr.nodevalue;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.expr.NodeValue;
import com.hp.hpl.jena.query.util.Utils;
import java.math.BigDecimal;

public class NodeValueDecimal
extends NodeValue {
    BigDecimal decimal;

    public NodeValueDecimal(BigDecimal d) {
        this.decimal = d;
    }

    public NodeValueDecimal(BigDecimal d, Node n) {
        super(n);
        this.decimal = d;
    }

    public boolean isNumber() {
        return true;
    }

    public boolean isDecimal() {
        return true;
    }

    public boolean isFloat() {
        return true;
    }

    public boolean isDouble() {
        return true;
    }

    public BigDecimal getDecimal() {
        return this.decimal;
    }

    public float getFloat() {
        return this.decimal.floatValue();
    }

    public double getDouble() {
        return this.decimal.doubleValue();
    }

    protected Node makeNode() {
        int s = this.decimal.scale();
        return Node.createLiteral((String)Utils.stringForm(this.decimal), null, (RDFDatatype)XSDDatatype.XSDdecimal);
    }

    public String asString() {
        return this.toString();
    }

    public String toString() {
        if (this.getNode() != null) {
            return super.asString();
        }
        return Utils.stringForm(this.decimal);
    }
}

